#[doc = "Register `INT_RAW_CH2` writer"]
pub struct W(crate::W<INT_RAW_CH2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<INT_RAW_CH2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<INT_RAW_CH2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<INT_RAW_CH2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `IN_DONE_CH2_INT_RAW` writer - The raw interrupt bit turns to high level when the last data pointed by one inlink descriptor has been received for Rx channel 2."]
pub struct IN_DONE_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> IN_DONE_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `IN_SUC_EOF_CH2_INT_RAW` writer - The raw interrupt bit turns to high level when the last data pointed by one inlink descriptor has been received for Rx channel 2. For UHCI0, the raw interrupt bit turns to high level when the last data pointed by one inlink descriptor has been received and no data error is detected for Rx channel 2."]
pub struct IN_SUC_EOF_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> IN_SUC_EOF_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `IN_ERR_EOF_CH2_INT_RAW` writer - The raw interrupt bit turns to high level when data error is detected only in the case that the peripheral is UHCI0 for Rx channel 2. For other peripherals, this raw interrupt is reserved."]
pub struct IN_ERR_EOF_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> IN_ERR_EOF_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `OUT_DONE_CH2_INT_RAW` writer - The raw interrupt bit turns to high level when the last data pointed by one outlink descriptor has been transmitted to peripherals for Tx channel 2."]
pub struct OUT_DONE_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> OUT_DONE_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `OUT_EOF_CH2_INT_RAW` writer - The raw interrupt bit turns to high level when the last data pointed by one outlink descriptor has been read from memory for Tx channel 2."]
pub struct OUT_EOF_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> OUT_EOF_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `IN_DSCR_ERR_CH2_INT_RAW` writer - The raw interrupt bit turns to high level when detecting inlink descriptor error, including owner error, the second and third word error of inlink descriptor for Rx channel 2."]
pub struct IN_DSCR_ERR_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> IN_DSCR_ERR_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `OUT_DSCR_ERR_CH2_INT_RAW` writer - The raw interrupt bit turns to high level when detecting outlink descriptor error, including owner error, the second and third word error of outlink descriptor for Tx channel 2."]
pub struct OUT_DSCR_ERR_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> OUT_DSCR_ERR_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `IN_DSCR_EMPTY_CH2_INT_RAW` writer - The raw interrupt bit turns to high level when Rx buffer pointed by inlink is full and receiving data is not completed, but there is no more inlink for Rx channel 2."]
pub struct IN_DSCR_EMPTY_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> IN_DSCR_EMPTY_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `OUT_TOTAL_EOF_CH2_INT_RAW` writer - The raw interrupt bit turns to high level when data corresponding a outlink (includes one link descriptor or few link descriptors) is transmitted out for Tx channel 2."]
pub struct OUT_TOTAL_EOF_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> OUT_TOTAL_EOF_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `INFIFO_OVF_CH2_INT_RAW` writer - This raw interrupt bit turns to high level when level 1 fifo of Rx channel 2 is overflow."]
pub struct INFIFO_OVF_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> INFIFO_OVF_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `INFIFO_UDF_CH2_INT_RAW` writer - This raw interrupt bit turns to high level when level 1 fifo of Rx channel 2 is underflow."]
pub struct INFIFO_UDF_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> INFIFO_UDF_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `OUTFIFO_OVF_CH2_INT_RAW` writer - This raw interrupt bit turns to high level when level 1 fifo of Tx channel 2 is overflow."]
pub struct OUTFIFO_OVF_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> OUTFIFO_OVF_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `OUTFIFO_UDF_CH2_INT_RAW` writer - This raw interrupt bit turns to high level when level 1 fifo of Tx channel 2 is underflow."]
pub struct OUTFIFO_UDF_CH2_INT_RAW_W<'a> {
    w: &'a mut W,
}
impl<'a> OUTFIFO_UDF_CH2_INT_RAW_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
impl W {
    #[doc = "Bit 0 - The raw interrupt bit turns to high level when the last data pointed by one inlink descriptor has been received for Rx channel 2."]
    #[inline(always)]
    pub fn in_done_ch2_int_raw(&mut self) -> IN_DONE_CH2_INT_RAW_W {
        IN_DONE_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Bit 1 - The raw interrupt bit turns to high level when the last data pointed by one inlink descriptor has been received for Rx channel 2. For UHCI0, the raw interrupt bit turns to high level when the last data pointed by one inlink descriptor has been received and no data error is detected for Rx channel 2."]
    #[inline(always)]
    pub fn in_suc_eof_ch2_int_raw(&mut self) -> IN_SUC_EOF_CH2_INT_RAW_W {
        IN_SUC_EOF_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Bit 2 - The raw interrupt bit turns to high level when data error is detected only in the case that the peripheral is UHCI0 for Rx channel 2. For other peripherals, this raw interrupt is reserved."]
    #[inline(always)]
    pub fn in_err_eof_ch2_int_raw(&mut self) -> IN_ERR_EOF_CH2_INT_RAW_W {
        IN_ERR_EOF_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Bit 3 - The raw interrupt bit turns to high level when the last data pointed by one outlink descriptor has been transmitted to peripherals for Tx channel 2."]
    #[inline(always)]
    pub fn out_done_ch2_int_raw(&mut self) -> OUT_DONE_CH2_INT_RAW_W {
        OUT_DONE_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Bit 4 - The raw interrupt bit turns to high level when the last data pointed by one outlink descriptor has been read from memory for Tx channel 2."]
    #[inline(always)]
    pub fn out_eof_ch2_int_raw(&mut self) -> OUT_EOF_CH2_INT_RAW_W {
        OUT_EOF_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Bit 5 - The raw interrupt bit turns to high level when detecting inlink descriptor error, including owner error, the second and third word error of inlink descriptor for Rx channel 2."]
    #[inline(always)]
    pub fn in_dscr_err_ch2_int_raw(&mut self) -> IN_DSCR_ERR_CH2_INT_RAW_W {
        IN_DSCR_ERR_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Bit 6 - The raw interrupt bit turns to high level when detecting outlink descriptor error, including owner error, the second and third word error of outlink descriptor for Tx channel 2."]
    #[inline(always)]
    pub fn out_dscr_err_ch2_int_raw(&mut self) -> OUT_DSCR_ERR_CH2_INT_RAW_W {
        OUT_DSCR_ERR_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Bit 7 - The raw interrupt bit turns to high level when Rx buffer pointed by inlink is full and receiving data is not completed, but there is no more inlink for Rx channel 2."]
    #[inline(always)]
    pub fn in_dscr_empty_ch2_int_raw(&mut self) -> IN_DSCR_EMPTY_CH2_INT_RAW_W {
        IN_DSCR_EMPTY_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Bit 8 - The raw interrupt bit turns to high level when data corresponding a outlink (includes one link descriptor or few link descriptors) is transmitted out for Tx channel 2."]
    #[inline(always)]
    pub fn out_total_eof_ch2_int_raw(&mut self) -> OUT_TOTAL_EOF_CH2_INT_RAW_W {
        OUT_TOTAL_EOF_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Bit 9 - This raw interrupt bit turns to high level when level 1 fifo of Rx channel 2 is overflow."]
    #[inline(always)]
    pub fn infifo_ovf_ch2_int_raw(&mut self) -> INFIFO_OVF_CH2_INT_RAW_W {
        INFIFO_OVF_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Bit 10 - This raw interrupt bit turns to high level when level 1 fifo of Rx channel 2 is underflow."]
    #[inline(always)]
    pub fn infifo_udf_ch2_int_raw(&mut self) -> INFIFO_UDF_CH2_INT_RAW_W {
        INFIFO_UDF_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Bit 11 - This raw interrupt bit turns to high level when level 1 fifo of Tx channel 2 is overflow."]
    #[inline(always)]
    pub fn outfifo_ovf_ch2_int_raw(&mut self) -> OUTFIFO_OVF_CH2_INT_RAW_W {
        OUTFIFO_OVF_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Bit 12 - This raw interrupt bit turns to high level when level 1 fifo of Tx channel 2 is underflow."]
    #[inline(always)]
    pub fn outfifo_udf_ch2_int_raw(&mut self) -> OUTFIFO_UDF_CH2_INT_RAW_W {
        OUTFIFO_UDF_CH2_INT_RAW_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "DMA_INT_RAW_CH2_REG.\n\nThis register you can [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [int_raw_ch2](index.html) module"]
pub struct INT_RAW_CH2_SPEC;
impl crate::RegisterSpec for INT_RAW_CH2_SPEC {
    type Ux = u32;
}
#[doc = "`write(|w| ..)` method takes [int_raw_ch2::W](W) writer structure"]
impl crate::Writable for INT_RAW_CH2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets INT_RAW_CH2 to value 0"]
impl crate::Resettable for INT_RAW_CH2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
