#[doc = "Register `SLEEP_CONF` reader"]
pub struct R(crate::R<SLEEP_CONF_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SLEEP_CONF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SLEEP_CONF_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SLEEP_CONF_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SLEEP_CONF` writer"]
pub struct W(crate::W<SLEEP_CONF_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SLEEP_CONF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SLEEP_CONF_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SLEEP_CONF_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ACTIVE_THRESHOLD` reader - The uart is activated from light sleeping mode when the input rxd edge changes more times than this register value."]
pub struct ACTIVE_THRESHOLD_R(crate::FieldReader<u16, u16>);
impl ACTIVE_THRESHOLD_R {
    pub(crate) fn new(bits: u16) -> Self {
        ACTIVE_THRESHOLD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACTIVE_THRESHOLD_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACTIVE_THRESHOLD` writer - The uart is activated from light sleeping mode when the input rxd edge changes more times than this register value."]
pub struct ACTIVE_THRESHOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> ACTIVE_THRESHOLD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03ff) | (value as u32 & 0x03ff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:9 - The uart is activated from light sleeping mode when the input rxd edge changes more times than this register value."]
    #[inline(always)]
    pub fn active_threshold(&self) -> ACTIVE_THRESHOLD_R {
        ACTIVE_THRESHOLD_R::new((self.bits & 0x03ff) as u16)
    }
}
impl W {
    #[doc = "Bits 0:9 - The uart is activated from light sleeping mode when the input rxd edge changes more times than this register value."]
    #[inline(always)]
    pub fn active_threshold(&mut self) -> ACTIVE_THRESHOLD_W {
        ACTIVE_THRESHOLD_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Sleep-mode configuration\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [sleep_conf](index.html) module"]
pub struct SLEEP_CONF_SPEC;
impl crate::RegisterSpec for SLEEP_CONF_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [sleep_conf::R](R) reader structure"]
impl crate::Readable for SLEEP_CONF_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [sleep_conf::W](W) writer structure"]
impl crate::Writable for SLEEP_CONF_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SLEEP_CONF to value 0xf0"]
impl crate::Resettable for SLEEP_CONF_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0xf0
    }
}
