#[doc = "Register `FUNC%s_OUT_SEL_CFG` reader"]
pub struct R(crate::R<FUNC_OUT_SEL_CFG_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<FUNC_OUT_SEL_CFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<FUNC_OUT_SEL_CFG_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<FUNC_OUT_SEL_CFG_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `FUNC%s_OUT_SEL_CFG` writer"]
pub struct W(crate::W<FUNC_OUT_SEL_CFG_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<FUNC_OUT_SEL_CFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<FUNC_OUT_SEL_CFG_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<FUNC_OUT_SEL_CFG_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `FUNC_OUT_SEL` reader - The value of the bits: <=s<=256. Set the value to select output signal. s=-255: output of GPIO\\[n\\]
equals input of peripheral\\[s\\]. s=256: output of GPIO\\[n\\]
equals GPIO_OUT_REG\\[n\\]."]
pub struct FUNC_OUT_SEL_R(crate::FieldReader<u8, u8>);
impl FUNC_OUT_SEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        FUNC_OUT_SEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FUNC_OUT_SEL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FUNC_OUT_SEL` writer - The value of the bits: <=s<=256. Set the value to select output signal. s=-255: output of GPIO\\[n\\]
equals input of peripheral\\[s\\]. s=256: output of GPIO\\[n\\]
equals GPIO_OUT_REG\\[n\\]."]
pub struct FUNC_OUT_SEL_W<'a> {
    w: &'a mut W,
}
impl<'a> FUNC_OUT_SEL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u32 & 0xff);
        self.w
    }
}
#[doc = "Field `FUNC_OUT_INV_SEL` reader - set this bit to invert output signal.1:invert.:not invert."]
pub struct FUNC_OUT_INV_SEL_R(crate::FieldReader<bool, bool>);
impl FUNC_OUT_INV_SEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        FUNC_OUT_INV_SEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FUNC_OUT_INV_SEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FUNC_OUT_INV_SEL` writer - set this bit to invert output signal.1:invert.:not invert."]
pub struct FUNC_OUT_INV_SEL_W<'a> {
    w: &'a mut W,
}
impl<'a> FUNC_OUT_INV_SEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `FUNC_OEN_SEL` reader - set this bit to select output enable signal.1:use GPIO_ENABLE_REG\\[n\\]
as output enable signal.:use peripheral output enable signal."]
pub struct FUNC_OEN_SEL_R(crate::FieldReader<bool, bool>);
impl FUNC_OEN_SEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        FUNC_OEN_SEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FUNC_OEN_SEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FUNC_OEN_SEL` writer - set this bit to select output enable signal.1:use GPIO_ENABLE_REG\\[n\\]
as output enable signal.:use peripheral output enable signal."]
pub struct FUNC_OEN_SEL_W<'a> {
    w: &'a mut W,
}
impl<'a> FUNC_OEN_SEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `FUNC_OEN_INV_SEL` reader - set this bit to invert output enable signal.1:invert.:not invert."]
pub struct FUNC_OEN_INV_SEL_R(crate::FieldReader<bool, bool>);
impl FUNC_OEN_INV_SEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        FUNC_OEN_INV_SEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FUNC_OEN_INV_SEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FUNC_OEN_INV_SEL` writer - set this bit to invert output enable signal.1:invert.:not invert."]
pub struct FUNC_OEN_INV_SEL_W<'a> {
    w: &'a mut W,
}
impl<'a> FUNC_OEN_INV_SEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - The value of the bits: <=s<=256. Set the value to select output signal. s=-255: output of GPIO\\[n\\]
equals input of peripheral\\[s\\]. s=256: output of GPIO\\[n\\]
equals GPIO_OUT_REG\\[n\\]."]
    #[inline(always)]
    pub fn func_out_sel(&self) -> FUNC_OUT_SEL_R {
        FUNC_OUT_SEL_R::new((self.bits & 0xff) as u8)
    }
    #[doc = "Bit 8 - set this bit to invert output signal.1:invert.:not invert."]
    #[inline(always)]
    pub fn func_out_inv_sel(&self) -> FUNC_OUT_INV_SEL_R {
        FUNC_OUT_INV_SEL_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - set this bit to select output enable signal.1:use GPIO_ENABLE_REG\\[n\\]
as output enable signal.:use peripheral output enable signal."]
    #[inline(always)]
    pub fn func_oen_sel(&self) -> FUNC_OEN_SEL_R {
        FUNC_OEN_SEL_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - set this bit to invert output enable signal.1:invert.:not invert."]
    #[inline(always)]
    pub fn func_oen_inv_sel(&self) -> FUNC_OEN_INV_SEL_R {
        FUNC_OEN_INV_SEL_R::new(((self.bits >> 10) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:7 - The value of the bits: <=s<=256. Set the value to select output signal. s=-255: output of GPIO\\[n\\]
equals input of peripheral\\[s\\]. s=256: output of GPIO\\[n\\]
equals GPIO_OUT_REG\\[n\\]."]
    #[inline(always)]
    pub fn func_out_sel(&mut self) -> FUNC_OUT_SEL_W {
        FUNC_OUT_SEL_W { w: self }
    }
    #[doc = "Bit 8 - set this bit to invert output signal.1:invert.:not invert."]
    #[inline(always)]
    pub fn func_out_inv_sel(&mut self) -> FUNC_OUT_INV_SEL_W {
        FUNC_OUT_INV_SEL_W { w: self }
    }
    #[doc = "Bit 9 - set this bit to select output enable signal.1:use GPIO_ENABLE_REG\\[n\\]
as output enable signal.:use peripheral output enable signal."]
    #[inline(always)]
    pub fn func_oen_sel(&mut self) -> FUNC_OEN_SEL_W {
        FUNC_OEN_SEL_W { w: self }
    }
    #[doc = "Bit 10 - set this bit to invert output enable signal.1:invert.:not invert."]
    #[inline(always)]
    pub fn func_oen_inv_sel(&mut self) -> FUNC_OEN_INV_SEL_W {
        FUNC_OEN_INV_SEL_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "GPIO output function select register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [func_out_sel_cfg](index.html) module"]
pub struct FUNC_OUT_SEL_CFG_SPEC;
impl crate::RegisterSpec for FUNC_OUT_SEL_CFG_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [func_out_sel_cfg::R](R) reader structure"]
impl crate::Readable for FUNC_OUT_SEL_CFG_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [func_out_sel_cfg::W](W) writer structure"]
impl crate::Writable for FUNC_OUT_SEL_CFG_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets FUNC%s_OUT_SEL_CFG to value 0x80"]
impl crate::Resettable for FUNC_OUT_SEL_CFG_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x80
    }
}
