#[doc = "Register `INFIFO_STATUS_CH2` reader"]
pub struct R(crate::R<INFIFO_STATUS_CH2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<INFIFO_STATUS_CH2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<INFIFO_STATUS_CH2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<INFIFO_STATUS_CH2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `INFIFO_FULL_CH2` reader - L1 Rx FIFO full signal for Rx channel 2."]
pub struct INFIFO_FULL_CH2_R(crate::FieldReader<bool, bool>);
impl INFIFO_FULL_CH2_R {
    pub(crate) fn new(bits: bool) -> Self {
        INFIFO_FULL_CH2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INFIFO_FULL_CH2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INFIFO_EMPTY_CH2` reader - L1 Rx FIFO empty signal for Rx channel 2."]
pub struct INFIFO_EMPTY_CH2_R(crate::FieldReader<bool, bool>);
impl INFIFO_EMPTY_CH2_R {
    pub(crate) fn new(bits: bool) -> Self {
        INFIFO_EMPTY_CH2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INFIFO_EMPTY_CH2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INFIFO_CNT_CH2` reader - The register stores the byte number of the data in L1 Rx FIFO for Rx channel 2."]
pub struct INFIFO_CNT_CH2_R(crate::FieldReader<u8, u8>);
impl INFIFO_CNT_CH2_R {
    pub(crate) fn new(bits: u8) -> Self {
        INFIFO_CNT_CH2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INFIFO_CNT_CH2_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IN_REMAIN_UNDER_1B_CH2` reader - reserved"]
pub struct IN_REMAIN_UNDER_1B_CH2_R(crate::FieldReader<bool, bool>);
impl IN_REMAIN_UNDER_1B_CH2_R {
    pub(crate) fn new(bits: bool) -> Self {
        IN_REMAIN_UNDER_1B_CH2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IN_REMAIN_UNDER_1B_CH2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IN_REMAIN_UNDER_2B_CH2` reader - reserved"]
pub struct IN_REMAIN_UNDER_2B_CH2_R(crate::FieldReader<bool, bool>);
impl IN_REMAIN_UNDER_2B_CH2_R {
    pub(crate) fn new(bits: bool) -> Self {
        IN_REMAIN_UNDER_2B_CH2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IN_REMAIN_UNDER_2B_CH2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IN_REMAIN_UNDER_3B_CH2` reader - reserved"]
pub struct IN_REMAIN_UNDER_3B_CH2_R(crate::FieldReader<bool, bool>);
impl IN_REMAIN_UNDER_3B_CH2_R {
    pub(crate) fn new(bits: bool) -> Self {
        IN_REMAIN_UNDER_3B_CH2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IN_REMAIN_UNDER_3B_CH2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IN_REMAIN_UNDER_4B_CH2` reader - reserved"]
pub struct IN_REMAIN_UNDER_4B_CH2_R(crate::FieldReader<bool, bool>);
impl IN_REMAIN_UNDER_4B_CH2_R {
    pub(crate) fn new(bits: bool) -> Self {
        IN_REMAIN_UNDER_4B_CH2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IN_REMAIN_UNDER_4B_CH2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IN_BUF_HUNGRY_CH2` reader - reserved"]
pub struct IN_BUF_HUNGRY_CH2_R(crate::FieldReader<bool, bool>);
impl IN_BUF_HUNGRY_CH2_R {
    pub(crate) fn new(bits: bool) -> Self {
        IN_BUF_HUNGRY_CH2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IN_BUF_HUNGRY_CH2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 0 - L1 Rx FIFO full signal for Rx channel 2."]
    #[inline(always)]
    pub fn infifo_full_ch2(&self) -> INFIFO_FULL_CH2_R {
        INFIFO_FULL_CH2_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - L1 Rx FIFO empty signal for Rx channel 2."]
    #[inline(always)]
    pub fn infifo_empty_ch2(&self) -> INFIFO_EMPTY_CH2_R {
        INFIFO_EMPTY_CH2_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bits 2:7 - The register stores the byte number of the data in L1 Rx FIFO for Rx channel 2."]
    #[inline(always)]
    pub fn infifo_cnt_ch2(&self) -> INFIFO_CNT_CH2_R {
        INFIFO_CNT_CH2_R::new(((self.bits >> 2) & 0x3f) as u8)
    }
    #[doc = "Bit 23 - reserved"]
    #[inline(always)]
    pub fn in_remain_under_1b_ch2(&self) -> IN_REMAIN_UNDER_1B_CH2_R {
        IN_REMAIN_UNDER_1B_CH2_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 24 - reserved"]
    #[inline(always)]
    pub fn in_remain_under_2b_ch2(&self) -> IN_REMAIN_UNDER_2B_CH2_R {
        IN_REMAIN_UNDER_2B_CH2_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 25 - reserved"]
    #[inline(always)]
    pub fn in_remain_under_3b_ch2(&self) -> IN_REMAIN_UNDER_3B_CH2_R {
        IN_REMAIN_UNDER_3B_CH2_R::new(((self.bits >> 25) & 0x01) != 0)
    }
    #[doc = "Bit 26 - reserved"]
    #[inline(always)]
    pub fn in_remain_under_4b_ch2(&self) -> IN_REMAIN_UNDER_4B_CH2_R {
        IN_REMAIN_UNDER_4B_CH2_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bit 27 - reserved"]
    #[inline(always)]
    pub fn in_buf_hungry_ch2(&self) -> IN_BUF_HUNGRY_CH2_R {
        IN_BUF_HUNGRY_CH2_R::new(((self.bits >> 27) & 0x01) != 0)
    }
}
#[doc = "DMA_INFIFO_STATUS_CH2_REG.\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [infifo_status_ch2](index.html) module"]
pub struct INFIFO_STATUS_CH2_SPEC;
impl crate::RegisterSpec for INFIFO_STATUS_CH2_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [infifo_status_ch2::R](R) reader structure"]
impl crate::Readable for INFIFO_STATUS_CH2_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets INFIFO_STATUS_CH2 to value 0x0780_0003"]
impl crate::Resettable for INFIFO_STATUS_CH2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0780_0003
    }
}
