# esl

A library for reading, writing and processing ESM/ESP/ESS files.

```rust
fn main() {
    let input = std::fs::File::open(file.clone()).unwrap(); 
    let mut input = std::io::BufReader::new(input);
    let records = Records::new(CodePage::Russian, 0, &mut input);
    let records = records.map(|x| {
        match x {
            Ok(mut x) => {
                x.fit();
                x
            },
            Err(e) => panic!(format!("{}", e))
        }
    }).collect::<Vec<_>>();
    let output = std::fs::File::create(file + ".yaml").unwrap();
    serde_yaml::to_writer(std::io::BufWriter::new(output), &records).unwrap();
}
```
