extern crate quote;
extern crate syn;

use proc_macro::TokenStream;
use quote::quote;
use syn::{parse_macro_input, DeriveInput};

#[proc_macro_derive(ENum)]
pub fn e_num(item: TokenStream) -> TokenStream {
    let ast = parse_macro_input!(item as DeriveInput);

    let impl_ident = &ast.ident;

    quote! {
    impl From<#impl_ident> for usize {
        fn from(opt: #impl_ident) -> usize {
            opt as usize
        }
    }
    }
    .into()
}
