extern crate quote;
extern crate syn;

use proc_macro::TokenStream;
use quote::quote;
use syn::{parse_macro_input, DeriveInput};

#[proc_macro_derive(ENum)]
pub fn e_num(item: TokenStream) -> TokenStream {
    let ast = parse_macro_input!(item as DeriveInput);

    let impl_ident = &ast.ident;

    quote! {
        impl From<usize> for #impl_ident {
            fn from(self) -> usize {
                self as usize
            }
        }
    }
    .into()
}
