# Merging with upstream evanw/esbuild

## Initial setup

- `git remote add upstream https://github.com/evanw/esbuild.git`.

## Fetching and merging

- `git fetch upstream`.
- Make sure the local repo is on the `master` branch i.e. `git checkout master`.
- Merge with the latest stable version (**not** `master`) e.g. `git merge v0.13.8`.
- Delete all tests (`*test.go`) and snapshots (`snapshots_*.txt`).
- Try to delete all files that require dependencies outside the standard Go library. Once removed, delete these dependencies from `go.mod`.
  - This will often involve deleting platform specific module files or build constraints (e.g. a generic implementation may be restricted to non-Windows/macOS/Linux, which we remove so we can use it and delete the other bloated platform-specific module files). This is usually OK, as we don't care about enhanced terminal logging or filesystem caching (this library is meant to be used as a low-level internal library, not a CLI or plug-and-play library).
- Delete all files outside the library:
  - CLI e.g. `/cmd/**`, `/pkg/cli/**`.
  - Server e.g. `/api/serve**`.
  - Node.js e.g. `/lib/**`, `/npm/**`, `/require/**`, `/scripts/**`.
  - Repo e.g. `/.github/**`, `/docs/**`, `/images/**`.
- Remove deleted files/folders from `.gitignore`.
- Avoid modifying upstream code within files, as that will make it harder for all merges in the future.
- If in doubt, check previous fork-specific (not upstream) commits in the Git history.
- Check for API changes and update `ffiapi` if necessary.
  - Unsupported features: logging, plugins, stdin, watching.
- Test by building:
  - Make a temporary folder outside the repo, referred to as `$TMP`.
  - `mkdir -p "$TMP/vendor/github.com/evanw"`.
  - `ln -s "$REPO" "$TMP/vendor/github.com/evanw/esbuild`, where `$REPO` is the path to this repo's directory.
  - From `$TMP`, run `go build -mod=vendor -buildmode=c-archive -o out vendor/github.com/evanw/esbuild/pkg/ffiapi/ffiapi.go`.
