# Merging with upstream evanw/esbuild

- Delete all tests (`*test.go`) and snapshots (`snapshots_*.txt`).
- Try to delete all files that require dependencies outside the standard Go library. Delete dependencies from `go.mod`.
- Delete all files outside the library:
  - CLI e.g. `/cmd/**`, `/pkg/cli/**`.
  - Node.js e.g. `/lib/**`, `/npm/**`, `/require/**`, `/scripts/**`.
  - Repo e.g. `/.github/**`, `/docs/**`, `/images/**`.
- Remove deleted files/folders from `.gitignore`. 
- Avoid modifying upstream code within files, as that will make it harder for all merges in the future.
- If in doubt, check previous fork-specific (not upstream) commits in the Git history.
- Check for API changes and update `ffiapi` if necessary.
  - Unsupported features: logging, plugins, stdin, watching.
- Test by building.
