#[doc = "<s>Vulkan Manual Page</s> · Constant"]
#[doc(alias = "VK_KHR_DEVICE_GROUP_SPEC_VERSION")]
pub const KHR_DEVICE_GROUP_SPEC_VERSION: u32 = 4;
#[doc = "<s>Vulkan Manual Page</s> · Constant"]
#[doc(alias = "VK_KHR_DEVICE_GROUP_EXTENSION_NAME")]
pub const KHR_DEVICE_GROUP_EXTENSION_NAME: *const std::os::raw::c_char = crate::cstr!("VK_KHR_device_group");
#[doc = "<s>Vulkan Manual Page</s> · Constant"]
pub const FN_GET_DEVICE_GROUP_PEER_MEMORY_FEATURES_KHR: *const std::os::raw::c_char = crate::cstr!("vkGetDeviceGroupPeerMemoryFeaturesKHR");
#[doc = "<s>Vulkan Manual Page</s> · Constant"]
pub const FN_CMD_SET_DEVICE_MASK_KHR: *const std::os::raw::c_char = crate::cstr!("vkCmdSetDeviceMaskKHR");
#[doc = "<s>Vulkan Manual Page</s> · Constant"]
pub const FN_CMD_DISPATCH_BASE_KHR: *const std::os::raw::c_char = crate::cstr!("vkCmdDispatchBaseKHR");
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPeerMemoryFeatureFlagsKHR.html) · Alias"]
#[doc(alias = "VkPeerMemoryFeatureFlagsKHR")]
#[allow(non_camel_case_types)]
pub type PeerMemoryFeatureFlagsKHR = crate::vk1_1::PeerMemoryFeatureFlags;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryAllocateFlagsKHR.html) · Alias"]
#[doc(alias = "VkMemoryAllocateFlagsKHR")]
#[allow(non_camel_case_types)]
pub type MemoryAllocateFlagsKHR = crate::vk1_1::MemoryAllocateFlags;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkPeerMemoryFeatureFlagBitsKHR.html) · Alias"]
#[doc(alias = "VkPeerMemoryFeatureFlagBitsKHR")]
#[allow(non_camel_case_types)]
pub type PeerMemoryFeatureFlagBitsKHR = crate::vk1_1::PeerMemoryFeatureFlagBits;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryAllocateFlagBitsKHR.html) · Alias"]
#[doc(alias = "VkMemoryAllocateFlagBitsKHR")]
#[allow(non_camel_case_types)]
pub type MemoryAllocateFlagBitsKHR = crate::vk1_1::MemoryAllocateFlagBits;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryAllocateFlagsInfoKHR.html) · Alias"]
#[doc(alias = "VkMemoryAllocateFlagsInfoKHR")]
#[allow(non_camel_case_types)]
pub type MemoryAllocateFlagsInfoKHR = crate::vk1_1::MemoryAllocateFlagsInfo;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkMemoryAllocateFlagsInfoKHR.html) · Alias"]
#[doc(alias = "VkMemoryAllocateFlagsInfoKHR")]
#[allow(non_camel_case_types)]
pub type MemoryAllocateFlagsInfoKHRBuilder<'a> = crate::vk1_1::MemoryAllocateFlagsInfoBuilder<'a>;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindBufferMemoryDeviceGroupInfoKHR.html) · Alias"]
#[doc(alias = "VkBindBufferMemoryDeviceGroupInfoKHR")]
#[allow(non_camel_case_types)]
pub type BindBufferMemoryDeviceGroupInfoKHR = crate::vk1_1::BindBufferMemoryDeviceGroupInfo;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindBufferMemoryDeviceGroupInfoKHR.html) · Alias"]
#[doc(alias = "VkBindBufferMemoryDeviceGroupInfoKHR")]
#[allow(non_camel_case_types)]
pub type BindBufferMemoryDeviceGroupInfoKHRBuilder<'a> = crate::vk1_1::BindBufferMemoryDeviceGroupInfoBuilder<'a>;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindImageMemoryDeviceGroupInfoKHR.html) · Alias"]
#[doc(alias = "VkBindImageMemoryDeviceGroupInfoKHR")]
#[allow(non_camel_case_types)]
pub type BindImageMemoryDeviceGroupInfoKHR = crate::vk1_1::BindImageMemoryDeviceGroupInfo;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkBindImageMemoryDeviceGroupInfoKHR.html) · Alias"]
#[doc(alias = "VkBindImageMemoryDeviceGroupInfoKHR")]
#[allow(non_camel_case_types)]
pub type BindImageMemoryDeviceGroupInfoKHRBuilder<'a> = crate::vk1_1::BindImageMemoryDeviceGroupInfoBuilder<'a>;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupRenderPassBeginInfoKHR.html) · Alias"]
#[doc(alias = "VkDeviceGroupRenderPassBeginInfoKHR")]
#[allow(non_camel_case_types)]
pub type DeviceGroupRenderPassBeginInfoKHR = crate::vk1_1::DeviceGroupRenderPassBeginInfo;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupRenderPassBeginInfoKHR.html) · Alias"]
#[doc(alias = "VkDeviceGroupRenderPassBeginInfoKHR")]
#[allow(non_camel_case_types)]
pub type DeviceGroupRenderPassBeginInfoKHRBuilder<'a> = crate::vk1_1::DeviceGroupRenderPassBeginInfoBuilder<'a>;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupCommandBufferBeginInfoKHR.html) · Alias"]
#[doc(alias = "VkDeviceGroupCommandBufferBeginInfoKHR")]
#[allow(non_camel_case_types)]
pub type DeviceGroupCommandBufferBeginInfoKHR = crate::vk1_1::DeviceGroupCommandBufferBeginInfo;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupCommandBufferBeginInfoKHR.html) · Alias"]
#[doc(alias = "VkDeviceGroupCommandBufferBeginInfoKHR")]
#[allow(non_camel_case_types)]
pub type DeviceGroupCommandBufferBeginInfoKHRBuilder<'a> = crate::vk1_1::DeviceGroupCommandBufferBeginInfoBuilder<'a>;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupSubmitInfoKHR.html) · Alias"]
#[doc(alias = "VkDeviceGroupSubmitInfoKHR")]
#[allow(non_camel_case_types)]
pub type DeviceGroupSubmitInfoKHR = crate::vk1_1::DeviceGroupSubmitInfo;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupSubmitInfoKHR.html) · Alias"]
#[doc(alias = "VkDeviceGroupSubmitInfoKHR")]
#[allow(non_camel_case_types)]
pub type DeviceGroupSubmitInfoKHRBuilder<'a> = crate::vk1_1::DeviceGroupSubmitInfoBuilder<'a>;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupBindSparseInfoKHR.html) · Alias"]
#[doc(alias = "VkDeviceGroupBindSparseInfoKHR")]
#[allow(non_camel_case_types)]
pub type DeviceGroupBindSparseInfoKHR = crate::vk1_1::DeviceGroupBindSparseInfo;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/VkDeviceGroupBindSparseInfoKHR.html) · Alias"]
#[doc(alias = "VkDeviceGroupBindSparseInfoKHR")]
#[allow(non_camel_case_types)]
pub type DeviceGroupBindSparseInfoKHRBuilder<'a> = crate::vk1_1::DeviceGroupBindSparseInfoBuilder<'a>;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceGroupPeerMemoryFeaturesKHR.html) · Alias"]
#[allow(non_camel_case_types)]
pub type PFN_vkGetDeviceGroupPeerMemoryFeaturesKHR = crate::vk1_1::PFN_vkGetDeviceGroupPeerMemoryFeatures;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetDeviceMaskKHR.html) · Alias"]
#[allow(non_camel_case_types)]
pub type PFN_vkCmdSetDeviceMaskKHR = crate::vk1_1::PFN_vkCmdSetDeviceMask;
#[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDispatchBaseKHR.html) · Alias"]
#[allow(non_camel_case_types)]
pub type PFN_vkCmdDispatchBaseKHR = crate::vk1_1::PFN_vkCmdDispatchBase;
#[doc = "Provided by [`crate::extensions::khr_device_group`]"]
impl crate::vk1_0::ImageCreateFlagBits {
    pub const SPLIT_INSTANCE_BIND_REGIONS_KHR: Self = Self::SPLIT_INSTANCE_BIND_REGIONS;
}
#[doc = "Provided by [`crate::extensions::khr_device_group`]"]
impl crate::vk1_0::PipelineCreateFlagBits {
    pub const VIEW_INDEX_FROM_DEVICE_INDEX_KHR: Self = Self::VIEW_INDEX_FROM_DEVICE_INDEX;
    pub const DISPATCH_BASE_KHR: Self = Self::DISPATCH_BASE;
}
#[doc = "Provided by [`crate::extensions::khr_device_group`]"]
impl crate::vk1_0::StructureType {
    pub const MEMORY_ALLOCATE_FLAGS_INFO_KHR: Self = Self::MEMORY_ALLOCATE_FLAGS_INFO;
    pub const DEVICE_GROUP_RENDER_PASS_BEGIN_INFO_KHR: Self = Self::DEVICE_GROUP_RENDER_PASS_BEGIN_INFO;
    pub const DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO_KHR: Self = Self::DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO;
    pub const DEVICE_GROUP_SUBMIT_INFO_KHR: Self = Self::DEVICE_GROUP_SUBMIT_INFO;
    pub const DEVICE_GROUP_BIND_SPARSE_INFO_KHR: Self = Self::DEVICE_GROUP_BIND_SPARSE_INFO;
    pub const BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO_KHR: Self = Self::BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO;
    pub const BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO_KHR: Self = Self::BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO;
}
#[doc = "Provided by [`crate::extensions::khr_device_group`]"]
impl crate::vk1_0::DependencyFlagBits {
    pub const DEVICE_GROUP_KHR: Self = Self::DEVICE_GROUP;
}
#[doc = "Provided by [`crate::extensions::khr_device_group`]"]
impl crate::vk1_1::PeerMemoryFeatureFlagBits {
    pub const COPY_SRC_KHR: Self = Self::COPY_SRC;
    pub const COPY_DST_KHR: Self = Self::COPY_DST;
    pub const GENERIC_SRC_KHR: Self = Self::GENERIC_SRC;
    pub const GENERIC_DST_KHR: Self = Self::GENERIC_DST;
}
#[doc = "Provided by [`crate::extensions::khr_device_group`]"]
impl crate::vk1_1::MemoryAllocateFlagBits {
    pub const DEVICE_MASK_KHR: Self = Self::DEVICE_MASK;
}
#[doc = "Provided by [`crate::extensions::khr_device_group`]"]
impl crate::DeviceLoader {
    #[inline]
    #[track_caller]
    #[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkGetDeviceGroupPeerMemoryFeaturesKHR.html) · Function"]
    #[doc(alias = "vkGetDeviceGroupPeerMemoryFeaturesKHR")]
    pub unsafe fn get_device_group_peer_memory_features_khr(&self, heap_index: u32, local_device_index: u32, remote_device_index: u32) -> crate::vk1_1::PeerMemoryFeatureFlags {
        let _function = self.get_device_group_peer_memory_features_khr.expect(crate::NOT_LOADED_MESSAGE);
        let mut peer_memory_features = Default::default();
        let _return = _function(self.handle, heap_index as _, local_device_index as _, remote_device_index as _, &mut peer_memory_features);
        peer_memory_features
    }
    #[inline]
    #[track_caller]
    #[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdSetDeviceMaskKHR.html) · Function"]
    #[doc(alias = "vkCmdSetDeviceMaskKHR")]
    pub unsafe fn cmd_set_device_mask_khr(&self, command_buffer: crate::vk1_0::CommandBuffer, device_mask: u32) -> () {
        let _function = self.cmd_set_device_mask_khr.expect(crate::NOT_LOADED_MESSAGE);
        let _return = _function(command_buffer as _, device_mask as _);
        ()
    }
    #[inline]
    #[track_caller]
    #[doc = "[Vulkan Manual Page](https://www.khronos.org/registry/vulkan/specs/1.2-extensions/man/html/vkCmdDispatchBaseKHR.html) · Function"]
    #[doc(alias = "vkCmdDispatchBaseKHR")]
    pub unsafe fn cmd_dispatch_base_khr(&self, command_buffer: crate::vk1_0::CommandBuffer, base_group_x: u32, base_group_y: u32, base_group_z: u32, group_count_x: u32, group_count_y: u32, group_count_z: u32) -> () {
        let _function = self.cmd_dispatch_base_khr.expect(crate::NOT_LOADED_MESSAGE);
        let _return = _function(command_buffer as _, base_group_x as _, base_group_y as _, base_group_z as _, group_count_x as _, group_count_y as _, group_count_z as _);
        ()
    }
}
