# erl_nif

This crate provides bindings to the [erl_nif](https://erlang.org/doc/man/erl_nif.html) C API, making it easy to write native extensions for Erlang and Elixir in Rust.

## Example

Write your NIF in Rust:

```rust
erl_nif::init!(
  name: "Elixir.Add",
  funcs: [add],
);

#[erl_nif::nif]
fn add(a: u64, b: u64) -> Result<u64, String> {
  Ok(a + b)
}
```

Then load it in Elixir.

```elixir
defmodule Add do
  @on_load {:init, 0}
  def init do
    path = :filename.join(:code.priv_dir(:add), "libadd")
    :ok = :erlang.load_nif(path, nil)
  end

  def add(_) do
    :erlang.nif_error(:nif_not_loaded)
  end
end
```

See the examples folder for a complete example.

## Serde integration

To make it easy to move data structures between Rust and Elixir, the erl_nif crate supports integration with [serde](https://serde.rs).

```rust
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename = "Elixir.Example.Contact")]
struct Contact {
  name: String,
  email: String,
}
```

```elixir
defmodule Example do
  defmodule Contact do
    defstruct [
      :name,
      :email
    ]
  end
end
```
