//! # Kitchen
//! Module to deal with the backgorund of a restaurant: the kitchen

/// An enum to deal with ingredients. Necessary for many functions and structs in this library.

pub enum Ingredients
{
    Potato,
    Meat,
    Fish,
    Ships,
}

/// A Dish
pub struct Dish <'a>
{
    pub ingredients: Vec<Ingredients>,
    pub chef: &'a Chef, 
}
/// A Chef

pub struct Chef
{
    name: String,
    age: i32,
    dishes_made: i32,
}


impl Chef {
    pub fn new(name: String, age: i32) -> Chef {
        Chef{
            name: name,
            age: age,
            dishes_made: 0,
        }
    }

    pub fn make_dish<'a >(&'a mut self, ingredients: Vec<Ingredients>) -> Dish {
        self.dishes_made += 1;
        Dish {
            ingredients: ingredients,
            chef: self,
        }
    }

}