
# This file was @generated by crate2nix 0.9.0-alpha.1 with the command:
#   "generate"
# See https://github.com/kolloch/crate2nix for more info.

{ nixpkgs ? <nixpkgs>
, pkgs ? import nixpkgs { config = {}; }
, lib ? pkgs.lib
, stdenv ? pkgs.stdenv
, buildRustCrate ? pkgs.buildRustCrate
  # This is used as the `crateOverrides` argument for `buildRustCrate`.
, defaultCrateOverrides ? pkgs.defaultCrateOverrides
  # The features to enable for the root_crate or the workspace_members.
, rootFeatures ? [ "default" ]
  # If true, throw errors instead of issueing deprecation warnings.
, strictDeprecation ? false
  # Whether to perform release builds: longer compile times, faster binaries.
, release ? true
  # Additional crate2nix configuration if it exists.
, crateConfig
  ? if builtins.pathExists ./crate-config.nix
    then pkgs.callPackage ./crate-config.nix {}
    else {}
}:

rec {
  #
  # "public" attributes that we attempt to keep stable with new versions of crate2nix.
  #

  rootCrate = rec {
    packageId = "erbium";

    # Use this attribute to refer to the derivation building your root crate package.
    # You can override the features with rootCrate.build.override { features = [ "default" "feature1" ... ]; }.
    build = internal.buildRustCrateWithFeatures {
      inherit packageId;
    };

    # Debug support which might change between releases.
    # File a bug if you depend on any for non-debug work!
    debug = internal.debugCrate { inherit packageId; };
  };
  # Refer your crate build derivation by name here.
  # You can override the features with
  # workspaceMembers."${crateName}".build.override { features = [ "default" "feature1" ... ]; }.
  workspaceMembers = {
    "erbium" = rec {
      packageId = "erbium";
      build = internal.buildRustCrateWithFeatures {
        packageId = "erbium";
      };

      # Debug support which might change between releases.
      # File a bug if you depend on any for non-debug work!
      debug = internal.debugCrate { inherit packageId; };
    };
  };

  # A derivation that joins the outputs of all workspace members together.
  allWorkspaceMembers = pkgs.symlinkJoin {
      name = "all-workspace-members";
      paths =
        let members = builtins.attrValues workspaceMembers;
        in builtins.map (m: m.build) members;
  };

  #
  # "internal" ("private") attributes that may change in every new version of crate2nix.
  #

  internal = rec {
    # Build and dependency information for crates.
    # Many of the fields are passed one-to-one to buildRustCrate.
    #
    # Noteworthy:
    # * `dependencies`/`buildDependencies`: similar to the corresponding fields for buildRustCrate.
    #   but with additional information which is used during dependency/feature resolution.
    # * `resolvedDependencies`: the selected default features reported by cargo - only included for debugging.
    # * `devDependencies` as of now not used by `buildRustCrate` but used to
    #   inject test dependencies into the build

    crates = {
      "adler" = rec {
        crateName = "adler";
        version = "1.0.2";
        edition = "2015";
        sha256 = "1zim79cvzd5yrkzl3nyfx0avijwgk9fqv3yrscdy1cc79ih02qpj";
        authors = [
          "Jonas Schievink <jonasschievink@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
      };
      "ahash" = rec {
        crateName = "ahash";
        version = "0.7.4";
        edition = "2018";
        sha256 = "163vy6jcd7r3jczsv4zyhlc5x9dqsfgg1yrqbm3xhygr1czq7fs3";
        authors = [
          "Tom Kaitchuck <Tom.Kaitchuck@gmail.com>"
        ];
        dependencies = [
          {
            name = "getrandom";
            packageId = "getrandom";
            target = { target, features }: ((target."os" == "linux") || (target."os" == "android") || (target."os" == "windows") || (target."os" == "macos") || (target."os" == "ios") || (target."os" == "freebsd") || (target."os" == "openbsd") || (target."os" == "netbsd") || (target."os" == "dragonfly") || (target."os" == "solaris") || (target."os" == "illumos") || (target."os" == "fuchsia") || (target."os" == "redox") || (target."os" == "cloudabi") || (target."os" == "haiku") || (target."os" == "vxworks") || (target."os" == "emscripten") || (target."os" == "wasi"));
          }
          {
            name = "once_cell";
            packageId = "once_cell";
            usesDefaultFeatures = false;
            target = { target, features }: ((target."os" == "linux") || (target."os" == "android") || (target."os" == "windows") || (target."os" == "macos") || (target."os" == "ios") || (target."os" == "freebsd") || (target."os" == "openbsd") || (target."os" == "netbsd") || (target."os" == "dragonfly") || (target."os" == "solaris") || (target."os" == "illumos") || (target."os" == "fuchsia") || (target."os" == "redox") || (target."os" == "cloudabi") || (target."os" == "haiku") || (target."os" == "vxworks") || (target."os" == "emscripten") || (target."os" == "wasi"));
            features = [ "unstable" "alloc" ];
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check";
          }
        ];
        features = {
          "compile-time-rng" = [ "const-random" ];
          "default" = [ "std" ];
        };
      };
      "aho-corasick" = rec {
        crateName = "aho-corasick";
        version = "0.7.18";
        edition = "2018";
        sha256 = "0vv50b3nvkhyy7x7ip19qnsq11bqlnffkmj2yx2xlyk5wzawydqy";
        libName = "aho_corasick";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "memchr";
            packageId = "memchr";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "memchr/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "anyhow" = rec {
        crateName = "anyhow";
        version = "1.0.42";
        edition = "2018";
        sha256 = "11n4mf7psp5pyy9zjp6yg2kqx822f7q9jyq6nmf5bm30gbx3qpar";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "arbitrary" = rec {
        crateName = "arbitrary";
        version = "1.0.1";
        edition = "2018";
        sha256 = "14a6r7q9b1kf1m7810p8bcl51q11mrwc5z7fjkz0lx6kdvyk0x13";
        authors = [
          "The Rust-Fuzz Project Developers"
          "Nick Fitzgerald <fitzgen@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
          "Simonas Kazlauskas <arbitrary@kazlauskas.me>"
          "Brian L. Troutwine <brian@troutwine.us>"
          "Corey Farwell <coreyf@rwell.org>"
        ];
        dependencies = [
          {
            name = "derive_arbitrary";
            packageId = "derive_arbitrary";
            optional = true;
          }
        ];
        features = {
          "derive" = [ "derive_arbitrary" ];
        };
        resolvedDefaultFeatures = [ "derive" "derive_arbitrary" ];
      };
      "async-channel" = rec {
        crateName = "async-channel";
        version = "1.6.1";
        edition = "2018";
        sha256 = "06b3sq2hd8qwl2xxlc4qalg6xw3l9b41w4sym9g0q70mf93dc511";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        dependencies = [
          {
            name = "concurrent-queue";
            packageId = "concurrent-queue";
          }
          {
            name = "event-listener";
            packageId = "event-listener";
          }
          {
            name = "futures-core";
            packageId = "futures-core";
          }
        ];
        
      };
      "async-executor" = rec {
        crateName = "async-executor";
        version = "1.4.1";
        edition = "2018";
        sha256 = "0rd9sd0rksvjwx4zzy6c69qcd7bwp3z42rpiiizfnbm2w2srn7w7";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        dependencies = [
          {
            name = "async-task";
            packageId = "async-task";
          }
          {
            name = "concurrent-queue";
            packageId = "concurrent-queue";
          }
          {
            name = "fastrand";
            packageId = "fastrand";
          }
          {
            name = "futures-lite";
            packageId = "futures-lite";
          }
          {
            name = "once_cell";
            packageId = "once_cell";
          }
          {
            name = "slab";
            packageId = "slab";
          }
        ];
        
      };
      "async-global-executor" = rec {
        crateName = "async-global-executor";
        version = "2.0.2";
        edition = "2018";
        sha256 = "1xjacr43sbz2zk0zygpd9k14n95wa61x8n9i8mcdwdkz659fr1lm";
        authors = [
          "Marc-Antoine Perennou <Marc-Antoine@Perennou.com>"
        ];
        dependencies = [
          {
            name = "async-channel";
            packageId = "async-channel";
          }
          {
            name = "async-executor";
            packageId = "async-executor";
          }
          {
            name = "async-io";
            packageId = "async-io";
            optional = true;
          }
          {
            name = "async-mutex";
            packageId = "async-mutex";
          }
          {
            name = "blocking";
            packageId = "blocking";
          }
          {
            name = "futures-lite";
            packageId = "futures-lite";
          }
          {
            name = "num_cpus";
            packageId = "num_cpus";
          }
          {
            name = "once_cell";
            packageId = "once_cell";
          }
          {
            name = "tokio";
            packageId = "tokio 0.2.25";
            rename = "tokio02-crate";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "rt-core" ];
          }
        ];
        features = {
          "default" = [ "async-io" ];
          "tokio" = [ "tokio-crate" ];
          "tokio02" = [ "tokio02-crate" ];
          "tokio03" = [ "tokio03-crate" ];
        };
        resolvedDefaultFeatures = [ "async-io" "default" "tokio02" "tokio02-crate" ];
      };
      "async-io" = rec {
        crateName = "async-io";
        version = "1.6.0";
        edition = "2018";
        sha256 = "0yv0xv7nhkdhyz9z5q1hq9bavlmkrysrd1q30h69yhzjg6jfc4d8";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        dependencies = [
          {
            name = "concurrent-queue";
            packageId = "concurrent-queue";
          }
          {
            name = "futures-lite";
            packageId = "futures-lite";
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: target."unix";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "once_cell";
            packageId = "once_cell";
          }
          {
            name = "parking";
            packageId = "parking";
          }
          {
            name = "polling";
            packageId = "polling";
          }
          {
            name = "slab";
            packageId = "slab";
          }
          {
            name = "socket2";
            packageId = "socket2";
            features = [ "all" ];
          }
          {
            name = "waker-fn";
            packageId = "waker-fn";
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: target."windows";
            features = [ "winsock2" ];
          }
        ];
        
      };
      "async-lock" = rec {
        crateName = "async-lock";
        version = "2.4.0";
        edition = "2018";
        sha256 = "12vrxabscfq0a20qayf60fqpgg3xchga7bawgh0a2iwrpxhyma76";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        dependencies = [
          {
            name = "event-listener";
            packageId = "event-listener";
          }
        ];
        
      };
      "async-mutex" = rec {
        crateName = "async-mutex";
        version = "1.4.0";
        edition = "2018";
        sha256 = "0vhmsscqx48dmxw0yir6az0pbwcq6qjvcv2f43vdpn95vd9bi7a7";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        dependencies = [
          {
            name = "event-listener";
            packageId = "event-listener";
          }
        ];
        
      };
      "async-std" = rec {
        crateName = "async-std";
        version = "1.9.0";
        edition = "2018";
        sha256 = "0h834fni3npsggjqin8386d2fn11m2z42dr1ymq0aknppa2ndw6r";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
          "Yoshua Wuyts <yoshuawuyts@gmail.com>"
          "Friedel Ziegelmayer <me@dignifiedquire.com>"
          "Contributors to async-std"
        ];
        dependencies = [
          {
            name = "async-channel";
            packageId = "async-channel";
            optional = true;
          }
          {
            name = "async-global-executor";
            packageId = "async-global-executor";
            optional = true;
            target = { target, features }: (!(target."os" == "unknown"));
            features = [ "async-io" ];
          }
          {
            name = "async-io";
            packageId = "async-io";
            optional = true;
            target = { target, features }: (!(target."os" == "unknown"));
          }
          {
            name = "async-lock";
            packageId = "async-lock";
            optional = true;
          }
          {
            name = "crossbeam-utils";
            packageId = "crossbeam-utils";
            optional = true;
          }
          {
            name = "futures-channel";
            packageId = "futures-channel";
            optional = true;
            target = { target, features }: (target."arch" == "wasm32");
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "futures-io";
            packageId = "futures-io";
            optional = true;
          }
          {
            name = "futures-lite";
            packageId = "futures-lite";
            optional = true;
            target = { target, features }: (!(target."os" == "unknown"));
          }
          {
            name = "gloo-timers";
            packageId = "gloo-timers";
            optional = true;
            target = { target, features }: (target."arch" == "wasm32");
            features = [ "futures" ];
          }
          {
            name = "kv-log-macro";
            packageId = "kv-log-macro";
            optional = true;
          }
          {
            name = "log";
            packageId = "log";
            optional = true;
            features = [ "kv_unstable" ];
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
          }
          {
            name = "num_cpus";
            packageId = "num_cpus";
            optional = true;
          }
          {
            name = "once_cell";
            packageId = "once_cell";
            optional = true;
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite 0.2.7";
            optional = true;
          }
          {
            name = "pin-utils";
            packageId = "pin-utils";
            optional = true;
          }
          {
            name = "slab";
            packageId = "slab";
            optional = true;
          }
          {
            name = "wasm-bindgen-futures";
            packageId = "wasm-bindgen-futures";
            optional = true;
            target = { target, features }: (target."arch" == "wasm32");
          }
        ];
        features = {
          "alloc" = [ "futures-core/alloc" "pin-project-lite" ];
          "attributes" = [ "async-attributes" ];
          "default" = [ "std" "async-global-executor" "async-io" "futures-lite" "kv-log-macro" "log" "num_cpus" "pin-project-lite" "gloo-timers" ];
          "docs" = [ "attributes" "unstable" "default" ];
          "std" = [ "alloc" "crossbeam-utils" "futures-core/std" "futures-io" "memchr" "once_cell" "pin-utils" "slab" "wasm-bindgen-futures" "futures-channel" "async-channel" "async-lock" ];
          "tokio02" = [ "async-global-executor/tokio02" ];
          "tokio03" = [ "async-global-executor/tokio03" ];
          "tokio1" = [ "async-global-executor/tokio" ];
          "unstable" = [ "std" "async-io" "async-process" ];
        };
        resolvedDefaultFeatures = [ "alloc" "async-channel" "async-global-executor" "async-io" "async-lock" "crossbeam-utils" "default" "futures-channel" "futures-core" "futures-io" "futures-lite" "gloo-timers" "kv-log-macro" "log" "memchr" "num_cpus" "once_cell" "pin-project-lite" "pin-utils" "slab" "std" "tokio02" "wasm-bindgen-futures" ];
      };
      "async-task" = rec {
        crateName = "async-task";
        version = "4.0.3";
        edition = "2018";
        sha256 = "1w0a1c8jim6s5bvcyiiwg9m4bdv3xnd4hbjm97ndgmphmgg32679";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "async-trait" = rec {
        crateName = "async-trait";
        version = "0.1.50";
        edition = "2018";
        sha256 = "08m7xim7dvcjw5cx2ryz3wndxc0vib2s02qrvabxvg2cpd5yi60b";
        procMacro = true;
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "full" "visit-mut" ];
          }
        ];
        
      };
      "atomic-waker" = rec {
        crateName = "atomic-waker";
        version = "1.0.0";
        edition = "2018";
        sha256 = "0ansiq5vlw684fhks2x4a4is2rqlbv50q5mi8x0fxxvx5q2p8lq6";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        
      };
      "atty" = rec {
        crateName = "atty";
        version = "0.2.14";
        edition = "2015";
        sha256 = "1s7yslcs6a28c5vz7jwj63lkfgyx8mx99fdirlhi9lbhhzhrpcyr";
        authors = [
          "softprops <d.tangren@gmail.com>"
        ];
        dependencies = [
          {
            name = "hermit-abi";
            packageId = "hermit-abi";
            target = { target, features }: (target."os" == "hermit");
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: target."unix";
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: target."windows";
            features = [ "consoleapi" "processenv" "minwinbase" "minwindef" "winbase" ];
          }
        ];
        
      };
      "autocfg" = rec {
        crateName = "autocfg";
        version = "1.0.1";
        edition = "2015";
        sha256 = "0jj6i9zn4gjl03kjvziqdji6rwx8ykz8zk2ngpc331z2g3fk3c6d";
        authors = [
          "Josh Stone <cuviper@gmail.com>"
        ];
        
      };
      "bitflags" = rec {
        crateName = "bitflags";
        version = "1.2.1";
        edition = "2015";
        sha256 = "14qnd5nq8p2almk79m4m8ydqhd413yaxsyjp5xd19g3mikzf47fg";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "blocking" = rec {
        crateName = "blocking";
        version = "1.0.2";
        edition = "2018";
        sha256 = "1s9myg9gqmwzrbc38p23bh4vkc8w4pbpddqrcrrl1xz1xpdp1qf5";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        dependencies = [
          {
            name = "async-channel";
            packageId = "async-channel";
          }
          {
            name = "async-task";
            packageId = "async-task";
          }
          {
            name = "atomic-waker";
            packageId = "atomic-waker";
          }
          {
            name = "fastrand";
            packageId = "fastrand";
          }
          {
            name = "futures-lite";
            packageId = "futures-lite";
          }
          {
            name = "once_cell";
            packageId = "once_cell";
          }
        ];
        
      };
      "bumpalo" = rec {
        crateName = "bumpalo";
        version = "3.7.0";
        edition = "2018";
        sha256 = "0ccn025n0x1gc0ijjlabin2xs7dkx5yfagkskr93yw9c06pyfncw";
        authors = [
          "Nick Fitzgerald <fitzgen@gmail.com>"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "byteorder" = rec {
        crateName = "byteorder";
        version = "1.4.3";
        edition = "2018";
        sha256 = "0456lv9xi1a5bcm32arknf33ikv76p3fr9yzki4lb2897p2qkh8l";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "i128" "std" ];
      };
      "bytes 0.5.6" = rec {
        crateName = "bytes";
        version = "0.5.6";
        edition = "2018";
        sha256 = "0f5s7xq6qzmdh22ygsy8v0sp02m51y0radvq4i4y8cizy1lfqk0f";
        authors = [
          "Carl Lerche <me@carllerche.com>"
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "bytes 1.0.1" = rec {
        crateName = "bytes";
        version = "1.0.1";
        edition = "2018";
        sha256 = "0h6h1c8g3yj2b4k8g25gr3246mq985y0kl3z685cs784fr1ww05p";
        authors = [
          "Carl Lerche <me@carllerche.com>"
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "cache-padded" = rec {
        crateName = "cache-padded";
        version = "1.1.1";
        edition = "2018";
        sha256 = "1fkdwv9vjazm6fs3s5v56mm4carwswdmw8fcwm9ygrcvihcya6k3";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        
      };
      "cc" = rec {
        crateName = "cc";
        version = "1.0.69";
        edition = "2018";
        crateBin = [];
        sha256 = "1cly36mskqby2yqiygls7myd0qjcfrvxcyw2cf4qdqbc5kvc4377";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "jobserver";
            packageId = "jobserver";
            optional = true;
          }
        ];
        features = {
          "parallel" = [ "jobserver" ];
        };
        resolvedDefaultFeatures = [ "jobserver" "parallel" ];
      };
      "cfg-if" = rec {
        crateName = "cfg-if";
        version = "1.0.0";
        edition = "2018";
        sha256 = "1za0vb97n4brpzpv8lsbnzmq5r8f2b0cpqqr0sy8h5bn751xxwds";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
      };
      "chrono" = rec {
        crateName = "chrono";
        version = "0.4.19";
        edition = "2015";
        sha256 = "0wyfl6c00vhfl562spnfcna3zkw8jqvcp652m9iskhl8j26dc2k7";
        authors = [
          "Kang Seonghoon <public+rust@mearie.org>"
          "Brandon W Maister <quodlibetor@gmail.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            optional = true;
          }
          {
            name = "num-integer";
            packageId = "num-integer";
            usesDefaultFeatures = false;
          }
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
          }
          {
            name = "time";
            packageId = "time";
            optional = true;
          }
          {
            name = "winapi";
            packageId = "winapi";
            optional = true;
            target = { target, features }: target."windows";
            features = [ "std" "minwinbase" "minwindef" "timezoneapi" ];
          }
        ];
        features = {
          "clock" = [ "libc" "std" "winapi" ];
          "default" = [ "clock" "std" "oldtime" ];
          "oldtime" = [ "time" ];
          "unstable-locales" = [ "pure-rust-locales" "alloc" ];
          "wasmbind" = [ "wasm-bindgen" "js-sys" ];
        };
        resolvedDefaultFeatures = [ "clock" "default" "libc" "oldtime" "std" "time" "winapi" ];
      };
      "concurrent-queue" = rec {
        crateName = "concurrent-queue";
        version = "1.2.2";
        edition = "2018";
        sha256 = "18w6hblcjjk9d0my3657ra1zdj79gwfjmzvc0b3985g01dahgv9h";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        dependencies = [
          {
            name = "cache-padded";
            packageId = "cache-padded";
          }
        ];
        
      };
      "crc32fast" = rec {
        crateName = "crc32fast";
        version = "1.2.1";
        edition = "2015";
        sha256 = "06ivjlkzcxxxk7nyshc44aql4zjpmvirq46vmzrakdjax3n6y5c1";
        authors = [
          "Sam Rijs <srijs@airpost.net>"
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "crossbeam-utils" = rec {
        crateName = "crossbeam-utils";
        version = "0.8.5";
        edition = "2018";
        sha256 = "1ny481cx8a5pdknypb41jqym03dl8x26i2ldyyp3yb3zrq8zqb6q";
        authors = [
          "The Crossbeam Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
            optional = true;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "lazy_static" ];
        };
        resolvedDefaultFeatures = [ "default" "lazy_static" "std" ];
      };
      "ctor" = rec {
        crateName = "ctor";
        version = "0.1.20";
        edition = "2018";
        sha256 = "0v80naiw5fp81xkyfkds6jpyamf3wx43kz4nif936bkq3any562y";
        procMacro = true;
        authors = [
          "Matt Mastracci <matthew@mastracci.com>"
        ];
        dependencies = [
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            usesDefaultFeatures = false;
            features = [ "full" "parsing" "printing" "proc-macro" ];
          }
        ];
        
      };
      "derive_arbitrary" = rec {
        crateName = "derive_arbitrary";
        version = "1.0.1";
        edition = "2018";
        sha256 = "0nig0iydva7a9h9i9qyi6an9w5qjafmn3qlzvdqqiw0x2kp824jz";
        procMacro = true;
        authors = [
          "The Rust-Fuzz Project Developers"
          "Nick Fitzgerald <fitzgen@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
          "Andre Bogus <bogusandre@gmail.com>"
          "Corey Farwell <coreyf@rwell.org>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "derive" ];
          }
        ];
        
      };
      "enum-iterator" = rec {
        crateName = "enum-iterator";
        version = "0.6.0";
        edition = "2018";
        sha256 = "1mxq9fds22paikg2c95kxkpxych4p1n3yzhca4q7fz8rl4hn76n7";
        authors = [
          "Stephane Raux <stephaneyfx@gmail.com>"
        ];
        dependencies = [
          {
            name = "enum-iterator-derive";
            packageId = "enum-iterator-derive";
          }
        ];
        
      };
      "enum-iterator-derive" = rec {
        crateName = "enum-iterator-derive";
        version = "0.6.0";
        edition = "2018";
        sha256 = "01pc15d8l0ayrjv7xjjx1lxw2vypvlawcvc9ax7pdp60ywqsm50y";
        procMacro = true;
        authors = [
          "Stephane Raux <stephaneyfx@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
          }
        ];
        
      };
      "env_logger" = rec {
        crateName = "env_logger";
        version = "0.8.4";
        edition = "2018";
        sha256 = "1qzw8g11dbdfi7ixm44ldykwcqsxqkh8vx5cgpd88zmclgz8g4d1";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "atty";
            packageId = "atty";
            optional = true;
          }
          {
            name = "humantime";
            packageId = "humantime";
            optional = true;
          }
          {
            name = "log";
            packageId = "log";
            features = [ "std" ];
          }
          {
            name = "regex";
            packageId = "regex";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "std" "perf" ];
          }
          {
            name = "termcolor";
            packageId = "termcolor";
            optional = true;
          }
        ];
        features = {
          "default" = [ "termcolor" "atty" "humantime" "regex" ];
        };
        resolvedDefaultFeatures = [ "atty" "default" "humantime" "regex" "termcolor" ];
      };
      "erbium" = rec {
        crateName = "erbium";
        version = "0.2.12-rc5";
        edition = "2018";
        crateBin = [
          { name = "erbium-dns"; path = "src/bin/erbium-dns.rs"; }
          { name = "erbium-dhcp"; path = "src/bin/erbium-dhcp.rs"; }
          { name = "erbium"; path = "src/main.rs"; }
          { name = "erbium-conftest"; path = "src/bin/erbium-conftest.rs"; }
        ];
        src = lib.cleanSourceWith { filter = sourceFilter;  src = ./.; };
        build = "src/build.rs";
        authors = [
          "Perry Lorier <git@isomer.meta.net.nz>"
        ];
        dependencies = [
          {
            name = "arbitrary";
            packageId = "arbitrary";
            features = [ "derive" ];
          }
          {
            name = "async-std";
            packageId = "async-std";
            features = [ "tokio02" ];
          }
          {
            name = "async-trait";
            packageId = "async-trait";
          }
          {
            name = "bytes";
            packageId = "bytes 1.0.1";
          }
          {
            name = "env_logger";
            packageId = "env_logger";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "futures-core";
            packageId = "futures-core";
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
          }
          {
            name = "hostname";
            packageId = "hostname";
          }
          {
            name = "hyper";
            packageId = "hyper";
            optional = true;
            features = [ "server" "http1" "stream" "runtime" "tcp" ];
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "mio";
            packageId = "mio";
          }
          {
            name = "netlink-packet-route";
            packageId = "netlink-packet-route";
          }
          {
            name = "netlink-sys";
            packageId = "netlink-sys";
            features = [ "tokio_socket" ];
          }
          {
            name = "nix";
            packageId = "nix";
          }
          {
            name = "prometheus";
            packageId = "prometheus";
            features = [ "process" ];
          }
          {
            name = "rand";
            packageId = "rand 0.8.4";
          }
          {
            name = "rusqlite";
            packageId = "rusqlite";
          }
          {
            name = "rust-crypto";
            packageId = "rust-crypto";
          }
          {
            name = "tokio";
            packageId = "tokio 1.9.0";
            features = [ "full" ];
          }
          {
            name = "tokio-compat-02";
            packageId = "tokio-compat-02";
          }
          {
            name = "tokio-util";
            packageId = "tokio-util";
            features = [ "codec" ];
          }
          {
            name = "yaml-rust";
            packageId = "yaml-rust";
          }
        ];
        buildDependencies = [
          {
            name = "vergen";
            packageId = "vergen";
          }
        ];
        features = {
          "default" = [ "dhcp" "radv" "http" "dns" ];
          "full" = [ "dhcp" "radv" "http" "dns" ];
          "http" = [ "hyper" "dhcp" ];
          "static" = [ "rusqlite/bundled" ];
        };
        resolvedDefaultFeatures = [ "default" "dhcp" "dns" "full" "http" "hyper" "radv" "static" ];
      };
      "event-listener" = rec {
        crateName = "event-listener";
        version = "2.5.1";
        edition = "2018";
        sha256 = "0ndyp41pb2cx7gxijqh4ymnc47nyrvhvir7rvjlw6x09ayb10lzp";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        
      };
      "fallible-iterator" = rec {
        crateName = "fallible-iterator";
        version = "0.2.0";
        edition = "2018";
        sha256 = "1xq759lsr8gqss7hva42azn3whgrbrs2sd9xpn92c5ickxm1fhs4";
        authors = [
          "Steven Fackler <sfackler@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "fallible-streaming-iterator" = rec {
        crateName = "fallible-streaming-iterator";
        version = "0.1.9";
        edition = "2015";
        sha256 = "0nj6j26p71bjy8h42x6jahx1hn0ng6mc2miwpgwnp8vnwqf4jq3k";
        authors = [
          "Steven Fackler <sfackler@gmail.com>"
        ];
        features = {
        };
      };
      "fastrand" = rec {
        crateName = "fastrand";
        version = "1.5.0";
        edition = "2018";
        sha256 = "0birvh29m4x6nwjdyrmiyiypw9l52bmvk15ksdw96hjs50yyv55k";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        dependencies = [
          {
            name = "instant";
            packageId = "instant";
            target = { target, features }: (target."arch" == "wasm32");
          }
        ];
        devDependencies = [
          {
            name = "instant";
            packageId = "instant";
            target = {target, features}: (target."arch" == "wasm32");
            features = [ "wasm-bindgen" ];
          }
        ];
        
      };
      "flate2" = rec {
        crateName = "flate2";
        version = "1.0.20";
        edition = "2018";
        sha256 = "1q5b4r2rclhjbcxlbv5231avp1y6y8bynrf5v3brdzhhvr9yqfnd";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Josh Triplett <josh@joshtriplett.org>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "crc32fast";
            packageId = "crc32fast";
          }
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "miniz_oxide";
            packageId = "miniz_oxide";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "miniz_oxide";
            packageId = "miniz_oxide";
            usesDefaultFeatures = false;
            target = { target, features }: ((target."arch" == "wasm32") && (!(target."os" == "emscripten")));
          }
        ];
        features = {
          "cloudflare_zlib" = [ "any_zlib" "cloudflare-zlib-sys" ];
          "default" = [ "rust_backend" ];
          "rust_backend" = [ "miniz_oxide" ];
          "tokio" = [ "tokio-io" "futures" ];
          "zlib" = [ "any_zlib" "libz-sys" ];
          "zlib-ng-compat" = [ "zlib" "libz-sys/zlib-ng" ];
        };
        resolvedDefaultFeatures = [ "default" "miniz_oxide" "rust_backend" ];
      };
      "fnv" = rec {
        crateName = "fnv";
        version = "1.0.7";
        edition = "2015";
        sha256 = "1hc2mcqha06aibcaza94vbi81j6pr9a1bbxrxjfhc91zin8yr7iz";
        libPath = "lib.rs";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "form_urlencoded" = rec {
        crateName = "form_urlencoded";
        version = "1.0.1";
        edition = "2018";
        sha256 = "1491fmakavcmsjbm3q6iy0bhmn9l422jasdhzx5hkljgza3mmhjz";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "matches";
            packageId = "matches";
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding";
          }
        ];
        
      };
      "fuchsia-cprng" = rec {
        crateName = "fuchsia-cprng";
        version = "0.1.1";
        edition = "2018";
        sha256 = "1fnkqrbz7ixxzsb04bsz9p0zzazanma8znfdqjvh39n14vapfvx0";
        authors = [
          "Erick Tryzelaar <etryzelaar@google.com>"
        ];
        
      };
      "futures" = rec {
        crateName = "futures";
        version = "0.3.15";
        edition = "2018";
        sha256 = "09zwmmfi8d1glhi0bz2didagjyqz3q9gxa7nq4vzmqns0fl46zhf";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "futures-channel";
            packageId = "futures-channel";
            usesDefaultFeatures = false;
            features = [ "sink" ];
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-executor";
            packageId = "futures-executor";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "futures-io";
            packageId = "futures-io";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-task";
            packageId = "futures-task";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-util";
            packageId = "futures-util";
            usesDefaultFeatures = false;
            features = [ "sink" ];
          }
        ];
        features = {
          "alloc" = [ "futures-core/alloc" "futures-task/alloc" "futures-sink/alloc" "futures-channel/alloc" "futures-util/alloc" ];
          "async-await" = [ "futures-util/async-await" "futures-util/async-await-macro" ];
          "bilock" = [ "futures-util/bilock" ];
          "compat" = [ "std" "futures-util/compat" ];
          "default" = [ "std" "async-await" "executor" ];
          "executor" = [ "std" "futures-executor/std" ];
          "io-compat" = [ "compat" "futures-util/io-compat" ];
          "read-initializer" = [ "futures-io/read-initializer" "futures-util/read-initializer" ];
          "std" = [ "alloc" "futures-core/std" "futures-task/std" "futures-io/std" "futures-sink/std" "futures-util/std" "futures-util/io" "futures-util/channel" ];
          "thread-pool" = [ "executor" "futures-executor/thread-pool" ];
          "unstable" = [ "futures-core/unstable" "futures-task/unstable" "futures-channel/unstable" "futures-io/unstable" "futures-util/unstable" ];
          "write-all-vectored" = [ "futures-util/write-all-vectored" ];
        };
        resolvedDefaultFeatures = [ "alloc" "async-await" "default" "executor" "futures-executor" "std" ];
      };
      "futures-channel" = rec {
        crateName = "futures-channel";
        version = "0.3.15";
        edition = "2018";
        sha256 = "1qki53g079ymjkgdxg3rlh5yivys8qvdqhy18l2xz0m8565sd0p6";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "futures-core/alloc" ];
          "default" = [ "std" ];
          "sink" = [ "futures-sink" ];
          "std" = [ "alloc" "futures-core/std" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "futures-sink" "sink" "std" ];
      };
      "futures-core" = rec {
        crateName = "futures-core";
        version = "0.3.15";
        edition = "2018";
        sha256 = "1lbrw5087ndaqvbjrckbz9ld4ya67k72d6w87c22d6m8v1jzf0h4";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "std" ];
      };
      "futures-executor" = rec {
        crateName = "futures-executor";
        version = "0.3.15";
        edition = "2018";
        sha256 = "0ydbmzg6ig9gankp2nspaq668r3ngzss4806dliygjgs16lsdnms";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-task";
            packageId = "futures-task";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-util";
            packageId = "futures-util";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "futures-core/std" "futures-task/std" "futures-util/std" ];
          "thread-pool" = [ "std" "num_cpus" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "futures-io" = rec {
        crateName = "futures-io";
        version = "0.3.15";
        edition = "2018";
        sha256 = "1899vd5yri6zv88by53pzxb1h4x96mc42riziy6qyd1vzgg9ki5c";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "futures-lite" = rec {
        crateName = "futures-lite";
        version = "1.12.0";
        edition = "2018";
        sha256 = "0j5zzjcq1ib2kf1mm3apqf9g2ly1jjw1d1d4v9vjqi9rrnd4i53n";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
          "Contributors to futures-rs"
        ];
        dependencies = [
          {
            name = "fastrand";
            packageId = "fastrand";
            optional = true;
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-io";
            packageId = "futures-io";
            optional = true;
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
          }
          {
            name = "parking";
            packageId = "parking";
            optional = true;
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite 0.2.7";
          }
          {
            name = "waker-fn";
            packageId = "waker-fn";
            optional = true;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" "fastrand" "futures-io" "parking" "memchr" "waker-fn" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "fastrand" "futures-io" "memchr" "parking" "std" "waker-fn" ];
      };
      "futures-macro" = rec {
        crateName = "futures-macro";
        version = "0.3.15";
        edition = "2018";
        sha256 = "08fixp6b34lr58cs85kacp3h599bi63njvfd03655pvc92c05i54";
        procMacro = true;
        authors = [
          "Taylor Cramer <cramertj@google.com>"
          "Taiki Endo <te316e89@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro-hack";
            packageId = "proc-macro-hack";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "full" ];
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        
      };
      "futures-sink" = rec {
        crateName = "futures-sink";
        version = "0.3.15";
        edition = "2018";
        sha256 = "10j21j3k358512qyglqpfyxj309kr6bcspj6izg6s3gzrv8flyx5";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "std" ];
      };
      "futures-task" = rec {
        crateName = "futures-task";
        version = "0.3.15";
        edition = "2018";
        sha256 = "1bixscylw61w61dizqxhrdlnb8mv7yg9h775pssxsk8szkwvw5la";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "std" ];
      };
      "futures-util" = rec {
        crateName = "futures-util";
        version = "0.3.15";
        edition = "2018";
        sha256 = "0rqr36zy4na270kn9fwk866adx1xkv1b49zxzm7zjavys8wc5dgy";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "futures-channel";
            packageId = "futures-channel";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-io";
            packageId = "futures-io";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
          {
            name = "futures-macro";
            packageId = "futures-macro";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "futures-task";
            packageId = "futures-task";
            usesDefaultFeatures = false;
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite 0.2.7";
          }
          {
            name = "pin-utils";
            packageId = "pin-utils";
          }
          {
            name = "proc-macro-hack";
            packageId = "proc-macro-hack";
            optional = true;
          }
          {
            name = "proc-macro-nested";
            packageId = "proc-macro-nested";
            optional = true;
          }
          {
            name = "slab";
            packageId = "slab";
            optional = true;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        features = {
          "alloc" = [ "futures-core/alloc" "futures-task/alloc" ];
          "async-await-macro" = [ "async-await" "futures-macro" "proc-macro-hack" "proc-macro-nested" ];
          "channel" = [ "std" "futures-channel" ];
          "compat" = [ "std" "futures_01" ];
          "default" = [ "std" "async-await" "async-await-macro" ];
          "io" = [ "std" "futures-io" "memchr" ];
          "io-compat" = [ "io" "compat" "tokio-io" ];
          "read-initializer" = [ "io" "futures-io/read-initializer" "futures-io/unstable" ];
          "sink" = [ "futures-sink" ];
          "std" = [ "alloc" "futures-core/std" "futures-task/std" "slab" ];
          "unstable" = [ "futures-core/unstable" "futures-task/unstable" ];
          "write-all-vectored" = [ "io" ];
        };
        resolvedDefaultFeatures = [ "alloc" "async-await" "async-await-macro" "channel" "futures-channel" "futures-io" "futures-macro" "futures-sink" "io" "memchr" "proc-macro-hack" "proc-macro-nested" "sink" "slab" "std" ];
      };
      "gcc" = rec {
        crateName = "gcc";
        version = "0.3.55";
        edition = "2015";
        crateBin = [];
        sha256 = "1hng1sajn4r67hndvhjysswz8niayjwvcj42zphpxzhbz89kjpwg";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "parallel" = [ "rayon" ];
        };
      };
      "getrandom" = rec {
        crateName = "getrandom";
        version = "0.2.3";
        edition = "2018";
        sha256 = "0lr7mnkvnzdh1xxmwmhhbm4gwg29k3m2rzhpjmjm4k2jcfa9kkbz";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: target."unix";
          }
          {
            name = "wasi";
            packageId = "wasi";
            target = { target, features }: (target."os" == "wasi");
          }
        ];
        features = {
          "js" = [ "wasm-bindgen" "js-sys" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "libc/rustc-dep-of-std" "wasi/rustc-dep-of-std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "getset" = rec {
        crateName = "getset";
        version = "0.1.1";
        edition = "2018";
        sha256 = "016590lxhlqga016z1qnavl0zavk59b97aix2zcd4wad3b02icr4";
        procMacro = true;
        authors = [
          "Ana Hobden <ana@hoverbear.org>"
        ];
        dependencies = [
          {
            name = "proc-macro-error";
            packageId = "proc-macro-error";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
          }
        ];
        
      };
      "git2" = rec {
        crateName = "git2";
        version = "0.13.20";
        edition = "2018";
        sha256 = "1fkc2gzcnl4ci3rja9mc5jl2ygl3fkc1fgym3rcwby216ac1x0yr";
        authors = [
          "Josh Triplett <josh@joshtriplett.org>"
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "libgit2-sys";
            packageId = "libgit2-sys";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "url";
            packageId = "url";
          }
        ];
        features = {
          "default" = [ "ssh" "https" "ssh_key_from_memory" ];
          "https" = [ "libgit2-sys/https" "openssl-sys" "openssl-probe" ];
          "ssh" = [ "libgit2-sys/ssh" ];
          "ssh_key_from_memory" = [ "libgit2-sys/ssh_key_from_memory" ];
          "vendored-openssl" = [ "openssl-sys/vendored" ];
          "zlib-ng-compat" = [ "libgit2-sys/zlib-ng-compat" ];
        };
      };
      "gloo-timers" = rec {
        crateName = "gloo-timers";
        version = "0.2.1";
        edition = "2018";
        sha256 = "07w999jm1r1i8r574qbmsa3l4w3gxhyx04cbllg0m4pzm934l827";
        authors = [
          "Rust and WebAssembly Working Group"
        ];
        dependencies = [
          {
            name = "futures-channel";
            packageId = "futures-channel";
            optional = true;
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            optional = true;
          }
          {
            name = "js-sys";
            packageId = "js-sys";
          }
          {
            name = "wasm-bindgen";
            packageId = "wasm-bindgen";
          }
          {
            name = "web-sys";
            packageId = "web-sys";
            features = [ "Window" "WorkerGlobalScope" ];
          }
        ];
        features = {
          "futures" = [ "futures-core" "futures-channel" ];
        };
        resolvedDefaultFeatures = [ "default" "futures" "futures-channel" "futures-core" ];
      };
      "hashbrown" = rec {
        crateName = "hashbrown";
        version = "0.11.2";
        edition = "2018";
        sha256 = "0vkjsf5nzs7qcia5ya79j9sq2p1caz4crrncr1675wwyj3ag0pmb";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "ahash";
            packageId = "ahash";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "ahash-compile-time-rng" = [ "ahash/compile-time-rng" ];
          "default" = [ "ahash" "inline-more" ];
          "rustc-dep-of-std" = [ "nightly" "core" "compiler_builtins" "alloc" "rustc-internal-api" ];
        };
        resolvedDefaultFeatures = [ "ahash" "default" "inline-more" ];
      };
      "hashlink" = rec {
        crateName = "hashlink";
        version = "0.7.0";
        edition = "2018";
        sha256 = "1kzs54xq1g41zph39cfdfchiafij99382zw5fk6zq7xwkh9a6jbj";
        authors = [
          "kyren <kerriganw@gmail.com>"
        ];
        dependencies = [
          {
            name = "hashbrown";
            packageId = "hashbrown";
          }
        ];
        features = {
          "serde_impl" = [ "serde" ];
        };
      };
      "hermit-abi" = rec {
        crateName = "hermit-abi";
        version = "0.1.19";
        edition = "2018";
        sha256 = "0cxcm8093nf5fyn114w8vxbrbcyvv91d4015rdnlgfll7cs6gd32";
        authors = [
          "Stefan Lankes"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins/rustc-dep-of-std" "libc/rustc-dep-of-std" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "hex" = rec {
        crateName = "hex";
        version = "0.4.3";
        edition = "2018";
        sha256 = "0w1a4davm1lgzpamwnba907aysmlrnygbqmfis2mqjx5m552a93z";
        authors = [
          "KokaKiwi <kokakiwi@kokakiwi.net>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "std" ];
      };
      "hostname" = rec {
        crateName = "hostname";
        version = "0.3.1";
        edition = "2015";
        sha256 = "0rz8yf70cvzl3nry71m4bz9w6x4j9kdz3qng6pnwhk2h20z1qwrw";
        authors = [
          "fengcen <fengcen.love@gmail.com>"
          "svartalf <self@svartalf.info>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" || (target."os" == "redox"));
          }
          {
            name = "match_cfg";
            packageId = "match_cfg";
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."os" == "windows");
            features = [ "sysinfoapi" ];
          }
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "http" = rec {
        crateName = "http";
        version = "0.2.4";
        edition = "2018";
        sha256 = "04fcnqbnqmrsnphz5lbca2plascsm8bib5csd518bqj7qyd8qzjj";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Carl Lerche <me@carllerche.com>"
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes 1.0.1";
          }
          {
            name = "fnv";
            packageId = "fnv";
          }
          {
            name = "itoa";
            packageId = "itoa";
          }
        ];
        
      };
      "http-body" = rec {
        crateName = "http-body";
        version = "0.4.2";
        edition = "2018";
        sha256 = "1abmxi1mgv4qxawn4v1bxmp7b7ac835mg7isy2q6sy70w15s3nk0";
        authors = [
          "Carl Lerche <me@carllerche.com>"
          "Lucio Franco <luciofranco14@gmail.com>"
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes 1.0.1";
          }
          {
            name = "http";
            packageId = "http";
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite 0.2.7";
          }
        ];
        
      };
      "httparse" = rec {
        crateName = "httparse";
        version = "1.4.1";
        edition = "2015";
        sha256 = "0s2y7ki3sxyf1ynp0mm2k3mgafigy23d7g0rzci3rs9pdrhppa7k";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "httpdate" = rec {
        crateName = "httpdate";
        version = "1.0.1";
        edition = "2018";
        sha256 = "0h240ck2xlp62dqfhfp6g45984avsmh1pkcgjmyywgzkr2kbhmk4";
        authors = [
          "Pyfisch <pyfisch@posteo.org>"
        ];
        
      };
      "humantime" = rec {
        crateName = "humantime";
        version = "2.1.0";
        edition = "2018";
        sha256 = "1r55pfkkf5v0ji1x6izrjwdq9v6sc7bv99xj6srywcar37xmnfls";
        authors = [
          "Paul Colomiets <paul@colomiets.name>"
        ];
        
      };
      "hyper" = rec {
        crateName = "hyper";
        version = "0.14.11";
        edition = "2018";
        sha256 = "04gvzwq66p5dv3spdcp19ccjkjj44bf82yy9a9inxkzb38nwyq8b";type = [ "lib" "staticlib" "cdylib" ];
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes 1.0.1";
          }
          {
            name = "futures-channel";
            packageId = "futures-channel";
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-util";
            packageId = "futures-util";
            usesDefaultFeatures = false;
          }
          {
            name = "http";
            packageId = "http";
          }
          {
            name = "http-body";
            packageId = "http-body";
          }
          {
            name = "httparse";
            packageId = "httparse";
          }
          {
            name = "httpdate";
            packageId = "httpdate";
          }
          {
            name = "itoa";
            packageId = "itoa";
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite 0.2.7";
          }
          {
            name = "socket2";
            packageId = "socket2";
            optional = true;
          }
          {
            name = "tokio";
            packageId = "tokio 1.9.0";
            features = [ "sync" ];
          }
          {
            name = "tower-service";
            packageId = "tower-service";
          }
          {
            name = "tracing";
            packageId = "tracing";
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
          {
            name = "want";
            packageId = "want";
          }
        ];
        devDependencies = [
          {
            name = "futures-util";
            packageId = "futures-util";
            usesDefaultFeatures = false;
            features = [ "alloc" ];
          }
          {
            name = "tokio";
            packageId = "tokio 1.9.0";
            features = [ "fs" "macros" "io-std" "io-util" "rt" "rt-multi-thread" "sync" "time" "test-util" ];
          }
        ];
        features = {
          "ffi" = [ "libc" ];
          "full" = [ "client" "http1" "http2" "server" "stream" "runtime" ];
          "http2" = [ "h2" ];
          "runtime" = [ "tcp" "tokio/rt" ];
          "tcp" = [ "socket2" "tokio/net" "tokio/rt" "tokio/time" ];
        };
        resolvedDefaultFeatures = [ "default" "http1" "runtime" "server" "socket2" "stream" "tcp" ];
      };
      "idna" = rec {
        crateName = "idna";
        version = "0.2.3";
        edition = "2018";
        sha256 = "1y7ca2w5qp9msgl57n03zqp78gq1bk2crqzg6kv7a542mdphm2j1";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "matches";
            packageId = "matches";
          }
          {
            name = "unicode-bidi";
            packageId = "unicode-bidi";
          }
          {
            name = "unicode-normalization";
            packageId = "unicode-normalization";
          }
        ];
        
      };
      "instant" = rec {
        crateName = "instant";
        version = "0.1.10";
        edition = "2018";
        sha256 = "0ka75wmkh22bkxjw5smhmlwl3xpqnj2xv50w03pmgl892a5k5q5y";
        authors = [
          "sebcrozet <developer@crozet.re>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
        ];
        features = {
          "now" = [ "time" ];
          "wasm-bindgen" = [ "js-sys" "wasm-bindgen_rs" "web-sys" ];
        };
      };
      "itoa" = rec {
        crateName = "itoa";
        version = "0.4.7";
        edition = "2015";
        sha256 = "0di7fggbknwfjcw8cgzm1dnm3ik32l2m1f7nmyh8ipmh45h069fx";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "jobserver" = rec {
        crateName = "jobserver";
        version = "0.1.22";
        edition = "2018";
        sha256 = "1zg7p4khibisbvd8b1lqvvni6lr00g49d4bq2zj6m76bs7jmlbwp";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: target."unix";
          }
        ];
        
      };
      "js-sys" = rec {
        crateName = "js-sys";
        version = "0.3.51";
        edition = "2018";
        sha256 = "0qkhnsidcx4vkgacn4hhl6bf6lxhc3lljfzpad11ms50wfngpgc3";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "wasm-bindgen";
            packageId = "wasm-bindgen";
          }
        ];
        
      };
      "kv-log-macro" = rec {
        crateName = "kv-log-macro";
        version = "1.0.7";
        edition = "2018";
        sha256 = "0zwp4bxkkp87rl7xy2dain77z977rvcry1gmr5bssdbn541v7s0d";
        authors = [
          "Yoshua Wuyts <yoshuawuyts@gmail.com>"
        ];
        dependencies = [
          {
            name = "log";
            packageId = "log";
            features = [ "kv_unstable" ];
          }
        ];
        
      };
      "lazy_static" = rec {
        crateName = "lazy_static";
        version = "1.4.0";
        edition = "2015";
        sha256 = "0in6ikhw8mgl33wjv6q6xfrb5b9jr16q8ygjy803fay4zcisvaz2";
        authors = [
          "Marvin Löbel <loebel.marvin@gmail.com>"
        ];
        features = {
          "spin_no_std" = [ "spin" ];
        };
      };
      "libc" = rec {
        crateName = "libc";
        version = "0.2.98";
        edition = "2015";
        sha256 = "144728k6d98k3hplzklqn18a134nq6nw0jzdxy1s98sx2xvzw31j";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "align" "rustc-std-workspace-core" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "extra_traits" "std" ];
      };
      "libgit2-sys" = rec {
        crateName = "libgit2-sys";
        version = "0.12.21+1.1.0";
        edition = "2018";
        sha256 = "09b85x3gpvq0d7v1mhg4f3w1b3skzlpbikrx9j2rwarbsyn1n9w6";
        libName = "libgit2_sys";
        libPath = "lib.rs";
        authors = [
          "Josh Triplett <josh@joshtriplett.org>"
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "libz-sys";
            packageId = "libz-sys";
            usesDefaultFeatures = false;
            features = [ "libc" ];
          }
        ];
        buildDependencies = [
          {
            name = "cc";
            packageId = "cc";
            features = [ "parallel" ];
          }
          {
            name = "pkg-config";
            packageId = "pkg-config";
          }
        ];
        features = {
          "https" = [ "openssl-sys" ];
          "ssh" = [ "libssh2-sys" ];
          "zlib-ng-compat" = [ "libz-sys/zlib-ng" "libssh2-sys/zlib-ng-compat" ];
        };
      };
      "libsqlite3-sys" = rec {
        crateName = "libsqlite3-sys";
        version = "0.22.2";
        edition = "2018";
        sha256 = "17gqc2mwih81j3ds479gl5zmsxqzzrcrj3yyv62vh34bgy8n82r9";
        authors = [
          "The rusqlite developers"
        ];
        buildDependencies = [
          {
            name = "cc";
            packageId = "cc";
            optional = true;
          }
          {
            name = "pkg-config";
            packageId = "pkg-config";
            optional = true;
          }
          {
            name = "vcpkg";
            packageId = "vcpkg";
            optional = true;
            target = {target, features}: (target."env" == "msvc");
          }
        ];
        features = {
          "buildtime_bindgen" = [ "bindgen" "pkg-config" "vcpkg" ];
          "bundled" = [ "cc" "bundled_bindings" ];
          "bundled-windows" = [ "cc" "bundled_bindings" ];
          "default" = [ "min_sqlite_version_3_6_8" ];
          "min_sqlite_version_3_6_23" = [ "pkg-config" "vcpkg" ];
          "min_sqlite_version_3_6_8" = [ "pkg-config" "vcpkg" ];
          "min_sqlite_version_3_7_16" = [ "pkg-config" "vcpkg" ];
          "min_sqlite_version_3_7_7" = [ "pkg-config" "vcpkg" ];
          "preupdate_hook" = [ "buildtime_bindgen" ];
          "session" = [ "preupdate_hook" "buildtime_bindgen" ];
          "winsqlite3" = [ "min_sqlite_version_3_7_16" ];
        };
        resolvedDefaultFeatures = [ "bundled" "bundled_bindings" "cc" "default" "min_sqlite_version_3_6_8" "pkg-config" "vcpkg" ];
      };
      "libz-sys" = rec {
        crateName = "libz-sys";
        version = "1.1.3";
        edition = "2015";
        sha256 = "0rpcxkccjn8da9114kvl8hrnrkspzsmdn0qcxlix85lwajw3am6y";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Josh Triplett <josh@joshtriplett.org>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            optional = true;
          }
        ];
        buildDependencies = [
          {
            name = "cc";
            packageId = "cc";
          }
          {
            name = "pkg-config";
            packageId = "pkg-config";
          }
          {
            name = "vcpkg";
            packageId = "vcpkg";
            target = {target, features}: (target."env" == "msvc");
          }
        ];
        features = {
          "default" = [ "libc" "stock-zlib" ];
          "zlib-ng" = [ "libc" "cmake" ];
        };
        resolvedDefaultFeatures = [ "libc" ];
      };
      "linked-hash-map" = rec {
        crateName = "linked-hash-map";
        version = "0.5.4";
        edition = "2015";
        sha256 = "1ww8zsraqnvrsknd315481185igwkx5n14xnhq5i8216z65b7fbz";
        authors = [
          "Stepan Koltsov <stepan.koltsov@gmail.com>"
          "Andrew Paseltiner <apaseltiner@gmail.com>"
        ];
        features = {
          "heapsize_impl" = [ "heapsize" ];
          "serde_impl" = [ "serde" "serde_test" ];
        };
      };
      "lock_api" = rec {
        crateName = "lock_api";
        version = "0.4.4";
        edition = "2018";
        sha256 = "1sq7pw7h7jbfvnv5nq3vm912gdwhhv8idi3njifd3xnz0q38i0h3";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "scopeguard";
            packageId = "scopeguard";
            usesDefaultFeatures = false;
          }
        ];
        features = {
        };
      };
      "log" = rec {
        crateName = "log";
        version = "0.4.14";
        edition = "2015";
        sha256 = "04175hv0v62shd82qydq58a48k3bjijmk54v38zgqlbxqkkbpfai";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "value-bag";
            packageId = "value-bag";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "value-bag";
            packageId = "value-bag";
            features = [ "test" ];
          }
        ];
        features = {
          "kv_unstable" = [ "value-bag" ];
          "kv_unstable_serde" = [ "kv_unstable_std" "value-bag/serde" "serde" ];
          "kv_unstable_std" = [ "std" "kv_unstable" "value-bag/error" ];
          "kv_unstable_sval" = [ "kv_unstable" "value-bag/sval" "sval" ];
        };
        resolvedDefaultFeatures = [ "kv_unstable" "std" "value-bag" ];
      };
      "match_cfg" = rec {
        crateName = "match_cfg";
        version = "0.1.0";
        edition = "2015";
        sha256 = "1r5j3zqc3qr8ybcx95bk8q57mkizmgmffj5lmicd4i8d9riyigpz";
        authors = [
          "gnzlbg <gonzalobg88@gmail.com>"
        ];
        features = {
          "default" = [ "use_core" ];
        };
        resolvedDefaultFeatures = [ "default" "use_core" ];
      };
      "matches" = rec {
        crateName = "matches";
        version = "0.1.8";
        edition = "2015";
        sha256 = "020axl4q7rk9vz90phs7f8jas4imxal9y9kxl4z4v7a6719mrz3z";
        libPath = "lib.rs";
        authors = [
          "Simon Sapin <simon.sapin@exyr.org>"
        ];
        
      };
      "memchr" = rec {
        crateName = "memchr";
        version = "2.4.0";
        edition = "2018";
        sha256 = "1p478fqf4nia2ma0kv4npb8x1hli0zz6k16517ikb51jkryx8sxi";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
          "bluss"
        ];
        features = {
          "default" = [ "std" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "miniz_oxide" = rec {
        crateName = "miniz_oxide";
        version = "0.4.4";
        edition = "2018";
        sha256 = "0jsfv00hl5rmx1nijn59sr9jmjd4rjnjhh4kdjy8d187iklih9d9";
        authors = [
          "Frommi <daniil.liferenko@gmail.com>"
          "oyvindln <oyvindln@users.noreply.github.com>"
        ];
        dependencies = [
          {
            name = "adler";
            packageId = "adler";
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "alloc" "compiler_builtins" "adler/rustc-dep-of-std" ];
        };
      };
      "mio" = rec {
        crateName = "mio";
        version = "0.7.13";
        edition = "2018";
        sha256 = "05mvlrn3r2vqps4fflmknw15r0rs8xld4g99sdf8647c2iixnawc";
        authors = [
          "Carl Lerche <me@carllerche.com>"
          "Thomas de Zeeuw <thomasdezeeuw@gmail.com>"
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: target."unix";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "miow";
            packageId = "miow";
            target = { target, features }: target."windows";
          }
          {
            name = "ntapi";
            packageId = "ntapi";
            target = { target, features }: target."windows";
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: target."windows";
            features = [ "winsock2" "mswsock" "mstcpip" ];
          }
        ];
        features = {
          "os-ext" = [ "os-poll" ];
          "os-util" = [ "os-ext" ];
          "pipe" = [ "os-ext" ];
          "tcp" = [ "net" ];
          "udp" = [ "net" ];
          "uds" = [ "net" ];
        };
        resolvedDefaultFeatures = [ "default" "net" "os-ext" "os-poll" "os-util" "tcp" "udp" "uds" ];
      };
      "miow" = rec {
        crateName = "miow";
        version = "0.3.7";
        edition = "2018";
        sha256 = "08afp2xfpxmdw003111lxz6g9jgbj4zi2fpldvv7da6d4nqcbwdr";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi";
            features = [ "std" "fileapi" "handleapi" "ioapiset" "minwindef" "namedpipeapi" "ntdef" "synchapi" "winerror" "winsock2" "ws2def" "ws2ipdef" ];
          }
        ];
        
      };
      "netlink-packet-core" = rec {
        crateName = "netlink-packet-core";
        version = "0.2.4";
        edition = "2018";
        sha256 = "1jrwj3z501dwyh7pl7wm9gayrc6ny67vbdmwpmsz3gb2a2fjfj5c";
        authors = [
          "Corentin Henry <corentinhenry@gmail.com>"
        ];
        dependencies = [
          {
            name = "anyhow";
            packageId = "anyhow";
          }
          {
            name = "byteorder";
            packageId = "byteorder";
          }
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "netlink-packet-utils";
            packageId = "netlink-packet-utils";
          }
        ];
        
      };
      "netlink-packet-route" = rec {
        crateName = "netlink-packet-route";
        version = "0.7.1";
        edition = "2018";
        sha256 = "1wf05v9i5fxm5bgwmxpjicmnm2fa2f1d4j0wh456vzi8cmmai4jc";
        authors = [
          "Corentin Henry <corentinhenry@gmail.com>"
        ];
        dependencies = [
          {
            name = "anyhow";
            packageId = "anyhow";
          }
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "byteorder";
            packageId = "byteorder";
          }
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "netlink-packet-core";
            packageId = "netlink-packet-core";
          }
          {
            name = "netlink-packet-utils";
            packageId = "netlink-packet-utils";
          }
        ];
        
      };
      "netlink-packet-utils" = rec {
        crateName = "netlink-packet-utils";
        version = "0.4.1";
        edition = "2018";
        sha256 = "1137gb12679aiqz00cjvmmmdj6420ya6sn9r4d5rcvmnb3vvdksz";
        authors = [
          "Corentin Henry <corentinhenry@gmail.com>"
        ];
        dependencies = [
          {
            name = "anyhow";
            packageId = "anyhow";
          }
          {
            name = "byteorder";
            packageId = "byteorder";
          }
          {
            name = "paste";
            packageId = "paste";
          }
          {
            name = "thiserror";
            packageId = "thiserror";
          }
        ];
        
      };
      "netlink-sys" = rec {
        crateName = "netlink-sys";
        version = "0.6.0";
        edition = "2018";
        sha256 = "1vz9dmybami9ywbrbmw8amxihaq6asv21n3zrc3wv82sfds5676n";
        authors = [
          "Corentin Henry <corentinhenry@gmail.com>"
        ];
        dependencies = [
          {
            name = "futures";
            packageId = "futures";
            optional = true;
          }
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "tokio";
            packageId = "tokio 1.9.0";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "net" ];
          }
        ];
        devDependencies = [
          {
            name = "tokio";
            packageId = "tokio 1.9.0";
            usesDefaultFeatures = false;
            features = [ "net" "macros" "rt-multi-thread" ];
          }
        ];
        features = {
          "smol_socket" = [ "async-io" ];
          "tokio_socket" = [ "tokio" "futures" ];
        };
        resolvedDefaultFeatures = [ "default" "futures" "tokio" "tokio_socket" ];
      };
      "nix" = rec {
        crateName = "nix";
        version = "0.20.0";
        edition = "2018";
        sha256 = "12n1syfd967hblrcrrqk63a4s1h4hsybfqwblh71rihvv8cli6zs";
        authors = [
          "The nix-rust Project Developers"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "libc";
            packageId = "libc";
            features = [ "extra_traits" ];
          }
        ];
        buildDependencies = [
          {
            name = "cc";
            packageId = "cc";
            target = {target, features}: (target."os" == "dragonfly");
          }
        ];
        
      };
      "ntapi" = rec {
        crateName = "ntapi";
        version = "0.3.6";
        edition = "2018";
        sha256 = "0i5daj9sr8wyi5jkpwpybln2jqpn59z0mqfc0dpdidipwh1bjsrz";
        authors = [
          "MSxDOS <melcodos@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi";
            features = [ "cfg" "evntrace" "in6addr" "inaddr" "minwinbase" "ntsecapi" "windef" "winioctl" ];
          }
        ];
        features = {
          "default" = [ "user" ];
          "impl-default" = [ "winapi/impl-default" ];
        };
        resolvedDefaultFeatures = [ "default" "user" ];
      };
      "num-integer" = rec {
        crateName = "num-integer";
        version = "0.1.44";
        edition = "2015";
        sha256 = "1nq152y3304as1iai95hqz8prqnc94lks1s7q05sfjdmcf56kk6j";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        features = {
          "default" = [ "std" ];
          "i128" = [ "num-traits/i128" ];
          "std" = [ "num-traits/std" ];
        };
      };
      "num-traits" = rec {
        crateName = "num-traits";
        version = "0.2.14";
        edition = "2015";
        sha256 = "144j176s2p76azy2ngk2vkdzgwdc0bc8c93jhki8c9fsbknb2r4s";
        authors = [
          "The Rust Project Developers"
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        features = {
          "default" = [ "std" ];
        };
      };
      "num_cpus" = rec {
        crateName = "num_cpus";
        version = "1.13.0";
        edition = "2015";
        sha256 = "1cv6yxhz2zbnwn8pn1yn8grg7zsnd523947fby41a737aqvryj85";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "hermit-abi";
            packageId = "hermit-abi";
            target = { target, features }: (((target."arch" == "x86_64") || (target."arch" == "aarch64")) && (target."os" == "hermit"));
          }
          {
            name = "libc";
            packageId = "libc";
          }
        ];
        
      };
      "once_cell" = rec {
        crateName = "once_cell";
        version = "1.8.0";
        edition = "2018";
        sha256 = "0mkbbxg6416z11r2yzsq91cqrkj9w1iyx5hakq15h5sbnriwnbv9";
        authors = [
          "Aleksey Kladov <aleksey.kladov@gmail.com>"
        ];
        features = {
          "alloc" = [ "race" ];
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "race" "std" "unstable" ];
      };
      "parking" = rec {
        crateName = "parking";
        version = "2.0.0";
        edition = "2018";
        sha256 = "0wnxxnizfxlax3n709s5r83f4n8awy3m4a18q4fdk0z7z693hz22";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
          "The Rust Project Developers"
        ];
        
      };
      "parking_lot" = rec {
        crateName = "parking_lot";
        version = "0.11.1";
        edition = "2018";
        sha256 = "1sqmgaia8zfd5fbnqw2w13ijh7crk3lf9vw4cb52vwlx0an48xvd";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "instant";
            packageId = "instant";
          }
          {
            name = "lock_api";
            packageId = "lock_api";
          }
          {
            name = "parking_lot_core";
            packageId = "parking_lot_core";
          }
        ];
        features = {
          "deadlock_detection" = [ "parking_lot_core/deadlock_detection" ];
          "nightly" = [ "parking_lot_core/nightly" "lock_api/nightly" ];
          "owning_ref" = [ "lock_api/owning_ref" ];
          "serde" = [ "lock_api/serde" ];
          "stdweb" = [ "instant/stdweb" ];
          "wasm-bindgen" = [ "instant/wasm-bindgen" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "parking_lot_core" = rec {
        crateName = "parking_lot_core";
        version = "0.8.3";
        edition = "2018";
        sha256 = "065hkylji0g0fkh1vqp7kzs74vclhsxcczwhwqzpcig770lphyps";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "instant";
            packageId = "instant";
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: target."unix";
          }
          {
            name = "redox_syscall";
            packageId = "redox_syscall";
            target = { target, features }: (target."os" == "redox");
          }
          {
            name = "smallvec";
            packageId = "smallvec";
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: target."windows";
            features = [ "winnt" "ntstatus" "minwindef" "winerror" "winbase" "errhandlingapi" "handleapi" ];
          }
        ];
        features = {
          "deadlock_detection" = [ "petgraph" "thread-id" "backtrace" ];
        };
      };
      "paste" = rec {
        crateName = "paste";
        version = "1.0.5";
        edition = "2018";
        sha256 = "0n7y1pabn6vspdxgzx62rs9wdlbnay9r1g84j8jk2pn6s1x59gxc";
        procMacro = true;
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        
      };
      "percent-encoding" = rec {
        crateName = "percent-encoding";
        version = "2.1.0";
        edition = "2015";
        sha256 = "0bp3zrsk3kr47fbpipyczidbbx4g54lzxdm77ni1i3qws10mdzfl";
        libPath = "lib.rs";
        authors = [
          "The rust-url developers"
        ];
        
      };
      "pest" = rec {
        crateName = "pest";
        version = "2.1.3";
        edition = "2015";
        sha256 = "0lry80bm90x47nq71wxq83kjrm9ashpz4kbm92p90ysdx4m8gx0h";
        authors = [
          "Dragoș Tiselice <dragostiselice@gmail.com>"
        ];
        dependencies = [
          {
            name = "ucd-trie";
            packageId = "ucd-trie";
          }
        ];
        features = {
          "pretty-print" = [ "serde" "serde_json" ];
        };
      };
      "pin-project-lite 0.1.12" = rec {
        crateName = "pin-project-lite";
        version = "0.1.12";
        edition = "2018";
        sha256 = "0xx7f3wzc8ydvd1v2mmrxfypjchp52bphrirf08phbq8ba8n8yr5";
        authors = [
          "Taiki Endo <te316e89@gmail.com>"
        ];
        
      };
      "pin-project-lite 0.2.7" = rec {
        crateName = "pin-project-lite";
        version = "0.2.7";
        edition = "2018";
        sha256 = "0hwl8iyx3h9i3i3jr2vqj07nf4ay1v1w1ga29cbjmdd6d4fd2ccd";
        authors = [
          "Taiki Endo <te316e89@gmail.com>"
        ];
        
      };
      "pin-utils" = rec {
        crateName = "pin-utils";
        version = "0.1.0";
        edition = "2018";
        sha256 = "117ir7vslsl2z1a7qzhws4pd01cg2d3338c47swjyvqv2n60v1wb";
        authors = [
          "Josef Brandl <mail@josefbrandl.de>"
        ];
        
      };
      "pkg-config" = rec {
        crateName = "pkg-config";
        version = "0.3.19";
        edition = "2015";
        sha256 = "0k4860955riciibxr8bhnklp79jydp4xfylwdn5v9kj96hxlac9q";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        
      };
      "polling" = rec {
        crateName = "polling";
        version = "2.1.0";
        edition = "2018";
        sha256 = "098zk8glik948jk4m0kzzzry672y1m22vn7lgr1shkm3kxvisd4j";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: target."unix";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "wepoll-ffi";
            packageId = "wepoll-ffi";
            target = { target, features }: target."windows";
            features = [ "null-overlapped-wakeups-patch" ];
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: target."windows";
            features = [ "ioapiset" "winsock2" ];
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "ppv-lite86" = rec {
        crateName = "ppv-lite86";
        version = "0.2.10";
        edition = "2018";
        sha256 = "0ms8198kclg4h96ggbziixxmsdl847s648kmbx11zlmjsqjccx5c";
        authors = [
          "The CryptoCorrosion Contributors"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "simd" "std" ];
      };
      "proc-macro-error" = rec {
        crateName = "proc-macro-error";
        version = "1.0.4";
        edition = "2018";
        sha256 = "1373bhxaf0pagd8zkyd03kkx6bchzf6g0dkwrwzsnal9z47lj9fs";
        authors = [
          "CreepySkeleton <creepy-skeleton@yandex.ru>"
        ];
        dependencies = [
          {
            name = "proc-macro-error-attr";
            packageId = "proc-macro-error-attr";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check";
          }
        ];
        features = {
          "default" = [ "syn-error" ];
          "syn-error" = [ "syn" ];
        };
        resolvedDefaultFeatures = [ "default" "syn" "syn-error" ];
      };
      "proc-macro-error-attr" = rec {
        crateName = "proc-macro-error-attr";
        version = "1.0.4";
        edition = "2018";
        sha256 = "0sgq6m5jfmasmwwy8x4mjygx5l7kp8s4j60bv25ckv2j1qc41gm1";
        procMacro = true;
        authors = [
          "CreepySkeleton <creepy-skeleton@yandex.ru>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check";
          }
        ];
        
      };
      "proc-macro-hack" = rec {
        crateName = "proc-macro-hack";
        version = "0.5.19";
        edition = "2018";
        sha256 = "1rg0kzsj7lj00qj602d3h77spwfz48vixn1wbjp7a4yrq65w9w6v";
        procMacro = true;
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        
      };
      "proc-macro-nested" = rec {
        crateName = "proc-macro-nested";
        version = "0.1.7";
        edition = "2015";
        sha256 = "11hh1jynh62f3m1ii0f9gf1l3y0fhkwpmr40lz3704v848n1p25w";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        
      };
      "proc-macro2" = rec {
        crateName = "proc-macro2";
        version = "1.0.28";
        edition = "2018";
        sha256 = "04k6kwfsl56xqv46f9k88jmj7x4544hhbr6xswzfm1mqqywdhzjw";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "unicode-xid";
            packageId = "unicode-xid";
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "procfs" = rec {
        crateName = "procfs";
        version = "0.9.1";
        edition = "2018";
        sha256 = "1kfmlpx902czawrn54zbs0918k0bxi22lv931zds4l44q7h0k25b";
        authors = [
          "Andrew Chin <achin@eminence32.net>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "byteorder";
            packageId = "byteorder";
            features = [ "i128" ];
          }
          {
            name = "flate2";
            packageId = "flate2";
          }
          {
            name = "hex";
            packageId = "hex";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "libc";
            packageId = "libc";
          }
        ];
        features = {
          "default" = [ "chrono" ];
        };
      };
      "prometheus" = rec {
        crateName = "prometheus";
        version = "0.12.0";
        edition = "2018";
        sha256 = "175r0lz6qsqjzm8mpcnlzwqng6ybm7dir2qgyp99401qca6sm1jr";
        authors = [
          "overvenus@gmail.com"
          "siddontang@gmail.com"
          "vistaswx@gmail.com"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "fnv";
            packageId = "fnv";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "libc";
            packageId = "libc";
            optional = true;
          }
          {
            name = "memchr";
            packageId = "memchr";
          }
          {
            name = "parking_lot";
            packageId = "parking_lot";
          }
          {
            name = "procfs";
            packageId = "procfs";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: (target."os" == "linux");
          }
          {
            name = "protobuf";
            packageId = "protobuf";
            optional = true;
          }
          {
            name = "thiserror";
            packageId = "thiserror";
          }
        ];
        features = {
          "default" = [ "protobuf" ];
          "gen" = [ "protobuf-codegen-pure" ];
          "nightly" = [ "libc" ];
          "process" = [ "libc" "procfs" ];
          "push" = [ "reqwest" "libc" "protobuf" ];
        };
        resolvedDefaultFeatures = [ "default" "libc" "process" "procfs" "protobuf" ];
      };
      "protobuf" = rec {
        crateName = "protobuf";
        version = "2.24.1";
        edition = "2018";
        sha256 = "0rq20xr5vhj4ys4qv4mpn656kc4h3bm332n57p6qqicnw5xffl6v";
        authors = [
          "Stepan Koltsov <stepan.koltsov@gmail.com>"
        ];
        features = {
          "with-bytes" = [ "bytes" ];
          "with-serde" = [ "serde" "serde_derive" ];
        };
      };
      "quote" = rec {
        crateName = "quote";
        version = "1.0.9";
        edition = "2018";
        sha256 = "19rjmfqzk26rxbgxy5j2ckqc2v12sw2xw8l4gi8bzpn2bmsbkl63";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
          "proc-macro" = [ "proc-macro2/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "rand 0.3.23" = rec {
        crateName = "rand";
        version = "0.3.23";
        edition = "2015";
        sha256 = "0v679h38pjjqj5h4md7v2slsvj6686qgcn7p9fbw3h43iwnk1b34";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "rand";
            packageId = "rand 0.4.6";
          }
        ];
        features = {
          "nightly" = [ "i128_support" ];
        };
      };
      "rand 0.4.6" = rec {
        crateName = "rand";
        version = "0.4.6";
        edition = "2015";
        sha256 = "14qjfv3gggzhnma20k0sc1jf8y6pplsaq7n1j9ls5c8kf2wl0a2m";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "fuchsia-cprng";
            packageId = "fuchsia-cprng";
            target = { target, features }: (target."os" == "fuchsia");
          }
          {
            name = "libc";
            packageId = "libc";
            optional = true;
            target = { target, features }: target."unix";
          }
          {
            name = "rand_core";
            packageId = "rand_core 0.3.1";
            usesDefaultFeatures = false;
            target = { target, features }: (target."env" == "sgx");
          }
          {
            name = "rdrand";
            packageId = "rdrand";
            target = { target, features }: (target."env" == "sgx");
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: target."windows";
            features = [ "minwindef" "ntsecapi" "profileapi" "winnt" ];
          }
        ];
        features = {
          "default" = [ "std" ];
          "nightly" = [ "i128_support" ];
          "std" = [ "libc" ];
        };
        resolvedDefaultFeatures = [ "default" "libc" "std" ];
      };
      "rand 0.8.4" = rec {
        crateName = "rand";
        version = "0.8.4";
        edition = "2018";
        sha256 = "1n5wska2fbfj4dsfz8mc0pd0dgjlrb6c9anpk5mwym345rip6x9f";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: target."unix";
          }
          {
            name = "rand_chacha";
            packageId = "rand_chacha";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: (!(target."os" == "emscripten"));
          }
          {
            name = "rand_core";
            packageId = "rand_core 0.6.3";
          }
          {
            name = "rand_hc";
            packageId = "rand_hc";
            optional = true;
            target = { target, features }: (target."os" == "emscripten");
          }
        ];
        devDependencies = [
          {
            name = "rand_hc";
            packageId = "rand_hc";
          }
        ];
        features = {
          "alloc" = [ "rand_core/alloc" ];
          "default" = [ "std" "std_rng" ];
          "getrandom" = [ "rand_core/getrandom" ];
          "serde1" = [ "serde" "rand_core/serde1" ];
          "simd_support" = [ "packed_simd" ];
          "std" = [ "rand_core/std" "rand_chacha/std" "alloc" "getrandom" "libc" ];
          "std_rng" = [ "rand_chacha" "rand_hc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "getrandom" "libc" "rand_chacha" "rand_hc" "std" "std_rng" ];
      };
      "rand_chacha" = rec {
        crateName = "rand_chacha";
        version = "0.3.1";
        edition = "2018";
        sha256 = "123x2adin558xbhvqb8w4f6syjsdkmqff8cxwhmjacpsl1ihmhg6";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
          "The CryptoCorrosion Contributors"
        ];
        dependencies = [
          {
            name = "ppv-lite86";
            packageId = "ppv-lite86";
            usesDefaultFeatures = false;
            features = [ "simd" ];
          }
          {
            name = "rand_core";
            packageId = "rand_core 0.6.3";
          }
        ];
        features = {
          "default" = [ "std" ];
          "serde1" = [ "serde" ];
          "std" = [ "ppv-lite86/std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "rand_core 0.3.1" = rec {
        crateName = "rand_core";
        version = "0.3.1";
        edition = "2015";
        sha256 = "0jzdgszfa4bliigiy4hi66k7fs3gfwi2qxn8vik84ph77fwdwvvs";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.4.2";
          }
        ];
        features = {
          "alloc" = [ "rand_core/alloc" ];
          "default" = [ "std" ];
          "serde1" = [ "rand_core/serde1" ];
          "std" = [ "rand_core/std" ];
        };
      };
      "rand_core 0.4.2" = rec {
        crateName = "rand_core";
        version = "0.4.2";
        edition = "2015";
        sha256 = "1p09ynysrq1vcdlmcqnapq4qakl2yd1ng3kxh3qscpx09k2a6cww";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        features = {
          "serde1" = [ "serde" "serde_derive" ];
          "std" = [ "alloc" ];
        };
      };
      "rand_core 0.6.3" = rec {
        crateName = "rand_core";
        version = "0.6.3";
        edition = "2018";
        sha256 = "1rxlxc3bpzgwphcg9c9yasvv9idipcg2z2y4j0vlb52jyl418kyk";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "getrandom";
            packageId = "getrandom";
            optional = true;
          }
        ];
        features = {
          "serde1" = [ "serde" ];
          "std" = [ "alloc" "getrandom" "getrandom/std" ];
        };
        resolvedDefaultFeatures = [ "alloc" "getrandom" "std" ];
      };
      "rand_hc" = rec {
        crateName = "rand_hc";
        version = "0.3.1";
        edition = "2018";
        sha256 = "1rwpykyvhkxs4jvqdja3mzp9dqaqamzn113cxaigs9z2dmcry7nm";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.6.3";
          }
        ];
        
      };
      "rdrand" = rec {
        crateName = "rdrand";
        version = "0.4.0";
        edition = "2015";
        sha256 = "1cjq0kwx1bk7jx3kzyciiish5gqsj7620dm43dc52sr8fzmm9037";
        authors = [
          "Simonas Kazlauskas <rdrand@kazlauskas.me>"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.3.1";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "redox_syscall" = rec {
        crateName = "redox_syscall";
        version = "0.2.9";
        edition = "2018";
        sha256 = "1vpyfnfrw5ki262720yks8m7vn1a2mg89s4rqi5ir7izvyx9md2s";
        libName = "syscall";
        authors = [
          "Jeremy Soller <jackpot51@gmail.com>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
        ];
        
      };
      "regex" = rec {
        crateName = "regex";
        version = "1.5.4";
        edition = "2018";
        sha256 = "0qf479kjbmb582h4d1d6gfl75h0j8aq2nrdi5wg6zdcy6llqcynh";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "aho-corasick";
            packageId = "aho-corasick";
            optional = true;
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
          }
          {
            name = "regex-syntax";
            packageId = "regex-syntax";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" "perf" "unicode" "regex-syntax/default" ];
          "perf" = [ "perf-cache" "perf-dfa" "perf-inline" "perf-literal" ];
          "perf-literal" = [ "aho-corasick" "memchr" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" "regex-syntax/unicode" ];
          "unicode-age" = [ "regex-syntax/unicode-age" ];
          "unicode-bool" = [ "regex-syntax/unicode-bool" ];
          "unicode-case" = [ "regex-syntax/unicode-case" ];
          "unicode-gencat" = [ "regex-syntax/unicode-gencat" ];
          "unicode-perl" = [ "regex-syntax/unicode-perl" ];
          "unicode-script" = [ "regex-syntax/unicode-script" ];
          "unicode-segment" = [ "regex-syntax/unicode-segment" ];
          "unstable" = [ "pattern" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "aho-corasick" "memchr" "perf" "perf-cache" "perf-dfa" "perf-inline" "perf-literal" "std" ];
      };
      "regex-syntax" = rec {
        crateName = "regex-syntax";
        version = "0.6.25";
        edition = "2018";
        sha256 = "16y87hz1bxmmz6kk360cxwfm3jnbsxb3x4zw9x1gzz7khic2i5zl";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "default" = [ "unicode" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
        };
      };
      "rusqlite" = rec {
        crateName = "rusqlite";
        version = "0.25.3";
        edition = "2018";
        sha256 = "1csfxb0jff78gzakva3bwgmm5g0dk90pnalc4krrdbzsr1kwzbap";
        authors = [
          "The rusqlite developers"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "fallible-iterator";
            packageId = "fallible-iterator";
          }
          {
            name = "fallible-streaming-iterator";
            packageId = "fallible-streaming-iterator";
          }
          {
            name = "hashlink";
            packageId = "hashlink";
          }
          {
            name = "libsqlite3-sys";
            packageId = "libsqlite3-sys";
          }
          {
            name = "memchr";
            packageId = "memchr";
          }
          {
            name = "smallvec";
            packageId = "smallvec";
          }
        ];
        features = {
          "array" = [ "vtab" ];
          "backup" = [ "libsqlite3-sys/min_sqlite_version_3_6_23" ];
          "blob" = [ "libsqlite3-sys/min_sqlite_version_3_7_7" ];
          "buildtime_bindgen" = [ "libsqlite3-sys/buildtime_bindgen" ];
          "bundled" = [ "libsqlite3-sys/bundled" "modern_sqlite" ];
          "bundled-full" = [ "array" "backup" "blob" "bundled" "chrono" "collation" "column_decltype" "csvtab" "extra_check" "functions" "hooks" "i128_blob" "limits" "load_extension" "serde_json" "series" "trace" "unlock_notify" "url" "uuid" "vtab" "window" ];
          "bundled-windows" = [ "libsqlite3-sys/bundled-windows" ];
          "csvtab" = [ "csv" "vtab" ];
          "functions" = [ "libsqlite3-sys/min_sqlite_version_3_7_7" ];
          "i128_blob" = [ "byteorder" ];
          "in_gecko" = [ "modern_sqlite" "libsqlite3-sys/in_gecko" ];
          "modern_sqlite" = [ "libsqlite3-sys/bundled_bindings" ];
          "series" = [ "vtab" ];
          "session" = [ "libsqlite3-sys/session" "hooks" ];
          "sqlcipher" = [ "libsqlite3-sys/sqlcipher" ];
          "trace" = [ "libsqlite3-sys/min_sqlite_version_3_6_23" ];
          "unlock_notify" = [ "libsqlite3-sys/unlock_notify" ];
          "vtab" = [ "libsqlite3-sys/min_sqlite_version_3_7_7" "lazy_static" ];
          "wasm32-wasi-vfs" = [ "libsqlite3-sys/wasm32-wasi-vfs" ];
          "window" = [ "functions" ];
          "winsqlite3" = [ "libsqlite3-sys/winsqlite3" ];
          "with-asan" = [ "libsqlite3-sys/with-asan" ];
        };
        resolvedDefaultFeatures = [ "bundled" "modern_sqlite" ];
      };
      "rust-crypto" = rec {
        crateName = "rust-crypto";
        version = "0.2.36";
        edition = "2015";
        sha256 = "0aias7gh2ypj4skmh6hfsjli4fhnvcvf9s1ljjpz9m9zk79havgp";
        libName = "crypto";
        authors = [
          "The Rust-Crypto Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "rand";
            packageId = "rand 0.3.23";
          }
          {
            name = "rustc-serialize";
            packageId = "rustc-serialize";
          }
          {
            name = "time";
            packageId = "time";
          }
        ];
        buildDependencies = [
          {
            name = "gcc";
            packageId = "gcc";
          }
        ];
        features = {
        };
      };
      "rustc-serialize" = rec {
        crateName = "rustc-serialize";
        version = "0.3.24";
        edition = "2015";
        sha256 = "1nkg3vasg7nk80ffkazizgiyv3hb1l9g3d8h17cajbkx538jiwfw";
        authors = [
          "The Rust Project Developers"
        ];
        
      };
      "rustc_version" = rec {
        crateName = "rustc_version";
        version = "0.3.3";
        edition = "2018";
        sha256 = "1vjmw7xcdri0spsf24mkpwpph853wrbqppihhw061i2igh4f5pzh";
        authors = [
          "Marvin Löbel <loebel.marvin@gmail.com>"
        ];
        dependencies = [
          {
            name = "semver";
            packageId = "semver";
          }
        ];
        
      };
      "scopeguard" = rec {
        crateName = "scopeguard";
        version = "1.1.0";
        edition = "2015";
        sha256 = "1kbqm85v43rq92vx7hfiay6pmcga03vrjbbfwqpyj3pwsg3b16nj";
        authors = [
          "bluss"
        ];
        features = {
          "default" = [ "use_std" ];
        };
      };
      "semver" = rec {
        crateName = "semver";
        version = "0.11.0";
        edition = "2015";
        sha256 = "1dn6064fipjymnmjccyjhb70miyvqvp08gvw1wbg8vbg4c8ay0gk";
        authors = [
          "Steve Klabnik <steve@steveklabnik.com>"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "semver-parser";
            packageId = "semver-parser";
          }
        ];
        features = {
          "ci" = [ "serde" "diesel/sqlite" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "semver-parser" = rec {
        crateName = "semver-parser";
        version = "0.10.2";
        edition = "2018";
        crateBin = [];
        sha256 = "1xqijhqhx3bn77xnl1mlcp032hz8nv7n2fbdacbdzq7rnzsvxc00";
        authors = [
          "Steve Klabnik <steve@steveklabnik.com>"
        ];
        dependencies = [
          {
            name = "pest";
            packageId = "pest";
          }
        ];
        
      };
      "signal-hook-registry" = rec {
        crateName = "signal-hook-registry";
        version = "1.4.0";
        edition = "2015";
        sha256 = "1c2mhijg54y6c1zi4630yki1vpq3z96ljfnsrdy0rb64ilr767p5";
        authors = [
          "Michal 'vorner' Vaner <vorner@vorner.cz>"
          "Masaki Hara <ackie.h.gmai@gmail.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
        ];
        
      };
      "slab" = rec {
        crateName = "slab";
        version = "0.4.3";
        edition = "2015";
        sha256 = "09v57dmy9gnfcj3c6gywp7wi09zywxf0ppj07w02hfvy38ysqwzi";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "smallvec" = rec {
        crateName = "smallvec";
        version = "1.6.1";
        edition = "2018";
        sha256 = "0kk08axr0ybfbjzk65a41k84mb6sfhyajmfndaka9igkx34kf3zy";
        authors = [
          "The Servo Project Developers"
        ];
        features = {
        };
      };
      "socket2" = rec {
        crateName = "socket2";
        version = "0.4.0";
        edition = "2018";
        sha256 = "18ny6m1gnf6cwp5ax0b5hr36w6yg16z7faj76b31aq2jghhgqgcy";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Thomas de Zeeuw <thomasdezeeuw@gmail.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: target."unix";
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: target."windows";
            features = [ "handleapi" "ws2ipdef" "ws2tcpip" ];
          }
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "all" ];
      };
      "syn" = rec {
        crateName = "syn";
        version = "1.0.74";
        edition = "2018";
        sha256 = "175j336afigixhzixxs821sgw2xh38v023y2vg1qhi8dalrdhwqq";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
          }
          {
            name = "quote";
            packageId = "quote";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "unicode-xid";
            packageId = "unicode-xid";
          }
        ];
        features = {
          "default" = [ "derive" "parsing" "printing" "clone-impls" "proc-macro" ];
          "printing" = [ "quote" ];
          "proc-macro" = [ "proc-macro2/proc-macro" "quote/proc-macro" ];
          "test" = [ "syn-test-suite/all-features" ];
        };
        resolvedDefaultFeatures = [ "clone-impls" "default" "derive" "full" "parsing" "printing" "proc-macro" "quote" "visit" "visit-mut" ];
      };
      "termcolor" = rec {
        crateName = "termcolor";
        version = "1.1.2";
        edition = "2018";
        sha256 = "1x65i1ny4m6z1by62ra6wdcrd557p2ysm866x0pg60zby2cxizid";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-util";
            packageId = "winapi-util";
            target = { target, features }: target."windows";
          }
        ];
        
      };
      "thiserror" = rec {
        crateName = "thiserror";
        version = "1.0.26";
        edition = "2018";
        sha256 = "1qmz542pq4wmz3p0s4kavsqv09h0x99klkf3k33ydjy1x97rw4ck";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "thiserror-impl";
            packageId = "thiserror-impl";
          }
        ];
        
      };
      "thiserror-impl" = rec {
        crateName = "thiserror-impl";
        version = "1.0.26";
        edition = "2018";
        sha256 = "0ia72qiynlws5avb8f1xqlazp4g6bqgzjbwy5vs6nyg7myh6j386";
        procMacro = true;
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
          }
        ];
        
      };
      "time" = rec {
        crateName = "time";
        version = "0.1.43";
        edition = "2015";
        sha256 = "0f14wrgxj7ya2v4msg5mni7046bsm2angm7cn3pd3yv04gpm12na";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: target."windows";
            features = [ "std" "minwinbase" "minwindef" "ntdef" "profileapi" "sysinfoapi" "timezoneapi" ];
          }
        ];
        devDependencies = [
          {
            name = "winapi";
            packageId = "winapi";
            features = [ "std" "processthreadsapi" "winbase" ];
          }
        ];
        
      };
      "tinyvec" = rec {
        crateName = "tinyvec";
        version = "1.3.1";
        edition = "2018";
        sha256 = "0f2kkgsf1ivxdjyznzg6xlcivc99krs9584nbqxpbxmrh48ix2l4";
        authors = [
          "Lokathor <zefria@gmail.com>"
        ];
        dependencies = [
          {
            name = "tinyvec_macros";
            packageId = "tinyvec_macros";
            optional = true;
          }
        ];
        features = {
          "alloc" = [ "tinyvec_macros" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "tinyvec_macros" ];
      };
      "tinyvec_macros" = rec {
        crateName = "tinyvec_macros";
        version = "0.1.0";
        edition = "2018";
        sha256 = "0p5zvgbas5nh403fbxica819mf3g83n8g2hzpfazfr56w6klv9yd";
        authors = [
          "Soveu <marx.tomasz@gmail.com>"
        ];
        
      };
      "tokio 0.2.25" = rec {
        crateName = "tokio";
        version = "0.2.25";
        edition = "2018";
        sha256 = "14l0rll6y1dyzh6qcd8rma2ch3wx0dxzxq8b54di744sjirs40v7";
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes 0.5.6";
          }
          {
            name = "num_cpus";
            packageId = "num_cpus";
            optional = true;
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite 0.1.12";
          }
          {
            name = "slab";
            packageId = "slab";
            optional = true;
          }
        ];
        features = {
          "blocking" = [ "rt-core" ];
          "dns" = [ "rt-core" ];
          "fs" = [ "rt-core" "io-util" ];
          "full" = [ "blocking" "dns" "fs" "io-driver" "io-util" "io-std" "macros" "net" "process" "rt-core" "rt-util" "rt-threaded" "signal" "stream" "sync" "time" ];
          "io-driver" = [ "mio" "lazy_static" ];
          "io-std" = [ "rt-core" ];
          "io-util" = [ "memchr" ];
          "macros" = [ "tokio-macros" ];
          "net" = [ "dns" "tcp" "udp" "uds" ];
          "process" = [ "io-driver" "libc" "mio-named-pipes" "signal" "winapi/consoleapi" "winapi/minwindef" "winapi/threadpoollegacyapiset" "winapi/winerror" ];
          "rt-core" = [ "slab" ];
          "rt-threaded" = [ "num_cpus" "rt-core" ];
          "signal" = [ "io-driver" "lazy_static" "libc" "mio-uds" "signal-hook-registry" "winapi/consoleapi" "winapi/minwindef" ];
          "stream" = [ "futures-core" ];
          "sync" = [ "fnv" ];
          "tcp" = [ "io-driver" "iovec" ];
          "time" = [ "slab" ];
          "udp" = [ "io-driver" ];
          "uds" = [ "io-driver" "mio-uds" "libc" ];
        };
        resolvedDefaultFeatures = [ "default" "num_cpus" "rt-core" "rt-threaded" "slab" ];
      };
      "tokio 1.9.0" = rec {
        crateName = "tokio";
        version = "1.9.0";
        edition = "2018";
        sha256 = "0k3b6vi6j8fchxw92q9c6n55wbqm5mhkx1bn29npw15726gk8ysb";
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes 1.0.1";
            optional = true;
          }
          {
            name = "libc";
            packageId = "libc";
            optional = true;
            target = { target, features }: target."unix";
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
          }
          {
            name = "mio";
            packageId = "mio";
            optional = true;
          }
          {
            name = "num_cpus";
            packageId = "num_cpus";
            optional = true;
          }
          {
            name = "once_cell";
            packageId = "once_cell";
            optional = true;
          }
          {
            name = "parking_lot";
            packageId = "parking_lot";
            optional = true;
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite 0.2.7";
          }
          {
            name = "signal-hook-registry";
            packageId = "signal-hook-registry";
            optional = true;
            target = { target, features }: target."unix";
          }
          {
            name = "tokio-macros";
            packageId = "tokio-macros";
            optional = true;
          }
          {
            name = "winapi";
            packageId = "winapi";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: target."windows";
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        devDependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = {target, features}: target."unix";
          }
        ];
        features = {
          "full" = [ "fs" "io-util" "io-std" "macros" "net" "parking_lot" "process" "rt" "rt-multi-thread" "signal" "sync" "time" ];
          "io-util" = [ "memchr" "bytes" ];
          "macros" = [ "tokio-macros" ];
          "net" = [ "libc" "mio/os-poll" "mio/os-util" "mio/tcp" "mio/udp" "mio/uds" "winapi/namedpipeapi" ];
          "process" = [ "bytes" "once_cell" "libc" "mio/os-poll" "mio/os-util" "mio/uds" "signal-hook-registry" "winapi/threadpoollegacyapiset" ];
          "rt-multi-thread" = [ "num_cpus" "rt" ];
          "signal" = [ "once_cell" "libc" "mio/os-poll" "mio/uds" "mio/os-util" "signal-hook-registry" "winapi/consoleapi" ];
        };
        resolvedDefaultFeatures = [ "bytes" "default" "fs" "full" "io-std" "io-util" "libc" "macros" "memchr" "mio" "net" "num_cpus" "once_cell" "parking_lot" "process" "rt" "rt-multi-thread" "signal" "signal-hook-registry" "sync" "time" "tokio-macros" "winapi" ];
      };
      "tokio-compat-02" = rec {
        crateName = "tokio-compat-02";
        version = "0.2.0";
        edition = "2018";
        sha256 = "01vyvimvyip9m779a3v5nvf3bm7sc9s949vs1bzqzgmp49w27m77";
        authors = [
          "Lucio Franco <luciofranco14@gmail.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes 0.5.6";
          }
          {
            name = "once_cell";
            packageId = "once_cell";
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite 0.2.7";
          }
          {
            name = "tokio";
            packageId = "tokio 0.2.25";
            rename = "tokio_02";
            features = [ "rt-threaded" ];
          }
          {
            name = "tokio";
            packageId = "tokio 1.9.0";
          }
          {
            name = "tokio-stream";
            packageId = "tokio-stream";
          }
        ];
        devDependencies = [
          {
            name = "tokio";
            packageId = "tokio 1.9.0";
            features = [ "full" ];
          }
        ];
        
      };
      "tokio-macros" = rec {
        crateName = "tokio-macros";
        version = "1.3.0";
        edition = "2018";
        sha256 = "045igm2h1mfjakbi68hrl07dflgs2rfvvjff17ylxgjf3zk3nisl";
        procMacro = true;
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "full" ];
          }
        ];
        
      };
      "tokio-stream" = rec {
        crateName = "tokio-stream";
        version = "0.1.7";
        edition = "2018";
        sha256 = "0zvj8d2i1147s4i3ml3lh3h6fypncjmbw0h1mhck3w2kh9lkybvv";
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "futures-core";
            packageId = "futures-core";
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite 0.2.7";
          }
          {
            name = "tokio";
            packageId = "tokio 1.9.0";
            features = [ "sync" ];
          }
        ];
        devDependencies = [
          {
            name = "tokio";
            packageId = "tokio 1.9.0";
            features = [ "full" "test-util" ];
          }
        ];
        features = {
          "default" = [ "time" ];
          "fs" = [ "tokio/fs" ];
          "io-util" = [ "tokio/io-util" ];
          "net" = [ "tokio/net" ];
          "signal" = [ "tokio/signal" ];
          "sync" = [ "tokio/sync" "tokio-util" ];
          "time" = [ "tokio/time" ];
        };
        resolvedDefaultFeatures = [ "default" "time" ];
      };
      "tokio-util" = rec {
        crateName = "tokio-util";
        version = "0.6.7";
        edition = "2018";
        sha256 = "14imdf24bng2ynsxa9hvmcx65h4xm75zib5mavdlk84lil60pahw";
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes 1.0.1";
          }
          {
            name = "futures-core";
            packageId = "futures-core";
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite 0.2.7";
          }
          {
            name = "tokio";
            packageId = "tokio 1.9.0";
            features = [ "sync" ];
          }
        ];
        devDependencies = [
          {
            name = "tokio";
            packageId = "tokio 1.9.0";
            features = [ "full" ];
          }
        ];
        features = {
          "__docs_rs" = [ "futures-util" ];
          "compat" = [ "futures-io" ];
          "full" = [ "codec" "compat" "io" "time" "net" "rt" ];
          "net" = [ "tokio/net" ];
          "rt" = [ "tokio/rt" ];
          "time" = [ "tokio/time" "slab" ];
        };
        resolvedDefaultFeatures = [ "codec" "default" ];
      };
      "tower-service" = rec {
        crateName = "tower-service";
        version = "0.3.1";
        edition = "2018";
        sha256 = "1iih764s3f6vlkspfmr72fkrs2lw1v3wiqmc6bd5zq1hdlfzs39n";
        authors = [
          "Tower Maintainers <team@tower-rs.com>"
        ];
        
      };
      "tracing" = rec {
        crateName = "tracing";
        version = "0.1.26";
        edition = "2018";
        sha256 = "17dqjhixmnbrk0c99ydb3b9pygjnzfb7yhlasb6134s4jy6fpb89";
        authors = [
          "Eliza Weisman <eliza@buoyant.io>"
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite 0.2.7";
          }
          {
            name = "tracing-core";
            packageId = "tracing-core";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "attributes" = [ "tracing-attributes" ];
          "default" = [ "std" "attributes" ];
          "log-always" = [ "log" ];
          "std" = [ "tracing-core/std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "tracing-core" = rec {
        crateName = "tracing-core";
        version = "0.1.18";
        edition = "2018";
        sha256 = "0lm0li6lx75jgbbgxsb45439257sqb0j7828caf2hjqsigwi9zx9";
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "lazy_static";
            packageId = "lazy_static";
            optional = true;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "lazy_static" ];
        };
        resolvedDefaultFeatures = [ "lazy_static" "std" ];
      };
      "try-lock" = rec {
        crateName = "try-lock";
        version = "0.2.3";
        edition = "2015";
        sha256 = "0hkn1ksmg5hdqgqdw1ahy5qk69f4crh2psf0v61qphyrf777nm2r";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        
      };
      "ucd-trie" = rec {
        crateName = "ucd-trie";
        version = "0.1.3";
        edition = "2018";
        sha256 = "072cblf8v3wzyaz3lhbpzgil4s03dpzg1ppy3gqx2l4v622y3pjn";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "unicode-bidi" = rec {
        crateName = "unicode-bidi";
        version = "0.3.5";
        edition = "2018";
        sha256 = "1q07h5kp9jszwf0bkrpa1v5wmv04dv920x3w2xy6pjdikchbxf7f";
        libName = "unicode_bidi";
        authors = [
          "The Servo Project Developers"
        ];
        dependencies = [
          {
            name = "matches";
            packageId = "matches";
          }
        ];
        features = {
          "flame_it" = [ "flame" "flamer" ];
          "with_serde" = [ "serde" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "unicode-normalization" = rec {
        crateName = "unicode-normalization";
        version = "0.1.19";
        edition = "2018";
        sha256 = "1yabhmg8zlcksda3ajly9hpbzqgbhknxwch8dwkfkaa1569r0ifm";
        authors = [
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        dependencies = [
          {
            name = "tinyvec";
            packageId = "tinyvec";
            features = [ "alloc" ];
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "unicode-xid" = rec {
        crateName = "unicode-xid";
        version = "0.2.2";
        edition = "2015";
        sha256 = "1wrkgcw557v311dkdb6n2hrix9dm2qdsb1zpw7pn79l03zb85jwc";
        authors = [
          "erick.tryzelaar <erick.tryzelaar@gmail.com>"
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "url" = rec {
        crateName = "url";
        version = "2.2.2";
        edition = "2018";
        sha256 = "132pzpvfvpw33gjlzqd55n5iag9qddzffq8qbp1myfykna1w61x5";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "form_urlencoded";
            packageId = "form_urlencoded";
          }
          {
            name = "idna";
            packageId = "idna";
          }
          {
            name = "matches";
            packageId = "matches";
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding";
          }
        ];
        
      };
      "value-bag" = rec {
        crateName = "value-bag";
        version = "1.0.0-alpha.7";
        edition = "2018";
        sha256 = "1bj0v1sq0xvwmxcixvia08a9r1mdfr257xwn7qan2hpr40ahwcnx";
        authors = [
          "Ashley Mannix <ashleymannix@live.com.au>"
        ];
        dependencies = [
          {
            name = "ctor";
            packageId = "ctor";
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check";
            rename = "rustc";
          }
        ];
        features = {
          "error" = [ "std" "sval1_lib/std" ];
          "serde" = [ "serde1" ];
          "serde1" = [ "serde1_lib" "sval1_lib/serde1" "sval1_lib/alloc" "erased-serde1/alloc" "serde1_fmt" ];
          "sval" = [ "sval1" ];
          "sval1" = [ "sval1_lib" ];
          "test" = [ "std" ];
        };
      };
      "vcpkg" = rec {
        crateName = "vcpkg";
        version = "0.2.15";
        edition = "2015";
        sha256 = "09i4nf5y8lig6xgj3f7fyrvzd3nlaw4znrihw8psidvv5yk4xkdc";
        authors = [
          "Jim McGrath <jimmc2@gmail.com>"
        ];
        
      };
      "vergen" = rec {
        crateName = "vergen";
        version = "4.2.0";
        edition = "2018";
        sha256 = "02asiz1k8v3lfs70avzspsc8vzw7lpm4rpbfnnlg3ln6az89fcb4";
        authors = [
          "Jason Ozias <jason.g.ozias@gmail.com>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "chrono";
            packageId = "chrono";
            optional = true;
          }
          {
            name = "enum-iterator";
            packageId = "enum-iterator";
          }
          {
            name = "getset";
            packageId = "getset";
          }
          {
            name = "git2";
            packageId = "git2";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "rustc_version";
            packageId = "rustc_version";
            optional = true;
          }
          {
            name = "thiserror";
            packageId = "thiserror";
          }
        ];
        buildDependencies = [
          {
            name = "chrono";
            packageId = "chrono";
          }
        ];
        features = {
          "build" = [ "chrono" ];
          "default" = [ "build" "cargo" "git" "rustc" ];
          "git" = [ "chrono" "git2" ];
          "rustc" = [ "rustc_version" ];
        };
        resolvedDefaultFeatures = [ "build" "cargo" "chrono" "default" "git" "git2" "rustc" "rustc_version" ];
      };
      "version_check" = rec {
        crateName = "version_check";
        version = "0.9.3";
        edition = "2015";
        sha256 = "1zmkcgj2m0pq0l4wnhrp1wl1lygf7x2h5p7pvjwc4719lnlxrv2z";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];
        
      };
      "waker-fn" = rec {
        crateName = "waker-fn";
        version = "1.1.0";
        edition = "2018";
        sha256 = "1jpfiis0frk2b36krqvk8264kgxk2dyhfzjsr8g3wah1nii2qnwx";
        authors = [
          "Stjepan Glavina <stjepang@gmail.com>"
        ];
        
      };
      "want" = rec {
        crateName = "want";
        version = "0.3.0";
        edition = "2018";
        sha256 = "181b2zmwfq389x9n2g1n37cvcvvdand832zz6v8i1l8wrdlaks0w";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "try-lock";
            packageId = "try-lock";
          }
        ];
        
      };
      "wasi" = rec {
        crateName = "wasi";
        version = "0.10.2+wasi-snapshot-preview1";
        edition = "2018";
        sha256 = "1ii7nff4y1mpcrxzzvbpgxm7a1nn3szjf1n21jnx37c2g6dbsvzx";
        authors = [
          "The Cranelift Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "rustc-std-workspace-alloc" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "wasm-bindgen" = rec {
        crateName = "wasm-bindgen";
        version = "0.2.74";
        edition = "2018";
        sha256 = "1zcp57mwb47vdw3r594cl7vbj6pwd503xrkq8a3phvs8xpaf2knm";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "wasm-bindgen-macro";
            packageId = "wasm-bindgen-macro";
          }
        ];
        features = {
          "default" = [ "spans" "std" ];
          "enable-interning" = [ "std" ];
          "serde-serialize" = [ "serde" "serde_json" "std" ];
          "spans" = [ "wasm-bindgen-macro/spans" ];
          "strict-macro" = [ "wasm-bindgen-macro/strict-macro" ];
          "xxx_debug_only_print_generated_code" = [ "wasm-bindgen-macro/xxx_debug_only_print_generated_code" ];
        };
        resolvedDefaultFeatures = [ "default" "spans" "std" ];
      };
      "wasm-bindgen-backend" = rec {
        crateName = "wasm-bindgen-backend";
        version = "0.2.74";
        edition = "2018";
        sha256 = "005ra6jc8pm1y2wi6swkvn34r2is3knv5f2dv59ymkscd6hgccrv";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "bumpalo";
            packageId = "bumpalo";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "full" ];
          }
          {
            name = "wasm-bindgen-shared";
            packageId = "wasm-bindgen-shared";
          }
        ];
        features = {
          "extra-traits" = [ "syn/extra-traits" ];
        };
        resolvedDefaultFeatures = [ "spans" ];
      };
      "wasm-bindgen-futures" = rec {
        crateName = "wasm-bindgen-futures";
        version = "0.4.24";
        edition = "2018";
        sha256 = "1wb75qgv91qjblv685hnka2fn3w4fp0wi05cs3i3rmbrqrw7kfjz";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "js-sys";
            packageId = "js-sys";
          }
          {
            name = "wasm-bindgen";
            packageId = "wasm-bindgen";
          }
          {
            name = "web-sys";
            packageId = "web-sys";
            target = { target, features }: (target."feature" == "atomics");
            features = [ "MessageEvent" "Worker" ];
          }
        ];
        features = {
          "futures-core-03-stream" = [ "futures-core" ];
        };
      };
      "wasm-bindgen-macro" = rec {
        crateName = "wasm-bindgen-macro";
        version = "0.2.74";
        edition = "2018";
        sha256 = "1m4bn6wlzc2rkp693zgnn7kh05r5fm4w55l0igjy23s3c756k088";
        procMacro = true;
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "wasm-bindgen-macro-support";
            packageId = "wasm-bindgen-macro-support";
          }
        ];
        features = {
          "spans" = [ "wasm-bindgen-macro-support/spans" ];
          "strict-macro" = [ "wasm-bindgen-macro-support/strict-macro" ];
        };
        resolvedDefaultFeatures = [ "spans" ];
      };
      "wasm-bindgen-macro-support" = rec {
        crateName = "wasm-bindgen-macro-support";
        version = "0.2.74";
        edition = "2018";
        sha256 = "15vsk3q4jfk8ax4walc8vy3fgvrpkg86vjz2ym0z5ngk5xa428my";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "visit" "full" ];
          }
          {
            name = "wasm-bindgen-backend";
            packageId = "wasm-bindgen-backend";
          }
          {
            name = "wasm-bindgen-shared";
            packageId = "wasm-bindgen-shared";
          }
        ];
        features = {
          "extra-traits" = [ "syn/extra-traits" ];
          "spans" = [ "wasm-bindgen-backend/spans" ];
        };
        resolvedDefaultFeatures = [ "spans" ];
      };
      "wasm-bindgen-shared" = rec {
        crateName = "wasm-bindgen-shared";
        version = "0.2.74";
        edition = "2018";
        sha256 = "0ksbnhjzvnsmzc1n18bs98swnrzrwxjrpx3clrsyv3pip1vgikyp";
        authors = [
          "The wasm-bindgen Developers"
        ];
        
      };
      "web-sys" = rec {
        crateName = "web-sys";
        version = "0.3.51";
        edition = "2018";
        sha256 = "10p514z7zmwzxqll0z0zqhlswv3hadbrwais3l8zfgcz6xxl2a78";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "js-sys";
            packageId = "js-sys";
          }
          {
            name = "wasm-bindgen";
            packageId = "wasm-bindgen";
          }
        ];
        features = {
          "AbortSignal" = [ "EventTarget" ];
          "AnalyserNode" = [ "AudioNode" "EventTarget" ];
          "Animation" = [ "EventTarget" ];
          "AnimationEvent" = [ "Event" ];
          "AnimationPlaybackEvent" = [ "Event" ];
          "Attr" = [ "EventTarget" "Node" ];
          "AudioBufferSourceNode" = [ "AudioNode" "AudioScheduledSourceNode" "EventTarget" ];
          "AudioContext" = [ "BaseAudioContext" "EventTarget" ];
          "AudioDestinationNode" = [ "AudioNode" "EventTarget" ];
          "AudioNode" = [ "EventTarget" ];
          "AudioProcessingEvent" = [ "Event" ];
          "AudioScheduledSourceNode" = [ "AudioNode" "EventTarget" ];
          "AudioStreamTrack" = [ "EventTarget" "MediaStreamTrack" ];
          "AudioTrackList" = [ "EventTarget" ];
          "AudioWorklet" = [ "Worklet" ];
          "AudioWorkletGlobalScope" = [ "WorkletGlobalScope" ];
          "AudioWorkletNode" = [ "AudioNode" "EventTarget" ];
          "AuthenticatorAssertionResponse" = [ "AuthenticatorResponse" ];
          "AuthenticatorAttestationResponse" = [ "AuthenticatorResponse" ];
          "BaseAudioContext" = [ "EventTarget" ];
          "BatteryManager" = [ "EventTarget" ];
          "BeforeUnloadEvent" = [ "Event" ];
          "BiquadFilterNode" = [ "AudioNode" "EventTarget" ];
          "BlobEvent" = [ "Event" ];
          "Bluetooth" = [ "EventTarget" ];
          "BluetoothAdvertisingEvent" = [ "Event" ];
          "BluetoothDevice" = [ "EventTarget" ];
          "BluetoothPermissionResult" = [ "EventTarget" "PermissionStatus" ];
          "BluetoothRemoteGattCharacteristic" = [ "EventTarget" ];
          "BluetoothRemoteGattService" = [ "EventTarget" ];
          "BroadcastChannel" = [ "EventTarget" ];
          "CanvasCaptureMediaStream" = [ "EventTarget" "MediaStream" ];
          "CdataSection" = [ "CharacterData" "EventTarget" "Node" "Text" ];
          "ChannelMergerNode" = [ "AudioNode" "EventTarget" ];
          "ChannelSplitterNode" = [ "AudioNode" "EventTarget" ];
          "CharacterData" = [ "EventTarget" "Node" ];
          "ChromeWorker" = [ "EventTarget" "Worker" ];
          "Clipboard" = [ "EventTarget" ];
          "ClipboardEvent" = [ "Event" ];
          "CloseEvent" = [ "Event" ];
          "Comment" = [ "CharacterData" "EventTarget" "Node" ];
          "CompositionEvent" = [ "Event" "UiEvent" ];
          "ConstantSourceNode" = [ "AudioNode" "AudioScheduledSourceNode" "EventTarget" ];
          "ConvolverNode" = [ "AudioNode" "EventTarget" ];
          "CssAnimation" = [ "Animation" "EventTarget" ];
          "CssConditionRule" = [ "CssGroupingRule" "CssRule" ];
          "CssCounterStyleRule" = [ "CssRule" ];
          "CssFontFaceRule" = [ "CssRule" ];
          "CssFontFeatureValuesRule" = [ "CssRule" ];
          "CssGroupingRule" = [ "CssRule" ];
          "CssImportRule" = [ "CssRule" ];
          "CssKeyframeRule" = [ "CssRule" ];
          "CssKeyframesRule" = [ "CssRule" ];
          "CssMediaRule" = [ "CssConditionRule" "CssGroupingRule" "CssRule" ];
          "CssNamespaceRule" = [ "CssRule" ];
          "CssPageRule" = [ "CssRule" ];
          "CssStyleRule" = [ "CssRule" ];
          "CssStyleSheet" = [ "StyleSheet" ];
          "CssSupportsRule" = [ "CssConditionRule" "CssGroupingRule" "CssRule" ];
          "CssTransition" = [ "Animation" "EventTarget" ];
          "CustomEvent" = [ "Event" ];
          "DedicatedWorkerGlobalScope" = [ "EventTarget" "WorkerGlobalScope" ];
          "DelayNode" = [ "AudioNode" "EventTarget" ];
          "DeviceLightEvent" = [ "Event" ];
          "DeviceMotionEvent" = [ "Event" ];
          "DeviceOrientationEvent" = [ "Event" ];
          "DeviceProximityEvent" = [ "Event" ];
          "Document" = [ "EventTarget" "Node" ];
          "DocumentFragment" = [ "EventTarget" "Node" ];
          "DocumentTimeline" = [ "AnimationTimeline" ];
          "DocumentType" = [ "EventTarget" "Node" ];
          "DomMatrix" = [ "DomMatrixReadOnly" ];
          "DomPoint" = [ "DomPointReadOnly" ];
          "DomRect" = [ "DomRectReadOnly" ];
          "DomRequest" = [ "EventTarget" ];
          "DragEvent" = [ "Event" "MouseEvent" "UiEvent" ];
          "DynamicsCompressorNode" = [ "AudioNode" "EventTarget" ];
          "Element" = [ "EventTarget" "Node" ];
          "ErrorEvent" = [ "Event" ];
          "EventSource" = [ "EventTarget" ];
          "ExtendableEvent" = [ "Event" ];
          "ExtendableMessageEvent" = [ "Event" "ExtendableEvent" ];
          "FetchEvent" = [ "Event" "ExtendableEvent" ];
          "FetchObserver" = [ "EventTarget" ];
          "File" = [ "Blob" ];
          "FileReader" = [ "EventTarget" ];
          "FileSystemDirectoryEntry" = [ "FileSystemEntry" ];
          "FileSystemFileEntry" = [ "FileSystemEntry" ];
          "FocusEvent" = [ "Event" "UiEvent" ];
          "FontFaceSet" = [ "EventTarget" ];
          "FontFaceSetLoadEvent" = [ "Event" ];
          "GainNode" = [ "AudioNode" "EventTarget" ];
          "GamepadAxisMoveEvent" = [ "Event" "GamepadEvent" ];
          "GamepadButtonEvent" = [ "Event" "GamepadEvent" ];
          "GamepadEvent" = [ "Event" ];
          "GpuDevice" = [ "EventTarget" ];
          "GpuUncapturedErrorEvent" = [ "Event" ];
          "HashChangeEvent" = [ "Event" ];
          "HtmlAnchorElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlAreaElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlAudioElement" = [ "Element" "EventTarget" "HtmlElement" "HtmlMediaElement" "Node" ];
          "HtmlBaseElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlBodyElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlBrElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlButtonElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlCanvasElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDListElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDataElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDataListElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDetailsElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDialogElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDirectoryElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDivElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDocument" = [ "Document" "EventTarget" "Node" ];
          "HtmlElement" = [ "Element" "EventTarget" "Node" ];
          "HtmlEmbedElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlFieldSetElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlFontElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlFormControlsCollection" = [ "HtmlCollection" ];
          "HtmlFormElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlFrameElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlFrameSetElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlHeadElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlHeadingElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlHrElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlHtmlElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlIFrameElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlImageElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlInputElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlLabelElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlLegendElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlLiElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlLinkElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlMapElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlMediaElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlMenuElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlMenuItemElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlMetaElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlMeterElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlModElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlOListElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlObjectElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlOptGroupElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlOptionElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlOptionsCollection" = [ "HtmlCollection" ];
          "HtmlOutputElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlParagraphElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlParamElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlPictureElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlPreElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlProgressElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlQuoteElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlScriptElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlSelectElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlSlotElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlSourceElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlSpanElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlStyleElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTableCaptionElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTableCellElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTableColElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTableElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTableRowElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTableSectionElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTemplateElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTextAreaElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTimeElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTitleElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTrackElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlUListElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlUnknownElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlVideoElement" = [ "Element" "EventTarget" "HtmlElement" "HtmlMediaElement" "Node" ];
          "IdbCursorWithValue" = [ "IdbCursor" ];
          "IdbDatabase" = [ "EventTarget" ];
          "IdbFileHandle" = [ "EventTarget" ];
          "IdbFileRequest" = [ "DomRequest" "EventTarget" ];
          "IdbLocaleAwareKeyRange" = [ "IdbKeyRange" ];
          "IdbMutableFile" = [ "EventTarget" ];
          "IdbOpenDbRequest" = [ "EventTarget" "IdbRequest" ];
          "IdbRequest" = [ "EventTarget" ];
          "IdbTransaction" = [ "EventTarget" ];
          "IdbVersionChangeEvent" = [ "Event" ];
          "IirFilterNode" = [ "AudioNode" "EventTarget" ];
          "ImageCaptureErrorEvent" = [ "Event" ];
          "InputEvent" = [ "Event" "UiEvent" ];
          "KeyboardEvent" = [ "Event" "UiEvent" ];
          "KeyframeEffect" = [ "AnimationEffect" ];
          "LocalMediaStream" = [ "EventTarget" "MediaStream" ];
          "MediaDevices" = [ "EventTarget" ];
          "MediaElementAudioSourceNode" = [ "AudioNode" "EventTarget" ];
          "MediaEncryptedEvent" = [ "Event" ];
          "MediaKeyError" = [ "Event" ];
          "MediaKeyMessageEvent" = [ "Event" ];
          "MediaKeySession" = [ "EventTarget" ];
          "MediaQueryList" = [ "EventTarget" ];
          "MediaQueryListEvent" = [ "Event" ];
          "MediaRecorder" = [ "EventTarget" ];
          "MediaRecorderErrorEvent" = [ "Event" ];
          "MediaSource" = [ "EventTarget" ];
          "MediaStream" = [ "EventTarget" ];
          "MediaStreamAudioDestinationNode" = [ "AudioNode" "EventTarget" ];
          "MediaStreamAudioSourceNode" = [ "AudioNode" "EventTarget" ];
          "MediaStreamEvent" = [ "Event" ];
          "MediaStreamTrack" = [ "EventTarget" ];
          "MediaStreamTrackEvent" = [ "Event" ];
          "MessageEvent" = [ "Event" ];
          "MessagePort" = [ "EventTarget" ];
          "MidiAccess" = [ "EventTarget" ];
          "MidiConnectionEvent" = [ "Event" ];
          "MidiInput" = [ "EventTarget" "MidiPort" ];
          "MidiMessageEvent" = [ "Event" ];
          "MidiOutput" = [ "EventTarget" "MidiPort" ];
          "MidiPort" = [ "EventTarget" ];
          "MouseEvent" = [ "Event" "UiEvent" ];
          "MouseScrollEvent" = [ "Event" "MouseEvent" "UiEvent" ];
          "MutationEvent" = [ "Event" ];
          "NetworkInformation" = [ "EventTarget" ];
          "Node" = [ "EventTarget" ];
          "Notification" = [ "EventTarget" ];
          "NotificationEvent" = [ "Event" "ExtendableEvent" ];
          "OfflineAudioCompletionEvent" = [ "Event" ];
          "OfflineAudioContext" = [ "BaseAudioContext" "EventTarget" ];
          "OfflineResourceList" = [ "EventTarget" ];
          "OffscreenCanvas" = [ "EventTarget" ];
          "OscillatorNode" = [ "AudioNode" "AudioScheduledSourceNode" "EventTarget" ];
          "PageTransitionEvent" = [ "Event" ];
          "PaintWorkletGlobalScope" = [ "WorkletGlobalScope" ];
          "PannerNode" = [ "AudioNode" "EventTarget" ];
          "PaymentMethodChangeEvent" = [ "Event" "PaymentRequestUpdateEvent" ];
          "PaymentRequestUpdateEvent" = [ "Event" ];
          "Performance" = [ "EventTarget" ];
          "PerformanceMark" = [ "PerformanceEntry" ];
          "PerformanceMeasure" = [ "PerformanceEntry" ];
          "PerformanceNavigationTiming" = [ "PerformanceEntry" "PerformanceResourceTiming" ];
          "PerformanceResourceTiming" = [ "PerformanceEntry" ];
          "PermissionStatus" = [ "EventTarget" ];
          "PointerEvent" = [ "Event" "MouseEvent" "UiEvent" ];
          "PopStateEvent" = [ "Event" ];
          "PopupBlockedEvent" = [ "Event" ];
          "PresentationAvailability" = [ "EventTarget" ];
          "PresentationConnection" = [ "EventTarget" ];
          "PresentationConnectionAvailableEvent" = [ "Event" ];
          "PresentationConnectionCloseEvent" = [ "Event" ];
          "PresentationConnectionList" = [ "EventTarget" ];
          "PresentationRequest" = [ "EventTarget" ];
          "ProcessingInstruction" = [ "CharacterData" "EventTarget" "Node" ];
          "ProgressEvent" = [ "Event" ];
          "PromiseRejectionEvent" = [ "Event" ];
          "PublicKeyCredential" = [ "Credential" ];
          "PushEvent" = [ "Event" "ExtendableEvent" ];
          "RadioNodeList" = [ "NodeList" ];
          "RtcDataChannel" = [ "EventTarget" ];
          "RtcDataChannelEvent" = [ "Event" ];
          "RtcPeerConnection" = [ "EventTarget" ];
          "RtcPeerConnectionIceEvent" = [ "Event" ];
          "RtcTrackEvent" = [ "Event" ];
          "RtcdtmfSender" = [ "EventTarget" ];
          "RtcdtmfToneChangeEvent" = [ "Event" ];
          "Screen" = [ "EventTarget" ];
          "ScreenOrientation" = [ "EventTarget" ];
          "ScriptProcessorNode" = [ "AudioNode" "EventTarget" ];
          "ScrollAreaEvent" = [ "Event" "UiEvent" ];
          "SecurityPolicyViolationEvent" = [ "Event" ];
          "ServiceWorker" = [ "EventTarget" ];
          "ServiceWorkerContainer" = [ "EventTarget" ];
          "ServiceWorkerGlobalScope" = [ "EventTarget" "WorkerGlobalScope" ];
          "ServiceWorkerRegistration" = [ "EventTarget" ];
          "ShadowRoot" = [ "DocumentFragment" "EventTarget" "Node" ];
          "SharedWorker" = [ "EventTarget" ];
          "SharedWorkerGlobalScope" = [ "EventTarget" "WorkerGlobalScope" ];
          "SourceBuffer" = [ "EventTarget" ];
          "SourceBufferList" = [ "EventTarget" ];
          "SpeechRecognition" = [ "EventTarget" ];
          "SpeechRecognitionError" = [ "Event" ];
          "SpeechRecognitionEvent" = [ "Event" ];
          "SpeechSynthesis" = [ "EventTarget" ];
          "SpeechSynthesisErrorEvent" = [ "Event" "SpeechSynthesisEvent" ];
          "SpeechSynthesisEvent" = [ "Event" ];
          "SpeechSynthesisUtterance" = [ "EventTarget" ];
          "StereoPannerNode" = [ "AudioNode" "EventTarget" ];
          "StorageEvent" = [ "Event" ];
          "SvgAnimateElement" = [ "Element" "EventTarget" "Node" "SvgAnimationElement" "SvgElement" ];
          "SvgAnimateMotionElement" = [ "Element" "EventTarget" "Node" "SvgAnimationElement" "SvgElement" ];
          "SvgAnimateTransformElement" = [ "Element" "EventTarget" "Node" "SvgAnimationElement" "SvgElement" ];
          "SvgAnimationElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgCircleElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgClipPathElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgComponentTransferFunctionElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgDefsElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgDescElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgElement" = [ "Element" "EventTarget" "Node" ];
          "SvgEllipseElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgFilterElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgForeignObjectElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgGeometryElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgGradientElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgGraphicsElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgImageElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgLineElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgLinearGradientElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGradientElement" ];
          "SvgMarkerElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgMaskElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgMetadataElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgPathElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgPathSegArcAbs" = [ "SvgPathSeg" ];
          "SvgPathSegArcRel" = [ "SvgPathSeg" ];
          "SvgPathSegClosePath" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoCubicAbs" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoCubicRel" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoCubicSmoothAbs" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoCubicSmoothRel" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoQuadraticAbs" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoQuadraticRel" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoQuadraticSmoothAbs" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoQuadraticSmoothRel" = [ "SvgPathSeg" ];
          "SvgPathSegLinetoAbs" = [ "SvgPathSeg" ];
          "SvgPathSegLinetoHorizontalAbs" = [ "SvgPathSeg" ];
          "SvgPathSegLinetoHorizontalRel" = [ "SvgPathSeg" ];
          "SvgPathSegLinetoRel" = [ "SvgPathSeg" ];
          "SvgPathSegLinetoVerticalAbs" = [ "SvgPathSeg" ];
          "SvgPathSegLinetoVerticalRel" = [ "SvgPathSeg" ];
          "SvgPathSegMovetoAbs" = [ "SvgPathSeg" ];
          "SvgPathSegMovetoRel" = [ "SvgPathSeg" ];
          "SvgPatternElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgPolygonElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgPolylineElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgRadialGradientElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGradientElement" ];
          "SvgRectElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgScriptElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgSetElement" = [ "Element" "EventTarget" "Node" "SvgAnimationElement" "SvgElement" ];
          "SvgStopElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgStyleElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgSwitchElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgSymbolElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgTextContentElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgTextElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" "SvgTextContentElement" "SvgTextPositioningElement" ];
          "SvgTextPathElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" "SvgTextContentElement" ];
          "SvgTextPositioningElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" "SvgTextContentElement" ];
          "SvgTitleElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgUseElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgViewElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgaElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgfeBlendElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeColorMatrixElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeComponentTransferElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeCompositeElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeConvolveMatrixElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeDiffuseLightingElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeDisplacementMapElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeDistantLightElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeDropShadowElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeFloodElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeFuncAElement" = [ "Element" "EventTarget" "Node" "SvgComponentTransferFunctionElement" "SvgElement" ];
          "SvgfeFuncBElement" = [ "Element" "EventTarget" "Node" "SvgComponentTransferFunctionElement" "SvgElement" ];
          "SvgfeFuncGElement" = [ "Element" "EventTarget" "Node" "SvgComponentTransferFunctionElement" "SvgElement" ];
          "SvgfeFuncRElement" = [ "Element" "EventTarget" "Node" "SvgComponentTransferFunctionElement" "SvgElement" ];
          "SvgfeGaussianBlurElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeImageElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeMergeElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeMergeNodeElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeMorphologyElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeOffsetElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfePointLightElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeSpecularLightingElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeSpotLightElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeTileElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeTurbulenceElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvggElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgmPathElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgsvgElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgtSpanElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" "SvgTextContentElement" "SvgTextPositioningElement" ];
          "TcpServerSocket" = [ "EventTarget" ];
          "TcpServerSocketEvent" = [ "Event" ];
          "TcpSocket" = [ "EventTarget" ];
          "TcpSocketErrorEvent" = [ "Event" ];
          "TcpSocketEvent" = [ "Event" ];
          "Text" = [ "CharacterData" "EventTarget" "Node" ];
          "TextTrack" = [ "EventTarget" ];
          "TextTrackCue" = [ "EventTarget" ];
          "TextTrackList" = [ "EventTarget" ];
          "TimeEvent" = [ "Event" ];
          "TouchEvent" = [ "Event" "UiEvent" ];
          "TrackEvent" = [ "Event" ];
          "TransitionEvent" = [ "Event" ];
          "UiEvent" = [ "Event" ];
          "Usb" = [ "EventTarget" ];
          "UsbConnectionEvent" = [ "Event" ];
          "UsbPermissionResult" = [ "EventTarget" "PermissionStatus" ];
          "UserProximityEvent" = [ "Event" ];
          "ValueEvent" = [ "Event" ];
          "VideoStreamTrack" = [ "EventTarget" "MediaStreamTrack" ];
          "VideoTrackList" = [ "EventTarget" ];
          "VrDisplay" = [ "EventTarget" ];
          "VttCue" = [ "EventTarget" "TextTrackCue" ];
          "WaveShaperNode" = [ "AudioNode" "EventTarget" ];
          "WebGlContextEvent" = [ "Event" ];
          "WebKitCssMatrix" = [ "DomMatrix" "DomMatrixReadOnly" ];
          "WebSocket" = [ "EventTarget" ];
          "WheelEvent" = [ "Event" "MouseEvent" "UiEvent" ];
          "Window" = [ "EventTarget" ];
          "WindowClient" = [ "Client" ];
          "Worker" = [ "EventTarget" ];
          "WorkerDebuggerGlobalScope" = [ "EventTarget" ];
          "WorkerGlobalScope" = [ "EventTarget" ];
          "XmlDocument" = [ "Document" "EventTarget" "Node" ];
          "XmlHttpRequest" = [ "EventTarget" "XmlHttpRequestEventTarget" ];
          "XmlHttpRequestEventTarget" = [ "EventTarget" ];
          "XmlHttpRequestUpload" = [ "EventTarget" "XmlHttpRequestEventTarget" ];
          "Xr" = [ "EventTarget" ];
          "XrBoundedReferenceSpace" = [ "EventTarget" "XrReferenceSpace" "XrSpace" ];
          "XrInputSourceEvent" = [ "Event" ];
          "XrInputSourcesChangeEvent" = [ "Event" ];
          "XrReferenceSpace" = [ "EventTarget" "XrSpace" ];
          "XrReferenceSpaceEvent" = [ "Event" ];
          "XrSession" = [ "EventTarget" ];
          "XrSessionEvent" = [ "Event" ];
          "XrSpace" = [ "EventTarget" ];
          "XrViewerPose" = [ "XrPose" ];
        };
        resolvedDefaultFeatures = [ "Event" "EventTarget" "MessageEvent" "Window" "Worker" "WorkerGlobalScope" ];
      };
      "wepoll-ffi" = rec {
        crateName = "wepoll-ffi";
        version = "0.1.2";
        edition = "2018";
        sha256 = "1yxpkva08d5f6ih3b5hdb8h45mkz3jq3dh1bzjspfhy6qpnzshyp";
        authors = [
          "Philip Degarmo <aclysma@gmail.com>"
        ];
        buildDependencies = [
          {
            name = "cc";
            packageId = "cc";
          }
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "null-overlapped-wakeups-patch" ];
      };
      "winapi" = rec {
        crateName = "winapi";
        version = "0.3.9";
        edition = "2015";
        sha256 = "06gl025x418lchw1wxj64ycr7gha83m44cjr5sarhynd9xkrm0sw";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-i686-pc-windows-gnu";
            packageId = "winapi-i686-pc-windows-gnu";
            target = { target, features }: (stdenv.hostPlatform.config == "i686-pc-windows-gnu");
          }
          {
            name = "winapi-x86_64-pc-windows-gnu";
            packageId = "winapi-x86_64-pc-windows-gnu";
            target = { target, features }: (stdenv.hostPlatform.config == "x86_64-pc-windows-gnu");
          }
        ];
        features = {
          "debug" = [ "impl-debug" ];
        };
        resolvedDefaultFeatures = [ "cfg" "consoleapi" "errhandlingapi" "evntrace" "fileapi" "handleapi" "in6addr" "inaddr" "ioapiset" "minwinbase" "minwindef" "mstcpip" "mswsock" "namedpipeapi" "ntdef" "ntsecapi" "ntstatus" "processenv" "profileapi" "std" "synchapi" "sysinfoapi" "threadpoollegacyapiset" "timezoneapi" "winbase" "wincon" "windef" "winerror" "winioctl" "winnt" "winsock2" "ws2def" "ws2ipdef" "ws2tcpip" ];
      };
      "winapi-i686-pc-windows-gnu" = rec {
        crateName = "winapi-i686-pc-windows-gnu";
        version = "0.4.0";
        edition = "2015";
        sha256 = "1dmpa6mvcvzz16zg6d5vrfy4bxgg541wxrcip7cnshi06v38ffxc";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];
        
      };
      "winapi-util" = rec {
        crateName = "winapi-util";
        version = "0.1.5";
        edition = "2018";
        sha256 = "0y71bp7f6d536czj40dhqk0d55wfbbwqfp2ymqf1an5ibgl6rv3h";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: target."windows";
            features = [ "std" "consoleapi" "errhandlingapi" "fileapi" "minwindef" "processenv" "winbase" "wincon" "winerror" "winnt" ];
          }
        ];
        
      };
      "winapi-x86_64-pc-windows-gnu" = rec {
        crateName = "winapi-x86_64-pc-windows-gnu";
        version = "0.4.0";
        edition = "2015";
        sha256 = "0gqq64czqb64kskjryj8isp62m2sgvx25yyj3kpc2myh85w24bki";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];
        
      };
      "yaml-rust" = rec {
        crateName = "yaml-rust";
        version = "0.4.5";
        edition = "2018";
        sha256 = "118wbqrr4n6wgk5rjjnlrdlahawlxc1bdsx146mwk8f79in97han";
        authors = [
          "Yuheng Chen <yuhengchen@sensetime.com>"
        ];
        dependencies = [
          {
            name = "linked-hash-map";
            packageId = "linked-hash-map";
          }
        ];
        
      };
    };

    #
# crate2nix/default.nix (excerpt start)
#

  /* Target (platform) data for conditional dependencies.
     This corresponds roughly to what buildRustCrate is setting.
  */
  defaultTarget = {
    unix = true;
    windows = false;
    fuchsia = true;
    test = false;

    # This doesn't appear to be officially documented anywhere yet.
    # See https://github.com/rust-lang-nursery/rust-forge/issues/101.
    os =
      if stdenv.hostPlatform.isDarwin
      then "macos"
      else stdenv.hostPlatform.parsed.kernel.name;
    arch = stdenv.hostPlatform.parsed.cpu.name;
    family = "unix";
    env = "gnu";
    endian =
      if stdenv.hostPlatform.parsed.cpu.significantByte.name == "littleEndian"
      then "little" else "big";
    pointer_width = toString stdenv.hostPlatform.parsed.cpu.bits;
    vendor = stdenv.hostPlatform.parsed.vendor.name;
    debug_assertions = false;
  };

  /* Filters common temp files and build files. */
  # TODO(pkolloch): Substitute with gitignore filter
  sourceFilter = name: type:
    let
      baseName = builtins.baseNameOf (builtins.toString name);
    in
      ! (
        # Filter out git
        baseName == ".gitignore"
        || (type == "directory" && baseName == ".git")

        # Filter out build results
        || (
          type == "directory" && (
            baseName == "target"
            || baseName == "_site"
            || baseName == ".sass-cache"
            || baseName == ".jekyll-metadata"
            || baseName == "build-artifacts"
          )
        )

        # Filter out nix-build result symlinks
        || (
          type == "symlink" && lib.hasPrefix "result" baseName
        )

        # Filter out IDE config
        || (
          type == "directory" && (
            baseName == ".idea" || baseName == ".vscode"
          )
        ) || lib.hasSuffix ".iml" baseName

        # Filter out nix build files
        || baseName == "Cargo.nix"

        # Filter out editor backup / swap files.
        || lib.hasSuffix "~" baseName
        || builtins.match "^\\.sw[a-z]$$" baseName != null
        || builtins.match "^\\..*\\.sw[a-z]$$" baseName != null
        || lib.hasSuffix ".tmp" baseName
        || lib.hasSuffix ".bak" baseName
        || baseName == "tests.nix"
      );

  /* Returns a crate which depends on successful test execution
     of crate given as the second argument.

     testCrateFlags: list of flags to pass to the test exectuable
     testInputs: list of packages that should be available during test execution
  */
  crateWithTest = { crate, testCrate, testCrateFlags, testInputs }:
    assert builtins.typeOf testCrateFlags == "list";
    assert builtins.typeOf testInputs == "list";
    let
      # override the `crate` so that it will build and execute tests instead of
      # building the actual lib and bin targets We just have to pass `--test`
      # to rustc and it will do the right thing.  We execute the tests and copy
      # their log and the test executables to $out for later inspection.
      test =
        let
          drv = testCrate.override
            (
              _: {
                buildTests = true;
              }
            );
        in
        pkgs.runCommand "run-tests-${testCrate.name}" {
          inherit testCrateFlags;
          buildInputs = testInputs;
        } ''
          set -ex

          export RUST_BACKTRACE=1

          # recreate a file hierarchy as when running tests with cargo

          # the source for test data
          ${pkgs.xorg.lndir}/bin/lndir ${crate.src}

          # build outputs
          testRoot=target/debug
          mkdir -p $testRoot

          # executables of the crate
          # we copy to prevent std::env::current_exe() to resolve to a store location
          for i in ${crate}/bin/*; do
            cp "$i" "$testRoot"
          done
          chmod +w -R .

          # test harness executables are suffixed with a hash, like cargo does
          # this allows to prevent name collision with the main
          # executables of the crate
          hash=$(basename $out)
          for file in ${drv}/tests/*; do
            f=$testRoot/$(basename $file)-$hash
            cp $file $f
            $f $testCrateFlags 2>&1 | tee -a $out
          done
        '';
    in
    crate.overrideAttrs
      (
        old: {
          checkPhase = ''
            test -e ${test}
          '';
          passthru = (old.passthru or { }) // {
            inherit test;
          };
        }
      );

  /* A restricted overridable version of builtRustCratesWithFeatures. */
  buildRustCrateWithFeatures =
    { packageId
    , features ? rootFeatures
    , crateOverrides ? defaultCrateOverrides
    , buildRustCrateFunc ? null
    , runTests ? false
    , testCrateFlags ? [ ]
    , testInputs ? [ ]
    }:
    lib.makeOverridable
      (
        { features
        , crateOverrides
        , runTests
        , testCrateFlags
        , testInputs
        }:
        let
          buildRustCrateFuncOverriden =
            if buildRustCrateFunc != null
            then buildRustCrateFunc
            else (
              if crateOverrides == pkgs.defaultCrateOverrides
              then buildRustCrate
              else buildRustCrate.override {
                defaultCrateOverrides = crateOverrides;
              }
            );
          builtRustCrates = builtRustCratesWithFeatures {
            inherit packageId features;
            buildRustCrateFunc = buildRustCrateFuncOverriden;
            runTests = false;
          };
          builtTestRustCrates = builtRustCratesWithFeatures {
            inherit packageId features;
            buildRustCrateFunc = buildRustCrateFuncOverriden;
            runTests = true;
          };
          drv = builtRustCrates.${packageId};
          testDrv = builtTestRustCrates.${packageId};
          derivation =
            if runTests then
              crateWithTest {
                crate = drv;
                testCrate = testDrv;
                inherit testCrateFlags testInputs;
              }
            else drv;
        in
        derivation
      )
      { inherit features crateOverrides runTests testCrateFlags testInputs; };

  /* Returns an attr set with packageId mapped to the result of buildRustCrateFunc
     for the corresponding crate.
  */
  builtRustCratesWithFeatures =
    { packageId
    , features
    , crateConfigs ? crates
    , buildRustCrateFunc
    , runTests
    , target ? defaultTarget
    } @ args:
      assert (builtins.isAttrs crateConfigs);
      assert (builtins.isString packageId);
      assert (builtins.isList features);
      assert (builtins.isAttrs target);
      assert (builtins.isBool runTests);
      let
        rootPackageId = packageId;
        mergedFeatures = mergePackageFeatures
          (
            args // {
              inherit rootPackageId;
              target = target // { test = runTests; };
            }
          );
        buildByPackageId = packageId: buildByPackageIdImpl packageId;

        # Memoize built packages so that reappearing packages are only built once.
        builtByPackageId =
          lib.mapAttrs (packageId: value: buildByPackageId packageId) crateConfigs;
        buildByPackageIdImpl = packageId:
          let
            features = mergedFeatures."${packageId}" or [ ];
            crateConfig' = crateConfigs."${packageId}";
            crateConfig =
              builtins.removeAttrs crateConfig' [ "resolvedDefaultFeatures" "devDependencies" ];
            devDependencies =
              lib.optionals
                (runTests && packageId == rootPackageId)
                (crateConfig'.devDependencies or [ ]);
            dependencies =
              dependencyDerivations {
                inherit builtByPackageId features target;
                dependencies =
                  (crateConfig.dependencies or [ ])
                  ++ devDependencies;
              };
            buildDependencies =
              dependencyDerivations {
                inherit builtByPackageId features target;
                dependencies = crateConfig.buildDependencies or [ ];
              };
            filterEnabledDependenciesForThis = dependencies: filterEnabledDependencies {
              inherit dependencies features target;
            };
            dependenciesWithRenames =
              lib.filter (d: d ? "rename")
                (
                  filterEnabledDependenciesForThis
                    (
                      (crateConfig.buildDependencies or [ ])
                      ++ (crateConfig.dependencies or [ ])
                      ++ devDependencies
                    )
                );
            # Crate renames have the form:
            #
            # {
            #    crate_name = [
            #       { version = "1.2.3"; rename = "crate_name01"; }
            #    ];
            #    # ...
            # }
            crateRenames =
              let
                grouped =
                  lib.groupBy
                    (dependency: dependency.name)
                    dependenciesWithRenames;
                versionAndRename = dep:
                  let
                    package = builtByPackageId."${dep.packageId}";
                  in
                  { inherit (dep) rename; version = package.version; };
              in
              lib.mapAttrs (name: choices: builtins.map versionAndRename choices) grouped;
          in
          buildRustCrateFunc
            (
              crateConfig // {
                src = crateConfig.src or (
                  pkgs.fetchurl rec {
                    name = "${crateConfig.crateName}-${crateConfig.version}.tar.gz";
                    # https://www.pietroalbini.org/blog/downloading-crates-io/
                    # Not rate-limited, CDN URL.
                    url = "https://static.crates.io/crates/${crateConfig.crateName}/${crateConfig.crateName}-${crateConfig.version}.crate";
                    sha256 =
                      assert (lib.assertMsg (crateConfig ? sha256) "Missing sha256 for ${name}");
                      crateConfig.sha256;
                  }
                );
                inherit features dependencies buildDependencies crateRenames release;
              }
            );
      in
      builtByPackageId;

  /* Returns the actual derivations for the given dependencies. */
  dependencyDerivations =
    { builtByPackageId
    , features
    , dependencies
    , target
    }:
      assert (builtins.isAttrs builtByPackageId);
      assert (builtins.isList features);
      assert (builtins.isList dependencies);
      assert (builtins.isAttrs target);
      let
        enabledDependencies = filterEnabledDependencies {
          inherit dependencies features target;
        };
        depDerivation = dependency: builtByPackageId.${dependency.packageId};
      in
      map depDerivation enabledDependencies;

  /* Returns a sanitized version of val with all values substituted that cannot
     be serialized as JSON.
  */
  sanitizeForJson = val:
    if builtins.isAttrs val
    then lib.mapAttrs (n: v: sanitizeForJson v) val
    else if builtins.isList val
    then builtins.map sanitizeForJson val
    else if builtins.isFunction val
    then "function"
    else val;

  /* Returns various tools to debug a crate. */
  debugCrate = { packageId, target ? defaultTarget }:
    assert (builtins.isString packageId);
    let
      debug = rec {
        # The built tree as passed to buildRustCrate.
        buildTree = buildRustCrateWithFeatures {
          buildRustCrateFunc = lib.id;
          inherit packageId;
        };
        sanitizedBuildTree = sanitizeForJson buildTree;
        dependencyTree = sanitizeForJson
          (
            buildRustCrateWithFeatures {
              buildRustCrateFunc = crate: {
                "01_crateName" = crate.crateName or false;
                "02_features" = crate.features or [ ];
                "03_dependencies" = crate.dependencies or [ ];
              };
              inherit packageId;
            }
          );
        mergedPackageFeatures = mergePackageFeatures {
          features = rootFeatures;
          inherit packageId target;
        };
        diffedDefaultPackageFeatures = diffDefaultPackageFeatures {
          inherit packageId target;
        };
      };
    in
    { internal = debug; };

  /* Returns differences between cargo default features and crate2nix default
     features.

     This is useful for verifying the feature resolution in crate2nix.
  */
  diffDefaultPackageFeatures =
    { crateConfigs ? crates
    , packageId
    , target
    }:
      assert (builtins.isAttrs crateConfigs);
      let
        prefixValues = prefix: lib.mapAttrs (n: v: { "${prefix}" = v; });
        mergedFeatures =
          prefixValues
            "crate2nix"
            (mergePackageFeatures { inherit crateConfigs packageId target; features = [ "default" ]; });
        configs = prefixValues "cargo" crateConfigs;
        combined = lib.foldAttrs (a: b: a // b) { } [ mergedFeatures configs ];
        onlyInCargo =
          builtins.attrNames
            (lib.filterAttrs (n: v: !(v ? "crate2nix") && (v ? "cargo")) combined);
        onlyInCrate2Nix =
          builtins.attrNames
            (lib.filterAttrs (n: v: (v ? "crate2nix") && !(v ? "cargo")) combined);
        differentFeatures = lib.filterAttrs
          (
            n: v:
              (v ? "crate2nix")
              && (v ? "cargo")
              && (v.crate2nix.features or [ ]) != (v."cargo".resolved_default_features or [ ])
          )
          combined;
      in
      builtins.toJSON {
        inherit onlyInCargo onlyInCrate2Nix differentFeatures;
      };

  /* Returns an attrset mapping packageId to the list of enabled features.

     If multiple paths to a dependency enable different features, the
     corresponding feature sets are merged. Features in rust are additive.
  */
  mergePackageFeatures =
    { crateConfigs ? crates
    , packageId
    , rootPackageId ? packageId
    , features ? rootFeatures
    , dependencyPath ? [ crates.${packageId}.crateName ]
    , featuresByPackageId ? { }
    , target
      # Adds devDependencies to the crate with rootPackageId.
    , runTests ? false
    , ...
    } @ args:
      assert (builtins.isAttrs crateConfigs);
      assert (builtins.isString packageId);
      assert (builtins.isString rootPackageId);
      assert (builtins.isList features);
      assert (builtins.isList dependencyPath);
      assert (builtins.isAttrs featuresByPackageId);
      assert (builtins.isAttrs target);
      assert (builtins.isBool runTests);
      let
        crateConfig = crateConfigs."${packageId}" or (builtins.throw "Package not found: ${packageId}");
        expandedFeatures = expandFeatures (crateConfig.features or { }) features;
        depWithResolvedFeatures = dependency:
          let
            packageId = dependency.packageId;
            features = dependencyFeatures expandedFeatures dependency;
          in
          { inherit packageId features; };
        resolveDependencies = cache: path: dependencies:
          assert (builtins.isAttrs cache);
          assert (builtins.isList dependencies);
          let
            enabledDependencies = filterEnabledDependencies {
              inherit dependencies target;
              features = expandedFeatures;
            };
            directDependencies = map depWithResolvedFeatures enabledDependencies;
            foldOverCache = op: lib.foldl op cache directDependencies;
          in
          foldOverCache
            (
              cache: { packageId, features }:
                let
                  cacheFeatures = cache.${packageId} or [ ];
                  combinedFeatures = sortedUnique (cacheFeatures ++ features);
                in
                if cache ? ${packageId} && cache.${packageId} == combinedFeatures
                then cache
                else mergePackageFeatures {
                  features = combinedFeatures;
                  featuresByPackageId = cache;
                  inherit crateConfigs packageId target runTests rootPackageId;
                }
            );
        cacheWithSelf =
          let
            cacheFeatures = featuresByPackageId.${packageId} or [ ];
            combinedFeatures = sortedUnique (cacheFeatures ++ expandedFeatures);
          in
          featuresByPackageId // {
            "${packageId}" = combinedFeatures;
          };
        cacheWithDependencies =
          resolveDependencies cacheWithSelf "dep"
            (
              crateConfig.dependencies or [ ]
              ++ lib.optionals
                (runTests && packageId == rootPackageId)
                (crateConfig.devDependencies or [ ])
            );
        cacheWithAll =
          resolveDependencies
            cacheWithDependencies "build"
            (crateConfig.buildDependencies or [ ]);
      in
      cacheWithAll;

  /* Returns the enabled dependencies given the enabled features. */
  filterEnabledDependencies = { dependencies, features, target }:
    assert (builtins.isList dependencies);
    assert (builtins.isList features);
    assert (builtins.isAttrs target);

    lib.filter
      (
        dep:
        let
          targetFunc = dep.target or (features: true);
        in
        targetFunc { inherit features target; }
        && (
          !(dep.optional or false)
          || builtins.any (doesFeatureEnableDependency dep) features
        )
      )
      dependencies;

  /* Returns whether the given feature should enable the given dependency. */
  doesFeatureEnableDependency = { name, rename ? null, ... }: feature:
    let
      prefix = "${name}/";
      len = builtins.stringLength prefix;
      startsWithPrefix = builtins.substring 0 len feature == prefix;
    in
    (rename == null && feature == name)
    || (rename != null && rename == feature)
    || startsWithPrefix;

  /* Returns the expanded features for the given inputFeatures by applying the
     rules in featureMap.

     featureMap is an attribute set which maps feature names to lists of further
     feature names to enable in case this feature is selected.
  */
  expandFeatures = featureMap: inputFeatures:
    assert (builtins.isAttrs featureMap);
    assert (builtins.isList inputFeatures);
    let
      expandFeature = feature:
        assert (builtins.isString feature);
        [ feature ] ++ (expandFeatures featureMap (featureMap."${feature}" or [ ]));
      outFeatures = lib.concatMap expandFeature inputFeatures;
    in
    sortedUnique outFeatures;

  /*
     Returns the actual features for the given dependency.

     features: The features of the crate that refers this dependency.
  */
  dependencyFeatures = features: dependency:
    assert (builtins.isList features);
    assert (builtins.isAttrs dependency);
    let
      defaultOrNil =
        if dependency.usesDefaultFeatures or true
        then [ "default" ]
        else [ ];
      explicitFeatures = dependency.features or [ ];
      additionalDependencyFeatures =
        let
          dependencyPrefix = (dependency.rename or dependency.name) + "/";
          dependencyFeatures =
            builtins.filter (f: lib.hasPrefix dependencyPrefix f) features;
        in
        builtins.map (lib.removePrefix dependencyPrefix) dependencyFeatures;
    in
    defaultOrNil ++ explicitFeatures ++ additionalDependencyFeatures;

  /* Sorts and removes duplicates from a list of strings. */
  sortedUnique = features:
    assert (builtins.isList features);
    assert (builtins.all builtins.isString features);
    let
      outFeaturesSet = lib.foldl (set: feature: set // { "${feature}" = 1; }) { } features;
      outFeaturesUnique = builtins.attrNames outFeaturesSet;
    in
    builtins.sort (a: b: a < b) outFeaturesUnique;

  deprecationWarning = message: value:
    if strictDeprecation
    then builtins.throw "strictDeprecation enabled, aborting: ${message}"
    else builtins.trace message value;

  #
  # crate2nix/default.nix (excerpt end)
  #

  };
}
