mod equation;

pub use equation::{TwoFactor, SimpleTwoFactor, Equation, basic};


pub fn generate_two_factor(amount: usize, config: &Config) -> Vec<TwoFactor> {
	let mut equation_list = Vec::new();

	for _n in 0..amount {
		let equation = TwoFactor::new(&config.random_buffer());

		equation_list.push(equation);
	}

	equation_list
}




pub enum DifficultyMode {
	Easy,
	Normal,
	Hard,
	Lunatic,
}

pub struct Config {
	difficulty: DifficultyMode,
	random_buffer: [i32; 100],
}

impl Config {
	pub fn new(difficulty: DifficultyMode) -> Config {
		let range = number::set_range(&difficulty);
		
		Config {
			difficulty,
			random_buffer: number::generate_buffer(range),
		}
	}
	
	pub fn random_buffer(&self) -> &[i32; 100] {
		&self.random_buffer
	}
	
	pub fn difficulty(&self) -> &DifficultyMode {
		&self.difficulty
	}
}

mod number {
	use super::DifficultyMode;
	use random_number as rn;

	pub fn change_float_part(x: f64, decimal_count: usize) -> f64 {
		let power = match decimal_count {
			0 => 1.0,
			1 => 10.0,
			2 => 100.0,
			3 => 1000.0,
			4 => 10000.0,
			5 => 100000.0,
			_ => 100000.0,
		};

	
		let expanded = x * power; //145.7484
		let rounded = expanded.floor();
		let x_truncated = rounded / 100.0;

		x_truncated
	}

	pub fn generate_buffer(range_max_inclusive: i32) -> [i32; 100] {
		let mut random_buffer = [0; 100];
		rn::random_fill_ranged(&mut random_buffer, 0..=range_max_inclusive);
	
		random_buffer
	}
	
	
	pub fn set_range(difficulty: &DifficultyMode) -> i32 {
		match difficulty {
			DifficultyMode::Easy => 10,
			DifficultyMode::Normal => 25,
			DifficultyMode::Hard => 50,
			DifficultyMode::Lunatic => 100,
		}
	}
}
