use std::ops::Range;
use serde::{Serialize, Deserialize};

#[derive(Serialize, Deserialize)]
pub struct TwoFactor {
	pub a: usize, 
	pub b: usize,
}

impl TwoFactor {
	pub fn new(factor: (usize, usize)) -> TwoFactor {
		TwoFactor {
			a: factor.0,
			b: factor.1,
		}
	}
}



pub struct ThreeFactor<T> {
	pub a: T,
	pub b: T,
	pub c: T,
}


pub fn generate_two_factor(amount: usize, range: Range<usize>) -> Vec<TwoFactor> {
	let mut equation_list = Vec::new();
	
	for _n in 0..amount {
		
		let a = random_number::random_ranged(range.clone());
		let b = random_number::random_ranged(range.clone());

		let twofactor = TwoFactor::new((a, b));
		
		equation_list.push(twofactor);
	}

	equation_list
}