use crate as cm;
use cm::number;

pub mod basic;

enum Operation {
	Addition,
	Soustraction,
	Multiplication,
	Division,
}


pub trait Equation {
	fn make_addition(&mut self) -> f64;
	fn make_soustraction(&mut self) -> f64;
	fn make_multiplication(&mut self) -> f64;
	fn make_division(&mut self) -> f64;
	fn print(&self) -> Result<String, &str>;
	fn result(&self) -> Option<f64>;
}

//2 factors equation base
pub struct TwoFactor {
	pub x: f64,
	pub y: f64,
	result: Option<f64>,
	operation: Option<Operation>,
}

impl TwoFactor {
	pub fn new(random_buffer: &[i32; 100]) -> TwoFactor {
		let x_random_index = random_number::random_ranged(0..random_buffer.len());
		let y_random_index = random_number::random_ranged(0..random_buffer.len());

		TwoFactor {
			x: f64::from(*random_buffer.get(x_random_index).unwrap()),
			y: f64::from(*random_buffer.get(y_random_index).unwrap()),
			result: None,
			operation: None,
		}
	}

	//todo
	// fn add_factor(self, random_buffer: &mut [i32; 100]) -> ThreeFactor {
	// 	ThreeFactor {
	// 		x: self.x,
	// 		y: self.y,
	// 		z: f64::from(*random_buffer.get(cm::number::r_index()).unwrap()),
	// 		result: 0.0,
	// 	}
	// }
}

impl Equation for TwoFactor {

	fn make_addition(&mut self) -> f64 {
		let result = self.x + self.y;
		self.operation = Some(Operation::Addition);
		self.result = Some(result);

		result
	}

	fn make_soustraction(&mut self) -> f64 {
		let result = self.x - self.y;
		self.operation = Some(Operation::Soustraction);
		self.result = Some(result);

		result
	}

	fn make_multiplication(&mut self) -> f64 {
		let result = self.x * self.y;
		self.operation = Some(Operation::Multiplication);
		self.result = Some(result);

		result
	}

	fn make_division(&mut self) -> f64 {
		let result = number::change_float_part(self.x / self.y, 3);
		self.operation = Some(Operation::Division);
		self.result = Some(result);

		result
	}

	fn print(&self) -> Result<String, &str> {
		let operation = match &self.operation {
			Some(operation) => match operation {
				Operation::Addition => "+",
				Operation::Soustraction => "-",
				Operation::Multiplication => "*",
				Operation::Division => "/",
			}
			None => return Err("There is no operation on this equation"),
		};

		let expression = format!("{} {} {}", self.x, operation, self.y);

		Ok(expression)
	}

	fn result(&self) -> Option<f64> {
		self.result
	}
}


pub struct SimpleTwoFactor {
	pub x: f64,
	pub y: f64,
}

impl SimpleTwoFactor {
	pub fn new(x: f64, y: f64) -> SimpleTwoFactor {
		SimpleTwoFactor {
			x,
			y,
		}
	}
}


//todo 
pub struct _ThreeFactor { }



