[![Test](https://github.com/wtetsu/epo/actions/workflows/test.yml/badge.svg)](https://github.com/wtetsu/epo/actions/workflows/test.yml) [![codecov](https://codecov.io/gh/wtetsu/epo/branch/master/graph/badge.svg?token=26lMbyfI60)](https://codecov.io/gh/wtetsu/epo)

# epo

Handy epoch converter.

## Epoch -> Human readable time

```bash
$ epo 0

| Epoch |                    +0900 |
| ----- | ------------------------ |
|     0 | 1970-01-01T09:00:00+0900 |
```

```bash
$ epo 0 +9 +1 -5

| Epoch |                    +0900 |                    +0100 |                    -0500 |
| ----- | ------------------------ | ------------------------ | ------------------------
|     0 | 1970-01-01T09:00:00+0900 | 1970-01-01T01:00:00+0100 | 1969-12-31T19:00:00-0500 |
```

```bash
$ epo 0 tokyo london new_york

| Epoch |               Asia/Tokyo |            Europe/London |         America/New_York |
| ----- | ------------------------ | ------------------------ | ------------------------
|     0 | 1970-01-01T09:00:00+0900 | 1970-01-01T01:00:00+0100 | 1969-12-31T19:00:00-0500 |
```

You can write JavaScript code.

```bash
$ epo 1651313524 1651313524+86400 1651313524-86400 london

|      Epoch |            Europe/London |
| ---------- | ------------------------
| 1651313524 | 2022-04-30T11:12:04+0100 |
| 1651399924 | 2022-05-01T11:12:04+0100 |
| 1651227124 | 2022-04-29T11:12:04+0100 |
```

```bash
$ epo "[now, now+86400, now+86400*2]" Monaco London Tokyo

|      Epoch |            Europe/Monaco |            Europe/London |               Asia/Tokyo |
| ---------- | ------------------------ | ------------------------ | ------------------------
| 1651313675 | 2022-04-30T12:14:35+0200 | 2022-04-30T11:14:35+0100 | 2022-04-30T19:14:35+0900 |
| 1651400075 | 2022-05-01T12:14:35+0200 | 2022-05-01T11:14:35+0100 | 2022-05-01T19:14:35+0900 |
| 1651486475 | 2022-05-02T12:14:35+0200 | 2022-05-02T11:14:35+0100 | 2022-05-02T19:14:35+0900 |
```

```bash
$ epo "[...Array(100).keys()].map(a=>now+86400*a)" Monaco London Tokyo
|      Epoch |            Europe/Monaco |            Europe/London |               Asia/Tokyo |
| ---------- | ------------------------ | ------------------------ | ------------------------
| 1651313711 | 2022-04-30T12:15:11+0200 | 2022-04-30T11:15:11+0100 | 2022-04-30T19:15:11+0900 |
| 1651400111 | 2022-05-01T12:15:11+0200 | 2022-05-01T11:15:11+0100 | 2022-05-01T19:15:11+0900 |
...
| 1659780911 | 2022-08-06T12:15:11+0200 | 2022-08-06T11:15:11+0100 | 2022-08-06T19:15:11+0900 |
| 1659867311 | 2022-08-07T12:15:11+0200 | 2022-08-07T11:15:11+0100 | 2022-08-07T19:15:11+0900 |
```


## Date -> Epoch

```bash
$ epo 2022-03-01T00:00:00

|                Date |      +0900 |
| ------------------- | ----------
| 2022-03-01T00:00:00 | 1646060400 |
```


```bash
$ epo 2022-01-01T00:00:00 2022-02-01T00:00:00 2022-03-01T00:00:00 2022-04-01T00:00:00 -10 -5 +5 +10

|                Date |      -1000 |      -0500 |      +0500 |      +1000 |
| ------------------- | ---------- | ---------- | ---------- | ----------
| 2022-01-01T00:00:00 | 1641031200 | 1641013200 | 1640977200 | 1640959200 |
| 2022-02-01T00:00:00 | 1643709600 | 1643691600 | 1643655600 | 1643637600 |
| 2022-03-01T00:00:00 | 1646128800 | 1646110800 | 1646074800 | 1646056800 |
| 2022-04-01T00:00:00 | 1648807200 | 1648789200 | 1648753200 | 1648735200 |
```
