use epimetheus::*;
use std::thread;
use std::time::*;

fn main() {
    std::env::set_var("RUST_LOG", "info");
    env_logger::init();
    epimetheus::spawn_http_server();
    thread::spawn(|| send_metrics_test());
    thread::spawn(|| send_metrics_test());
    thread::spawn(|| send_metrics_test());
    thread::spawn(|| bench_metrics());
    thread::spawn(|| bench_metrics_labeled());
    thread::spawn(|| bench_metrics_once());
    thread::spawn(|| bench_metrics_once_labelled());
    thread::sleep(Duration::from_secs(99999));
}

fn send_metrics_test() {
    loop {
        metric!(foobar).add(2.5);
        thread::sleep(Duration::from_secs(1));
    }
}

fn bench_metrics_labeled() {
    loop {
        let t1 = Instant::now();
        for _ in 0..1000 {
            let result = "failed";
            metric!(barqux{user=1, result=result}).add(2.5);
        }
        let d = t1.elapsed();
        metric!(bench_plain_seconds_sum).add(d.as_secs_f64());
        metric!(bench_plain_seconds_count).add(1000.0);
        println!("label:           {:?}", d);
        thread::sleep(Duration::from_millis(1001));
    }
}
fn bench_metrics() {
    loop {
        let t1 = Instant::now();
        for _ in 0..1000 {
            metric!(barqux).add(2.5);
        }
        let d = t1.elapsed();
        metric!(bench_labelled_seconds_sum).add(d.as_secs_f64());
        metric!(bench_labelled_seconds_count).add(1000.0);
        println!("plain: {:?}", d);
        thread::sleep(Duration::from_secs(1));
    }
}
fn bench_metrics_once() {
    loop {
        metric!(barqux).add(2.5);
        let t1 = Instant::now();
        metric!(barqux).add(2.5);
        let d = t1.elapsed();
        println!("once:                               {:?}", d);
        thread::sleep(Duration::from_millis(999));
    }
}
fn bench_metrics_once_labelled() {
    loop {
        metric!(barqux{foo=1}).add(2.5);
        let t1 = Instant::now();
        metric!(barqux{foo=1}).add(2.5);
        let d = t1.elapsed();
        println!("once:                                            {:?}", d);
        thread::sleep(Duration::from_millis(998));
    }
}
