/**
 * Part of Epicinium
 * developed by A Bunch of Hacks.
 *
 * Copyright (c) 2017-2020 A Bunch of Hacks
 *
 * Epicinium is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Epicinium is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * [authors:]
 * Sander in 't Veld (sander@abunchofhacks.coop)
 * Daan Mulder (daan@abunchofhacks.coop)
 */
#include "initiativesequencer.hpp"
#include "source.hpp"


InitiativeSequencer::InitiativeSequencer(uint8_t number_of_players) :
	_num(number_of_players)
{
	DEBUG_ASSERT(number_of_players <= ((size_t) MAX_NUM));
}

uint8_t PERM_SEQ_2[8][2] = {
	{0, 1},
	{1, 0},
	{1, 0},
	{0, 1},
	{1, 0},
	{0, 1},
	{0, 1},
	{1, 0},
};

uint8_t PERM_SEQ_3[12][3] = {
	{0, 1, 2},
	{2, 0, 1},
	{1, 2, 0},
	{2, 1, 0},
	{1, 0, 2},
	{0, 2, 1},
	{1, 2, 0},
	{2, 0, 1},
	{0, 1, 2},
	{0, 2, 1},
	{1, 0, 2},
	{2, 1, 0},
};

uint8_t PERM_SEQ_4[840][4] = {
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{3, 0, 2, 1},
	{1, 2, 0, 3},
	{2, 1, 3, 0},
	{0, 3, 1, 2},
	{0, 1, 3, 2},
	{2, 3, 1, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{2, 1, 3, 0},
	{0, 3, 1, 2},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{3, 0, 2, 1},
	{1, 2, 0, 3},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{1, 3, 0, 2},
	{2, 0, 3, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{0, 2, 1, 3},
	{3, 1, 2, 0},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{2, 0, 1, 3},
	{3, 1, 0, 2},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{1, 3, 2, 0},
	{0, 2, 3, 1},
	{0, 2, 1, 3},
	{3, 1, 2, 0},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{1, 3, 0, 2},
	{2, 0, 3, 1},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{3, 0, 2, 1},
	{1, 2, 0, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 1, 3, 0},
	{0, 3, 1, 2},
	{3, 0, 2, 1},
	{1, 2, 0, 3},
	{0, 1, 3, 2},
	{2, 3, 1, 0},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 1, 3, 0},
	{0, 3, 1, 2},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{2, 0, 1, 3},
	{3, 1, 0, 2},
	{1, 3, 0, 2},
	{2, 0, 3, 1},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{1, 3, 2, 0},
	{0, 2, 3, 1},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{0, 2, 1, 3},
	{3, 1, 2, 0},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{1, 3, 2, 0},
	{0, 2, 3, 1},
	{0, 1, 3, 2},
	{2, 3, 1, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{3, 0, 2, 1},
	{1, 2, 0, 3},
	{2, 1, 3, 0},
	{0, 3, 1, 2},
	{2, 0, 1, 3},
	{3, 1, 0, 2},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{1, 3, 2, 0},
	{0, 2, 3, 1},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{3, 0, 2, 1},
	{1, 2, 0, 3},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 3, 0, 2},
	{2, 0, 3, 1},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 2, 1, 3},
	{3, 1, 2, 0},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{1, 3, 0, 2},
	{2, 0, 3, 1},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{2, 0, 1, 3},
	{3, 1, 0, 2},
	{3, 2, 0, 1},
	{1, 0, 2, 3},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 3, 2, 0},
	{0, 2, 3, 1},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{3, 0, 2, 1},
	{1, 2, 0, 3},
	{0, 1, 3, 2},
	{2, 3, 1, 0},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{1, 3, 2, 0},
	{0, 2, 3, 1},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 1, 3, 0},
	{0, 3, 1, 2},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{3, 2, 0, 1},
	{1, 0, 2, 3},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{2, 1, 3, 0},
	{0, 3, 1, 2},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{3, 0, 2, 1},
	{1, 2, 0, 3},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{1, 3, 0, 2},
	{2, 0, 3, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{0, 2, 1, 3},
	{3, 1, 2, 0},
	{1, 3, 0, 2},
	{2, 0, 3, 1},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{0, 2, 1, 3},
	{3, 1, 2, 0},
	{1, 3, 2, 0},
	{0, 2, 3, 1},
	{2, 0, 1, 3},
	{3, 1, 0, 2},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{3, 0, 2, 1},
	{1, 2, 0, 3},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{1, 3, 0, 2},
	{2, 0, 3, 1},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{2, 0, 1, 3},
	{3, 1, 0, 2},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{0, 2, 1, 3},
	{3, 1, 2, 0},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{3, 0, 2, 1},
	{1, 2, 0, 3},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{3, 2, 0, 1},
	{1, 0, 2, 3},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{1, 3, 2, 0},
	{0, 2, 3, 1},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{1, 3, 0, 2},
	{2, 0, 3, 1},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{2, 0, 1, 3},
	{3, 1, 0, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{1, 3, 0, 2},
	{2, 0, 3, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{0, 2, 1, 3},
	{3, 1, 2, 0},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{2, 0, 1, 3},
	{3, 1, 0, 2},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{1, 3, 0, 2},
	{2, 0, 3, 1},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 1, 3, 2},
	{2, 3, 1, 0},
	{2, 1, 3, 0},
	{0, 3, 1, 2},
	{3, 0, 2, 1},
	{1, 2, 0, 3},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{1, 3, 2, 0},
	{0, 2, 3, 1},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{2, 0, 1, 3},
	{3, 1, 0, 2},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{3, 2, 0, 1},
	{1, 0, 2, 3},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{0, 1, 3, 2},
	{2, 3, 1, 0},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{1, 0, 3, 2},
	{2, 3, 0, 1},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
	{3, 2, 1, 0},
	{0, 1, 2, 3},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{3, 0, 1, 2},
	{2, 1, 0, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{1, 2, 3, 0},
	{0, 3, 2, 1},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 2, 3, 1},
	{1, 3, 2, 0},
	{2, 1, 0, 3},
	{3, 0, 1, 2},
	{3, 1, 0, 2},
	{2, 0, 1, 3},
	{0, 3, 2, 1},
	{1, 2, 3, 0},
	{1, 2, 0, 3},
	{3, 0, 2, 1},
	{2, 3, 1, 0},
	{0, 1, 3, 2},
	{0, 3, 1, 2},
	{2, 1, 3, 0},
	{1, 0, 2, 3},
	{3, 2, 0, 1},
	{2, 3, 0, 1},
	{1, 0, 3, 2},
	{3, 1, 2, 0},
	{0, 2, 1, 3},
	{0, 1, 2, 3},
	{3, 2, 1, 0},
	{2, 0, 3, 1},
	{1, 3, 0, 2},
};

uint8_t PERM_SEQ_5[840][5] = {
	{0, 1, 2, 3, 4},
	{4, 3, 1, 2, 0},
	{2, 4, 3, 0, 1},
	{3, 0, 4, 1, 2},
	{1, 2, 0, 4, 3},
	{1, 3, 4, 0, 2},
	{2, 4, 0, 3, 1},
	{0, 2, 1, 4, 3},
	{3, 0, 2, 1, 4},
	{4, 1, 3, 2, 0},
	{4, 2, 1, 0, 3},
	{3, 1, 0, 2, 4},
	{0, 3, 2, 4, 1},
	{2, 4, 3, 1, 0},
	{1, 0, 4, 3, 2},
	{4, 2, 0, 1, 3},
	{3, 1, 2, 0, 4},
	{1, 0, 3, 4, 2},
	{0, 3, 4, 2, 1},
	{2, 4, 1, 3, 0},
	{3, 1, 4, 0, 2},
	{2, 0, 1, 4, 3},
	{4, 2, 0, 3, 1},
	{1, 4, 3, 2, 0},
	{0, 3, 2, 1, 4},
	{3, 4, 0, 1, 2},
	{2, 1, 4, 0, 3},
	{0, 2, 1, 3, 4},
	{1, 3, 2, 4, 0},
	{4, 0, 3, 2, 1},
	{2, 3, 0, 4, 1},
	{1, 4, 3, 0, 2},
	{0, 1, 4, 2, 3},
	{4, 2, 1, 3, 0},
	{3, 0, 1, 2, 4},
	{3, 4, 2, 1, 0},
	{0, 2, 4, 1, 3},
	{1, 0, 2, 3, 4},
	{4, 1, 3, 0, 2},
	{2, 0, 3, 4, 1},
	{2, 3, 0, 1, 4},
	{4, 3, 1, 0, 2},
	{0, 1, 2, 4, 3},
	{3, 4, 0, 2, 1},
	{1, 2, 4, 3, 0},
	{2, 3, 1, 0, 4},
	{4, 0, 3, 1, 2},
	{1, 4, 0, 2, 3},
	{0, 2, 4, 3, 1},
	{3, 1, 2, 4, 0},
	{2, 0, 1, 3, 4},
	{4, 3, 0, 1, 2},
	{3, 1, 4, 2, 0},
	{0, 2, 3, 4, 1},
	{1, 4, 2, 0, 3},
	{2, 1, 0, 3, 4},
	{0, 3, 4, 1, 2},
	{3, 4, 1, 2, 0},
	{4, 2, 3, 0, 1},
	{1, 0, 2, 4, 3},
	{3, 4, 2, 0, 1},
	{1, 0, 4, 2, 3},
	{2, 1, 3, 4, 0},
	{0, 4, 1, 3, 2},
	{3, 2, 0, 1, 4},
	{4, 3, 2, 1, 0},
	{0, 1, 3, 2, 4},
	{1, 2, 4, 0, 3},
	{4, 0, 1, 3, 2},
	{2, 3, 4, 0, 1},
	{2, 1, 0, 4, 3},
	{3, 0, 1, 4, 2},
	{0, 4, 2, 3, 1},
	{4, 2, 3, 1, 0},
	{1, 3, 0, 2, 4},
	{4, 1, 2, 0, 3},
	{3, 0, 4, 2, 1},
	{1, 2, 0, 3, 4},
	{0, 3, 1, 4, 2},
	{2, 3, 4, 1, 0},
	{0, 4, 3, 2, 1},
	{1, 2, 3, 4, 0},
	{2, 4, 1, 0, 3},
	{4, 1, 0, 3, 2},
	{3, 0, 2, 4, 1},
	{2, 0, 3, 1, 4},
	{1, 4, 0, 3, 2},
	{3, 2, 1, 0, 4},
	{4, 1, 0, 2, 3},
	{3, 2, 4, 1, 0},
	{0, 4, 2, 1, 3},
	{1, 3, 2, 0, 4},
	{0, 1, 4, 3, 2},
	{2, 3, 1, 4, 0},
	{4, 3, 0, 2, 1},
	{1, 0, 3, 2, 4},
	{4, 0, 2, 3, 1},
	{3, 4, 1, 0, 2},
	{2, 0, 4, 1, 3},
	{0, 1, 3, 4, 2},
	{3, 2, 1, 4, 0},
	{2, 4, 0, 1, 3},
	{4, 1, 2, 3, 0},
	{1, 2, 3, 0, 4},
	{0, 3, 1, 2, 4},
	{2, 0, 4, 3, 1},
	{4, 3, 2, 0, 1},
	{3, 1, 0, 4, 2},
	{0, 4, 1, 2, 3},
	{1, 3, 4, 2, 0},
	{0, 2, 3, 1, 4},
	{2, 1, 4, 3, 0},
	{4, 0, 2, 1, 3},
	{3, 2, 0, 4, 1},
	{0, 4, 3, 1, 2},
	{1, 4, 2, 3, 0},
	{2, 1, 3, 0, 4},
	{1, 3, 0, 4, 2},
	{4, 0, 1, 2, 3},
	{3, 2, 4, 0, 1},
	{4, 2, 1, 3, 0},
	{0, 3, 2, 1, 4},
	{1, 4, 3, 0, 2},
	{2, 0, 3, 4, 1},
	{4, 1, 0, 2, 3},
	{3, 1, 4, 2, 0},
	{0, 2, 1, 3, 4},
	{3, 4, 2, 0, 1},
	{2, 0, 4, 1, 3},
	{1, 3, 0, 4, 2},
	{4, 3, 1, 2, 0},
	{0, 1, 2, 3, 4},
	{2, 4, 3, 0, 1},
	{1, 2, 0, 4, 3},
	{3, 0, 4, 1, 2},
	{3, 2, 1, 4, 0},
	{0, 4, 2, 1, 3},
	{4, 1, 0, 3, 2},
	{2, 3, 4, 0, 1},
	{1, 0, 3, 2, 4},
	{3, 1, 4, 0, 2},
	{2, 0, 1, 4, 3},
	{4, 3, 0, 2, 1},
	{1, 4, 2, 3, 0},
	{0, 2, 3, 1, 4},
	{3, 1, 2, 0, 4},
	{4, 0, 1, 2, 3},
	{0, 2, 4, 3, 1},
	{2, 4, 3, 1, 0},
	{1, 0, 3, 4, 2},
	{1, 3, 0, 2, 4},
	{4, 3, 2, 0, 1},
	{2, 4, 0, 1, 3},
	{0, 1, 4, 3, 2},
	{3, 1, 2, 4, 0},
	{4, 2, 1, 0, 3},
	{3, 2, 0, 1, 4},
	{0, 3, 4, 2, 1},
	{2, 4, 1, 3, 0},
	{1, 0, 4, 3, 2},
	{1, 2, 3, 4, 0},
	{0, 3, 2, 4, 1},
	{3, 4, 1, 0, 2},
	{2, 0, 3, 1, 4},
	{1, 4, 0, 2, 3},
	{4, 1, 2, 3, 0},
	{0, 2, 3, 4, 1},
	{3, 0, 1, 2, 4},
	{4, 3, 0, 1, 2},
	{2, 1, 4, 0, 3},
	{0, 3, 1, 4, 2},
	{2, 1, 4, 3, 0},
	{4, 2, 3, 0, 1},
	{3, 0, 2, 1, 4},
	{1, 0, 4, 2, 3},
	{1, 4, 0, 3, 2},
	{2, 3, 0, 4, 1},
	{4, 1, 3, 2, 0},
	{3, 2, 1, 0, 4},
	{0, 4, 1, 2, 3},
	{4, 0, 2, 1, 3},
	{3, 2, 4, 1, 0},
	{2, 1, 0, 3, 4},
	{0, 4, 3, 1, 2},
	{1, 3, 2, 0, 4},
	{3, 2, 0, 4, 1},
	{4, 1, 2, 0, 3},
	{0, 4, 1, 3, 2},
	{1, 3, 4, 2, 0},
	{2, 0, 4, 3, 1},
	{2, 1, 3, 4, 0},
	{3, 0, 1, 4, 2},
	{0, 4, 3, 2, 1},
	{4, 2, 0, 1, 3},
	{1, 3, 2, 4, 0},
	{2, 3, 1, 0, 4},
	{4, 0, 3, 1, 2},
	{1, 2, 0, 3, 4},
	{0, 1, 4, 2, 3},
	{3, 4, 0, 2, 1},
	{1, 4, 2, 0, 3},
	{3, 0, 2, 4, 1},
	{2, 3, 4, 1, 0},
	{4, 1, 3, 0, 2},
	{0, 2, 1, 4, 3},
	{1, 0, 2, 3, 4},
	{3, 2, 4, 0, 1},
	{0, 3, 1, 2, 4},
	{4, 2, 3, 1, 0},
	{2, 4, 0, 3, 1},
	{3, 1, 0, 4, 2},
	{1, 4, 3, 2, 0},
	{4, 0, 1, 3, 2},
	{2, 3, 0, 1, 4},
	{0, 1, 2, 4, 3},
	{1, 3, 4, 0, 2},
	{4, 0, 2, 3, 1},
	{2, 1, 3, 0, 4},
	{0, 2, 4, 1, 3},
	{3, 4, 1, 2, 0},
	{4, 0, 3, 2, 1},
	{1, 2, 3, 0, 4},
	{0, 3, 4, 1, 2},
	{2, 1, 0, 4, 3},
	{3, 4, 2, 1, 0},
	{2, 0, 1, 3, 4},
	{4, 3, 1, 0, 2},
	{1, 2, 4, 3, 0},
	{0, 4, 2, 3, 1},
	{3, 1, 0, 2, 4},
	{1, 0, 2, 4, 3},
	{4, 3, 2, 1, 0},
	{0, 1, 3, 4, 2},
	{2, 4, 1, 0, 3},
	{3, 0, 4, 2, 1},
	{4, 2, 0, 3, 1},
	{1, 2, 4, 0, 3},
	{3, 4, 0, 1, 2},
	{2, 3, 1, 4, 0},
	{0, 1, 3, 2, 4},
	{3, 1, 0, 2, 4},
	{4, 0, 2, 1, 3},
	{2, 4, 3, 0, 1},
	{0, 3, 1, 4, 2},
	{1, 2, 4, 3, 0},
	{2, 1, 0, 3, 4},
	{4, 3, 1, 0, 2},
	{0, 4, 3, 2, 1},
	{3, 2, 4, 1, 0},
	{1, 0, 2, 4, 3},
	{4, 2, 0, 1, 3},
	{3, 1, 2, 0, 4},
	{1, 0, 3, 4, 2},
	{2, 4, 1, 3, 0},
	{0, 3, 4, 2, 1},
	{1, 3, 4, 2, 0},
	{0, 4, 2, 3, 1},
	{2, 1, 3, 0, 4},
	{3, 0, 1, 4, 2},
	{2, 4, 0, 1, 3},
	{4, 2, 0, 3, 1},
	{1, 3, 4, 0, 2},
	{0, 1, 3, 2, 4},
	{3, 2, 1, 4, 0},
	{4, 0, 1, 2, 3},
	{0, 4, 2, 1, 3},
	{3, 1, 2, 4, 0},
	{2, 0, 4, 3, 1},
	{4, 3, 0, 1, 2},
	{1, 2, 3, 0, 4},
	{2, 0, 3, 4, 1},
	{1, 4, 0, 3, 2},
	{4, 3, 1, 2, 0},
	{0, 2, 4, 1, 3},
	{3, 2, 1, 0, 4},
	{0, 1, 2, 3, 4},
	{4, 1, 3, 2, 0},
	{3, 4, 2, 0, 1},
	{1, 3, 0, 4, 2},
	{2, 0, 4, 1, 3},
	{3, 1, 4, 0, 2},
	{2, 0, 1, 4, 3},
	{4, 3, 0, 2, 1},
	{0, 2, 3, 1, 4},
	{1, 4, 2, 3, 0},
	{1, 0, 2, 3, 4},
	{4, 2, 3, 0, 1},
	{3, 4, 1, 2, 0},
	{2, 1, 0, 4, 3},
	{0, 3, 4, 1, 2},
	{0, 2, 3, 4, 1},
	{1, 4, 3, 2, 0},
	{4, 1, 0, 3, 2},
	{2, 3, 1, 0, 4},
	{3, 0, 2, 1, 4},
	{1, 2, 4, 0, 3},
	{4, 0, 2, 3, 1},
	{3, 4, 0, 1, 2},
	{0, 1, 4, 2, 3},
	{2, 3, 1, 4, 0},
	{3, 2, 4, 0, 1},
	{1, 4, 0, 2, 3},
	{2, 0, 1, 3, 4},
	{0, 1, 3, 4, 2},
	{4, 3, 2, 1, 0},
	{4, 1, 3, 0, 2},
	{2, 3, 0, 1, 4},
	{0, 2, 4, 3, 1},
	{1, 3, 2, 4, 0},
	{0, 4, 1, 2, 3},
	{3, 0, 2, 4, 1},
	{4, 2, 1, 3, 0},
	{1, 0, 3, 2, 4},
	{2, 1, 4, 0, 3},
	{3, 4, 1, 0, 2},
	{3, 2, 0, 1, 4},
	{4, 1, 0, 2, 3},
	{0, 4, 3, 1, 2},
	{2, 1, 4, 3, 0},
	{0, 3, 2, 4, 1},
	{1, 0, 4, 3, 2},
	{2, 4, 3, 1, 0},
	{3, 2, 0, 4, 1},
	{1, 3, 2, 0, 4},
	{4, 0, 1, 3, 2},
	{1, 0, 4, 2, 3},
	{2, 3, 0, 4, 1},
	{4, 1, 2, 0, 3},
	{3, 4, 2, 1, 0},
	{0, 3, 1, 2, 4},
	{4, 2, 3, 1, 0},
	{0, 2, 1, 3, 4},
	{1, 4, 3, 0, 2},
	{3, 0, 4, 2, 1},
	{1, 2, 0, 4, 3},
	{2, 1, 3, 4, 0},
	{2, 4, 0, 3, 1},
	{3, 0, 4, 1, 2},
	{0, 1, 2, 4, 3},
	{4, 3, 2, 0, 1},
	{3, 0, 1, 2, 4},
	{1, 4, 2, 0, 3},
	{0, 1, 4, 3, 2},
	{2, 3, 4, 1, 0},
	{4, 2, 1, 0, 3},
	{1, 3, 0, 2, 4},
	{4, 0, 3, 2, 1},
	{2, 0, 3, 1, 4},
	{3, 1, 0, 4, 2},
	{0, 4, 1, 3, 2},
	{1, 2, 3, 4, 0},
	{2, 3, 4, 0, 1},
	{4, 1, 2, 3, 0},
	{0, 2, 1, 4, 3},
	{3, 4, 0, 2, 1},
	{0, 3, 2, 1, 4},
	{2, 4, 1, 0, 3},
	{3, 1, 4, 2, 0},
	{1, 2, 0, 3, 4},
	{4, 0, 3, 1, 2},
	{1, 4, 3, 2, 0},
	{0, 2, 4, 3, 1},
	{3, 0, 2, 1, 4},
	{4, 1, 2, 0, 3},
	{2, 3, 0, 4, 1},
	{0, 3, 1, 4, 2},
	{1, 2, 4, 3, 0},
	{4, 1, 3, 0, 2},
	{2, 4, 0, 1, 3},
	{3, 0, 1, 2, 4},
	{1, 0, 3, 4, 2},
	{2, 3, 4, 0, 1},
	{4, 1, 0, 2, 3},
	{3, 4, 2, 1, 0},
	{0, 2, 1, 3, 4},
	{3, 2, 1, 0, 4},
	{4, 0, 2, 1, 3},
	{0, 1, 4, 3, 2},
	{2, 3, 1, 4, 0},
	{0, 4, 3, 2, 1},
	{1, 2, 0, 4, 3},
	{3, 1, 4, 2, 0},
	{4, 3, 0, 1, 2},
	{1, 0, 2, 3, 4},
	{2, 4, 3, 0, 1},
	{4, 2, 1, 0, 3},
	{3, 1, 0, 2, 4},
	{2, 0, 3, 4, 1},
	{1, 4, 2, 3, 0},
	{0, 3, 4, 1, 2},
	{1, 3, 4, 0, 2},
	{2, 4, 0, 3, 1},
	{0, 1, 3, 2, 4},
	{3, 2, 1, 4, 0},
	{0, 4, 2, 1, 3},
	{4, 0, 3, 2, 1},
	{1, 3, 2, 4, 0},
	{4, 2, 0, 1, 3},
	{3, 1, 4, 0, 2},
	{2, 0, 1, 3, 4},
	{2, 4, 3, 1, 0},
	{1, 0, 4, 3, 2},
	{0, 3, 2, 4, 1},
	{3, 1, 2, 0, 4},
	{4, 0, 1, 2, 3},
	{4, 2, 0, 3, 1},
	{1, 2, 3, 0, 4},
	{3, 1, 0, 4, 2},
	{2, 3, 4, 1, 0},
	{0, 4, 1, 2, 3},
	{2, 1, 0, 4, 3},
	{3, 0, 4, 1, 2},
	{4, 2, 1, 3, 0},
	{1, 3, 2, 0, 4},
	{0, 4, 2, 3, 1},
	{4, 1, 3, 2, 0},
	{0, 3, 1, 2, 4},
	{3, 2, 4, 0, 1},
	{1, 0, 2, 4, 3},
	{3, 4, 0, 1, 2},
	{2, 1, 3, 4, 0},
	{0, 2, 4, 1, 3},
	{4, 3, 0, 2, 1},
	{1, 4, 3, 0, 2},
	{2, 0, 1, 4, 3},
	{2, 1, 0, 3, 4},
	{3, 4, 1, 0, 2},
	{0, 3, 4, 2, 1},
	{4, 2, 3, 1, 0},
	{0, 1, 2, 3, 4},
	{1, 0, 4, 2, 3},
	{3, 2, 0, 1, 4},
	{4, 3, 2, 0, 1},
	{2, 4, 1, 3, 0},
	{0, 1, 3, 4, 2},
	{1, 0, 3, 2, 4},
	{4, 3, 2, 1, 0},
	{1, 2, 4, 0, 3},
	{3, 0, 1, 4, 2},
	{2, 0, 4, 3, 1},
	{3, 4, 0, 2, 1},
	{1, 4, 2, 0, 3},
	{0, 2, 3, 1, 4},
	{4, 1, 0, 3, 2},
	{2, 3, 1, 0, 4},
	{1, 2, 3, 4, 0},
	{4, 0, 2, 3, 1},
	{3, 4, 1, 2, 0},
	{0, 1, 2, 4, 3},
	{2, 3, 0, 1, 4},
	{4, 0, 1, 3, 2},
	{3, 2, 4, 1, 0},
	{0, 1, 4, 2, 3},
	{1, 3, 0, 4, 2},
	{4, 2, 3, 0, 1},
	{2, 4, 1, 0, 3},
	{3, 0, 2, 4, 1},
	{1, 3, 0, 2, 4},
	{0, 4, 3, 1, 2},
	{2, 1, 4, 3, 0},
	{2, 0, 4, 1, 3},
	{3, 1, 2, 4, 0},
	{0, 4, 1, 3, 2},
	{1, 2, 0, 3, 4},
	{4, 3, 1, 2, 0},
	{3, 4, 2, 0, 1},
	{0, 2, 3, 4, 1},
	{2, 1, 4, 0, 3},
	{4, 0, 3, 1, 2},
	{1, 3, 4, 2, 0},
	{0, 3, 2, 1, 4},
	{1, 4, 0, 2, 3},
	{3, 2, 0, 4, 1},
	{2, 1, 3, 0, 4},
	{4, 3, 1, 0, 2},
	{0, 2, 1, 4, 3},
	{1, 4, 0, 3, 2},
	{3, 0, 4, 2, 1},
	{4, 1, 2, 3, 0},
	{2, 0, 3, 1, 4},
	{0, 4, 1, 3, 2},
	{2, 3, 4, 1, 0},
	{1, 0, 3, 2, 4},
	{4, 2, 3, 0, 1},
	{2, 1, 0, 4, 3},
	{3, 0, 2, 1, 4},
	{4, 3, 1, 0, 2},
	{1, 4, 0, 2, 3},
	{3, 1, 2, 4, 0},
	{0, 2, 4, 3, 1},
	{2, 0, 1, 3, 4},
	{4, 3, 0, 1, 2},
	{1, 4, 3, 2, 0},
	{3, 2, 4, 0, 1},
	{0, 1, 2, 4, 3},
	{2, 1, 0, 3, 4},
	{4, 0, 3, 1, 2},
	{3, 4, 2, 0, 1},
	{1, 3, 4, 2, 0},
	{0, 2, 1, 4, 3},
	{1, 0, 3, 4, 2},
	{2, 3, 4, 0, 1},
	{0, 4, 1, 2, 3},
	{4, 1, 2, 3, 0},
	{3, 2, 0, 1, 4},
	{0, 2, 3, 4, 1},
	{1, 4, 2, 3, 0},
	{3, 0, 4, 1, 2},
	{2, 3, 1, 0, 4},
	{4, 1, 0, 2, 3},
	{4, 1, 0, 3, 2},
	{2, 0, 3, 1, 4},
	{3, 2, 1, 4, 0},
	{0, 3, 4, 2, 1},
	{1, 4, 2, 0, 3},
	{2, 4, 1, 3, 0},
	{0, 1, 3, 4, 2},
	{4, 3, 0, 2, 1},
	{1, 2, 4, 0, 3},
	{3, 0, 2, 4, 1},
	{2, 3, 0, 1, 4},
	{1, 0, 4, 3, 2},
	{4, 1, 3, 2, 0},
	{3, 2, 1, 0, 4},
	{0, 4, 2, 1, 3},
	{1, 0, 2, 3, 4},
	{4, 3, 1, 2, 0},
	{0, 2, 4, 1, 3},
	{3, 1, 0, 4, 2},
	{2, 4, 3, 0, 1},
	{3, 4, 2, 1, 0},
	{0, 1, 4, 2, 3},
	{2, 0, 3, 4, 1},
	{1, 2, 0, 3, 4},
	{3, 4, 1, 0, 2},
	{4, 3, 2, 0, 1},
	{1, 0, 4, 2, 3},
	{0, 2, 1, 3, 4},
	{2, 1, 3, 4, 0},
	{3, 4, 0, 1, 2},
	{4, 3, 2, 1, 0},
	{0, 1, 4, 3, 2},
	{2, 0, 1, 4, 3},
	{1, 3, 0, 2, 4},
	{4, 2, 0, 3, 1},
	{4, 1, 3, 0, 2},
	{2, 3, 1, 4, 0},
	{0, 2, 3, 1, 4},
	{3, 0, 4, 2, 1},
	{4, 1, 2, 0, 3},
	{1, 4, 0, 3, 2},
	{0, 3, 2, 1, 4},
	{2, 4, 1, 0, 3},
	{1, 2, 3, 4, 0},
	{3, 4, 0, 2, 1},
	{2, 0, 4, 3, 1},
	{1, 3, 4, 0, 2},
	{3, 0, 1, 2, 4},
	{4, 2, 3, 1, 0},
	{1, 0, 2, 4, 3},
	{0, 1, 3, 2, 4},
	{2, 4, 0, 3, 1},
	{3, 2, 4, 1, 0},
	{0, 3, 1, 4, 2},
	{4, 2, 1, 0, 3},
	{3, 1, 2, 0, 4},
	{4, 0, 2, 1, 3},
	{1, 3, 0, 4, 2},
	{2, 1, 4, 3, 0},
	{0, 4, 3, 2, 1},
	{2, 4, 0, 1, 3},
	{3, 0, 1, 4, 2},
	{1, 2, 4, 3, 0},
	{0, 3, 1, 2, 4},
	{4, 0, 2, 3, 1},
	{2, 1, 3, 0, 4},
	{1, 4, 3, 0, 2},
	{3, 2, 0, 4, 1},
	{0, 3, 4, 1, 2},
	{4, 0, 1, 2, 3},
	{1, 3, 2, 4, 0},
	{2, 1, 4, 0, 3},
	{0, 4, 2, 3, 1},
	{3, 1, 0, 2, 4},
	{4, 2, 1, 3, 0},
	{0, 4, 3, 1, 2},
	{2, 3, 0, 4, 1},
	{3, 1, 4, 2, 0},
	{1, 2, 3, 0, 4},
	{4, 2, 0, 1, 3},
	{4, 0, 1, 3, 2},
	{1, 3, 2, 0, 4},
	{2, 0, 4, 1, 3},
	{3, 4, 1, 2, 0},
	{0, 3, 2, 4, 1},
	{0, 1, 2, 3, 4},
	{2, 4, 3, 1, 0},
	{3, 1, 4, 0, 2},
	{4, 0, 3, 2, 1},
	{1, 2, 0, 4, 3},
	{4, 2, 3, 0, 1},
	{1, 0, 2, 3, 4},
	{3, 4, 1, 2, 0},
	{2, 1, 0, 4, 3},
	{0, 3, 4, 1, 2},
	{4, 3, 0, 2, 1},
	{1, 2, 3, 0, 4},
	{2, 0, 1, 4, 3},
	{3, 4, 2, 1, 0},
	{0, 1, 4, 3, 2},
	{4, 1, 3, 0, 2},
	{2, 0, 1, 3, 4},
	{3, 4, 0, 2, 1},
	{1, 3, 2, 4, 0},
	{0, 2, 4, 1, 3},
	{1, 4, 0, 2, 3},
	{3, 2, 4, 0, 1},
	{0, 1, 2, 3, 4},
	{4, 0, 3, 1, 2},
	{2, 3, 1, 4, 0},
	{4, 2, 3, 1, 0},
	{0, 3, 1, 2, 4},
	{1, 4, 2, 0, 3},
	{2, 0, 4, 3, 1},
	{3, 1, 0, 4, 2},
	{4, 1, 0, 3, 2},
	{2, 3, 1, 0, 4},
	{0, 4, 3, 2, 1},
	{3, 2, 4, 1, 0},
	{1, 0, 2, 4, 3},
	{4, 2, 0, 1, 3},
	{3, 0, 1, 2, 4},
	{1, 4, 2, 3, 0},
	{0, 1, 3, 4, 2},
	{2, 3, 4, 0, 1},
	{3, 0, 2, 4, 1},
	{1, 2, 4, 0, 3},
	{4, 1, 3, 2, 0},
	{0, 4, 1, 3, 2},
	{2, 3, 0, 1, 4},
	{0, 2, 3, 4, 1},
	{1, 3, 4, 2, 0},
	{2, 4, 1, 0, 3},
	{3, 0, 2, 1, 4},
	{4, 1, 0, 2, 3},
	{1, 0, 4, 3, 2},
	{3, 4, 2, 0, 1},
	{0, 2, 3, 1, 4},
	{4, 1, 2, 3, 0},
	{1, 3, 0, 4, 2},
	{2, 4, 1, 3, 0},
	{0, 3, 4, 2, 1},
	{3, 2, 0, 1, 4},
	{4, 1, 2, 0, 3},
	{2, 0, 3, 4, 1},
	{4, 3, 1, 0, 2},
	{1, 0, 3, 2, 4},
	{2, 1, 4, 3, 0},
	{0, 2, 1, 4, 3},
	{3, 4, 0, 1, 2},
	{3, 0, 1, 4, 2},
	{2, 1, 4, 0, 3},
	{0, 4, 2, 3, 1},
	{1, 3, 0, 2, 4},
	{4, 3, 2, 1, 0},
	{1, 2, 3, 4, 0},
	{0, 2, 4, 3, 1},
	{4, 0, 1, 2, 3},
	{2, 1, 3, 0, 4},
	{4, 3, 0, 1, 2},
	{3, 4, 1, 0, 2},
	{2, 0, 3, 1, 4},
	{1, 2, 0, 4, 3},
	{3, 1, 4, 2, 0},
	{4, 0, 2, 3, 1},
	{0, 4, 2, 1, 3},
	{3, 2, 1, 0, 4},
	{1, 4, 0, 3, 2},
	{2, 1, 3, 4, 0},
	{0, 3, 2, 4, 1},
	{3, 0, 4, 2, 1},
	{1, 4, 3, 2, 0},
	{4, 2, 1, 0, 3},
	{2, 1, 0, 3, 4},
	{0, 4, 3, 1, 2},
	{1, 3, 4, 0, 2},
	{2, 3, 0, 4, 1},
	{0, 1, 4, 2, 3},
	{4, 2, 1, 3, 0},
	{0, 3, 2, 1, 4},
	{3, 0, 4, 1, 2},
	{2, 4, 0, 3, 1},
	{3, 1, 2, 4, 0},
	{1, 0, 4, 2, 3},
	{0, 2, 1, 3, 4},
	{4, 3, 2, 0, 1},
	{2, 4, 3, 1, 0},
	{1, 0, 3, 4, 2},
	{3, 1, 0, 2, 4},
	{4, 2, 0, 3, 1},
	{0, 4, 1, 2, 3},
	{1, 3, 2, 0, 4},
	{3, 2, 1, 4, 0},
	{2, 0, 4, 1, 3},
	{1, 4, 3, 0, 2},
	{4, 0, 3, 2, 1},
	{3, 1, 2, 0, 4},
	{2, 4, 0, 1, 3},
	{0, 3, 1, 4, 2},
	{1, 2, 4, 3, 0},
	{4, 0, 2, 1, 3},
	{3, 1, 4, 0, 2},
	{0, 1, 3, 2, 4},
	{4, 3, 1, 2, 0},
	{3, 2, 0, 4, 1},
	{2, 4, 3, 0, 1},
	{1, 2, 0, 3, 4},
	{4, 0, 1, 3, 2},
	{2, 3, 4, 1, 0},
	{0, 1, 2, 4, 3},
	{2, 1, 4, 0, 3},
	{3, 4, 0, 1, 2},
	{1, 0, 2, 3, 4},
	{4, 3, 1, 2, 0},
	{0, 2, 3, 4, 1},
	{2, 0, 1, 4, 3},
	{3, 1, 4, 0, 2},
	{4, 3, 2, 1, 0},
	{1, 2, 0, 3, 4},
	{0, 4, 3, 2, 1},
	{2, 4, 3, 0, 1},
	{1, 3, 0, 4, 2},
	{0, 2, 4, 1, 3},
	{4, 1, 2, 3, 0},
	{3, 0, 1, 2, 4},
	{2, 0, 1, 3, 4},
	{4, 1, 3, 0, 2},
	{3, 4, 2, 1, 0},
	{1, 2, 0, 4, 3},
	{0, 3, 4, 2, 1},
	{2, 4, 0, 3, 1},
	{1, 3, 4, 0, 2},
	{0, 2, 1, 4, 3},
	{3, 0, 2, 1, 4},
	{4, 1, 3, 2, 0},
	{4, 2, 0, 3, 1},
	{1, 3, 2, 0, 4},
	{0, 1, 3, 4, 2},
	{3, 4, 1, 2, 0},
	{2, 0, 4, 1, 3},
	{2, 3, 1, 4, 0},
	{0, 1, 4, 3, 2},
	{4, 0, 2, 1, 3},
	{1, 2, 3, 0, 4},
	{3, 4, 0, 2, 1},
	{1, 2, 4, 0, 3},
	{3, 0, 2, 4, 1},
	{4, 1, 0, 3, 2},
	{2, 4, 3, 1, 0},
	{0, 3, 1, 2, 4},
	{0, 2, 3, 1, 4},
	{1, 4, 2, 3, 0},
	{4, 3, 0, 2, 1},
	{3, 0, 1, 4, 2},
	{2, 4, 1, 0, 3},
	{3, 1, 4, 2, 0},
	{0, 1, 2, 4, 3},
	{2, 0, 3, 1, 4},
	{4, 3, 1, 0, 2},
	{0, 2, 4, 3, 1},
	{1, 4, 0, 2, 3},
	{3, 2, 4, 1, 0},
	{2, 1, 3, 0, 4},
	{4, 0, 2, 3, 1},
	{1, 0, 3, 4, 2},
	{1, 3, 0, 2, 4},
	{4, 3, 2, 0, 1},
	{2, 4, 0, 1, 3},
	{3, 2, 1, 4, 0},
	{0, 4, 1, 3, 2},
	{0, 1, 4, 2, 3},
	{3, 1, 2, 4, 0},
	{2, 3, 0, 1, 4},
	{1, 0, 4, 3, 2},
	{4, 2, 3, 0, 1},
	{4, 1, 2, 0, 3},
	{3, 2, 0, 1, 4},
	{0, 3, 1, 4, 2},
	{2, 0, 4, 3, 1},
	{1, 4, 3, 2, 0},
	{4, 1, 0, 2, 3},
	{3, 2, 1, 0, 4},
	{0, 3, 2, 4, 1},
	{2, 4, 1, 3, 0},
	{3, 0, 4, 1, 2},
	{1, 4, 3, 0, 2},
	{2, 1, 0, 4, 3},
	{4, 0, 3, 2, 1},
	{1, 2, 4, 3, 0},
	{0, 3, 2, 1, 4},
	{1, 2, 3, 4, 0},
	{0, 4, 2, 3, 1},
	{4, 3, 0, 1, 2},
	{2, 3, 1, 0, 4},
	{1, 0, 4, 2, 3},
	{3, 1, 2, 0, 4},
	{4, 2, 0, 1, 3},
	{3, 0, 4, 2, 1},
	{2, 1, 3, 4, 0},
	{4, 0, 1, 3, 2},
	{0, 4, 1, 2, 3},
	{3, 2, 4, 0, 1},
	{0, 1, 2, 3, 4},
	{1, 3, 2, 4, 0},
	{0, 4, 3, 1, 2},
	{2, 1, 0, 3, 4},
	{4, 2, 3, 1, 0},
	{3, 4, 1, 0, 2},
	{2, 3, 0, 4, 1},
	{1, 0, 2, 4, 3},
	{1, 3, 4, 2, 0},
	{0, 4, 2, 1, 3},
	{3, 1, 0, 2, 4},
	{4, 2, 1, 0, 3},
	{2, 0, 3, 4, 1},
	{0, 3, 4, 1, 2},
	{4, 2, 1, 3, 0},
	{1, 0, 3, 2, 4},
	{3, 4, 2, 0, 1},
	{2, 1, 4, 3, 0},
	{1, 4, 0, 3, 2},
	{3, 2, 0, 4, 1},
	{4, 0, 1, 2, 3},
	{0, 1, 3, 2, 4},
	{2, 3, 4, 0, 1},
	{4, 0, 3, 1, 2},
	{0, 2, 1, 3, 4},
	{2, 3, 4, 1, 0},
	{3, 1, 0, 4, 2},
	{1, 4, 2, 0, 3},
};

uint8_t PERM_SEQ_6[840][6] = {
	{0, 1, 2, 3, 4, 5},
	{5, 4, 3, 2, 1, 0},
	{4, 3, 5, 0, 2, 1},
	{1, 2, 0, 5, 3, 4},
	{2, 5, 1, 4, 0, 3},
	{3, 0, 4, 1, 5, 2},
	{3, 5, 1, 4, 0, 2},
	{2, 0, 4, 1, 5, 3},
	{5, 2, 0, 3, 1, 4},
	{4, 1, 3, 0, 2, 5},
	{1, 4, 5, 2, 3, 0},
	{0, 3, 2, 5, 4, 1},
	{0, 4, 3, 2, 1, 5},
	{5, 1, 2, 3, 4, 0},
	{1, 3, 0, 4, 5, 2},
	{2, 5, 4, 0, 3, 1},
	{4, 2, 5, 1, 0, 3},
	{3, 0, 1, 5, 2, 4},
	{0, 2, 3, 5, 1, 4},
	{4, 1, 5, 3, 2, 0},
	{2, 3, 4, 1, 0, 5},
	{5, 0, 1, 4, 3, 2},
	{3, 5, 0, 2, 4, 1},
	{1, 4, 2, 0, 5, 3},
	{1, 4, 0, 5, 2, 3},
	{3, 2, 5, 0, 4, 1},
	{5, 1, 4, 3, 0, 2},
	{2, 0, 3, 4, 1, 5},
	{0, 3, 2, 1, 5, 4},
	{4, 5, 1, 2, 3, 0},
	{2, 4, 5, 1, 0, 3},
	{3, 0, 1, 5, 4, 2},
	{4, 3, 0, 2, 1, 5},
	{5, 1, 2, 0, 3, 4},
	{1, 5, 3, 4, 2, 0},
	{0, 2, 4, 3, 5, 1},
	{0, 2, 5, 1, 3, 4},
	{4, 3, 1, 5, 2, 0},
	{2, 5, 4, 0, 1, 3},
	{3, 1, 0, 4, 5, 2},
	{1, 0, 3, 2, 4, 5},
	{5, 4, 2, 3, 0, 1},
	{3, 5, 4, 1, 0, 2},
	{2, 0, 1, 4, 5, 3},
	{5, 4, 3, 0, 2, 1},
	{1, 2, 0, 3, 4, 5},
	{0, 1, 2, 5, 3, 4},
	{4, 3, 5, 2, 1, 0},
	{4, 3, 2, 1, 0, 5},
	{5, 0, 1, 2, 3, 4},
	{3, 1, 5, 4, 2, 0},
	{0, 2, 4, 5, 1, 3},
	{2, 4, 0, 3, 5, 1},
	{1, 5, 3, 0, 4, 2},
	{0, 1, 5, 2, 4, 3},
	{3, 4, 2, 5, 1, 0},
	{5, 2, 1, 3, 0, 4},
	{4, 0, 3, 1, 2, 5},
	{1, 3, 4, 0, 5, 2},
	{2, 5, 0, 4, 3, 1},
	{4, 0, 2, 5, 3, 1},
	{1, 3, 5, 2, 0, 4},
	{5, 2, 4, 0, 1, 3},
	{3, 1, 0, 4, 2, 5},
	{0, 4, 3, 1, 5, 2},
	{2, 5, 1, 3, 4, 0},
	{3, 2, 1, 5, 0, 4},
	{4, 0, 5, 1, 2, 3},
	{2, 1, 3, 4, 5, 0},
	{0, 5, 4, 3, 1, 2},
	{5, 4, 0, 2, 3, 1},
	{1, 3, 2, 0, 4, 5},
	{1, 3, 0, 5, 4, 2},
	{2, 4, 5, 0, 3, 1},
	{3, 0, 4, 1, 2, 5},
	{5, 2, 1, 4, 0, 3},
	{4, 5, 2, 3, 1, 0},
	{0, 1, 3, 2, 5, 4},
	{2, 0, 5, 1, 3, 4},
	{4, 3, 1, 5, 0, 2},
	{1, 5, 0, 4, 2, 3},
	{3, 2, 4, 0, 5, 1},
	{0, 1, 3, 2, 4, 5},
	{5, 4, 2, 3, 1, 0},
	{4, 2, 5, 3, 1, 0},
	{0, 1, 3, 5, 2, 4},
	{5, 3, 2, 0, 4, 1},
	{1, 4, 0, 2, 3, 5},
	{3, 0, 1, 4, 5, 2},
	{2, 5, 4, 1, 0, 3},
	{2, 4, 1, 5, 0, 3},
	{3, 0, 5, 1, 4, 2},
	{4, 1, 0, 3, 2, 5},
	{5, 2, 3, 0, 1, 4},
	{1, 5, 2, 4, 3, 0},
	{0, 3, 4, 2, 5, 1},
	{3, 0, 5, 2, 1, 4},
	{4, 1, 2, 5, 0, 3},
	{2, 5, 0, 3, 4, 1},
	{1, 4, 3, 0, 5, 2},
	{5, 3, 1, 4, 2, 0},
	{0, 2, 4, 1, 3, 5},
	{4, 0, 1, 2, 3, 5},
	{5, 3, 2, 1, 0, 4},
	{0, 1, 4, 3, 5, 2},
	{2, 5, 3, 4, 1, 0},
	{1, 2, 5, 0, 4, 3},
	{3, 4, 0, 5, 2, 1},
	{3, 4, 2, 5, 0, 1},
	{1, 0, 5, 2, 4, 3},
	{2, 3, 0, 4, 1, 5},
	{5, 1, 4, 0, 3, 2},
	{4, 5, 1, 3, 2, 0},
	{0, 2, 3, 1, 5, 4},
	{0, 5, 2, 3, 1, 4},
	{4, 1, 3, 2, 5, 0},
	{5, 3, 0, 4, 2, 1},
	{1, 2, 4, 0, 3, 5},
	{2, 0, 1, 5, 4, 3},
	{3, 4, 5, 1, 0, 2},
	{1, 4, 3, 0, 2, 5},
	{5, 2, 0, 3, 4, 1},
	{4, 3, 1, 2, 5, 0},
	{0, 5, 2, 1, 3, 4},
	{2, 1, 5, 4, 0, 3},
	{3, 0, 4, 5, 1, 2},
	{0, 3, 5, 1, 4, 2},
	{2, 4, 1, 5, 3, 0},
	{5, 0, 3, 2, 1, 4},
	{4, 1, 2, 3, 0, 5},
	{1, 2, 4, 0, 5, 3},
	{3, 5, 0, 4, 2, 1},
	{3, 4, 5, 0, 2, 1},
	{1, 2, 0, 5, 4, 3},
	{4, 5, 1, 3, 0, 2},
	{2, 0, 3, 1, 5, 4},
	{0, 3, 2, 4, 1, 5},
	{5, 1, 4, 2, 3, 0},
	{2, 1, 5, 4, 3, 0},
	{0, 3, 4, 5, 1, 2},
	{1, 0, 3, 2, 5, 4},
	{4, 5, 2, 3, 0, 1},
	{5, 4, 1, 0, 2, 3},
	{3, 2, 0, 1, 4, 5},
	{2, 3, 4, 0, 5, 1},
	{1, 5, 0, 4, 3, 2},
	{3, 2, 5, 1, 4, 0},
	{0, 4, 1, 5, 2, 3},
	{4, 0, 2, 3, 1, 5},
	{5, 1, 3, 2, 0, 4},
	{5, 0, 1, 3, 4, 2},
	{2, 4, 3, 1, 0, 5},
	{0, 1, 5, 4, 2, 3},
	{3, 2, 4, 5, 1, 0},
	{4, 3, 2, 0, 5, 1},
	{1, 5, 0, 2, 3, 4},
	{5, 1, 2, 3, 0, 4},
	{4, 0, 3, 2, 1, 5},
	{2, 3, 1, 4, 5, 0},
	{0, 5, 4, 1, 3, 2},
	{1, 4, 5, 0, 2, 3},
	{3, 2, 0, 5, 4, 1},
	{0, 3, 5, 2, 4, 1},
	{1, 4, 2, 5, 3, 0},
	{4, 0, 3, 1, 5, 2},
	{2, 5, 1, 3, 0, 4},
	{5, 2, 0, 4, 1, 3},
	{3, 1, 4, 0, 2, 5},
	{3, 1, 2, 4, 0, 5},
	{5, 0, 4, 2, 1, 3},
	{2, 3, 1, 5, 4, 0},
	{0, 4, 5, 1, 3, 2},
	{1, 5, 0, 3, 2, 4},
	{4, 2, 3, 0, 5, 1},
	{4, 0, 5, 2, 3, 1},
	{1, 3, 2, 5, 0, 4},
	{0, 4, 1, 3, 2, 5},
	{5, 2, 3, 1, 4, 0},
	{2, 5, 0, 4, 1, 3},
	{3, 1, 4, 0, 5, 2},
	{3, 4, 5, 2, 1, 0},
	{0, 1, 2, 5, 4, 3},
	{1, 3, 4, 0, 2, 5},
	{5, 2, 0, 4, 3, 1},
	{2, 5, 3, 1, 0, 4},
	{4, 0, 1, 3, 5, 2},
	{1, 0, 5, 4, 3, 2},
	{2, 3, 4, 5, 0, 1},
	{5, 4, 2, 0, 1, 3},
	{3, 1, 0, 2, 4, 5},
	{4, 2, 3, 1, 5, 0},
	{0, 5, 1, 3, 2, 4},
	{0, 3, 1, 2, 5, 4},
	{4, 5, 2, 1, 3, 0},
	{3, 0, 5, 4, 2, 1},
	{1, 2, 4, 5, 0, 3},
	{2, 1, 3, 0, 4, 5},
	{5, 4, 0, 3, 1, 2},
	{5, 1, 4, 0, 2, 3},
	{3, 2, 0, 4, 1, 5},
	{4, 5, 3, 2, 0, 1},
	{1, 0, 2, 3, 5, 4},
	{0, 3, 1, 5, 4, 2},
	{2, 4, 5, 1, 3, 0},
	{2, 1, 4, 0, 5, 3},
	{3, 5, 0, 4, 1, 2},
	{1, 2, 5, 3, 0, 4},
	{4, 0, 3, 5, 2, 1},
	{0, 4, 2, 1, 3, 5},
	{5, 3, 1, 2, 4, 0},
	{3, 5, 4, 2, 0, 1},
	{1, 0, 2, 4, 5, 3},
	{5, 3, 0, 1, 4, 2},
	{2, 4, 1, 0, 3, 5},
	{4, 2, 3, 5, 1, 0},
	{0, 1, 5, 3, 2, 4},
	{0, 1, 2, 4, 5, 3},
	{3, 5, 4, 2, 1, 0},
	{5, 3, 1, 0, 2, 4},
	{4, 2, 0, 1, 3, 5},
	{2, 4, 3, 5, 0, 1},
	{1, 0, 5, 3, 4, 2},
	{1, 0, 4, 3, 2, 5},
	{5, 2, 3, 4, 0, 1},
	{0, 4, 1, 2, 5, 3},
	{3, 5, 2, 1, 4, 0},
	{2, 3, 5, 0, 1, 4},
	{4, 1, 0, 5, 3, 2},
	{5, 4, 1, 3, 0, 2},
	{2, 0, 3, 1, 4, 5},
	{1, 5, 4, 0, 2, 3},
	{3, 2, 0, 4, 5, 1},
	{0, 3, 2, 5, 1, 4},
	{4, 1, 5, 2, 3, 0},
	{2, 3, 4, 1, 5, 0},
	{0, 5, 1, 4, 3, 2},
	{4, 1, 3, 2, 0, 5},
	{5, 0, 2, 3, 1, 4},
	{5, 2, 3, 0, 4, 1},
	{1, 4, 0, 3, 2, 5},
	{0, 1, 4, 5, 2, 3},
	{3, 2, 5, 4, 1, 0},
	{3, 4, 5, 2, 0, 1},
	{1, 0, 2, 5, 4, 3},
	{2, 5, 1, 0, 3, 4},
	{4, 3, 0, 1, 5, 2},
	{1, 0, 3, 4, 5, 2},
	{2, 5, 4, 3, 0, 1},
	{3, 4, 5, 1, 2, 0},
	{0, 2, 1, 5, 4, 3},
	{5, 1, 0, 2, 3, 4},
	{4, 3, 2, 0, 1, 5},
	{0, 4, 2, 3, 1, 5},
	{5, 1, 3, 2, 4, 0},
	{4, 2, 0, 5, 3, 1},
	{1, 3, 5, 0, 2, 4},
	{2, 0, 1, 3, 5, 4},
	{4, 5, 3, 1, 0, 2},
	{3, 1, 4, 5, 0, 2},
	{2, 0, 5, 4, 1, 3},
	{5, 4, 1, 2, 3, 0},
	{0, 3, 2, 1, 4, 5},
	{1, 2, 0, 4, 5, 3},
	{3, 5, 4, 0, 2, 1},
	{3, 0, 5, 2, 4, 1},
	{1, 4, 2, 5, 0, 3},
	{5, 3, 4, 0, 1, 2},
	{2, 1, 0, 4, 3, 5},
	{0, 2, 1, 3, 5, 4},
	{4, 5, 3, 1, 2, 0},
	{4, 2, 1, 3, 5, 0},
	{0, 5, 3, 1, 2, 4},
	{3, 4, 5, 0, 1, 2},
	{2, 1, 0, 5, 4, 3},
	{1, 0, 2, 4, 3, 5},
	{5, 3, 4, 2, 0, 1},
	{5, 2, 1, 0, 3, 4},
	{4, 3, 0, 1, 2, 5},
	{2, 4, 5, 3, 0, 1},
	{1, 0, 3, 5, 4, 2},
	{0, 1, 4, 2, 5, 3},
	{3, 5, 2, 4, 1, 0},
	{5, 3, 4, 1, 0, 2},
	{2, 0, 1, 4, 3, 5},
	{3, 5, 0, 2, 1, 4},
	{4, 1, 2, 0, 5, 3},
	{1, 4, 5, 3, 2, 0},
	{0, 2, 3, 5, 4, 1},
	{0, 2, 3, 4, 1, 5},
	{5, 1, 4, 3, 2, 0},
	{3, 4, 1, 5, 0, 2},
	{2, 0, 5, 1, 4, 3},
	{1, 5, 2, 0, 3, 4},
	{4, 3, 0, 2, 5, 1},
	{2, 0, 4, 3, 5, 1},
	{1, 5, 3, 4, 0, 2},
	{4, 2, 0, 5, 1, 3},
	{3, 1, 5, 0, 2, 4},
	{0, 3, 1, 2, 4, 5},
	{5, 4, 2, 1, 3, 0},
	{5, 1, 3, 4, 2, 0},
	{0, 2, 4, 3, 1, 5},
	{4, 5, 2, 1, 0, 3},
	{3, 0, 1, 2, 5, 4},
	{2, 3, 0, 5, 4, 1},
	{1, 4, 5, 0, 3, 2},
	{1, 3, 0, 5, 2, 4},
	{4, 2, 5, 0, 3, 1},
	{0, 4, 1, 3, 5, 2},
	{2, 5, 3, 1, 4, 0},
	{5, 1, 2, 4, 0, 3},
	{3, 0, 4, 2, 1, 5},
	{3, 2, 4, 5, 0, 1},
	{1, 0, 5, 4, 2, 3},
	{4, 1, 2, 3, 5, 0},
	{0, 5, 3, 2, 1, 4},
	{5, 3, 1, 0, 4, 2},
	{2, 4, 0, 1, 3, 5},
	{0, 2, 1, 4, 3, 5},
	{5, 3, 4, 1, 2, 0},
	{2, 0, 5, 3, 4, 1},
	{1, 4, 3, 5, 0, 2},
	{4, 5, 0, 2, 1, 3},
	{3, 1, 2, 0, 5, 4},
	{3, 1, 0, 5, 4, 2},
	{2, 4, 5, 0, 1, 3},
	{4, 3, 1, 2, 0, 5},
	{5, 0, 2, 1, 3, 4},
	{0, 5, 3, 4, 2, 1},
	{1, 2, 4, 3, 5, 0},
	{2, 1, 5, 3, 4, 0},
	{0, 4, 3, 5, 1, 2},
	{1, 5, 2, 4, 0, 3},
	{3, 0, 4, 2, 5, 1},
	{4, 3, 1, 0, 2, 5},
	{5, 2, 0, 1, 3, 4},
	{0, 2, 5, 3, 1, 4},
	{4, 1, 3, 5, 2, 0},
	{3, 5, 2, 0, 4, 1},
	{1, 4, 0, 2, 5, 3},
	{5, 0, 4, 1, 3, 2},
	{2, 3, 1, 4, 0, 5},
	{1, 2, 4, 3, 0, 5},
	{5, 0, 3, 4, 2, 1},
	{4, 3, 2, 1, 5, 0},
	{0, 5, 1, 2, 3, 4},
	{2, 1, 5, 0, 4, 3},
	{3, 4, 0, 5, 1, 2},
	{0, 3, 5, 4, 1, 2},
	{2, 1, 4, 5, 3, 0},
	{4, 0, 1, 3, 2, 5},
	{5, 2, 3, 1, 0, 4},
	{1, 5, 2, 0, 4, 3},
	{3, 4, 0, 2, 5, 1},
	{3, 0, 2, 4, 5, 1},
	{1, 5, 4, 2, 0, 3},
	{5, 1, 3, 0, 2, 4},
	{4, 2, 0, 3, 1, 5},
	{2, 3, 5, 1, 4, 0},
	{0, 4, 1, 5, 3, 2},
	{4, 0, 1, 2, 5, 3},
	{3, 5, 2, 1, 0, 4},
	{5, 4, 3, 0, 1, 2},
	{2, 1, 0, 3, 4, 5},
	{0, 2, 4, 5, 3, 1},
	{1, 3, 5, 4, 2, 0},
	{1, 3, 2, 4, 5, 0},
	{0, 5, 4, 2, 3, 1},
	{4, 2, 3, 0, 1, 5},
	{5, 1, 0, 3, 2, 4},
	{1, 4, 5, 3, 0, 2},
	{2, 0, 3, 5, 4, 1},
	{0, 5, 2, 1, 4, 3},
	{3, 4, 1, 2, 5, 0},
	{3, 2, 5, 0, 1, 4},
	{4, 1, 0, 5, 2, 3},
	{5, 3, 1, 4, 0, 2},
	{2, 0, 4, 1, 3, 5},
	{2, 0, 1, 3, 4, 5},
	{5, 4, 3, 1, 0, 2},
	{4, 1, 0, 2, 5, 3},
	{3, 5, 2, 0, 1, 4},
	{0, 3, 5, 4, 2, 1},
	{1, 2, 4, 5, 3, 0},
	{5, 2, 1, 3, 4, 0},
	{0, 4, 3, 1, 2, 5},
	{3, 1, 0, 2, 5, 4},
	{4, 5, 2, 0, 1, 3},
	{2, 0, 4, 5, 3, 1},
	{1, 3, 5, 4, 0, 2},
	{4, 1, 5, 3, 0, 2},
	{2, 0, 3, 5, 1, 4},
	{1, 5, 4, 2, 3, 0},
	{0, 3, 2, 4, 5, 1},
	{3, 4, 0, 1, 2, 5},
	{5, 2, 1, 0, 4, 3},
	{2, 0, 5, 4, 3, 1},
	{1, 3, 4, 5, 0, 2},
	{3, 5, 1, 2, 4, 0},
	{0, 4, 2, 1, 5, 3},
	{4, 1, 0, 2, 3, 5},
	{5, 3, 2, 0, 1, 4},
	{0, 2, 5, 3, 4, 1},
	{1, 4, 3, 5, 2, 0},
	{4, 5, 1, 0, 2, 3},
	{3, 2, 0, 1, 5, 4},
	{2, 1, 3, 4, 0, 5},
	{5, 0, 4, 3, 1, 2},
	{3, 5, 0, 1, 4, 2},
	{2, 4, 1, 0, 5, 3},
	{5, 3, 2, 4, 0, 1},
	{1, 0, 4, 2, 3, 5},
	{0, 1, 4, 3, 2, 5},
	{5, 2, 3, 4, 1, 0},
	{4, 2, 5, 0, 1, 3},
	{3, 1, 0, 5, 2, 4},
	{1, 5, 3, 2, 0, 4},
	{4, 0, 2, 3, 5, 1},
	{2, 3, 0, 1, 4, 5},
	{5, 4, 1, 0, 3, 2},
	{0, 4, 5, 3, 1, 2},
	{2, 1, 3, 5, 4, 0},
	{1, 2, 5, 4, 0, 3},
	{3, 0, 4, 5, 2, 1},
	{0, 3, 5, 1, 2, 4},
	{4, 2, 1, 5, 3, 0},
	{4, 5, 3, 2, 1, 0},
	{0, 1, 2, 3, 5, 4},
	{1, 3, 2, 4, 0, 5},
	{5, 0, 4, 2, 3, 1},
	{2, 4, 0, 1, 5, 3},
	{3, 5, 1, 0, 4, 2},
	{5, 0, 3, 4, 1, 2},
	{2, 1, 4, 3, 0, 5},
	{3, 5, 1, 0, 2, 4},
	{4, 2, 0, 1, 5, 3},
	{0, 4, 2, 5, 3, 1},
	{1, 3, 5, 2, 4, 0},
	{2, 1, 4, 3, 5, 0},
	{0, 5, 3, 4, 1, 2},
	{1, 4, 2, 0, 3, 5},
	{5, 3, 0, 2, 4, 1},
	{3, 0, 5, 1, 2, 4},
	{4, 2, 1, 5, 0, 3},
	{5, 4, 2, 0, 3, 1},
	{1, 3, 0, 2, 4, 5},
	{4, 1, 3, 5, 0, 2},
	{2, 0, 5, 3, 1, 4},
	{3, 2, 1, 4, 5, 0},
	{0, 5, 4, 1, 2, 3},
	{0, 5, 1, 2, 4, 3},
	{3, 4, 2, 1, 5, 0},
	{2, 3, 0, 5, 1, 4},
	{4, 1, 5, 0, 3, 2},
	{5, 0, 4, 3, 2, 1},
	{1, 2, 3, 4, 0, 5},
	{1, 2, 0, 4, 3, 5},
	{5, 3, 4, 0, 2, 1},
	{4, 1, 5, 2, 0, 3},
	{3, 0, 2, 5, 1, 4},
	{0, 5, 3, 1, 4, 2},
	{2, 4, 1, 3, 5, 0},
	{3, 2, 4, 1, 5, 0},
	{0, 5, 1, 4, 2, 3},
	{1, 3, 5, 0, 4, 2},
	{2, 4, 0, 5, 3, 1},
	{2, 0, 4, 3, 1, 5},
	{5, 1, 3, 4, 0, 2},
	{4, 5, 2, 0, 3, 1},
	{1, 3, 0, 2, 5, 4},
	{3, 1, 5, 2, 0, 4},
	{4, 0, 2, 5, 1, 3},
	{5, 4, 1, 3, 2, 0},
	{0, 2, 3, 1, 4, 5},
	{0, 2, 4, 1, 5, 3},
	{3, 5, 1, 4, 2, 0},
	{1, 0, 2, 3, 4, 5},
	{5, 4, 3, 2, 0, 1},
	{4, 3, 5, 0, 1, 2},
	{2, 1, 0, 5, 3, 4},
	{2, 5, 0, 3, 1, 4},
	{4, 1, 3, 0, 5, 2},
	{5, 0, 1, 2, 4, 3},
	{3, 4, 2, 1, 0, 5},
	{1, 3, 4, 5, 2, 0},
	{0, 2, 5, 4, 3, 1},
	{2, 4, 3, 0, 1, 5},
	{5, 1, 0, 3, 4, 2},
	{0, 3, 4, 5, 2, 1},
	{1, 2, 5, 4, 3, 0},
	{3, 5, 1, 2, 0, 4},
	{4, 0, 2, 1, 5, 3},
	{4, 2, 1, 0, 5, 3},
	{3, 5, 0, 1, 2, 4},
	{0, 4, 5, 2, 3, 1},
	{1, 3, 2, 5, 4, 0},
	{2, 1, 3, 5, 0, 4},
	{4, 0, 5, 3, 1, 2},
	{1, 3, 4, 2, 0, 5},
	{5, 0, 2, 4, 3, 1},
	{5, 4, 0, 1, 2, 3},
	{3, 2, 1, 0, 4, 5},
	{2, 5, 4, 3, 1, 0},
	{0, 1, 3, 4, 5, 2},
	{0, 3, 1, 5, 2, 4},
	{4, 2, 5, 1, 3, 0},
	{1, 0, 4, 3, 5, 2},
	{2, 5, 3, 4, 0, 1},
	{3, 4, 2, 0, 1, 5},
	{5, 1, 0, 2, 4, 3},
	{5, 0, 2, 3, 4, 1},
	{1, 4, 3, 2, 0, 5},
	{3, 1, 4, 5, 2, 0},
	{0, 2, 5, 4, 1, 3},
	{2, 5, 0, 1, 3, 4},
	{4, 3, 1, 0, 5, 2},
	{4, 1, 5, 0, 2, 3},
	{3, 2, 0, 5, 1, 4},
	{5, 0, 3, 1, 4, 2},
	{2, 4, 1, 3, 0, 5},
	{1, 3, 4, 2, 5, 0},
	{0, 5, 2, 4, 3, 1},
	{2, 0, 4, 5, 1, 3},
	{3, 1, 5, 4, 0, 2},
	{4, 2, 0, 3, 5, 1},
	{1, 5, 3, 0, 2, 4},
	{5, 3, 2, 1, 4, 0},
	{0, 4, 1, 2, 3, 5},
	{0, 1, 3, 4, 2, 5},
	{5, 2, 4, 3, 1, 0},
	{2, 0, 1, 5, 3, 4},
	{4, 3, 5, 1, 0, 2},
	{3, 4, 2, 0, 5, 1},
	{1, 5, 0, 2, 4, 3},
	{1, 5, 4, 3, 0, 2},
	{2, 0, 3, 4, 5, 1},
	{5, 1, 2, 0, 4, 3},
	{3, 4, 0, 2, 1, 5},
	{4, 3, 5, 1, 2, 0},
	{0, 2, 1, 5, 3, 4},
	{0, 2, 1, 3, 4, 5},
	{5, 4, 3, 1, 2, 0},
	{4, 0, 5, 2, 1, 3},
	{3, 1, 2, 5, 0, 4},
	{2, 3, 0, 4, 5, 1},
	{1, 5, 4, 0, 3, 2},
	{5, 1, 3, 0, 4, 2},
	{2, 4, 0, 3, 1, 5},
	{3, 2, 5, 1, 0, 4},
	{4, 0, 1, 5, 2, 3},
	{0, 1, 4, 2, 3, 5},
	{5, 3, 2, 4, 1, 0},
	{1, 5, 4, 3, 2, 0},
	{0, 2, 3, 4, 5, 1},
	{4, 3, 2, 5, 0, 1},
	{1, 0, 5, 2, 3, 4},
	{3, 4, 0, 1, 5, 2},
	{2, 5, 1, 0, 4, 3},
	{2, 5, 0, 1, 4, 3},
	{3, 4, 1, 0, 5, 2},
	{0, 1, 5, 2, 3, 4},
	{4, 3, 2, 5, 1, 0},
	{5, 2, 4, 3, 0, 1},
	{1, 0, 3, 4, 2, 5},
	{1, 3, 0, 4, 2, 5},
	{5, 2, 4, 0, 3, 1},
	{0, 4, 2, 5, 1, 3},
	{3, 1, 5, 2, 4, 0},
	{2, 3, 1, 5, 0, 4},
	{4, 0, 5, 1, 3, 2},
	{4, 5, 3, 0, 1, 2},
	{2, 1, 0, 3, 5, 4},
	{1, 4, 3, 2, 5, 0},
	{0, 5, 2, 3, 4, 1},
	{3, 0, 1, 4, 2, 5},
	{5, 2, 4, 1, 0, 3},
	{5, 2, 0, 1, 4, 3},
	{3, 4, 1, 0, 2, 5},
	{4, 1, 2, 5, 3, 0},
	{0, 3, 5, 2, 1, 4},
	{1, 5, 2, 3, 0, 4},
	{4, 0, 3, 2, 5, 1},
	{0, 3, 4, 1, 5, 2},
	{2, 5, 1, 4, 3, 0},
	{3, 2, 5, 4, 0, 1},
	{1, 0, 4, 5, 2, 3},
	{2, 4, 0, 5, 1, 3},
	{3, 1, 5, 0, 4, 2},
	{5, 0, 1, 3, 2, 4},
	{4, 2, 3, 1, 0, 5},
	{0, 4, 3, 2, 5, 1},
	{1, 5, 2, 3, 4, 0},
	{5, 1, 0, 4, 3, 2},
	{2, 3, 4, 0, 1, 5},
	{2, 4, 3, 1, 5, 0},
	{0, 5, 1, 3, 4, 2},
	{3, 0, 2, 4, 1, 5},
	{5, 1, 4, 2, 0, 3},
	{1, 2, 5, 0, 3, 4},
	{4, 3, 0, 5, 2, 1},
	{4, 5, 1, 0, 3, 2},
	{2, 3, 0, 1, 5, 4},
	{3, 0, 2, 5, 4, 1},
	{1, 4, 5, 2, 0, 3},
	{5, 1, 2, 4, 3, 0},
	{0, 3, 4, 2, 1, 5},
	{4, 2, 1, 3, 0, 5},
	{5, 0, 3, 1, 2, 4},
	{0, 1, 3, 5, 4, 2},
	{2, 4, 5, 3, 1, 0},
	{3, 2, 4, 0, 1, 5},
	{5, 1, 0, 4, 2, 3},
	{4, 5, 0, 2, 3, 1},
	{1, 3, 2, 0, 5, 4},
	{1, 2, 5, 3, 4, 0},
	{0, 4, 3, 5, 2, 1},
	{5, 0, 1, 4, 2, 3},
	{3, 2, 4, 1, 0, 5},
	{0, 3, 1, 4, 5, 2},
	{2, 5, 4, 1, 3, 0},
	{2, 1, 5, 3, 0, 4},
	{4, 0, 3, 5, 1, 2},
	{3, 5, 2, 4, 0, 1},
	{1, 0, 4, 2, 5, 3},
	{1, 4, 0, 3, 5, 2},
	{2, 5, 3, 0, 4, 1},
	{0, 4, 5, 2, 1, 3},
	{3, 1, 2, 5, 4, 0},
	{4, 2, 1, 0, 3, 5},
	{5, 3, 0, 1, 2, 4},
	{3, 5, 4, 0, 1, 2},
	{2, 1, 0, 4, 5, 3},
	{1, 2, 3, 5, 0, 4},
	{4, 0, 5, 3, 2, 1},
	{5, 3, 4, 2, 1, 0},
	{0, 1, 2, 4, 3, 5},
	{3, 0, 2, 1, 4, 5},
	{5, 4, 1, 2, 0, 3},
	{2, 3, 5, 0, 4, 1},
	{1, 4, 0, 5, 3, 2},
	{0, 2, 1, 4, 5, 3},
	{3, 5, 4, 1, 2, 0},
	{4, 5, 0, 3, 1, 2},
	{2, 1, 3, 0, 5, 4},
	{1, 0, 2, 5, 3, 4},
	{4, 3, 5, 2, 0, 1},
	{5, 2, 4, 1, 3, 0},
	{0, 3, 1, 4, 2, 5},
	{1, 4, 2, 3, 0, 5},
	{5, 0, 3, 2, 4, 1},
	{0, 4, 5, 1, 2, 3},
	{3, 2, 1, 5, 4, 0},
	{2, 5, 3, 0, 1, 4},
	{4, 1, 0, 3, 5, 2},
	{3, 4, 1, 2, 0, 5},
	{5, 0, 2, 1, 4, 3},
	{4, 3, 0, 5, 1, 2},
	{2, 1, 5, 0, 3, 4},
	{0, 5, 4, 3, 2, 1},
	{1, 2, 3, 4, 5, 0},
	{1, 2, 3, 5, 4, 0},
	{0, 4, 5, 3, 2, 1},
	{5, 3, 1, 2, 0, 4},
	{4, 0, 2, 1, 3, 5},
	{2, 1, 4, 0, 3, 5},
	{5, 3, 0, 4, 1, 2},
	{0, 5, 4, 2, 1, 3},
	{3, 1, 2, 4, 5, 0},
	{1, 0, 3, 5, 2, 4},
	{4, 2, 5, 3, 0, 1},
	{2, 4, 3, 0, 5, 1},
	{1, 5, 0, 3, 4, 2},
	{3, 4, 1, 5, 2, 0},
	{0, 2, 5, 1, 4, 3},
	{4, 5, 0, 1, 3, 2},
	{2, 3, 1, 0, 5, 4},
	{3, 1, 4, 2, 0, 5},
	{5, 0, 2, 4, 1, 3},
	{0, 5, 2, 4, 1, 3},
	{3, 1, 4, 2, 5, 0},
	{1, 0, 5, 3, 2, 4},
	{4, 2, 3, 5, 0, 1},
	{2, 3, 1, 0, 4, 5},
	{5, 4, 0, 1, 3, 2},
	{5, 4, 0, 3, 2, 1},
	{1, 2, 3, 0, 4, 5},
	{2, 3, 5, 1, 0, 4},
	{4, 0, 1, 5, 3, 2},
	{0, 1, 4, 5, 3, 2},
	{2, 3, 5, 4, 1, 0},
	{4, 5, 1, 2, 0, 3},
	{3, 0, 2, 1, 5, 4},
	{3, 1, 2, 0, 4, 5},
	{5, 4, 0, 2, 1, 3},
	{4, 5, 3, 0, 2, 1},
	{1, 2, 0, 3, 5, 4},
	{5, 2, 1, 4, 3, 0},
	{0, 3, 4, 1, 2, 5},
	{0, 5, 3, 2, 4, 1},
	{1, 4, 2, 3, 5, 0},
	{2, 1, 4, 5, 0, 3},
	{3, 0, 5, 4, 1, 2},
	{3, 0, 1, 2, 4, 5},
	{5, 4, 2, 1, 0, 3},
	{1, 2, 3, 0, 5, 4},
	{4, 5, 0, 3, 2, 1},
	{0, 1, 5, 4, 3, 2},
	{2, 3, 4, 5, 1, 0},
	{2, 4, 3, 5, 1, 0},
	{0, 1, 5, 3, 4, 2},
	{4, 5, 0, 1, 2, 3},
	{3, 2, 1, 0, 5, 4},
	{2, 3, 5, 4, 0, 1},
	{1, 0, 4, 5, 3, 2},
	{4, 1, 2, 0, 3, 5},
	{5, 3, 0, 2, 1, 4},
	{0, 4, 2, 3, 5, 1},
	{1, 5, 3, 2, 4, 0},
	{5, 0, 4, 1, 2, 3},
	{3, 2, 1, 4, 0, 5},
	{3, 1, 5, 0, 2, 4},
	{4, 2, 0, 5, 1, 3},
	{5, 3, 1, 2, 4, 0},
	{0, 4, 2, 1, 3, 5},
	{2, 0, 3, 4, 5, 1},
	{1, 5, 4, 3, 0, 2},
	{1, 3, 4, 0, 5, 2},
	{2, 5, 0, 4, 3, 1},
	{3, 0, 1, 2, 4, 5},
	{5, 4, 2, 1, 0, 3},
	{4, 2, 5, 3, 1, 0},
	{0, 1, 3, 5, 2, 4},
	{5, 0, 1, 3, 2, 4},
	{4, 2, 3, 1, 0, 5},
	{3, 4, 2, 0, 5, 1},
	{1, 5, 0, 2, 4, 3},
	{0, 1, 5, 4, 3, 2},
	{2, 3, 4, 5, 1, 0},
	{2, 1, 5, 4, 3, 0},
	{0, 3, 4, 5, 1, 2},
	{4, 5, 1, 0, 2, 3},
	{3, 2, 0, 1, 5, 4},
	{1, 0, 3, 2, 4, 5},
	{5, 4, 2, 3, 0, 1},
	{3, 2, 5, 4, 0, 1},
	{1, 0, 4, 5, 2, 3},
	{5, 4, 0, 1, 3, 2},
	{2, 3, 1, 0, 4, 5},
	{0, 1, 3, 2, 5, 4},
	{4, 5, 2, 3, 1, 0},
	{2, 4, 3, 5, 1, 0},
	{0, 1, 5, 3, 4, 2},
	{3, 2, 4, 1, 0, 5},
	{5, 0, 1, 4, 2, 3},
	{1, 5, 0, 2, 3, 4},
	{4, 3, 2, 0, 5, 1},
	{4, 5, 0, 2, 3, 1},
	{1, 3, 2, 0, 5, 4},
	{3, 4, 1, 5, 0, 2},
	{2, 0, 5, 1, 4, 3},
	{0, 2, 3, 4, 1, 5},
	{5, 1, 4, 3, 2, 0},
	{5, 2, 1, 0, 4, 3},
	{3, 4, 0, 1, 2, 5},
	{1, 5, 2, 3, 0, 4},
	{4, 0, 3, 2, 5, 1},
	{0, 3, 5, 4, 1, 2},
	{2, 1, 4, 5, 3, 0},
	{4, 2, 1, 0, 5, 3},
	{3, 5, 0, 1, 2, 4},
	{2, 4, 3, 5, 0, 1},
	{1, 0, 5, 3, 4, 2},
	{0, 1, 4, 2, 3, 5},
	{5, 3, 2, 4, 1, 0},
	{5, 3, 1, 4, 0, 2},
	{2, 0, 4, 1, 3, 5},
	{3, 2, 5, 0, 4, 1},
	{1, 4, 0, 5, 2, 3},
	{4, 1, 2, 3, 5, 0},
	{0, 5, 3, 2, 1, 4},
	{0, 1, 5, 2, 3, 4},
	{4, 3, 2, 5, 1, 0},
	{5, 0, 4, 1, 2, 3},
	{3, 2, 1, 4, 0, 5},
	{1, 4, 3, 0, 5, 2},
	{2, 5, 0, 3, 4, 1},
	{2, 3, 5, 0, 4, 1},
	{1, 4, 0, 5, 3, 2},
	{0, 2, 3, 1, 5, 4},
	{4, 5, 1, 3, 2, 0},
	{5, 1, 4, 2, 0, 3},
	{3, 0, 2, 4, 1, 5},
	{4, 3, 2, 0, 1, 5},
	{5, 1, 0, 2, 3, 4},
	{2, 4, 3, 1, 5, 0},
	{0, 5, 1, 3, 4, 2},
	{1, 0, 5, 4, 2, 3},
	{3, 2, 4, 5, 0, 1},
	{3, 5, 0, 2, 1, 4},
	{4, 1, 2, 0, 5, 3},
	{5, 3, 4, 1, 0, 2},
	{2, 0, 1, 4, 3, 5},
	{0, 2, 3, 5, 4, 1},
	{1, 4, 5, 3, 2, 0},
	{1, 4, 2, 0, 3, 5},
	{5, 3, 0, 2, 4, 1},
	{4, 1, 5, 3, 0, 2},
	{2, 0, 3, 5, 1, 4},
	{0, 2, 1, 4, 5, 3},
	{3, 5, 4, 1, 2, 0},
	{3, 5, 2, 1, 0, 4},
	{4, 0, 1, 2, 5, 3},
	{2, 4, 3, 0, 1, 5},
	{5, 1, 0, 3, 4, 2},
	{0, 3, 5, 4, 2, 1},
	{1, 2, 4, 5, 3, 0},
	{1, 5, 4, 2, 0, 3},
	{3, 0, 2, 4, 5, 1},
	{5, 1, 3, 0, 2, 4},
	{4, 2, 0, 3, 1, 5},
	{2, 4, 5, 1, 3, 0},
	{0, 3, 1, 5, 4, 2},
	{0, 3, 4, 1, 2, 5},
	{5, 2, 1, 4, 3, 0},
	{1, 4, 3, 5, 0, 2},
	{2, 0, 5, 3, 4, 1},
	{3, 5, 2, 0, 1, 4},
	{4, 1, 0, 2, 5, 3},
	{0, 2, 4, 1, 5, 3},
	{3, 5, 1, 4, 2, 0},
	{2, 4, 5, 0, 3, 1},
	{1, 3, 0, 5, 4, 2},
	{5, 1, 3, 2, 0, 4},
	{4, 0, 2, 3, 1, 5},
	{0, 4, 1, 3, 2, 5},
	{5, 2, 3, 1, 4, 0},
	{3, 1, 4, 5, 0, 2},
	{2, 0, 5, 4, 1, 3},
	{4, 5, 2, 0, 3, 1},
	{1, 3, 0, 2, 5, 4},
};

uint8_t PERM_SEQ_7[840][7] = {
	{0, 1, 2, 3, 4, 5, 6},
	{6, 5, 3, 4, 2, 1, 0},
	{4, 6, 5, 2, 1, 0, 3},
	{3, 0, 1, 5, 6, 2, 4},
	{2, 4, 0, 1, 3, 6, 5},
	{5, 3, 6, 1, 0, 4, 2},
	{1, 2, 4, 6, 5, 3, 0},
	{2, 5, 6, 0, 4, 3, 1},
	{0, 3, 4, 6, 1, 5, 2},
	{1, 4, 3, 0, 5, 2, 6},
	{6, 2, 0, 5, 3, 4, 1},
	{5, 1, 2, 4, 0, 6, 3},
	{3, 0, 5, 2, 6, 1, 4},
	{4, 6, 1, 3, 2, 0, 5},
	{6, 3, 0, 4, 2, 5, 1},
	{1, 5, 4, 2, 0, 3, 6},
	{0, 2, 6, 3, 4, 1, 5},
	{5, 4, 1, 6, 3, 2, 0},
	{2, 1, 3, 5, 6, 0, 4},
	{3, 6, 5, 0, 1, 4, 2},
	{4, 0, 2, 1, 5, 6, 3},
	{4, 5, 0, 3, 2, 1, 6},
	{6, 1, 2, 0, 3, 5, 4},
	{3, 2, 1, 4, 0, 6, 5},
	{5, 0, 6, 1, 4, 2, 3},
	{2, 6, 4, 5, 1, 3, 0},
	{1, 4, 3, 6, 5, 0, 2},
	{0, 3, 5, 2, 6, 4, 1},
	{5, 3, 0, 4, 1, 6, 2},
	{2, 6, 4, 1, 0, 3, 5},
	{3, 1, 6, 0, 2, 5, 4},
	{4, 0, 2, 5, 6, 1, 3},
	{6, 5, 1, 2, 3, 4, 0},
	{0, 4, 3, 6, 5, 2, 1},
	{1, 2, 5, 3, 4, 0, 6},
	{1, 5, 6, 4, 3, 2, 0},
	{0, 2, 4, 3, 6, 5, 1},
	{5, 6, 3, 2, 0, 1, 4},
	{4, 3, 0, 1, 2, 6, 5},
	{2, 1, 5, 6, 4, 0, 3},
	{3, 0, 2, 5, 1, 4, 6},
	{6, 4, 1, 0, 5, 3, 2},
	{0, 4, 2, 3, 1, 5, 6},
	{6, 5, 3, 1, 2, 4, 0},
	{1, 6, 4, 2, 5, 0, 3},
	{2, 3, 5, 0, 4, 6, 1},
	{4, 0, 1, 5, 6, 3, 2},
	{3, 1, 6, 4, 0, 2, 5},
	{5, 2, 0, 6, 3, 1, 4},
	{5, 1, 0, 3, 4, 6, 2},
	{2, 6, 4, 0, 3, 1, 5},
	{3, 4, 5, 1, 6, 2, 0},
	{0, 2, 1, 6, 5, 4, 3},
	{4, 3, 6, 5, 2, 0, 1},
	{1, 5, 2, 4, 0, 3, 6},
	{6, 0, 3, 2, 1, 5, 4},
	{2, 1, 6, 3, 0, 4, 5},
	{5, 3, 0, 4, 6, 1, 2},
	{0, 4, 2, 5, 1, 6, 3},
	{3, 6, 4, 1, 5, 2, 0},
	{1, 2, 5, 0, 4, 3, 6},
	{6, 5, 1, 2, 3, 0, 4},
	{4, 0, 3, 6, 2, 5, 1},
	{0, 5, 2, 1, 6, 3, 4},
	{4, 3, 6, 2, 1, 5, 0},
	{1, 6, 3, 0, 4, 2, 5},
	{5, 2, 0, 4, 3, 6, 1},
	{6, 4, 1, 3, 5, 0, 2},
	{3, 0, 4, 5, 2, 1, 6},
	{2, 1, 5, 6, 0, 4, 3},
	{0, 5, 6, 1, 2, 3, 4},
	{4, 3, 1, 2, 6, 5, 0},
	{2, 6, 0, 5, 3, 4, 1},
	{1, 4, 3, 0, 5, 6, 2},
	{6, 2, 5, 4, 1, 0, 3},
	{5, 0, 2, 3, 4, 1, 6},
	{3, 1, 4, 6, 0, 2, 5},
	{1, 3, 4, 2, 0, 5, 6},
	{6, 5, 2, 0, 4, 3, 1},
	{3, 0, 5, 6, 1, 4, 2},
	{2, 4, 6, 1, 5, 0, 3},
	{0, 1, 3, 5, 2, 6, 4},
	{5, 6, 1, 4, 3, 2, 0},
	{4, 2, 0, 3, 6, 1, 5},
	{0, 2, 1, 6, 3, 4, 5},
	{5, 4, 6, 3, 1, 2, 0},
	{2, 3, 4, 0, 5, 1, 6},
	{1, 6, 5, 4, 0, 3, 2},
	{6, 0, 3, 2, 4, 5, 1},
	{4, 5, 0, 1, 2, 6, 3},
	{3, 1, 2, 5, 6, 0, 4},
	{3, 0, 4, 6, 5, 2, 1},
	{1, 2, 5, 4, 6, 0, 3},
	{6, 5, 1, 3, 0, 4, 2},
	{2, 4, 3, 0, 1, 5, 6},
	{0, 6, 2, 5, 3, 1, 4},
	{5, 1, 6, 2, 4, 3, 0},
	{4, 3, 1, 0, 2, 6, 5},
	{4, 2, 0, 1, 3, 5, 6},
	{6, 5, 3, 1, 0, 2, 4},
	{3, 0, 4, 5, 2, 6, 1},
	{1, 6, 2, 4, 5, 0, 3},
	{5, 3, 0, 6, 1, 4, 2},
	{2, 4, 5, 3, 6, 1, 0},
	{0, 1, 6, 2, 4, 3, 5},
	{4, 2, 6, 1, 0, 3, 5},
	{5, 3, 1, 0, 6, 2, 4},
	{2, 0, 3, 5, 4, 6, 1},
	{1, 6, 4, 3, 5, 0, 2},
	{6, 5, 0, 4, 2, 1, 3},
	{0, 1, 5, 2, 3, 4, 6},
	{3, 4, 2, 6, 1, 5, 0},
	{1, 3, 4, 2, 0, 6, 5},
	{5, 6, 2, 0, 4, 3, 1},
	{0, 1, 6, 5, 3, 4, 2},
	{4, 2, 3, 6, 5, 1, 0},
	{2, 5, 1, 3, 6, 0, 4},
	{3, 4, 0, 1, 2, 5, 6},
	{6, 0, 5, 4, 1, 2, 3},
	{1, 4, 0, 5, 6, 3, 2},
	{2, 3, 5, 6, 0, 4, 1},
	{6, 2, 1, 3, 4, 0, 5},
	{0, 5, 4, 1, 3, 2, 6},
	{4, 6, 3, 2, 1, 5, 0},
	{5, 0, 6, 4, 2, 1, 3},
	{3, 1, 2, 0, 5, 6, 4},
	{0, 3, 5, 2, 1, 4, 6},
	{6, 4, 1, 5, 2, 3, 0},
	{2, 0, 3, 1, 4, 6, 5},
	{5, 1, 4, 6, 3, 0, 2},
	{3, 6, 2, 4, 0, 5, 1},
	{1, 5, 0, 3, 6, 2, 4},
	{4, 2, 6, 0, 5, 1, 3},
	{4, 5, 0, 2, 6, 3, 1},
	{1, 3, 6, 0, 2, 5, 4},
	{2, 6, 1, 4, 5, 0, 3},
	{3, 0, 5, 1, 4, 6, 2},
	{5, 2, 4, 6, 3, 1, 0},
	{0, 4, 3, 5, 1, 2, 6},
	{6, 1, 2, 3, 0, 4, 5},
	{0, 6, 2, 3, 4, 1, 5},
	{5, 1, 3, 4, 2, 6, 0},
	{6, 4, 5, 2, 1, 0, 3},
	{3, 2, 0, 1, 5, 4, 6},
	{4, 0, 1, 6, 3, 5, 2},
	{1, 3, 6, 5, 0, 2, 4},
	{2, 5, 4, 0, 6, 3, 1},
	{6, 1, 4, 5, 0, 2, 3},
	{3, 2, 5, 0, 4, 1, 6},
	{2, 0, 3, 6, 1, 4, 5},
	{5, 4, 6, 1, 3, 0, 2},
	{0, 3, 1, 2, 6, 5, 4},
	{4, 5, 0, 3, 2, 6, 1},
	{1, 6, 2, 4, 5, 3, 0},
	{4, 5, 6, 2, 1, 0, 3},
	{3, 0, 2, 1, 6, 5, 4},
	{1, 6, 4, 0, 5, 3, 2},
	{2, 3, 0, 5, 4, 6, 1},
	{5, 1, 3, 4, 0, 2, 6},
	{6, 4, 5, 3, 2, 1, 0},
	{0, 2, 6, 1, 3, 4, 5},
	{2, 3, 1, 6, 0, 5, 4},
	{4, 5, 1, 0, 6, 3, 2},
	{6, 2, 0, 3, 4, 1, 5},
	{5, 1, 4, 2, 3, 0, 6},
	{0, 4, 5, 6, 1, 2, 3},
	{3, 0, 2, 4, 5, 6, 1},
	{1, 6, 3, 5, 2, 4, 0},
	{3, 1, 6, 0, 5, 4, 2},
	{2, 4, 5, 6, 0, 1, 3},
	{1, 5, 0, 4, 2, 3, 6},
	{6, 0, 2, 3, 4, 5, 1},
	{4, 3, 1, 2, 6, 0, 5},
	{0, 2, 3, 5, 1, 6, 4},
	{5, 6, 4, 1, 3, 2, 0},
	{5, 3, 4, 6, 2, 0, 1},
	{1, 0, 6, 2, 4, 3, 5},
	{2, 5, 0, 3, 1, 4, 6},
	{4, 6, 3, 1, 0, 5, 2},
	{0, 2, 1, 5, 3, 6, 4},
	{3, 1, 5, 4, 6, 2, 0},
	{6, 4, 2, 0, 5, 1, 3},
	{4, 6, 1, 5, 2, 0, 3},
	{3, 0, 2, 1, 5, 6, 4},
	{6, 4, 5, 3, 1, 2, 0},
	{1, 5, 0, 2, 3, 4, 6},
	{0, 2, 3, 6, 4, 5, 1},
	{2, 1, 4, 0, 6, 3, 5},
	{5, 3, 6, 4, 0, 1, 2},
	{3, 5, 4, 2, 0, 6, 1},
	{1, 6, 2, 0, 4, 5, 3},
	{6, 0, 1, 3, 5, 4, 2},
	{4, 2, 5, 1, 3, 0, 6},
	{0, 3, 6, 5, 2, 1, 4},
	{2, 4, 0, 6, 1, 3, 5},
	{5, 1, 3, 4, 6, 2, 0},
	{5, 4, 2, 6, 3, 1, 0},
	{0, 1, 3, 2, 6, 4, 5},
	{6, 3, 1, 5, 0, 2, 4},
	{4, 2, 5, 0, 1, 6, 3},
	{3, 0, 4, 1, 2, 5, 6},
	{1, 6, 0, 4, 5, 3, 2},
	{2, 5, 6, 3, 4, 0, 1},
	{6, 5, 2, 4, 3, 1, 0},
	{0, 1, 4, 3, 2, 5, 6},
	{3, 6, 1, 5, 0, 2, 4},
	{2, 4, 5, 0, 1, 6, 3},
	{1, 3, 0, 6, 5, 4, 2},
	{5, 0, 6, 2, 4, 3, 1},
	{4, 2, 3, 1, 6, 0, 5},
	{4, 2, 0, 3, 6, 5, 1},
	{1, 5, 3, 6, 0, 2, 4},
	{2, 4, 6, 0, 5, 1, 3},
	{3, 0, 1, 5, 4, 6, 2},
	{6, 1, 5, 2, 3, 4, 0},
	{0, 6, 2, 4, 1, 3, 5},
	{5, 3, 4, 1, 2, 0, 6},
	{4, 3, 2, 5, 6, 1, 0},
	{0, 1, 5, 6, 2, 3, 4},
	{6, 0, 4, 3, 5, 2, 1},
	{1, 5, 3, 2, 4, 0, 6},
	{2, 6, 1, 4, 0, 5, 3},
	{3, 2, 6, 0, 1, 4, 5},
	{5, 4, 0, 1, 3, 6, 2},
	{5, 1, 0, 4, 2, 6, 3},
	{3, 6, 4, 2, 0, 1, 5},
	{2, 3, 5, 1, 4, 0, 6},
	{0, 4, 6, 5, 1, 3, 2},
	{6, 2, 1, 3, 5, 4, 0},
	{1, 0, 2, 6, 3, 5, 4},
	{4, 5, 3, 0, 6, 2, 1},
	{1, 0, 4, 2, 5, 6, 3},
	{3, 6, 5, 4, 2, 0, 1},
	{0, 2, 3, 5, 1, 4, 6},
	{6, 4, 2, 1, 3, 5, 0},
	{5, 1, 6, 0, 4, 3, 2},
	{4, 3, 1, 6, 0, 2, 5},
	{2, 5, 0, 3, 6, 1, 4},
	{5, 2, 6, 3, 0, 4, 1},
	{1, 4, 0, 6, 3, 2, 5},
	{3, 5, 1, 2, 4, 6, 0},
	{0, 6, 2, 4, 1, 5, 3},
	{4, 3, 5, 1, 6, 0, 2},
	{6, 0, 3, 5, 2, 1, 4},
	{2, 1, 4, 0, 5, 3, 6},
	{2, 3, 0, 4, 6, 1, 5},
	{5, 1, 4, 6, 0, 3, 2},
	{6, 5, 3, 0, 4, 2, 1},
	{1, 4, 2, 5, 3, 0, 6},
	{0, 2, 6, 3, 1, 5, 4},
	{4, 0, 5, 1, 2, 6, 3},
	{3, 6, 1, 2, 5, 4, 0},
	{3, 1, 2, 6, 0, 4, 5},
	{5, 4, 0, 2, 6, 1, 3},
	{1, 3, 6, 0, 4, 5, 2},
	{2, 0, 4, 5, 3, 6, 1},
	{6, 5, 1, 4, 2, 3, 0},
	{0, 6, 3, 1, 5, 2, 4},
	{4, 2, 5, 3, 1, 0, 6},
	{4, 1, 5, 2, 6, 0, 3},
	{3, 0, 2, 6, 5, 1, 4},
	{1, 5, 6, 3, 2, 4, 0},
	{0, 2, 4, 5, 3, 6, 1},
	{6, 4, 3, 0, 1, 5, 2},
	{5, 3, 0, 1, 4, 2, 6},
	{2, 6, 1, 4, 0, 3, 5},
	{6, 2, 0, 3, 4, 5, 1},
	{1, 5, 4, 0, 3, 2, 6},
	{3, 4, 1, 6, 2, 0, 5},
	{5, 0, 2, 1, 6, 3, 4},
	{4, 6, 5, 2, 0, 1, 3},
	{2, 1, 3, 4, 5, 6, 0},
	{0, 3, 6, 5, 1, 4, 2},
	{1, 6, 3, 2, 5, 0, 4},
	{4, 0, 5, 3, 2, 6, 1},
	{2, 5, 4, 1, 6, 3, 0},
	{0, 3, 6, 4, 1, 5, 2},
	{6, 1, 2, 5, 0, 4, 3},
	{3, 2, 0, 6, 4, 1, 5},
	{5, 4, 1, 0, 3, 2, 6},
	{3, 0, 5, 4, 1, 6, 2},
	{2, 6, 4, 1, 5, 0, 3},
	{0, 3, 1, 5, 2, 4, 6},
	{4, 1, 6, 2, 3, 5, 0},
	{6, 5, 2, 3, 0, 1, 4},
	{1, 4, 3, 0, 6, 2, 5},
	{5, 2, 0, 6, 4, 3, 1},
	{3, 0, 4, 2, 5, 1, 6},
	{6, 1, 2, 5, 4, 0, 3},
	{0, 4, 5, 6, 2, 3, 1},
	{1, 5, 6, 3, 0, 2, 4},
	{4, 2, 3, 1, 6, 5, 0},
	{5, 6, 1, 0, 3, 4, 2},
	{2, 3, 0, 4, 1, 6, 5},
	{2, 0, 5, 6, 1, 3, 4},
	{4, 3, 1, 5, 6, 0, 2},
	{6, 2, 0, 3, 5, 4, 1},
	{1, 4, 3, 0, 2, 5, 6},
	{5, 1, 6, 4, 3, 2, 0},
	{0, 5, 2, 1, 4, 6, 3},
	{3, 6, 4, 2, 0, 5, 1},
	{0, 2, 3, 4, 6, 1, 5},
	{1, 5, 6, 3, 4, 2, 0},
	{4, 6, 5, 1, 2, 0, 3},
	{3, 0, 1, 2, 5, 6, 4},
	{2, 4, 0, 6, 3, 1, 5},
	{5, 3, 2, 0, 1, 4, 6},
	{6, 1, 4, 5, 0, 3, 2},
	{3, 6, 5, 4, 1, 0, 2},
	{2, 0, 4, 1, 5, 6, 3},
	{5, 1, 6, 0, 2, 3, 4},
	{4, 3, 2, 6, 0, 1, 5},
	{1, 2, 0, 3, 4, 5, 6},
	{6, 4, 1, 5, 3, 2, 0},
	{0, 5, 3, 2, 6, 4, 1},
	{2, 5, 1, 3, 0, 4, 6},
	{6, 4, 0, 1, 3, 5, 2},
	{3, 6, 5, 0, 4, 2, 1},
	{1, 0, 2, 4, 5, 6, 3},
	{4, 2, 3, 5, 6, 1, 0},
	{0, 1, 4, 6, 2, 3, 5},
	{5, 3, 6, 2, 1, 0, 4},
	{6, 3, 5, 0, 1, 2, 4},
	{4, 2, 0, 1, 5, 3, 6},
	{5, 1, 6, 2, 4, 0, 3},
	{3, 0, 2, 4, 6, 1, 5},
	{1, 4, 3, 6, 0, 5, 2},
	{2, 6, 1, 5, 3, 4, 0},
	{0, 5, 4, 3, 2, 6, 1},
	{0, 6, 2, 3, 5, 4, 1},
	{1, 4, 3, 5, 2, 6, 0},
	{6, 5, 4, 1, 0, 2, 3},
	{2, 3, 0, 4, 1, 5, 6},
	{3, 1, 5, 6, 4, 0, 2},
	{5, 0, 1, 2, 6, 3, 4},
	{4, 2, 6, 0, 3, 1, 5},
	{2, 0, 4, 5, 3, 1, 6},
	{6, 1, 5, 3, 4, 0, 2},
	{4, 3, 2, 1, 0, 6, 5},
	{5, 6, 1, 0, 2, 3, 4},
	{0, 2, 3, 4, 6, 5, 1},
	{3, 5, 6, 2, 1, 4, 0},
	{1, 4, 0, 6, 5, 2, 3},
	{5, 0, 1, 6, 4, 3, 2},
	{2, 3, 4, 1, 6, 0, 5},
	{6, 4, 3, 2, 0, 5, 1},
	{1, 5, 0, 3, 2, 4, 6},
	{0, 6, 2, 4, 5, 1, 3},
	{3, 2, 5, 0, 1, 6, 4},
	{4, 1, 6, 5, 3, 2, 0},
	{5, 4, 1, 6, 2, 3, 0},
	{0, 3, 2, 1, 6, 4, 5},
	{4, 2, 6, 3, 5, 0, 1},
	{1, 0, 5, 2, 3, 6, 4},
	{3, 6, 0, 5, 4, 1, 2},
	{6, 5, 4, 0, 1, 2, 3},
	{2, 1, 3, 4, 0, 5, 6},
	{1, 0, 4, 6, 3, 2, 5},
	{5, 2, 3, 4, 6, 0, 1},
	{6, 3, 1, 2, 5, 4, 0},
	{0, 4, 2, 5, 1, 3, 6},
	{3, 5, 6, 0, 4, 1, 2},
	{2, 1, 5, 3, 0, 6, 4},
	{4, 6, 0, 1, 2, 5, 3},
	{1, 4, 2, 0, 6, 3, 5},
	{5, 0, 6, 3, 2, 4, 1},
	{6, 3, 5, 1, 4, 2, 0},
	{2, 1, 0, 4, 3, 5, 6},
	{4, 5, 3, 6, 0, 1, 2},
	{0, 2, 4, 5, 1, 6, 3},
	{3, 6, 1, 2, 5, 0, 4},
	{2, 1, 0, 6, 3, 5, 4},
	{4, 5, 6, 3, 0, 1, 2},
	{5, 4, 3, 2, 1, 0, 6},
	{6, 0, 2, 1, 4, 3, 5},
	{3, 6, 1, 5, 2, 4, 0},
	{1, 2, 4, 0, 5, 6, 3},
	{0, 3, 5, 4, 6, 2, 1},
	{0, 3, 6, 4, 5, 1, 2},
	{2, 1, 5, 6, 4, 3, 0},
	{3, 0, 4, 5, 1, 2, 6},
	{6, 5, 2, 1, 0, 4, 3},
	{4, 2, 1, 3, 6, 0, 5},
	{5, 4, 3, 0, 2, 6, 1},
	{1, 6, 0, 2, 3, 5, 4},
	{1, 2, 0, 6, 3, 4, 5},
	{5, 4, 3, 0, 6, 2, 1},
	{3, 1, 6, 4, 2, 5, 0},
	{0, 5, 4, 2, 1, 6, 3},
	{2, 6, 5, 3, 0, 1, 4},
	{6, 0, 1, 5, 4, 3, 2},
	{4, 3, 2, 1, 5, 0, 6},
	{2, 4, 5, 1, 6, 0, 3},
	{3, 0, 6, 5, 1, 4, 2},
	{1, 3, 2, 4, 0, 6, 5},
	{5, 6, 4, 0, 2, 3, 1},
	{0, 1, 3, 2, 4, 5, 6},
	{4, 5, 1, 6, 3, 2, 0},
	{6, 2, 0, 3, 5, 1, 4},
	{6, 1, 5, 0, 2, 3, 4},
	{4, 3, 0, 2, 5, 1, 6},
	{2, 6, 3, 4, 1, 5, 0},
	{0, 5, 1, 3, 4, 6, 2},
	{5, 2, 4, 6, 3, 0, 1},
	{3, 4, 6, 1, 0, 2, 5},
	{1, 0, 2, 5, 6, 4, 3},
	{0, 6, 1, 2, 4, 5, 3},
	{3, 5, 4, 1, 2, 6, 0},
	{2, 0, 6, 4, 5, 3, 1},
	{1, 3, 5, 0, 6, 4, 2},
	{4, 2, 3, 6, 1, 0, 5},
	{6, 1, 0, 5, 3, 2, 4},
	{5, 4, 2, 3, 0, 1, 6},
	{3, 4, 5, 2, 0, 1, 6},
	{6, 1, 0, 5, 2, 4, 3},
	{2, 0, 1, 3, 4, 6, 5},
	{5, 6, 4, 1, 3, 0, 2},
	{0, 3, 2, 4, 6, 5, 1},
	{4, 5, 3, 6, 1, 2, 0},
	{1, 2, 6, 0, 5, 3, 4},
	{6, 2, 1, 4, 5, 0, 3},
	{3, 0, 5, 1, 4, 2, 6},
	{5, 6, 4, 2, 0, 3, 1},
	{1, 3, 0, 6, 2, 4, 5},
	{2, 4, 3, 5, 1, 6, 0},
	{4, 1, 6, 0, 3, 5, 2},
	{0, 5, 2, 3, 6, 1, 4},
	{1, 6, 3, 4, 2, 5, 0},
	{0, 5, 2, 3, 4, 6, 1},
	{4, 2, 0, 1, 6, 3, 5},
	{5, 3, 6, 0, 1, 4, 2},
	{2, 1, 4, 6, 5, 0, 3},
	{3, 4, 1, 5, 0, 2, 6},
	{6, 0, 5, 2, 3, 1, 4},
	{5, 0, 6, 1, 4, 3, 2},
	{2, 3, 4, 0, 1, 6, 5},
	{6, 1, 3, 2, 5, 0, 4},
	{4, 2, 5, 3, 0, 1, 6},
	{1, 5, 0, 4, 6, 2, 3},
	{0, 6, 2, 5, 3, 4, 1},
	{3, 4, 1, 6, 2, 5, 0},
	{3, 5, 2, 4, 0, 6, 1},
	{1, 6, 4, 0, 2, 5, 3},
	{5, 0, 3, 2, 6, 1, 4},
	{4, 1, 0, 6, 3, 2, 5},
	{6, 2, 5, 1, 4, 3, 0},
	{2, 4, 1, 3, 5, 0, 6},
	{0, 3, 5, 6, 1, 4, 2},
	{3, 2, 6, 5, 0, 4, 1},
	{1, 6, 0, 4, 5, 2, 3},
	{4, 1, 3, 5, 2, 0, 6},
	{0, 5, 6, 2, 3, 1, 4},
	{2, 4, 1, 3, 6, 5, 0},
	{6, 0, 4, 5, 1, 3, 2},
	{0, 3, 2, 1, 4, 6, 5},
	{5, 6, 4, 0, 1, 3, 2},
	{2, 3, 1, 4, 5, 6, 0},
	{3, 5, 0, 1, 4, 2, 6},
	{6, 1, 5, 2, 0, 4, 3},
	{4, 2, 3, 0, 6, 5, 1},
	{1, 4, 6, 3, 2, 0, 5},
	{5, 0, 2, 6, 3, 1, 4},
	{3, 2, 0, 5, 6, 4, 1},
	{1, 4, 5, 6, 0, 2, 3},
	{6, 3, 2, 4, 1, 0, 5},
	{0, 5, 4, 1, 2, 3, 6},
	{2, 1, 6, 3, 4, 5, 0},
	{5, 0, 1, 2, 3, 6, 4},
	{4, 6, 3, 0, 5, 1, 2},
	{0, 5, 6, 4, 1, 3, 2},
	{2, 3, 4, 1, 6, 5, 0},
	{6, 2, 1, 0, 5, 4, 3},
	{3, 1, 0, 5, 4, 2, 6},
	{5, 4, 3, 6, 2, 0, 1},
	{4, 6, 2, 3, 0, 1, 5},
	{1, 5, 0, 2, 3, 6, 4},
	{4, 0, 5, 1, 6, 3, 2},
	{2, 3, 6, 5, 1, 0, 4},
	{1, 0, 3, 6, 2, 4, 5},
	{6, 4, 5, 2, 0, 1, 3},
	{3, 1, 2, 0, 4, 5, 6},
	{5, 2, 1, 4, 3, 6, 0},
	{0, 6, 4, 3, 5, 2, 1},
	{5, 4, 0, 6, 1, 3, 2},
	{2, 3, 1, 0, 6, 4, 5},
	{1, 2, 6, 5, 4, 0, 3},
	{3, 0, 4, 2, 5, 6, 1},
	{6, 1, 5, 4, 3, 2, 0},
	{0, 6, 3, 1, 2, 5, 4},
	{4, 5, 2, 3, 0, 1, 6},
	{0, 3, 4, 2, 5, 6, 1},
	{1, 6, 2, 5, 4, 3, 0},
	{3, 4, 5, 6, 0, 1, 2},
	{2, 5, 1, 0, 6, 4, 3},
	{6, 0, 3, 4, 1, 2, 5},
	{4, 1, 0, 3, 2, 5, 6},
	{5, 2, 6, 1, 3, 0, 4},
	{5, 3, 2, 4, 0, 1, 6},
	{6, 1, 0, 2, 4, 3, 5},
	{4, 0, 1, 6, 5, 2, 3},
	{3, 2, 5, 1, 6, 0, 4},
	{0, 4, 6, 3, 1, 5, 2},
	{2, 5, 4, 0, 3, 6, 1},
	{1, 3, 6, 5, 2, 4, 0},
	{5, 6, 3, 4, 2, 1, 0},
	{0, 1, 4, 2, 6, 3, 5},
	{6, 2, 1, 5, 3, 0, 4},
	{4, 0, 5, 3, 1, 2, 6},
	{3, 6, 2, 0, 5, 4, 1},
	{2, 5, 0, 1, 4, 6, 3},
	{1, 3, 4, 6, 0, 5, 2},
	{6, 4, 3, 1, 0, 5, 2},
	{2, 5, 1, 0, 4, 3, 6},
	{4, 0, 5, 2, 6, 1, 3},
	{3, 1, 2, 6, 5, 0, 4},
	{5, 6, 0, 3, 2, 4, 1},
	{1, 4, 6, 5, 3, 2, 0},
	{0, 2, 3, 4, 1, 6, 5},
	{1, 2, 0, 3, 5, 6, 4},
	{4, 5, 3, 6, 0, 2, 1},
	{6, 1, 4, 0, 2, 3, 5},
	{5, 3, 2, 4, 6, 1, 0},
	{0, 6, 1, 5, 3, 4, 2},
	{3, 4, 5, 2, 1, 0, 6},
	{2, 0, 6, 1, 4, 5, 3},
	{1, 3, 6, 4, 0, 2, 5},
	{5, 2, 4, 0, 6, 3, 1},
	{0, 1, 2, 3, 5, 6, 4},
	{6, 4, 5, 2, 3, 1, 0},
	{2, 0, 3, 5, 1, 4, 6},
	{4, 5, 1, 6, 2, 0, 3},
	{3, 6, 0, 1, 4, 5, 2},
	{6, 0, 2, 4, 1, 3, 5},
	{5, 3, 4, 1, 0, 2, 6},
	{2, 1, 6, 3, 5, 0, 4},
	{4, 5, 3, 0, 6, 1, 2},
	{0, 2, 1, 6, 4, 5, 3},
	{3, 4, 0, 5, 2, 6, 1},
	{1, 6, 5, 2, 3, 4, 0},
	{4, 6, 1, 2, 0, 3, 5},
	{5, 3, 0, 1, 2, 6, 4},
	{2, 0, 5, 4, 6, 1, 3},
	{3, 1, 6, 5, 4, 0, 2},
	{6, 4, 2, 0, 3, 5, 1},
	{1, 2, 3, 6, 5, 4, 0},
	{0, 5, 4, 3, 1, 2, 6},
	{1, 0, 3, 2, 5, 4, 6},
	{6, 4, 5, 3, 2, 0, 1},
	{2, 5, 1, 0, 4, 6, 3},
	{3, 6, 0, 4, 1, 2, 5},
	{5, 2, 4, 1, 6, 3, 0},
	{0, 1, 2, 6, 3, 5, 4},
	{4, 3, 6, 5, 0, 1, 2},
	{1, 0, 3, 4, 5, 6, 2},
	{2, 6, 4, 5, 3, 0, 1},
	{0, 1, 5, 3, 4, 2, 6},
	{3, 4, 6, 2, 1, 5, 0},
	{6, 5, 2, 1, 0, 3, 4},
	{4, 3, 0, 6, 2, 1, 5},
	{5, 2, 1, 0, 6, 4, 3},
	{6, 2, 3, 1, 4, 0, 5},
	{5, 0, 4, 3, 1, 2, 6},
	{4, 6, 1, 2, 0, 5, 3},
	{3, 5, 0, 6, 2, 1, 4},
	{2, 1, 5, 4, 3, 6, 0},
	{0, 3, 2, 5, 6, 4, 1},
	{1, 4, 6, 0, 5, 3, 2},
	{3, 0, 5, 6, 4, 1, 2},
	{2, 1, 4, 5, 6, 0, 3},
	{0, 6, 1, 4, 2, 3, 5},
	{5, 3, 6, 2, 1, 4, 0},
	{1, 4, 2, 3, 0, 5, 6},
	{6, 5, 0, 1, 3, 2, 4},
	{4, 2, 3, 0, 5, 6, 1},
	{5, 2, 4, 1, 6, 0, 3},
	{3, 0, 6, 4, 1, 2, 5},
	{1, 5, 2, 6, 0, 3, 4},
	{4, 6, 3, 0, 2, 5, 1},
	{0, 3, 1, 2, 5, 4, 6},
	{2, 1, 5, 3, 4, 6, 0},
	{6, 4, 0, 5, 3, 1, 2},
	{6, 3, 4, 5, 2, 1, 0},
	{0, 1, 5, 2, 4, 3, 6},
	{4, 6, 2, 3, 5, 0, 1},
	{1, 5, 0, 6, 3, 2, 4},
	{2, 0, 3, 4, 1, 6, 5},
	{3, 4, 1, 0, 6, 5, 2},
	{5, 2, 6, 1, 0, 4, 3},
	{0, 2, 5, 6, 4, 1, 3},
	{3, 1, 6, 4, 5, 2, 0},
	{5, 0, 4, 2, 1, 3, 6},
	{6, 4, 1, 3, 2, 0, 5},
	{2, 3, 0, 5, 6, 4, 1},
	{4, 5, 3, 1, 0, 6, 2},
	{1, 6, 2, 0, 3, 5, 4},
	{1, 3, 0, 4, 2, 6, 5},
	{5, 6, 2, 0, 3, 4, 1},
	{4, 2, 6, 5, 1, 3, 0},
	{0, 5, 1, 3, 4, 2, 6},
	{6, 1, 3, 2, 0, 5, 4},
	{3, 4, 5, 1, 6, 0, 2},
	{2, 0, 4, 6, 5, 1, 3},
	{4, 0, 2, 3, 1, 5, 6},
	{6, 5, 3, 1, 2, 0, 4},
	{1, 6, 5, 4, 0, 2, 3},
	{3, 2, 4, 0, 5, 6, 1},
	{2, 1, 0, 6, 4, 3, 5},
	{0, 3, 1, 5, 6, 4, 2},
	{5, 4, 6, 2, 3, 1, 0},
	{5, 3, 0, 2, 6, 1, 4},
	{4, 1, 6, 0, 2, 3, 5},
	{2, 6, 1, 4, 3, 5, 0},
	{0, 5, 4, 3, 1, 6, 2},
	{3, 2, 5, 6, 4, 0, 1},
	{1, 4, 3, 5, 0, 2, 6},
	{6, 0, 2, 1, 5, 4, 3},
	{1, 6, 4, 5, 2, 0, 3},
	{3, 0, 5, 2, 4, 6, 1},
	{2, 1, 0, 6, 5, 3, 4},
	{5, 4, 3, 0, 6, 1, 2},
	{4, 3, 6, 1, 0, 2, 5},
	{0, 2, 1, 4, 3, 5, 6},
	{6, 5, 2, 3, 1, 4, 0},
	{2, 6, 4, 5, 0, 1, 3},
	{3, 1, 5, 0, 4, 6, 2},
	{0, 2, 6, 4, 5, 3, 1},
	{1, 4, 3, 6, 2, 5, 0},
	{5, 3, 0, 1, 6, 2, 4},
	{4, 5, 1, 2, 3, 0, 6},
	{6, 0, 2, 3, 1, 4, 5},
	{3, 4, 2, 1, 0, 6, 5},
	{5, 6, 0, 4, 1, 2, 3},
	{2, 1, 5, 0, 6, 3, 4},
	{0, 3, 4, 6, 5, 1, 2},
	{1, 2, 6, 5, 3, 4, 0},
	{6, 5, 3, 2, 4, 0, 1},
	{4, 0, 1, 3, 2, 5, 6},
	{2, 6, 1, 0, 3, 4, 5},
	{5, 4, 3, 1, 0, 6, 2},
	{0, 3, 4, 5, 6, 2, 1},
	{1, 2, 5, 6, 4, 3, 0},
	{6, 0, 2, 3, 5, 1, 4},
	{3, 1, 0, 4, 2, 5, 6},
	{4, 5, 6, 2, 0, 1, 3},
	{6, 4, 5, 3, 1, 0, 2},
	{2, 1, 3, 0, 5, 4, 6},
	{4, 0, 1, 5, 2, 6, 3},
	{3, 5, 2, 6, 1, 0, 4},
	{0, 6, 4, 1, 3, 2, 5},
	{1, 3, 6, 2, 4, 5, 0},
	{5, 2, 0, 4, 6, 3, 1},
	{5, 2, 1, 3, 4, 6, 0},
	{0, 6, 3, 4, 1, 2, 5},
	{6, 5, 4, 2, 0, 1, 3},
	{3, 1, 2, 0, 5, 4, 6},
	{4, 0, 6, 1, 3, 5, 2},
	{2, 4, 0, 5, 6, 3, 1},
	{1, 3, 5, 6, 2, 0, 4},
	{5, 2, 1, 3, 6, 0, 4},
	{4, 0, 3, 6, 1, 2, 5},
	{6, 4, 0, 2, 5, 3, 1},
	{1, 3, 5, 0, 2, 4, 6},
	{2, 1, 6, 4, 0, 5, 3},
	{3, 5, 2, 1, 4, 6, 0},
	{0, 6, 4, 5, 3, 1, 2},
	{6, 5, 0, 1, 3, 4, 2},
	{2, 4, 1, 3, 0, 5, 6},
	{3, 6, 5, 0, 2, 1, 4},
	{4, 1, 2, 6, 5, 3, 0},
	{0, 3, 4, 2, 1, 6, 5},
	{1, 0, 6, 5, 4, 2, 3},
	{2, 5, 3, 4, 6, 0, 1},
	{5, 2, 4, 0, 3, 6, 1},
	{1, 6, 3, 4, 0, 5, 2},
	{0, 3, 5, 1, 4, 2, 6},
	{6, 4, 2, 5, 1, 3, 0},
	{3, 0, 1, 6, 2, 4, 5},
	{4, 1, 6, 2, 5, 0, 3},
	{5, 2, 0, 3, 6, 1, 4},
	{2, 5, 6, 1, 0, 4, 3},
	{3, 4, 0, 6, 1, 5, 2},
	{5, 2, 1, 4, 6, 3, 0},
	{0, 6, 4, 3, 2, 1, 5},
	{1, 3, 5, 0, 4, 2, 6},
	{4, 0, 3, 2, 5, 6, 1},
	{6, 1, 2, 5, 3, 0, 4},
	{3, 1, 2, 6, 0, 5, 4},
	{4, 5, 6, 0, 2, 1, 3},
	{0, 2, 5, 1, 4, 3, 6},
	{6, 3, 4, 5, 1, 2, 0},
	{2, 0, 1, 4, 3, 6, 5},
	{1, 6, 0, 3, 5, 4, 2},
	{5, 4, 3, 2, 6, 0, 1},
	{3, 4, 0, 5, 1, 6, 2},
	{2, 6, 5, 1, 0, 4, 3},
	{4, 3, 1, 0, 6, 2, 5},
	{5, 1, 6, 2, 3, 0, 4},
	{0, 2, 4, 6, 5, 3, 1},
	{6, 5, 2, 3, 4, 1, 0},
	{1, 0, 3, 4, 2, 5, 6},
	{0, 1, 2, 5, 6, 3, 4},
	{4, 3, 5, 6, 2, 1, 0},
	{6, 2, 4, 0, 1, 5, 3},
	{3, 5, 1, 4, 0, 2, 6},
	{1, 0, 6, 3, 5, 4, 2},
	{5, 6, 3, 2, 4, 0, 1},
	{2, 4, 0, 3, 1, 6, 5},
	{2, 5, 6, 1, 3, 0, 4},
	{4, 0, 3, 1, 6, 5, 2},
	{0, 1, 4, 2, 5, 3, 6},
	{6, 3, 2, 5, 4, 1, 0},
	{5, 6, 1, 0, 2, 4, 3},
	{3, 4, 5, 6, 0, 2, 1},
	{1, 2, 0, 4, 3, 6, 5},
	{4, 2, 3, 0, 1, 6, 5},
	{5, 6, 0, 1, 3, 2, 4},
	{1, 4, 2, 6, 5, 3, 0},
	{3, 0, 5, 2, 6, 4, 1},
	{0, 1, 6, 4, 2, 5, 3},
	{6, 3, 1, 5, 4, 0, 2},
	{2, 5, 4, 3, 0, 1, 6},
	{3, 2, 6, 4, 1, 0, 5},
	{5, 0, 1, 6, 4, 2, 3},
	{4, 1, 5, 3, 2, 6, 0},
	{0, 6, 3, 2, 5, 1, 4},
	{2, 4, 0, 1, 3, 5, 6},
	{1, 5, 4, 0, 6, 3, 2},
	{6, 3, 2, 5, 0, 4, 1},
	{5, 2, 3, 6, 1, 0, 4},
	{4, 0, 6, 1, 3, 2, 5},
	{0, 1, 4, 5, 2, 3, 6},
	{3, 6, 5, 2, 4, 1, 0},
	{1, 4, 2, 0, 6, 5, 3},
	{2, 3, 0, 4, 5, 6, 1},
	{6, 5, 3, 1, 0, 4, 2},
	{0, 5, 1, 3, 6, 4, 2},
	{2, 4, 6, 3, 1, 5, 0},
	{1, 6, 0, 5, 2, 3, 4},
	{4, 3, 5, 2, 0, 6, 1},
	{6, 2, 1, 4, 3, 0, 5},
	{3, 1, 4, 0, 5, 2, 6},
	{5, 0, 2, 6, 4, 1, 3},
	{1, 2, 6, 5, 0, 3, 4},
	{4, 0, 5, 3, 6, 2, 1},
	{3, 4, 1, 2, 5, 6, 0},
	{0, 6, 2, 1, 3, 4, 5},
	{5, 3, 4, 6, 1, 0, 2},
	{2, 5, 3, 0, 4, 1, 6},
	{6, 1, 0, 4, 2, 5, 3},
	{6, 0, 5, 4, 2, 1, 3},
	{3, 1, 2, 5, 4, 0, 6},
	{2, 6, 4, 0, 3, 5, 1},
	{1, 5, 3, 6, 0, 4, 2},
	{4, 2, 0, 3, 1, 6, 5},
	{5, 4, 1, 2, 6, 3, 0},
	{0, 3, 6, 1, 5, 2, 4},
	{5, 1, 3, 6, 0, 4, 2},
	{2, 4, 6, 0, 3, 1, 5},
	{0, 3, 4, 5, 1, 2, 6},
	{6, 2, 1, 4, 5, 3, 0},
	{3, 5, 0, 1, 2, 6, 4},
	{4, 0, 2, 3, 6, 5, 1},
	{1, 6, 5, 2, 4, 0, 3},
	{0, 4, 5, 1, 6, 3, 2},
	{2, 6, 1, 3, 5, 4, 0},
	{3, 2, 0, 5, 4, 1, 6},
	{6, 1, 4, 0, 3, 2, 5},
	{5, 3, 6, 4, 2, 0, 1},
	{1, 5, 3, 2, 0, 6, 4},
	{4, 0, 2, 6, 1, 5, 3},
	{1, 6, 0, 2, 4, 5, 3},
	{3, 5, 4, 6, 2, 0, 1},
	{5, 0, 2, 4, 1, 3, 6},
	{6, 2, 3, 1, 0, 4, 5},
	{4, 3, 1, 0, 5, 6, 2},
	{2, 4, 6, 5, 3, 1, 0},
	{0, 1, 5, 3, 6, 2, 4},
	{2, 5, 1, 6, 0, 3, 4},
	{4, 3, 0, 1, 6, 5, 2},
	{6, 4, 2, 5, 1, 0, 3},
	{3, 0, 5, 4, 2, 1, 6},
	{1, 2, 6, 0, 3, 4, 5},
	{5, 1, 3, 2, 4, 6, 0},
	{0, 4, 6, 3, 5, 2, 1},
	{0, 6, 4, 1, 2, 5, 3},
	{3, 5, 2, 6, 1, 4, 0},
	{5, 0, 1, 3, 4, 6, 2},
	{2, 1, 3, 4, 6, 0, 5},
	{4, 6, 5, 0, 3, 2, 1},
	{1, 2, 4, 5, 0, 3, 6},
	{6, 3, 0, 2, 5, 1, 4},
	{2, 6, 3, 1, 5, 0, 4},
	{4, 0, 5, 3, 1, 6, 2},
	{1, 2, 0, 5, 6, 4, 3},
	{3, 5, 6, 4, 0, 2, 1},
	{0, 4, 1, 6, 2, 3, 5},
	{6, 1, 4, 2, 3, 5, 0},
	{5, 3, 2, 0, 4, 1, 6},
	{0, 3, 5, 4, 2, 6, 1},
	{1, 6, 4, 2, 5, 3, 0},
	{3, 2, 6, 5, 1, 0, 4},
	{4, 5, 1, 0, 6, 2, 3},
	{2, 0, 3, 6, 4, 1, 5},
	{5, 1, 2, 3, 0, 4, 6},
	{6, 0, 4, 1, 3, 5, 2},
	{6, 4, 0, 3, 2, 1, 5},
	{5, 1, 2, 4, 3, 0, 6},
	{1, 3, 0, 5, 4, 6, 2},
	{2, 4, 6, 0, 5, 3, 1},
	{3, 6, 5, 1, 0, 2, 4},
	{0, 5, 1, 2, 6, 4, 3},
	{4, 2, 3, 6, 1, 5, 0},
	{6, 3, 4, 2, 1, 5, 0},
	{0, 5, 1, 4, 2, 3, 6},
	{2, 1, 0, 5, 4, 6, 3},
	{3, 4, 6, 0, 5, 2, 1},
	{1, 6, 5, 3, 0, 4, 2},
	{4, 0, 2, 6, 3, 1, 5},
	{5, 2, 3, 1, 6, 0, 4},
	{5, 0, 6, 1, 3, 2, 4},
	{4, 3, 2, 6, 1, 0, 5},
	{2, 4, 1, 5, 0, 6, 3},
	{3, 1, 5, 0, 6, 4, 2},
	{6, 2, 0, 4, 5, 3, 1},
	{1, 6, 3, 2, 4, 5, 0},
	{0, 5, 4, 3, 2, 1, 6},
	{3, 2, 5, 4, 0, 6, 1},
	{1, 6, 4, 0, 5, 2, 3},
	{2, 0, 3, 5, 6, 1, 4},
	{4, 5, 6, 1, 3, 0, 2},
	{0, 1, 2, 6, 4, 3, 5},
	{6, 4, 1, 3, 2, 5, 0},
	{5, 3, 0, 2, 1, 4, 6},
	{0, 1, 5, 3, 4, 6, 2},
	{2, 6, 3, 4, 5, 1, 0},
	{5, 4, 6, 1, 2, 0, 3},
	{3, 0, 1, 2, 6, 4, 5},
	{4, 2, 0, 5, 1, 3, 6},
	{1, 3, 2, 6, 0, 5, 4},
	{6, 5, 4, 0, 3, 2, 1},
};

uint8_t PERM_SEQ_8[840][8] = {
	{0, 1, 2, 3, 4, 5, 6, 7},
	{7, 6, 5, 4, 3, 2, 1, 0},
	{6, 7, 4, 5, 2, 3, 0, 1},
	{1, 0, 3, 2, 5, 4, 7, 6},
	{5, 3, 7, 1, 6, 0, 4, 2},
	{2, 4, 0, 6, 1, 7, 3, 5},
	{4, 2, 6, 0, 7, 1, 5, 3},
	{3, 5, 1, 7, 0, 6, 2, 4},
	{1, 3, 7, 5, 2, 0, 4, 6},
	{6, 4, 0, 2, 5, 7, 3, 1},
	{7, 6, 2, 4, 3, 5, 1, 0},
	{0, 1, 5, 3, 4, 2, 6, 7},
	{5, 0, 3, 1, 6, 4, 7, 2},
	{2, 7, 4, 6, 1, 3, 0, 5},
	{4, 2, 1, 0, 7, 6, 5, 3},
	{3, 5, 6, 7, 0, 1, 2, 4},
	{3, 0, 6, 2, 5, 1, 4, 7},
	{7, 4, 1, 5, 2, 6, 0, 3},
	{0, 2, 7, 1, 4, 5, 3, 6},
	{6, 3, 5, 4, 1, 7, 2, 0},
	{5, 6, 4, 3, 7, 0, 1, 2},
	{2, 1, 0, 7, 3, 4, 6, 5},
	{1, 7, 3, 6, 0, 2, 5, 4},
	{4, 5, 2, 0, 6, 3, 7, 1},
	{4, 2, 5, 6, 1, 3, 0, 7},
	{7, 0, 3, 1, 6, 5, 2, 4},
	{6, 1, 7, 3, 2, 4, 5, 0},
	{0, 5, 4, 2, 3, 7, 1, 6},
	{5, 3, 0, 4, 7, 2, 6, 1},
	{1, 6, 2, 7, 4, 0, 3, 5},
	{2, 4, 1, 0, 5, 6, 7, 3},
	{3, 7, 6, 5, 0, 1, 4, 2},
	{7, 0, 3, 6, 4, 5, 2, 1},
	{1, 2, 5, 4, 6, 3, 0, 7},
	{0, 1, 2, 5, 7, 4, 3, 6},
	{6, 3, 4, 7, 5, 2, 1, 0},
	{3, 4, 6, 1, 2, 0, 7, 5},
	{5, 7, 0, 2, 1, 6, 4, 3},
	{2, 5, 7, 0, 3, 1, 6, 4},
	{4, 6, 1, 3, 0, 7, 5, 2},
	{6, 5, 1, 7, 4, 3, 0, 2},
	{2, 0, 3, 4, 7, 1, 5, 6},
	{7, 6, 4, 3, 1, 5, 2, 0},
	{0, 2, 5, 1, 3, 4, 6, 7},
	{4, 1, 0, 2, 5, 6, 7, 3},
	{3, 7, 6, 5, 2, 0, 1, 4},
	{5, 3, 2, 0, 6, 7, 4, 1},
	{1, 4, 7, 6, 0, 2, 3, 5},
	{0, 3, 6, 1, 7, 4, 2, 5},
	{5, 2, 4, 7, 1, 6, 3, 0},
	{2, 7, 1, 5, 6, 3, 0, 4},
	{4, 0, 3, 6, 5, 1, 7, 2},
	{3, 4, 5, 0, 2, 7, 6, 1},
	{1, 6, 7, 2, 0, 5, 4, 3},
	{6, 1, 0, 4, 3, 2, 5, 7},
	{7, 5, 2, 3, 4, 0, 1, 6},
	{7, 4, 5, 2, 1, 6, 0, 3},
	{3, 0, 6, 1, 2, 5, 4, 7},
	{1, 7, 2, 3, 6, 4, 5, 0},
	{0, 5, 4, 6, 3, 2, 7, 1},
	{5, 6, 0, 4, 7, 3, 1, 2},
	{2, 1, 3, 7, 4, 0, 6, 5},
	{4, 2, 1, 0, 5, 7, 3, 6},
	{6, 3, 7, 5, 0, 1, 2, 4},
	{3, 0, 6, 2, 7, 5, 1, 4},
	{4, 1, 5, 7, 2, 6, 0, 3},
	{7, 3, 2, 5, 0, 1, 4, 6},
	{6, 4, 1, 0, 5, 2, 3, 7},
	{5, 6, 0, 4, 1, 3, 7, 2},
	{2, 7, 3, 1, 4, 0, 6, 5},
	{1, 2, 4, 6, 3, 7, 5, 0},
	{0, 5, 7, 3, 6, 4, 2, 1},
	{0, 6, 7, 4, 3, 1, 2, 5},
	{5, 2, 1, 3, 4, 7, 6, 0},
	{2, 5, 3, 1, 7, 4, 0, 6},
	{6, 0, 4, 7, 1, 3, 5, 2},
	{1, 4, 0, 6, 5, 2, 7, 3},
	{3, 7, 2, 5, 6, 0, 4, 1},
	{7, 3, 6, 0, 2, 5, 1, 4},
	{4, 1, 5, 2, 0, 6, 3, 7},
	{4, 5, 3, 0, 2, 7, 6, 1},
	{1, 6, 7, 2, 0, 3, 5, 4},
	{6, 1, 2, 7, 5, 0, 4, 3},
	{3, 4, 0, 5, 7, 2, 1, 6},
	{0, 3, 5, 4, 1, 6, 7, 2},
	{2, 7, 6, 1, 4, 5, 3, 0},
	{7, 2, 4, 3, 6, 1, 0, 5},
	{5, 0, 1, 6, 3, 4, 2, 7},
	{1, 5, 2, 7, 3, 4, 0, 6},
	{6, 0, 4, 3, 7, 2, 5, 1},
	{3, 6, 0, 4, 5, 7, 1, 2},
	{2, 1, 7, 5, 4, 0, 6, 3},
	{4, 2, 6, 1, 0, 5, 3, 7},
	{7, 3, 5, 0, 1, 6, 2, 4},
	{5, 7, 1, 6, 2, 3, 4, 0},
	{0, 4, 3, 2, 6, 1, 7, 5},
	{0, 7, 2, 6, 3, 1, 5, 4},
	{4, 5, 1, 3, 6, 2, 7, 0},
	{7, 4, 0, 1, 5, 6, 2, 3},
	{3, 2, 6, 5, 1, 0, 4, 7},
	{1, 3, 5, 2, 4, 7, 0, 6},
	{6, 0, 7, 4, 2, 5, 3, 1},
	{2, 6, 3, 0, 7, 4, 1, 5},
	{5, 1, 4, 7, 0, 3, 6, 2},
	{5, 4, 6, 0, 3, 1, 2, 7},
	{7, 2, 1, 3, 0, 6, 4, 5},
	{0, 6, 3, 5, 4, 2, 7, 1},
	{1, 7, 2, 4, 5, 3, 6, 0},
	{4, 1, 5, 7, 2, 0, 3, 6},
	{6, 3, 0, 2, 7, 5, 1, 4},
	{3, 0, 7, 6, 1, 4, 5, 2},
	{2, 5, 4, 1, 6, 7, 0, 3},
	{2, 1, 7, 6, 5, 4, 3, 0},
	{0, 3, 4, 5, 6, 7, 1, 2},
	{1, 2, 5, 3, 0, 6, 4, 7},
	{7, 4, 6, 0, 3, 5, 2, 1},
	{6, 7, 3, 4, 2, 1, 0, 5},
	{5, 0, 1, 2, 4, 3, 7, 6},
	{4, 5, 0, 7, 1, 2, 6, 3},
	{3, 6, 2, 1, 7, 0, 5, 4},
	{2, 3, 0, 7, 5, 6, 4, 1},
	{1, 4, 6, 5, 7, 0, 3, 2},
	{5, 6, 1, 0, 3, 7, 2, 4},
	{4, 2, 7, 3, 0, 1, 6, 5},
	{7, 1, 4, 2, 6, 3, 5, 0},
	{0, 5, 3, 6, 2, 4, 1, 7},
	{3, 0, 2, 4, 1, 5, 7, 6},
	{6, 7, 5, 1, 4, 2, 0, 3},
	{6, 4, 0, 5, 7, 2, 3, 1},
	{1, 3, 2, 7, 5, 0, 4, 6},
	{4, 6, 7, 3, 2, 5, 1, 0},
	{0, 1, 5, 2, 3, 7, 6, 4},
	{5, 0, 3, 1, 4, 6, 2, 7},
	{7, 2, 6, 4, 1, 3, 0, 5},
	{2, 7, 1, 0, 6, 4, 5, 3},
	{3, 5, 4, 6, 0, 1, 7, 2},
	{1, 3, 5, 7, 0, 2, 4, 6},
	{6, 4, 2, 0, 7, 5, 3, 1},
	{2, 6, 7, 5, 3, 1, 0, 4},
	{4, 0, 1, 3, 5, 7, 6, 2},
	{0, 5, 4, 1, 6, 3, 2, 7},
	{7, 2, 3, 6, 1, 4, 5, 0},
	{3, 7, 6, 4, 2, 0, 1, 5},
	{5, 1, 0, 2, 4, 6, 7, 3},
	{4, 1, 0, 2, 5, 7, 3, 6},
	{6, 3, 7, 5, 2, 0, 1, 4},
	{1, 6, 5, 7, 3, 4, 0, 2},
	{2, 0, 4, 3, 7, 5, 6, 1},
	{0, 2, 3, 4, 6, 1, 7, 5},
	{5, 7, 1, 6, 4, 3, 2, 0},
	{7, 5, 6, 1, 0, 2, 4, 3},
	{3, 4, 2, 0, 1, 6, 5, 7},
	{3, 4, 2, 7, 5, 6, 0, 1},
	{1, 0, 6, 5, 7, 2, 4, 3},
	{2, 6, 4, 1, 3, 7, 5, 0},
	{0, 5, 7, 3, 1, 4, 6, 2},
	{5, 7, 3, 0, 4, 1, 2, 6},
	{6, 2, 1, 4, 0, 3, 7, 5},
	{4, 1, 0, 6, 2, 5, 3, 7},
	{7, 3, 5, 2, 6, 0, 1, 4},
	{0, 5, 3, 6, 2, 7, 1, 4},
	{4, 1, 7, 2, 6, 3, 5, 0},
	{7, 2, 6, 3, 5, 0, 4, 1},
	{1, 4, 0, 5, 3, 6, 2, 7},
	{6, 0, 1, 4, 7, 5, 3, 2},
	{2, 3, 5, 7, 4, 1, 0, 6},
	{3, 7, 2, 1, 0, 4, 6, 5},
	{5, 6, 4, 0, 1, 2, 7, 3},
	{5, 1, 4, 2, 0, 3, 6, 7},
	{7, 6, 3, 0, 2, 4, 1, 5},
	{1, 5, 7, 4, 3, 2, 0, 6},
	{6, 0, 2, 3, 4, 7, 5, 1},
	{2, 3, 0, 6, 5, 1, 7, 4},
	{4, 7, 1, 5, 6, 0, 3, 2},
	{0, 4, 6, 7, 1, 5, 2, 3},
	{3, 2, 5, 1, 7, 6, 4, 0},
	{6, 4, 5, 7, 2, 1, 3, 0},
	{0, 3, 1, 2, 7, 5, 4, 6},
	{3, 2, 7, 1, 0, 6, 5, 4},
	{4, 5, 6, 0, 1, 7, 2, 3},
	{1, 6, 4, 5, 3, 0, 7, 2},
	{2, 7, 0, 3, 5, 4, 6, 1},
	{7, 0, 2, 4, 6, 3, 1, 5},
	{5, 1, 3, 6, 4, 2, 0, 7},
	{5, 3, 4, 2, 0, 1, 6, 7},
	{7, 6, 1, 0, 2, 4, 3, 5},
	{3, 5, 7, 1, 4, 6, 0, 2},
	{2, 0, 6, 4, 1, 7, 5, 3},
	{6, 2, 0, 5, 7, 3, 4, 1},
	{1, 4, 3, 7, 5, 0, 2, 6},
	{4, 1, 2, 6, 3, 5, 7, 0},
	{0, 7, 5, 3, 6, 2, 1, 4},
	{0, 7, 1, 2, 5, 4, 3, 6},
	{6, 3, 4, 5, 2, 1, 7, 0},
	{7, 1, 6, 0, 4, 5, 2, 3},
	{3, 2, 5, 4, 0, 6, 1, 7},
	{5, 0, 2, 3, 6, 7, 4, 1},
	{1, 4, 7, 6, 3, 2, 0, 5},
	{4, 6, 3, 1, 7, 0, 5, 2},
	{2, 5, 0, 7, 1, 3, 6, 4},
	{2, 3, 4, 1, 5, 0, 6, 7},
	{7, 6, 0, 5, 1, 4, 3, 2},
	{3, 7, 5, 0, 2, 1, 4, 6},
	{6, 4, 1, 2, 0, 5, 7, 3},
	{1, 2, 6, 7, 4, 3, 0, 5},
	{5, 0, 3, 4, 7, 6, 2, 1},
	{0, 5, 7, 6, 3, 2, 1, 4},
	{4, 1, 2, 3, 6, 7, 5, 0},
	{4, 6, 5, 1, 0, 2, 3, 7},
	{7, 3, 2, 0, 1, 5, 6, 4},
	{6, 4, 7, 3, 2, 0, 5, 1},
	{1, 5, 0, 2, 3, 7, 4, 6},
	{0, 2, 1, 5, 4, 6, 7, 3},
	{3, 7, 6, 4, 5, 1, 2, 0},
	{5, 1, 3, 7, 6, 4, 0, 2},
	{2, 0, 4, 6, 7, 3, 1, 5},
	{3, 2, 7, 4, 1, 0, 6, 5},
	{5, 6, 0, 1, 4, 7, 2, 3},
	{7, 0, 1, 5, 2, 4, 3, 6},
	{6, 3, 4, 2, 5, 1, 0, 7},
	{2, 4, 6, 3, 0, 5, 7, 1},
	{1, 7, 5, 0, 3, 6, 4, 2},
	{0, 1, 3, 6, 7, 2, 5, 4},
	{4, 5, 2, 7, 6, 3, 1, 0},
	{5, 4, 6, 7, 3, 1, 2, 0},
	{0, 2, 1, 3, 7, 6, 4, 5},
	{6, 5, 7, 1, 4, 3, 0, 2},
	{2, 0, 3, 4, 1, 7, 5, 6},
	{3, 1, 2, 0, 5, 4, 6, 7},
	{7, 6, 4, 5, 0, 2, 1, 3},
	{4, 7, 0, 2, 6, 5, 3, 1},
	{1, 3, 5, 6, 2, 0, 7, 4},
	{6, 2, 1, 5, 3, 7, 4, 0},
	{0, 4, 7, 3, 5, 1, 2, 6},
	{2, 0, 3, 4, 7, 5, 6, 1},
	{1, 6, 5, 7, 4, 3, 0, 2},
	{5, 1, 4, 0, 6, 2, 7, 3},
	{3, 7, 2, 6, 0, 4, 1, 5},
	{7, 3, 0, 1, 2, 6, 5, 4},
	{4, 5, 6, 2, 1, 0, 3, 7},
	{7, 4, 3, 6, 1, 0, 5, 2},
	{2, 5, 0, 1, 6, 3, 4, 7},
	{5, 1, 2, 0, 4, 6, 7, 3},
	{3, 7, 6, 4, 0, 2, 1, 5},
	{6, 0, 4, 3, 5, 7, 2, 1},
	{1, 2, 7, 5, 3, 4, 0, 6},
	{4, 3, 1, 2, 7, 5, 6, 0},
	{0, 6, 5, 7, 2, 1, 3, 4},
	{2, 7, 6, 5, 1, 3, 0, 4},
	{4, 0, 3, 1, 5, 6, 7, 2},
	{0, 1, 5, 3, 6, 4, 2, 7},
	{7, 2, 4, 6, 3, 5, 1, 0},
	{3, 6, 7, 2, 4, 0, 5, 1},
	{1, 5, 0, 4, 2, 7, 6, 3},
	{5, 4, 1, 0, 7, 2, 3, 6},
	{6, 3, 2, 7, 0, 1, 4, 5},
	{7, 2, 0, 6, 1, 3, 5, 4},
	{4, 5, 3, 1, 6, 0, 2, 7},
	{0, 1, 4, 5, 2, 6, 7, 3},
	{3, 7, 6, 2, 5, 4, 1, 0},
	{6, 3, 2, 7, 4, 5, 0, 1},
	{1, 0, 5, 4, 7, 2, 3, 6},
	{5, 4, 1, 3, 0, 7, 6, 2},
	{2, 6, 7, 0, 3, 1, 4, 5},
	{3, 2, 7, 6, 1, 0, 5, 4},
	{4, 5, 0, 1, 6, 7, 2, 3},
	{1, 6, 4, 0, 2, 5, 3, 7},
	{7, 3, 5, 2, 0, 4, 6, 1},
	{5, 7, 2, 3, 4, 6, 1, 0},
	{0, 1, 6, 4, 3, 2, 7, 5},
	{2, 0, 3, 7, 5, 1, 4, 6},
	{6, 4, 1, 5, 7, 3, 0, 2},
	{6, 4, 0, 7, 1, 5, 3, 2},
	{2, 3, 5, 1, 7, 0, 4, 6},
	{0, 1, 3, 5, 6, 7, 2, 4},
	{4, 2, 7, 6, 5, 3, 1, 0},
	{7, 6, 4, 2, 3, 1, 0, 5},
	{5, 0, 1, 3, 2, 4, 6, 7},
	{1, 5, 2, 4, 0, 6, 7, 3},
	{3, 7, 6, 0, 4, 2, 5, 1},
	{3, 4, 5, 7, 6, 0, 2, 1},
	{1, 2, 0, 6, 7, 5, 4, 3},
	{5, 7, 2, 1, 3, 4, 0, 6},
	{6, 0, 4, 3, 1, 2, 7, 5},
	{0, 6, 3, 4, 2, 1, 5, 7},
	{7, 5, 1, 2, 4, 3, 6, 0},
	{4, 1, 6, 0, 5, 7, 3, 2},
	{2, 3, 7, 5, 0, 6, 1, 4},
	{2, 7, 3, 5, 6, 0, 4, 1},
	{1, 4, 0, 6, 5, 3, 7, 2},
	{4, 1, 2, 0, 3, 7, 6, 5},
	{5, 6, 7, 3, 0, 2, 1, 4},
	{7, 5, 6, 1, 2, 4, 0, 3},
	{3, 0, 4, 2, 1, 6, 5, 7},
	{0, 3, 1, 4, 7, 5, 2, 6},
	{6, 2, 5, 7, 4, 1, 3, 0},
	{6, 2, 3, 5, 0, 7, 1, 4},
	{4, 1, 7, 0, 5, 3, 2, 6},
	{3, 6, 5, 1, 2, 0, 4, 7},
	{7, 4, 0, 2, 1, 5, 6, 3},
	{0, 7, 2, 4, 6, 1, 3, 5},
	{5, 3, 1, 6, 4, 2, 7, 0},
	{1, 5, 4, 7, 3, 6, 0, 2},
	{2, 0, 6, 3, 7, 4, 5, 1},
	{2, 6, 4, 7, 5, 0, 3, 1},
	{1, 3, 0, 5, 7, 4, 6, 2},
	{0, 5, 1, 3, 4, 7, 2, 6},
	{6, 2, 7, 4, 3, 1, 5, 0},
	{3, 7, 6, 2, 1, 5, 0, 4},
	{4, 0, 5, 1, 2, 6, 7, 3},
	{5, 4, 2, 0, 6, 3, 1, 7},
	{7, 1, 3, 6, 0, 2, 4, 5},
	{1, 7, 4, 6, 0, 2, 3, 5},
	{5, 3, 2, 0, 6, 4, 7, 1},
	{2, 1, 3, 7, 4, 0, 5, 6},
	{6, 5, 0, 4, 7, 3, 1, 2},
	{0, 4, 6, 5, 3, 1, 2, 7},
	{7, 2, 1, 3, 5, 6, 4, 0},
	{3, 6, 7, 2, 1, 5, 0, 4},
	{4, 0, 5, 1, 2, 7, 6, 3},
	{5, 7, 4, 0, 6, 1, 2, 3},
	{3, 2, 1, 6, 0, 4, 7, 5},
	{6, 0, 2, 4, 5, 7, 3, 1},
	{1, 3, 7, 5, 4, 2, 0, 6},
	{4, 1, 3, 7, 2, 5, 6, 0},
	{0, 6, 5, 2, 7, 3, 1, 4},
	{7, 5, 0, 1, 3, 6, 4, 2},
	{2, 4, 6, 3, 1, 0, 5, 7},
	{2, 3, 1, 0, 6, 5, 4, 7},
	{7, 4, 5, 6, 0, 1, 3, 2},
	{3, 1, 2, 5, 7, 0, 6, 4},
	{4, 6, 0, 7, 5, 2, 1, 3},
	{6, 0, 4, 2, 3, 7, 5, 1},
	{1, 5, 7, 3, 2, 4, 0, 6},
	{5, 7, 6, 1, 4, 3, 2, 0},
	{0, 2, 3, 4, 1, 6, 7, 5},
	{4, 0, 2, 1, 5, 7, 3, 6},
	{6, 3, 7, 5, 1, 2, 0, 4},
	{5, 4, 6, 2, 0, 1, 7, 3},
	{3, 7, 1, 0, 2, 6, 4, 5},
	{7, 1, 0, 6, 3, 4, 5, 2},
	{2, 5, 4, 3, 6, 0, 1, 7},
	{0, 2, 3, 4, 7, 5, 6, 1},
	{1, 6, 5, 7, 4, 3, 2, 0},
	{3, 1, 6, 2, 7, 5, 4, 0},
	{0, 4, 5, 7, 2, 6, 1, 3},
	{2, 6, 7, 5, 1, 3, 0, 4},
	{4, 0, 3, 1, 5, 7, 6, 2},
	{1, 5, 4, 3, 6, 0, 2, 7},
	{7, 2, 0, 6, 3, 4, 5, 1},
	{5, 7, 2, 4, 0, 1, 3, 6},
	{6, 3, 1, 0, 4, 2, 7, 5},
	{3, 0, 6, 4, 7, 1, 2, 5},
	{5, 2, 1, 7, 4, 6, 0, 3},
	{4, 7, 0, 6, 3, 2, 5, 1},
	{1, 5, 2, 3, 6, 0, 7, 4},
	{6, 1, 3, 5, 0, 7, 4, 2},
	{2, 4, 7, 0, 5, 3, 1, 6},
	{7, 3, 4, 2, 1, 5, 6, 0},
	{0, 6, 5, 1, 2, 4, 3, 7},
	{2, 0, 5, 1, 4, 6, 3, 7},
	{7, 3, 6, 4, 1, 5, 0, 2},
	{0, 4, 1, 2, 7, 3, 5, 6},
	{6, 5, 3, 7, 2, 1, 4, 0},
	{5, 6, 2, 3, 0, 7, 1, 4},
	{4, 1, 7, 0, 3, 2, 6, 5},
	{1, 7, 4, 6, 5, 0, 2, 3},
	{3, 2, 0, 5, 6, 4, 7, 1},
	{3, 6, 2, 4, 5, 0, 1, 7},
	{7, 1, 0, 5, 4, 2, 6, 3},
	{2, 7, 3, 0, 1, 6, 4, 5},
	{5, 4, 6, 1, 0, 3, 7, 2},
	{4, 5, 1, 6, 3, 7, 2, 0},
	{0, 2, 7, 3, 6, 1, 5, 4},
	{6, 0, 5, 7, 2, 4, 3, 1},
	{1, 3, 4, 2, 7, 5, 0, 6},
	{1, 7, 0, 3, 5, 4, 2, 6},
	{6, 2, 4, 5, 3, 0, 7, 1},
	{5, 3, 2, 1, 0, 7, 6, 4},
	{4, 6, 7, 0, 1, 2, 3, 5},
	{0, 4, 6, 7, 2, 1, 5, 3},
	{3, 5, 1, 2, 7, 6, 4, 0},
	{2, 1, 3, 4, 6, 5, 0, 7},
	{7, 0, 5, 6, 4, 3, 1, 2},
	{7, 6, 5, 4, 3, 0, 1, 2},
	{2, 1, 0, 3, 4, 5, 6, 7},
	{4, 7, 3, 1, 5, 6, 2, 0},
	{0, 2, 6, 5, 1, 3, 7, 4},
	{5, 0, 1, 2, 6, 7, 4, 3},
	{3, 4, 7, 6, 2, 1, 0, 5},
	{6, 3, 2, 0, 7, 4, 5, 1},
	{1, 5, 4, 7, 0, 2, 3, 6},
	{1, 0, 2, 4, 3, 7, 5, 6},
	{6, 5, 7, 3, 4, 2, 0, 1},
	{3, 4, 5, 6, 2, 0, 1, 7},
	{7, 1, 0, 2, 6, 5, 4, 3},
	{2, 7, 1, 0, 5, 6, 3, 4},
	{4, 3, 6, 5, 0, 1, 7, 2},
	{0, 6, 4, 7, 1, 3, 2, 5},
	{5, 2, 3, 1, 7, 4, 6, 0},
	{5, 3, 7, 4, 1, 6, 2, 0},
	{0, 2, 6, 1, 4, 7, 3, 5},
	{7, 4, 1, 5, 2, 3, 0, 6},
	{6, 0, 3, 2, 5, 1, 4, 7},
	{2, 6, 5, 0, 3, 4, 7, 1},
	{1, 7, 4, 3, 0, 5, 6, 2},
	{3, 1, 0, 6, 7, 2, 5, 4},
	{4, 5, 2, 7, 6, 0, 1, 3},
	{6, 4, 5, 1, 0, 2, 7, 3},
	{3, 7, 2, 0, 1, 5, 4, 6},
	{2, 1, 0, 3, 5, 4, 6, 7},
	{7, 6, 4, 5, 3, 0, 1, 2},
	{5, 0, 7, 4, 6, 3, 2, 1},
	{1, 2, 3, 6, 4, 7, 0, 5},
	{4, 3, 6, 7, 2, 1, 5, 0},
	{0, 5, 1, 2, 7, 6, 3, 4},
	{7, 1, 2, 6, 0, 5, 3, 4},
	{4, 3, 5, 0, 6, 2, 1, 7},
	{3, 7, 0, 4, 1, 6, 2, 5},
	{5, 2, 6, 1, 4, 0, 7, 3},
	{2, 5, 1, 7, 3, 4, 6, 0},
	{0, 6, 4, 3, 7, 1, 5, 2},
	{6, 0, 7, 5, 2, 3, 4, 1},
	{1, 4, 3, 2, 5, 7, 0, 6},
	{4, 1, 5, 6, 0, 2, 3, 7},
	{7, 3, 2, 0, 6, 5, 1, 4},
	{5, 4, 3, 2, 1, 6, 7, 0},
	{0, 7, 6, 1, 2, 3, 4, 5},
	{6, 0, 1, 3, 7, 4, 5, 2},
	{2, 5, 4, 7, 3, 1, 0, 6},
	{3, 2, 0, 4, 5, 7, 6, 1},
	{1, 6, 7, 5, 4, 0, 2, 3},
	{7, 1, 2, 0, 4, 5, 6, 3},
	{3, 6, 5, 4, 0, 2, 1, 7},
	{0, 2, 6, 7, 1, 4, 3, 5},
	{5, 3, 4, 1, 7, 6, 2, 0},
	{4, 5, 1, 3, 6, 7, 0, 2},
	{2, 0, 7, 6, 3, 1, 5, 4},
	{6, 7, 3, 2, 5, 0, 4, 1},
	{1, 4, 0, 5, 2, 3, 7, 6},
	{5, 1, 3, 2, 0, 4, 7, 6},
	{6, 7, 4, 0, 2, 3, 1, 5},
	{3, 4, 2, 6, 1, 5, 0, 7},
	{7, 0, 5, 1, 6, 2, 4, 3},
	{0, 5, 1, 7, 4, 6, 3, 2},
	{2, 3, 6, 4, 7, 1, 5, 0},
	{4, 2, 7, 5, 3, 0, 6, 1},
	{1, 6, 0, 3, 5, 7, 2, 4},
	{6, 7, 1, 0, 3, 2, 5, 4},
	{4, 5, 2, 3, 0, 1, 7, 6},
	{1, 6, 0, 2, 7, 5, 4, 3},
	{3, 4, 5, 7, 2, 0, 6, 1},
	{0, 3, 7, 4, 5, 6, 1, 2},
	{2, 1, 6, 5, 4, 7, 3, 0},
	{5, 2, 3, 6, 1, 4, 0, 7},
	{7, 0, 4, 1, 6, 3, 2, 5},
	{4, 7, 2, 1, 6, 3, 0, 5},
	{5, 0, 3, 6, 1, 2, 7, 4},
	{7, 2, 5, 3, 4, 0, 1, 6},
	{6, 1, 0, 4, 3, 5, 2, 7},
	{0, 6, 1, 5, 7, 4, 3, 2},
	{2, 3, 4, 7, 5, 1, 6, 0},
	{3, 4, 6, 2, 0, 7, 5, 1},
	{1, 5, 7, 0, 2, 6, 4, 3},
	{1, 5, 2, 3, 6, 4, 0, 7},
	{7, 0, 4, 6, 3, 2, 5, 1},
	{0, 1, 7, 4, 5, 6, 3, 2},
	{2, 3, 6, 5, 4, 7, 1, 0},
	{6, 2, 3, 7, 1, 0, 4, 5},
	{5, 4, 0, 1, 7, 3, 2, 6},
	{4, 7, 5, 2, 0, 1, 6, 3},
	{3, 6, 1, 0, 2, 5, 7, 4},
	{3, 5, 4, 1, 0, 2, 6, 7},
	{7, 6, 2, 0, 1, 4, 5, 3},
	{6, 3, 5, 2, 7, 1, 0, 4},
	{4, 0, 1, 7, 2, 5, 3, 6},
	{0, 1, 7, 4, 6, 3, 2, 5},
	{5, 2, 3, 6, 4, 7, 1, 0},
	{2, 4, 0, 5, 3, 6, 7, 1},
	{1, 7, 6, 3, 5, 0, 4, 2},
	{1, 5, 7, 6, 2, 3, 0, 4},
	{4, 0, 3, 2, 6, 7, 5, 1},
	{2, 4, 6, 0, 7, 5, 1, 3},
	{3, 1, 5, 7, 0, 6, 4, 2},
	{7, 3, 1, 5, 4, 0, 2, 6},
	{6, 2, 0, 4, 5, 1, 3, 7},
	{5, 6, 4, 3, 1, 2, 7, 0},
	{0, 7, 2, 1, 3, 4, 6, 5},
	{0, 3, 1, 6, 7, 2, 4, 5},
	{5, 4, 2, 7, 6, 1, 3, 0},
	{2, 0, 6, 4, 5, 3, 1, 7},
	{7, 1, 3, 5, 4, 6, 0, 2},
	{3, 7, 5, 1, 0, 4, 2, 6},
	{6, 2, 4, 0, 1, 5, 7, 3},
	{1, 6, 7, 2, 3, 0, 5, 4},
	{4, 5, 0, 3, 2, 7, 6, 1},
	{4, 0, 7, 5, 2, 6, 3, 1},
	{1, 3, 6, 2, 5, 7, 0, 4},
	{7, 4, 5, 6, 3, 0, 1, 2},
	{2, 1, 0, 3, 6, 5, 4, 7},
	{6, 2, 1, 0, 4, 3, 7, 5},
	{5, 7, 3, 4, 0, 1, 2, 6},
	{0, 5, 2, 1, 7, 4, 6, 3},
	{3, 6, 4, 7, 1, 2, 5, 0},
	{3, 1, 4, 5, 2, 6, 7, 0},
	{0, 7, 6, 2, 5, 4, 1, 3},
	{2, 3, 5, 6, 4, 1, 0, 7},
	{7, 0, 1, 4, 6, 5, 3, 2},
	{1, 4, 0, 7, 3, 2, 5, 6},
	{6, 5, 2, 3, 7, 0, 4, 1},
	{5, 6, 7, 0, 1, 3, 2, 4},
	{4, 2, 3, 1, 0, 7, 6, 5},
	{7, 6, 3, 4, 2, 0, 5, 1},
	{1, 5, 0, 2, 4, 3, 6, 7},
	{4, 0, 2, 1, 3, 6, 7, 5},
	{5, 7, 6, 3, 1, 2, 0, 4},
	{3, 2, 7, 5, 6, 1, 4, 0},
	{0, 4, 1, 6, 5, 7, 2, 3},
	{6, 1, 5, 0, 7, 4, 3, 2},
	{2, 3, 4, 7, 0, 5, 1, 6},
	{0, 4, 5, 7, 2, 1, 3, 6},
	{6, 3, 1, 2, 7, 5, 4, 0},
	{7, 2, 3, 6, 5, 4, 0, 1},
	{1, 0, 4, 5, 6, 3, 2, 7},
	{5, 1, 0, 4, 3, 6, 7, 2},
	{2, 7, 6, 3, 4, 0, 1, 5},
	{3, 6, 2, 1, 0, 7, 5, 4},
	{4, 5, 7, 0, 1, 2, 6, 3},
	{4, 1, 2, 0, 7, 5, 6, 3},
	{3, 6, 5, 7, 0, 2, 1, 4},
	{0, 2, 6, 5, 4, 1, 3, 7},
	{7, 3, 1, 4, 5, 6, 2, 0},
	{1, 7, 4, 3, 6, 0, 5, 2},
	{2, 5, 0, 6, 3, 4, 7, 1},
	{5, 4, 7, 2, 1, 3, 0, 6},
	{6, 0, 3, 1, 2, 7, 4, 5},
	{6, 3, 7, 2, 0, 5, 1, 4},
	{4, 1, 5, 0, 2, 7, 3, 6},
	{3, 6, 0, 5, 4, 2, 7, 1},
	{1, 7, 2, 4, 5, 0, 6, 3},
	{7, 2, 1, 6, 3, 4, 5, 0},
	{0, 5, 4, 3, 6, 1, 2, 7},
	{5, 0, 3, 1, 7, 6, 4, 2},
	{2, 4, 6, 7, 1, 3, 0, 5},
	{4, 2, 1, 0, 5, 6, 3, 7},
	{7, 3, 6, 5, 0, 1, 2, 4},
	{3, 4, 7, 6, 1, 2, 5, 0},
	{0, 5, 2, 1, 6, 7, 4, 3},
	{2, 0, 5, 7, 4, 3, 1, 6},
	{6, 1, 3, 4, 7, 5, 0, 2},
	{1, 6, 0, 2, 3, 4, 7, 5},
	{5, 7, 4, 3, 2, 0, 6, 1},
	{5, 7, 6, 4, 1, 0, 3, 2},
	{2, 3, 0, 1, 4, 6, 7, 5},
	{6, 1, 5, 0, 7, 4, 2, 3},
	{3, 2, 4, 7, 0, 5, 1, 6},
	{4, 0, 2, 3, 5, 7, 6, 1},
	{1, 6, 7, 5, 3, 2, 0, 4},
	{7, 5, 3, 2, 6, 1, 4, 0},
	{0, 4, 1, 6, 2, 3, 5, 7},
	{3, 1, 2, 0, 4, 6, 5, 7},
	{7, 5, 6, 4, 0, 2, 1, 3},
	{5, 7, 0, 2, 1, 3, 4, 6},
	{6, 4, 3, 1, 2, 0, 7, 5},
	{4, 6, 1, 3, 7, 5, 2, 0},
	{0, 2, 5, 7, 3, 1, 6, 4},
	{2, 0, 7, 6, 5, 4, 3, 1},
	{1, 3, 4, 5, 6, 7, 0, 2},
	{3, 1, 6, 4, 0, 2, 5, 7},
	{7, 5, 2, 0, 4, 6, 1, 3},
	{0, 4, 7, 1, 6, 3, 2, 5},
	{5, 2, 3, 6, 1, 7, 4, 0},
	{2, 6, 5, 3, 7, 1, 0, 4},
	{4, 0, 1, 7, 3, 5, 6, 2},
	{1, 3, 4, 5, 2, 0, 7, 6},
	{6, 7, 0, 2, 5, 4, 3, 1},
	{7, 5, 6, 0, 4, 2, 3, 1},
	{1, 3, 2, 4, 0, 6, 5, 7},
	{5, 7, 4, 2, 6, 0, 1, 3},
	{3, 1, 0, 6, 2, 4, 7, 5},
	{0, 6, 1, 3, 5, 7, 4, 2},
	{2, 4, 7, 5, 3, 1, 6, 0},
	{4, 2, 3, 1, 7, 5, 0, 6},
	{6, 0, 5, 7, 1, 3, 2, 4},
	{3, 1, 2, 0, 6, 7, 5, 4},
	{4, 5, 7, 6, 0, 2, 1, 3},
	{0, 4, 6, 5, 2, 1, 3, 7},
	{7, 3, 1, 2, 5, 6, 4, 0},
	{2, 7, 3, 1, 4, 5, 0, 6},
	{6, 0, 5, 4, 1, 3, 7, 2},
	{1, 6, 4, 7, 3, 0, 2, 5},
	{5, 2, 0, 3, 7, 4, 6, 1},
	{5, 7, 6, 0, 3, 2, 4, 1},
	{1, 4, 2, 3, 0, 6, 7, 5},
	{6, 5, 0, 2, 4, 7, 1, 3},
	{3, 1, 7, 4, 2, 0, 5, 6},
	{2, 3, 1, 7, 5, 4, 6, 0},
	{0, 6, 4, 5, 7, 1, 3, 2},
	{4, 0, 3, 1, 6, 5, 2, 7},
	{7, 2, 5, 6, 1, 3, 0, 4},
	{7, 5, 0, 1, 3, 4, 6, 2},
	{2, 6, 4, 3, 1, 0, 5, 7},
	{6, 2, 3, 4, 7, 5, 0, 1},
	{1, 0, 5, 7, 4, 3, 2, 6},
	{0, 1, 7, 2, 5, 6, 4, 3},
	{3, 4, 6, 5, 2, 7, 1, 0},
	{4, 3, 1, 0, 6, 2, 7, 5},
	{5, 7, 2, 6, 0, 1, 3, 4},
	{5, 7, 2, 1, 4, 3, 6, 0},
	{0, 6, 3, 4, 1, 2, 7, 5},
	{6, 4, 5, 0, 3, 7, 1, 2},
	{2, 1, 7, 3, 0, 5, 4, 6},
	{3, 2, 1, 7, 5, 6, 0, 4},
	{4, 0, 6, 5, 7, 1, 2, 3},
	{7, 5, 0, 2, 6, 4, 3, 1},
	{1, 3, 4, 6, 2, 0, 5, 7},
	{1, 4, 6, 0, 2, 3, 5, 7},
	{7, 5, 3, 2, 0, 6, 4, 1},
	{2, 3, 0, 4, 1, 5, 7, 6},
	{6, 7, 5, 1, 4, 0, 3, 2},
	{5, 6, 1, 7, 3, 4, 2, 0},
	{0, 2, 4, 3, 7, 1, 6, 5},
	{4, 0, 7, 6, 5, 2, 1, 3},
	{3, 1, 2, 5, 6, 7, 0, 4},
	{3, 1, 6, 0, 7, 2, 5, 4},
	{4, 5, 2, 7, 0, 6, 1, 3},
	{2, 7, 0, 4, 3, 1, 6, 5},
	{5, 6, 1, 3, 4, 0, 7, 2},
	{6, 3, 5, 1, 2, 4, 0, 7},
	{7, 0, 4, 2, 1, 5, 3, 6},
	{0, 4, 7, 5, 6, 3, 2, 1},
	{1, 2, 3, 6, 5, 7, 4, 0},
	{1, 5, 2, 7, 3, 4, 6, 0},
	{0, 6, 4, 3, 7, 2, 5, 1},
	{5, 2, 6, 0, 1, 7, 4, 3},
	{3, 4, 7, 1, 0, 6, 2, 5},
	{7, 3, 1, 4, 2, 5, 0, 6},
	{6, 0, 5, 2, 4, 1, 3, 7},
	{4, 1, 0, 6, 5, 3, 7, 2},
	{2, 7, 3, 5, 6, 0, 1, 4},
	{6, 2, 3, 0, 4, 7, 5, 1},
	{1, 5, 7, 4, 0, 3, 2, 6},
	{4, 3, 0, 7, 2, 6, 1, 5},
	{5, 1, 6, 2, 7, 0, 3, 4},
	{7, 6, 5, 1, 3, 2, 4, 0},
	{0, 4, 2, 3, 1, 5, 6, 7},
	{2, 0, 1, 5, 6, 4, 7, 3},
	{3, 7, 4, 6, 5, 1, 0, 2},
	{3, 5, 0, 1, 4, 7, 2, 6},
	{6, 2, 7, 4, 1, 0, 5, 3},
	{5, 7, 6, 2, 0, 1, 3, 4},
	{4, 3, 1, 0, 2, 6, 7, 5},
	{1, 4, 2, 3, 6, 5, 0, 7},
	{7, 0, 5, 6, 3, 2, 4, 1},
	{0, 6, 4, 7, 5, 3, 1, 2},
	{2, 1, 3, 5, 7, 4, 6, 0},
	{7, 3, 2, 4, 1, 5, 0, 6},
	{6, 0, 5, 1, 4, 2, 3, 7},
	{2, 4, 6, 0, 3, 7, 1, 5},
	{5, 1, 7, 3, 0, 6, 4, 2},
	{1, 5, 3, 7, 6, 0, 2, 4},
	{4, 2, 0, 6, 7, 3, 5, 1},
	{0, 7, 4, 5, 2, 1, 6, 3},
	{3, 6, 1, 2, 5, 4, 7, 0},
	{6, 3, 1, 5, 2, 4, 0, 7},
	{7, 0, 4, 2, 5, 1, 3, 6},
	{3, 1, 6, 0, 4, 2, 7, 5},
	{5, 7, 2, 4, 0, 6, 1, 3},
	{2, 4, 5, 7, 3, 0, 6, 1},
	{1, 6, 0, 3, 7, 5, 4, 2},
	{0, 5, 7, 6, 1, 3, 2, 4},
	{4, 2, 3, 1, 6, 7, 5, 0},
	{7, 4, 1, 2, 6, 5, 0, 3},
	{3, 0, 5, 6, 2, 1, 4, 7},
	{5, 6, 2, 0, 4, 3, 7, 1},
	{1, 7, 3, 4, 0, 2, 6, 5},
	{2, 1, 4, 7, 3, 0, 5, 6},
	{6, 5, 0, 3, 7, 4, 1, 2},
	{0, 3, 6, 1, 5, 7, 2, 4},
	{4, 2, 7, 5, 1, 6, 3, 0},
	{4, 3, 7, 1, 6, 5, 0, 2},
	{2, 0, 5, 6, 1, 7, 3, 4},
	{1, 5, 6, 0, 7, 4, 2, 3},
	{3, 2, 4, 7, 0, 6, 5, 1},
	{7, 4, 3, 2, 5, 0, 1, 6},
	{6, 1, 0, 5, 2, 3, 4, 7},
	{0, 6, 2, 3, 4, 1, 7, 5},
	{5, 7, 1, 4, 3, 2, 6, 0},
	{5, 2, 6, 3, 1, 7, 0, 4},
	{4, 0, 7, 1, 3, 6, 2, 5},
	{2, 3, 4, 0, 5, 1, 6, 7},
	{7, 6, 1, 5, 0, 4, 3, 2},
	{1, 7, 5, 6, 2, 0, 4, 3},
	{3, 4, 0, 2, 6, 5, 7, 1},
	{0, 5, 3, 7, 4, 2, 1, 6},
	{6, 1, 2, 4, 7, 3, 5, 0},
	{6, 4, 7, 1, 3, 0, 2, 5},
	{5, 2, 0, 3, 1, 7, 4, 6},
	{4, 6, 1, 2, 7, 5, 0, 3},
	{3, 0, 5, 7, 2, 1, 6, 4},
	{0, 7, 3, 5, 6, 4, 1, 2},
	{2, 1, 4, 6, 5, 3, 7, 0},
	{1, 3, 2, 0, 4, 6, 5, 7},
	{7, 5, 6, 4, 0, 2, 3, 1},
	{5, 2, 7, 6, 3, 4, 0, 1},
	{1, 0, 4, 3, 6, 7, 2, 5},
	{6, 3, 1, 0, 7, 2, 5, 4},
	{4, 5, 2, 7, 0, 1, 3, 6},
	{7, 4, 5, 2, 1, 0, 6, 3},
	{3, 6, 0, 1, 2, 5, 4, 7},
	{2, 1, 3, 5, 4, 6, 7, 0},
	{0, 7, 6, 4, 5, 3, 1, 2},
	{0, 4, 5, 6, 3, 7, 1, 2},
	{2, 1, 7, 3, 6, 5, 4, 0},
	{4, 0, 2, 7, 5, 1, 3, 6},
	{6, 3, 1, 5, 7, 2, 0, 4},
	{1, 6, 3, 0, 2, 4, 5, 7},
	{7, 5, 4, 2, 0, 3, 6, 1},
	{5, 7, 6, 1, 4, 0, 2, 3},
	{3, 2, 0, 4, 1, 6, 7, 5},
	{3, 7, 2, 0, 6, 5, 4, 1},
	{1, 4, 5, 6, 0, 2, 7, 3},
	{0, 3, 1, 4, 2, 7, 5, 6},
	{6, 5, 7, 2, 4, 1, 3, 0},
	{5, 2, 6, 7, 1, 3, 0, 4},
	{4, 0, 3, 1, 7, 6, 2, 5},
	{7, 6, 4, 3, 5, 0, 1, 2},
	{2, 1, 0, 5, 3, 4, 6, 7},
	{1, 2, 4, 0, 6, 3, 5, 7},
	{7, 5, 3, 6, 0, 4, 2, 1},
	{3, 4, 5, 2, 1, 6, 7, 0},
	{0, 7, 6, 1, 2, 5, 4, 3},
	{6, 0, 1, 7, 5, 2, 3, 4},
	{4, 3, 2, 5, 7, 1, 0, 6},
	{5, 1, 7, 4, 3, 0, 6, 2},
	{2, 6, 0, 3, 4, 7, 1, 5},
	{2, 0, 4, 7, 6, 3, 5, 1},
	{1, 5, 3, 6, 7, 4, 0, 2},
	{4, 2, 6, 3, 0, 7, 1, 5},
	{5, 1, 7, 0, 3, 6, 2, 4},
	{3, 7, 0, 5, 1, 2, 4, 6},
	{6, 4, 2, 1, 5, 0, 7, 3},
	{0, 6, 1, 2, 4, 5, 3, 7},
	{7, 3, 5, 4, 2, 1, 6, 0},
	{5, 7, 1, 6, 2, 4, 3, 0},
	{0, 3, 4, 2, 6, 1, 7, 5},
	{3, 6, 5, 7, 1, 2, 0, 4},
	{4, 0, 2, 1, 7, 5, 6, 3},
	{2, 4, 0, 5, 3, 7, 1, 6},
	{6, 1, 7, 3, 5, 0, 4, 2},
	{1, 5, 6, 4, 0, 3, 2, 7},
	{7, 2, 3, 0, 4, 6, 5, 1},
	{7, 4, 3, 1, 0, 2, 6, 5},
	{5, 6, 2, 0, 1, 3, 4, 7},
	{2, 7, 6, 4, 3, 1, 5, 0},
	{0, 5, 1, 3, 4, 6, 7, 2},
	{1, 0, 5, 7, 6, 4, 2, 3},
	{3, 2, 4, 6, 7, 5, 0, 1},
	{6, 3, 0, 5, 2, 7, 1, 4},
	{4, 1, 7, 2, 5, 0, 3, 6},
	{4, 3, 2, 5, 0, 7, 1, 6},
	{6, 1, 7, 0, 5, 2, 3, 4},
	{5, 4, 0, 7, 2, 3, 6, 1},
	{1, 6, 3, 2, 7, 0, 4, 5},
	{7, 2, 6, 1, 3, 4, 5, 0},
	{0, 5, 4, 3, 1, 6, 2, 7},
	{3, 0, 1, 6, 4, 5, 7, 2},
	{2, 7, 5, 4, 6, 1, 0, 3},
	{1, 6, 2, 0, 5, 4, 7, 3},
	{3, 7, 4, 5, 0, 2, 6, 1},
	{7, 0, 3, 4, 1, 6, 5, 2},
	{2, 5, 6, 1, 4, 3, 0, 7},
	{5, 2, 1, 6, 3, 7, 4, 0},
	{0, 4, 7, 3, 6, 1, 2, 5},
	{4, 1, 0, 2, 7, 5, 3, 6},
	{6, 3, 5, 7, 2, 0, 1, 4},
	{6, 3, 5, 2, 7, 0, 4, 1},
	{1, 4, 0, 7, 2, 5, 3, 6},
	{4, 1, 6, 0, 3, 2, 5, 7},
	{7, 5, 2, 3, 0, 6, 1, 4},
	{2, 7, 3, 5, 1, 4, 6, 0},
	{0, 6, 4, 1, 5, 3, 7, 2},
	{5, 0, 7, 6, 4, 1, 2, 3},
	{3, 2, 1, 4, 6, 7, 0, 5},
	{0, 3, 6, 7, 2, 5, 4, 1},
	{1, 4, 5, 2, 7, 6, 3, 0},
	{4, 1, 2, 5, 3, 7, 0, 6},
	{6, 0, 7, 3, 5, 2, 1, 4},
	{7, 6, 3, 0, 1, 4, 5, 2},
	{2, 5, 4, 1, 0, 3, 6, 7},
	{5, 2, 1, 4, 6, 0, 7, 3},
	{3, 7, 0, 6, 4, 1, 2, 5},
	{3, 0, 2, 6, 4, 1, 5, 7},
	{7, 5, 1, 4, 6, 2, 0, 3},
	{6, 7, 4, 5, 1, 0, 3, 2},
	{2, 3, 0, 1, 5, 4, 7, 6},
	{1, 2, 7, 3, 0, 5, 6, 4},
	{4, 6, 5, 0, 3, 7, 2, 1},
	{5, 4, 3, 2, 7, 6, 1, 0},
	{0, 1, 6, 7, 2, 3, 4, 5},
	{0, 7, 4, 1, 3, 2, 5, 6},
	{6, 5, 2, 3, 1, 4, 7, 0},
	{2, 6, 0, 5, 4, 3, 1, 7},
	{7, 1, 3, 4, 5, 0, 6, 2},
	{1, 3, 7, 6, 0, 5, 2, 4},
	{4, 2, 5, 0, 6, 7, 3, 1},
	{5, 4, 6, 7, 2, 1, 0, 3},
	{3, 0, 1, 2, 7, 6, 4, 5},
	{3, 0, 4, 2, 1, 6, 7, 5},
	{5, 7, 6, 1, 2, 4, 0, 3},
	{7, 5, 1, 6, 0, 3, 4, 2},
	{2, 4, 3, 0, 6, 1, 5, 7},
	{4, 2, 0, 3, 5, 7, 6, 1},
	{1, 6, 7, 5, 3, 0, 2, 4},
	{6, 1, 2, 4, 7, 5, 3, 0},
	{0, 3, 5, 7, 4, 2, 1, 6},
	{3, 0, 5, 1, 6, 7, 2, 4},
	{4, 2, 7, 6, 1, 5, 0, 3},
	{0, 7, 2, 4, 5, 1, 3, 6},
	{6, 3, 1, 5, 4, 2, 7, 0},
	{1, 6, 3, 2, 0, 4, 5, 7},
	{7, 5, 4, 0, 2, 3, 6, 1},
	{5, 4, 6, 7, 3, 0, 1, 2},
	{2, 1, 0, 3, 7, 6, 4, 5},
	{2, 7, 6, 3, 5, 4, 0, 1},
	{1, 0, 4, 5, 3, 6, 7, 2},
	{7, 1, 5, 0, 2, 3, 6, 4},
	{4, 6, 3, 2, 0, 5, 1, 7},
	{3, 4, 2, 1, 6, 7, 5, 0},
	{0, 5, 7, 6, 1, 2, 4, 3},
	{6, 2, 0, 4, 7, 1, 3, 5},
	{5, 3, 1, 7, 4, 0, 2, 6},
	{5, 1, 0, 4, 3, 7, 6, 2},
	{2, 6, 7, 3, 4, 0, 1, 5},
	{4, 0, 1, 5, 6, 2, 3, 7},
	{7, 3, 2, 6, 5, 1, 0, 4},
	{3, 7, 5, 2, 1, 6, 4, 0},
	{0, 4, 6, 1, 2, 5, 7, 3},
	{6, 5, 3, 0, 7, 4, 2, 1},
	{1, 2, 4, 7, 0, 3, 5, 6},
};

uint8_t InitiativeSequencer::getPlayerIndex(uint32_t round, uint8_t offset)
{
	DEBUG_ASSERT(offset < _num);

	// The sequences for 2 and 3 are supposed to repeat. The others are not.
	// The magic number 840 is the least common multiple of 4, 5, 6, 7 and 8
	// and by extension 3! = 6, 4! = 24 and 5! = 120.
	// Thus for 4 and 5 players it is a multiple of the number of permutations,
	// and for 6/7/8 players it is a multiple of the number of players.
	// Also it is very large; we do not want games that last that long anyway.
	DEBUG_ASSERT(round < 840);
	DEBUG_ASSERT(array_size(PERM_SEQ_4) == 840);
	DEBUG_ASSERT(array_size(PERM_SEQ_5) == 840);
	DEBUG_ASSERT(array_size(PERM_SEQ_6) == 840);
	DEBUG_ASSERT(array_size(PERM_SEQ_7) == 840);
	DEBUG_ASSERT(array_size(PERM_SEQ_8) == 840);

	DEBUG_ASSERT(MAX_NUM == 8);
	switch (_num)
	{
		case 1: return 0;
		case 2: return PERM_SEQ_2[round % array_size(PERM_SEQ_2)][offset];
		case 3: return PERM_SEQ_3[round % array_size(PERM_SEQ_3)][offset];
		case 4: return PERM_SEQ_4[round % array_size(PERM_SEQ_4)][offset];
		case 5: return PERM_SEQ_5[round % array_size(PERM_SEQ_5)][offset];
		case 6: return PERM_SEQ_6[round % array_size(PERM_SEQ_6)][offset];
		case 7: return PERM_SEQ_7[round % array_size(PERM_SEQ_7)][offset];
		case 8: return PERM_SEQ_8[round % array_size(PERM_SEQ_8)][offset];
		default:
		break;
	}
	DEBUG_ASSERT(false && _num >= 1 && _num <= MAX_NUM);
	return offset;
}
