/// an identifier that tells what the packet is meant to do
#[derive(Debug, Clone, Copy, PartialEq, Primitive)]
pub enum Action {
    Request = 1,
    Accept = 2,
    Reply = 3,
    Remove = 4,
    Agree = 5,
    Create = 6,
    Add = 7,
    Player = 8,
    Take = 9,
    Use = 10,
    Buy = 11,
    Sell = 12,
    Open = 13,
    Close = 14,
    Message = 15,
    Spec = 16,
    Admin = 17,
    List = 18,
    Tell = 20,
    Report = 21,
    Announce = 22,
    Server = 23,
    Drop = 24,
    Junk = 25,
    Obtain = 26,
    Get = 27,
    Kick = 28,
    Rank = 29,
    TargetSelf = 30,
    TargetOther = 31,
    TargetGroup = 33,
    Dialog = 34,
    Ping = 240,
    Pong = 241,
    Net3 = 242,
    Init = 255,
}
