const { Binary } = require("binary-install");
const os = require("os");

function getPlatform() {
  const type = os.type();
  const arch = os.arch();

  if (type === "Windows_NT" && arch === "x64") return "win64";
  if (type === "Windows_NT") return "win32";
  if (type === "Linux" && arch === "x64") return "linux";
  if (type === "Darwin" && arch === "x64") return "macos";
  if (type === "Darwin" && arch === "arm64") return "macos";

  throw new Error(`Unsupported platform: ${type} ${arch}`);
}

function getBinary() {
  const platform = getPlatform();
  const version = require("../package.json").version;
  const url = `https://github.com/arvindell/envful/releases/download/v${version}/envful-v${version}-${platform}.tar.gz`;
  const name = "envful";
  return new Binary(platform.startsWith("win") ? `${name}.exe` : name, url);
}

module.exports = getBinary;
