use proc_macro::TokenStream;
use syn::{
    parse_macro_input, 
    DeriveInput, 
    Meta, 
    MetaList, 
    NestedMeta
};


static mut ID: u32 = 0;

#[proc_macro_derive(Component, attributes(impls))]
pub fn test(input: TokenStream) -> TokenStream {
    let ast = parse_macro_input!(input as DeriveInput);
    let attrs = &ast.attrs;
    let struct_name = ast.ident;
    let mut impls_data: Vec<String> = Default::default();

    // let name_attr = attrs.iter()
    // .find(|attr| attr.path.is_ident("name"));

    // match name_attr {
    //     Some(attr) => {
    //         match attr.parse_meta().unwrap() {
    //             Meta::NameValue(MetaNameValue{ref path, ref lit, ..}) 
    //             if path.is_ident("name") => {
    //                 if let Lit::Str(lit) = lit {
    //                     component_name = lit.value();
    //                 }
    //             },
    //             _ => {}
    //         }
    //     },
    //     None => {
    //         panic!("Component name is not defined. Define it with #[name=\"Foo\"]");
    //     }
    // }

    let impls_attr = attrs.iter()
    .find(|attr| attr.path.is_ident("impls"));

    match impls_attr {
        Some(attr) => {
            match attr.parse_meta().unwrap() {
                Meta::List(MetaList{ref nested, ..}) => {
                    for value in nested {
                        match value {
                            NestedMeta::Meta(meta) => {
                                match meta {
                                    Meta::Path(path) => {
                                        for segment in &path.segments {
                                            impls_data.push(format!("{}", segment.ident));
                                        }
                                    },
                                    _ => {}
                                }
                            },
                            _ => {}
                        }
                    }
                }, 
                _ => {}
            }
        },

        None => {
            panic!("Component implementations not defined. Define them with #[name=Update, Render]");
        }
    }

    unsafe {
        ID+=1;
    }

    let mut result = format!("
impl enschin::ComponentData for {0} {{
    fn name(&self) -> &'static str {{
        \"{0}\"
    }}

    fn id(&self) -> u32 {{
        {1}
    }}
}}"
    , struct_name, unsafe{ID});


    if !impls_data.contains(&"Render".to_string()) {
        result = format!("
{0}

impl enschin::Render for {1} {{
    fn render_type(&self) -> RenderType {{RenderType::None}}
    fn is_static(&self) -> {{True}}
    fn get_pos(&self) -> Position {{None}};
}}
"
        ,result, struct_name)
    }


    if !impls_data.contains(&"Update".to_string()) {
        result = format!("
{0}

impl enschin::Update for {1} {{
    fn update(&mut self, scene: &mut enschin::SceneContext, enschin: &mut enschin::EnschinContext) {{}}
}}
"
        ,result, struct_name)
    }

    if !impls_data.contains(&"Collission".to_string()) {
        result = format!("
{0}

impl enschin::Collission for {1} {{
    fn get_body(&self) {{}}
    fn on_collission(&self) {{}}
}}
"
        ,result, struct_name)
    }

    if !impls_data.contains(&"SaveLoad".to_string()) {
        result = format!("
{0}

impl enschin::SaveLoad for {1} {{
    fn save(&self) {{}}
    fn load(&self) {{}}
}}
"
        ,result, struct_name)
    }

    result.parse().unwrap()
}
