use crate::{
    SceneContext,
    EnschinContext,
};

pub trait SceneController {
    fn setup(&mut self, scene: &mut SceneContext, enschin: &mut EnschinContext);
    fn dispose(&mut self, scene: &mut SceneContext, enschin: &mut EnschinContext);
    fn update(&mut self, scene: &mut SceneContext, enschin: &mut EnschinContext);

    fn name(&self) -> &'static str;
}
