#![crate_type = "lib"]
#![crate_type = "rlib"]
#![crate_type = "dylib"]
#![crate_name = "enschin"]

extern crate wgpu;
extern crate winit;

#[macro_use]
mod component;
mod core;
mod graphics;
mod math;
mod scene;
mod input;

pub use wgpu::RenderPass;
pub use enschin_proc::Component;
pub use crate::{
    component::{
        component_type::ComponentType,
        component::*,
        position::Position
    },
    core::{
        enschin_context::EnschinContext,
        enschin::Enschin,
        resources::Resources
    },
    input::{
        input_code::{
            InputCode,
            StateAsBool
        },
        input_event::InputEvent,
        input::Input,
    },
    graphics::{
        camera::Camera,
        color::Color,
        model::Model,
        render_data::RenderData,
        renderer::Renderer,
        texture::Texture,
        sprite_sheet::SpriteSheet,
        vertex::Vertex
    },
    math::{
        vectors::{
            Vec2,
            Vec3,
            Vec4
        },
        matrix4x4::Matrix4x4
    },
    scene::{
        scene_context::SceneContext,
        scene_controller::SceneController,
        scene::Scene
    }
};
