use std::time::Instant;

use crate::{
    InputCode
};

pub struct InputEvent {
    pub held: bool,
    pressed: bool,
    pub start_time: u128,
    pub code: InputCode,
}

impl InputEvent {
    pub fn new(code: InputCode) -> Self {
        InputEvent {
            held: false,
            pressed: true,
            start_time: 0,
            code: code
        }
    }

    pub fn update(&mut self, held: bool) {
        if !self.held && held {
            self.start_time = Instant::now().elapsed().as_millis();
            self.pressed = false;
        }
        self.held = held;
    }

    pub fn get_held_time(&self) -> u128 {
        if self.held {
            Instant::now().elapsed().as_millis() - self.start_time
        } else {
            0
        }
    }

    pub fn get_code(&self) -> u32 {
        self.code as u32
    }

    pub fn take(&mut self) -> bool {
        if !self.pressed && self.held {
            self.pressed = true;
            if self.code == InputCode::ScrollLeft 
            || self.code == InputCode::ScrollRight
            || self.code == InputCode::ScrollDown 
            || self.code == InputCode::ScrollUp {
                self.held = false;
            }
            true
        } else {
            false
        }
    }
}
