use image::GenericImageView;
use crate::{
    Texture,
    Vec2
};

use wgpu::{
    Device,
    Queue,
    BindGroupLayout
};

pub struct SpriteSheet {
    sprites: Vec<Texture>,
    amount: u32
}

impl SpriteSheet {
    pub fn new(device: &Device, queue: &Queue, layout: &BindGroupLayout, bytes: &[u8], sprites: Vec2<u32>, sprite_size: Vec2<u32>) -> SpriteSheet  {
        let mut img = image::load_from_memory(bytes).unwrap();
        let amount = sprites.x * sprites.y;


        let mut sheet = SpriteSheet {
            sprites: Vec::with_capacity(amount as usize),
            amount
        };

        for i in 0..sprites.y {
            for j in 0..sprites.x {
                let sprite = img.crop(j * sprite_size.x, i * sprite_size.y, sprite_size.x, sprite_size.y);
                let rgba = sprite.as_rgba8().unwrap();
                let dimensions = sprite.dimensions();
                sheet.sprites.push(Texture::create(device, queue, layout, rgba, dimensions, None).unwrap());
            }
        }

        return sheet;
    }

    pub fn get_sprite(&self, index: usize) -> &Texture {
        &self.sprites[index]
    }

    pub fn get_amount(&self) -> u32 {
        self.amount
    }
}
