use std::fmt::{Display, Formatter, Result};

#[derive(Clone, Copy)]
pub struct Color {
    pub r: f32,
    pub g: f32,
    pub b: f32,
    pub a: f32
}

impl Color {
    pub fn new(r: f32, g: f32, b: f32, a: f32) -> Self {
        return Self {
            r,
            g,
            b,
            a
        }
    }

    pub fn set(&mut self, r: f32, g: f32, b: f32, a: f32) {
        self.r = r;
        self.g = g;
        self.b = b;
        self.a = a;
    }

    pub fn invert(&mut self) {
        self.r = 1.0-self.r;
        self.g = 1.0-self.g;
        self.b = 1.0-self.b;
    }

    pub fn into_wgpu(&self) -> wgpu::Color {
        wgpu::Color {
            r: self.r as f64,
            g: self.g as f64,
            b: self.b as f64,
            a: self.a as f64
        }
    }
}

impl Display for Color {
    fn fmt(&self, fmt: &mut Formatter) -> Result {
        write!(fmt, "(r: {}, g: {}, b: {}, a: {})", &self.r, &self.g, &self.b, &self.a)
    }
}
