use enschin::Renderer;

#[cfg_attr(target_os = "android", ndk_glue::main(backtrace = "on"))]
fn main() {
    enschin::Enschin::init("SpriteSheet", GameScene{});
}

struct GameScene {}

impl enschin::SceneController for GameScene {
    fn setup(&mut self, scene: &mut enschin::SceneContext, enschin: &mut enschin::EnschinContext) {
        let model = enschin::Model::new_box(enschin.render_data, enschin::Vec2::new(1.0, 1.0));
        enschin.resources.add_model("test", model);
        enschin.resources.add_sprite_sheet(
            enschin.render_data, 
            "sheet", 
            include_bytes!("./img/sheet.png"), 
            enschin::Vec2::new(6, 1), 
            enschin::Vec2::new(21, 21)
        );

        scene.add_component(Holder::new());
    }
    
    fn update(&mut self, _scene: &mut enschin::SceneContext, _enschin: &mut enschin::EnschinContext) {}
    fn dispose(&mut self, _scene: &mut enschin::SceneContext, _enschin: &mut enschin::EnschinContext) {}
    fn name(&self) -> &'static str {
        "SpriteSheet"
    }
}

#[derive(enschin::Component)]
#[impls(Render, Update)]
struct Holder{
    pos: enschin::Position,
    sprite_counter: f32
}

impl Holder {
    pub fn new() -> Self {
        Self {
            pos: enschin::Position::null(enschin::Vec2::new(1.0, 1.0)),
            sprite_counter: 0.0
        }
    }
}

impl enschin::Update for Holder {
    fn update(&mut self, _scene: &mut enschin::SceneContext, enschin: &mut enschin::EnschinContext) {
        self.sprite_counter += enschin.delta_time * 10.0;
    }
}

impl enschin::Render for Holder {
    fn render_type(&self) -> enschin::RenderType {
        enschin::RenderType::Solo
    }
    fn get_pos(&self) -> Option<&enschin::Position> {
        Some(&self.pos)
    }
    fn render<'a>(&'a self, enschin: &'a enschin::EnschinContext, render_pass: &mut enschin::RenderPass<'a>) {
        let sheet = enschin.resources.get_sprite_sheet("sheet");
        render_pass.render_texture(
            enschin.resources, 
            enschin.resources.get_model("test"), 
            sheet.get_sprite(self.sprite_counter as usize % 6)
        );
    }
}
