extern crate winit;

use rand::Rng;
use enschin::Renderer;

const GRAVITY: f32 = -2.5;

#[cfg_attr(target_os = "android", ndk_glue::main(backtrace = "on"))]
pub fn main() {
    enschin::Enschin::init("BunnyMark", GameScene{total_bunnies: 2});
}

pub struct GameScene {
    total_bunnies: u32,
}

impl enschin::SceneController for GameScene {
    fn setup(&mut self, scene: &mut enschin::SceneContext, enschin: &mut enschin::EnschinContext) {
        let model = enschin::Model::new_box(enschin.render_data, enschin::Vec2::new(0.39, 0.555));
        enschin.resources.add_model("bunny", model);
        enschin.resources.add_texture(enschin.render_data, "bunny", include_bytes!("./img/wabbit.png"));

        for _ in 0..self.total_bunnies {
            let bunny = Bunny::new(scene);
            scene.add_component(bunny);
        }
        scene.input.add_event("spawn_many", enschin::InputCode::MouseLeft);
        scene.input.add_event("spawn_one", enschin::InputCode::MouseRight);

        scene.camera.set_fov(10.0);
    }

    fn update(&mut self, scene: &mut enschin::SceneContext, _enschin: &mut enschin::EnschinContext) {
        if scene.input.get_event("spawn_many").held  || scene.input.is_touch() {
            for _ in 0..500 {
                let bunny = Bunny::new(scene);
                scene.add_component(bunny);
                self.total_bunnies+=1;
            }
            println!("There are now {} bunnies!", self.total_bunnies);
        }
        if scene.input.get_event("spawn_one").held {
            let bunny = Bunny::new(scene);
            scene.add_component(bunny);
            self.total_bunnies+=1;
            println!("There are now {} bunnies!", self.total_bunnies);
        }
    }

    fn dispose(&mut self, _scene: &mut enschin::SceneContext, enschin: &mut enschin::EnschinContext) {
        enschin.resources.destroy_model("bunny");
        enschin.resources.destroy_texture("bunny");
    }

    fn name(&self) -> &'static str {
        "BunnyMark"
    }
}

#[derive(enschin::Component)]
#[impls(Update, Render)]
pub struct Bunny {
    position: enschin::Position,
    speed: enschin::Vec2<f32>,
}

impl Bunny {
    pub fn new(scene: &mut enschin::SceneContext) -> Self {
        let speed = enschin::Vec2::new(
            rand::thread_rng().gen_range(0.0..5.0) - 2.5,
            rand::thread_rng().gen_range(0.0..15.0) - 7.5
        );
        Bunny {
            position: enschin::Position::new(scene.input.get_cursor_pos(), enschin::Vec2::new(0.39, 0.555), enschin::Vec2::new(1.0, 1.0), 0.0),
            speed: speed,
        }
    }
}

impl enschin::Render for Bunny {
    fn render_type(&self) -> enschin::RenderType {
        enschin::RenderType::Multi
    }
    fn always_render(&self) -> bool {
        true
    }
    fn get_pos(&self) -> Option<&enschin::Position> {
        Some(&self.position)
    }
    fn render<'a>(&'a self, enschin: &'a enschin::EnschinContext, render_pass: &mut enschin::RenderPass<'a>) {
        render_pass.render_texture(
            enschin.resources, 
            enschin.resources.get_model("bunny"), 
            enschin.resources.get_texture("bunny")
        );
    }
}

impl enschin::Update for Bunny {
    fn update(&mut self, scene: &mut enschin::SceneContext, enschin: &mut enschin::EnschinContext) {
        self.position.pos += self.speed * enschin.delta_time;
        self.speed.y += GRAVITY * enschin.delta_time;
        let fov = scene.camera.get_fov();

        if self.position.pos.x >= fov.x {
            self.speed.x *= -1.0;
            self.position.pos.x = fov.x;
        } else if self.position.pos.x <= -fov.x {
            self.speed.x *= -1.0;
            self.position.pos.x = -fov.x;
        }
    
        if self.position.pos.y < -fov.y {
            self.speed.y *= -0.85;
            self.position.pos.y = -fov.y;
            if rand::thread_rng().gen_range(0.0..1.0) > 0.5{
                self.speed.y -= rand::thread_rng().gen_range(0.0..15.0);
            }
        } else if self.position.pos.y > fov.y {
            self.speed.y = 0.0;
            self.position.pos.y = fov.y;
        }
        self.position.build();
    }
}
