use crate::{
    Camera,
    ComponentData,
    Input
};


pub struct SceneContext<'a> {
    pub camera: &'a mut Camera,
    pub input: &'a mut Input,
    pub new_components: Vec<Box<dyn ComponentData>>,
}

impl <'a>SceneContext<'a> {
    pub fn new(
        camera: &'a mut Camera,
        input: &'a mut Input
    ) -> Self {
        Self {
            camera,
            input,
            new_components: Default::default()
        }
    }

    pub fn add_component<T: 'static + ComponentData>(&mut self, new_component: T) {
        self.new_components.push(Box::new(new_component));
    }
}


