use winit::{
    window::Window
};

use crate::{
    Color,
    Resources,
    Vec2,
    RenderData
};


pub struct EnschinContext<'a> {
    pub window:         &'a mut Window,
    pub clear_color:    &'a mut Color,
    pub resources:      &'a mut Resources,
    pub main_scene:     &'a mut String,
    pub render_data:    &'a RenderData,
    pub window_size:    &'a Vec2<u32>,
    pub window_ratio:   f32,
    pub delta_time:     f32,
    pub total_time:     f32,
    pub update_time:    f32,
    pub render_time:    f32,
    pub fps:            i32,
}

impl <'a>EnschinContext<'a> {
    pub fn new (
        window: &'a mut Window, 
        clear_color: &'a mut Color, 
        resources: &'a mut Resources,
        main_scene: &'a mut String,
        render_data: &'a RenderData,
        window_size: &'a Vec2<u32>,
        window_ratio: f32,
        delta_time: f32, 
        total_time: f32, 
        update_time: f32,
        render_time: f32,
        fps: i32) -> Self {

        EnschinContext {
            window,
            resources,
            main_scene,
            render_data,
            clear_color,
            window_size,
            window_ratio,
            delta_time,
            total_time,
            update_time,
            render_time,
            fps
        }
    }
}
