use wgpu::{
    RenderPass
};

use crate::{
    EnschinContext,
    SceneContext,
    Position
};

#[derive(PartialEq)]
pub enum RenderType {
    None,
    Solo,
    Multi
}

pub trait Update {
    fn update(&mut self, scene: &mut SceneContext, enschin: &mut EnschinContext);
}

pub trait Render {
    fn render_type(&self) -> RenderType;
    fn get_pos(&self) -> Option<&Position>;
    fn is_static(&self) -> bool { false }
    fn always_render(&self) -> bool { false }
    fn render_solo<'a>(&'a self, _enschin: &'a EnschinContext, _render_pass: &mut RenderPass<'a>) {}
    fn render_multi<'a>(&'a self, _enschin: &'a EnschinContext, _render_pass: &mut RenderPass<'a>) {}
}

pub trait Collission {
    fn get_body(&self);
    fn on_collission(&self);
}

pub trait SaveLoad {
    fn save(&self);
    fn load(&self);
}

pub trait ComponentData: Update + Render + Render + Collission + SaveLoad {
    fn name(&self) -> &'static str;
    fn id(&self) -> u32;
}
