use std::{ops::{Add, AddAssign, Sub, SubAssign, Mul, MulAssign, Div, DivAssign, Neg}, fmt::{Display, Formatter, Result}};

#[derive(Clone, Copy)]
pub struct Vec3i {
    pub x: i32,
    pub y: i32,
    pub z: i32
}

// Arithmetic

impl Add<Self> for Vec3i {
    type Output = Self;
    fn add(self, v: Self) -> Self {
        Self {
            x: self.x + v.x,
            y: self.y + v.y,
            z: self.z + v.z,
        }
    }
}

impl Sub<Self> for Vec3i {
    type Output = Self;
    fn sub(self, v: Self) -> Self {
        Self {
            x: self.x - v.x,
            y: self.y - v.y,
            z: self.z - v.z,
        }
    }
}

impl Mul<Self> for Vec3i {
    type Output = Self;
    fn mul(self, v: Self) -> Self {
        Self {
            x: self.x * v.x,
            y: self.y * v.y,
            z: self.z * v.z,
        }
    }
}

impl Div<Self> for Vec3i {
    type Output = Self;
    fn div(self, v: Self) -> Self {
        Self {
            x: self.x / v.x,
            y: self.y / v.y,
            z: self.z / v.z,
        }
    }
}

impl Mul<i32> for Vec3i {
    type Output = Self;
    fn mul(self, i: i32) -> Self {
        Self {
            x: self.x * i,
            y: self.y * i,
            z: self.z * i,
        }
    }
}

impl Div<i32> for Vec3i {
    type Output = Self;
    fn div(self, i: i32) -> Self {
        Self {
            x: self.x / i,
            y: self.y / i,
            z: self.z / i,
        }
    }
}


// Arithmetic assignment

impl AddAssign<Self> for Vec3i {
    fn add_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x + v.x,
            y: self.y + v.y,
            z: self.z + v.z,
        };
    }
}

impl SubAssign<Self> for Vec3i {
    fn sub_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x - v.x,
            y: self.y - v.y,
            z: self.z - v.z,
        };
    }
}

impl MulAssign<Self> for Vec3i {
    fn mul_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x * v.x,
            y: self.y * v.y,
            z: self.z * v.z,
        };
    }
}

impl DivAssign<Self> for Vec3i {
    fn div_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x / v.x,
            y: self.y / v.y,
            z: self.z / v.z,
        };
    }
}

impl MulAssign<i32> for Vec3i {
    fn mul_assign(&mut self, i: i32) {
        *self = Self {
            x: self.x * i,
            y: self.y * i,
            z: self.z * i,
        };
    }
}

impl DivAssign<i32> for Vec3i {
    fn div_assign(&mut self, i: i32) {
        *self = Self {
            x: self.x / i,
            y: self.y / i,
            z: self.z / i,
        };
    }
}


// Comparison

impl PartialEq for Vec3i {
    fn eq(&self, v: &Self) -> bool {
        self.x == v.x &&
        self.y == v.y &&
        self.z == v.z
    }

    fn ne(&self, v: &Self) -> bool {
        !Self::eq(&self, v)
    }
}



// Other

impl Neg for Vec3i {
    type Output = Self;
    fn neg(self) -> Self{
        Self {
            x: -self.x,
            y: -self.y,
            z: -self.z,
        }
    }
}

impl Display for Vec3i {
    fn fmt(&self, fmt: &mut Formatter) -> Result {
        write!(fmt, "({}, {}. {})", &self.x, &self.y, &self.z)
    }
}