use std::{ops::{Add, AddAssign, Sub, SubAssign, Mul, MulAssign, Div, DivAssign, Neg}, fmt::{Display, Formatter, Result}};

#[derive(Clone, Copy)]
pub struct Vec3f {
    pub x: f32,
    pub y: f32,
    pub z: f32
}

// Arithmetic

impl Add<Self> for Vec3f {
    type Output = Self;
    fn add(self, v: Self) -> Self {
        Self {
            x: self.x + v.x,
            y: self.y + v.y,
            z: self.z + v.z,
        }
    }
}

impl Sub<Self> for Vec3f {
    type Output = Self;
    fn sub(self, v: Self) -> Self {
        Self {
            x: self.x - v.x,
            y: self.y - v.y,
            z: self.z - v.z,
        }
    }
}

impl Mul<Self> for Vec3f {
    type Output = Self;
    fn mul(self, v: Self) -> Self {
        Self {
            x: self.x * v.x,
            y: self.y * v.y,
            z: self.z * v.z,
        }
    }
}

impl Div<Self> for Vec3f {
    type Output = Self;
    fn div(self, v: Self) -> Self {
        Self {
            x: self.x / v.x,
            y: self.y / v.y,
            z: self.z / v.z,
        }
    }
}

impl Mul<f32> for Vec3f {
    type Output = Self;
    fn mul(self, f: f32) -> Self {
        Self {
            x: self.x * f,
            y: self.y * f,
            z: self.z * f,
        }
    }
}

impl Div<f32> for Vec3f {
    type Output = Self;
    fn div(self, f: f32) -> Self {
        Self {
            x: self.x / f,
            y: self.y / f,
            z: self.z / f,
        }
    }
}


// Arithmetic assignment

impl AddAssign<Self> for Vec3f {
    fn add_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x + v.x,
            y: self.y + v.y,
            z: self.z + v.z,
        };
    }
}

impl SubAssign<Self> for Vec3f {
    fn sub_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x - v.x,
            y: self.y - v.y,
            z: self.z - v.z,
        };
    }
}

impl MulAssign<Self> for Vec3f {
    fn mul_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x * v.x,
            y: self.y * v.y,
            z: self.z * v.z,
        };
    }
}

impl DivAssign<Self> for Vec3f {
    fn div_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x / v.x,
            y: self.y / v.y,
            z: self.z / v.z,
        };
    }
}

impl MulAssign<f32> for Vec3f {
    fn mul_assign(&mut self, f: f32) {
        *self = Self {
            x: self.x * f,
            y: self.y * f,
            z: self.z * f,
        };
    }
}

impl DivAssign<f32> for Vec3f {
    fn div_assign(&mut self, f: f32) {
        *self = Self {
            x: self.x / f,
            y: self.y / f,
            z: self.z / f,
        };
    }
}


// Comparison

impl PartialEq for Vec3f {
    fn eq(&self, v: &Self) -> bool {
        self.x == v.x &&
        self.y == v.y &&
        self.z == v.z
    }

    fn ne(&self, v: &Self) -> bool {
        !Self::eq(&self, v)
    }
}


// Other

impl Neg for Vec3f {
    type Output = Self;
    fn neg(self) -> Self{
        Self {
            x: -self.x,
            y: -self.y,
            z: -self.z,
        }
    }
}

impl Display for Vec3f {
    fn fmt(&self, fmt: &mut Formatter) -> Result {
        write!(fmt, "({}, {}. {})", &self.x, &self.y, &self.z)
    }
}