use std::{ops::{Add, AddAssign, Sub, SubAssign, Mul, MulAssign, Div, DivAssign, Neg}, cmp::PartialEq, fmt::{Display, Formatter, Result}};

#[derive(Clone, Copy)]
pub struct Vec2i {
    pub x: i32,
    pub y: i32
}

// Arithmetic

impl Add<Self> for Vec2i {
    type Output = Self;
    fn add(self, v: Self) -> Self {
        Self {
            x: self.x + v.x,
            y: self.y + v.y,
        }
    }
}

impl Sub<Self> for Vec2i {
    type Output = Self;
    fn sub(self, v: Self) -> Self {
        Self {
            x: self.x - v.x,
            y: self.y - v.y,
        }
    }
}

impl Mul<Self> for Vec2i {
    type Output = Self;
    fn mul(self, v: Self) -> Self {
        Self {
            x: self.x * v.x,
            y: self.y * v.y,
        }
    }
}

impl Div<Self> for Vec2i {
    type Output = Self;
    fn div(self, v: Self) -> Self {
        Self {
            x: self.x / v.x,
            y: self.y / v.y,
        }
    }
}

impl Mul<i32> for Vec2i {
    type Output = Self;
    fn mul(self, i: i32) -> Self {
        Self {
            x: self.x * i,
            y: self.y * i,
        }
    }
}

impl Div<i32> for Vec2i {
    type Output = Self;
    fn div(self, i: i32) -> Self {
        Self {
            x: self.x / i,
            y: self.y / i,
        }
    }
}


// Arithmetic assignment

impl AddAssign<Self> for Vec2i {
    fn add_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x + v.x,
            y: self.y + v.y,
        };
    }
}

impl SubAssign<Self> for Vec2i {
    fn sub_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x - v.x,
            y: self.y - v.y,
        };
    }
}

impl MulAssign<Self> for Vec2i {
    fn mul_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x * v.x,
            y: self.y * v.y,
        };
    }
}

impl DivAssign<Self> for Vec2i {
    fn div_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x / v.x,
            y: self.y / v.y,
        };
    }
}

impl MulAssign<i32> for Vec2i {
    fn mul_assign(&mut self, i: i32) {
        *self = Self {
            x: self.x * i,
            y: self.y * i,
        };
    }
}

impl DivAssign<i32> for Vec2i {
    fn div_assign(&mut self, i: i32) {
        *self = Self {
            x: self.x / i,
            y: self.y / i,
        };
    }
}


// Comparison

impl PartialEq for Vec2i {
    fn eq(&self, v: &Self) -> bool {
        self.x == v.x &&
        self.y == v.y
    }

    fn ne(&self, v: &Self) -> bool {
        !Self::eq(&self, v)
    }
}



// Other

impl Neg for Vec2i {
    type Output = Self;
    fn neg(self) -> Self{
        Self {
            x: -self.x,
            y: -self.y
        }
    }
}

impl Display for Vec2i {
    fn fmt(&self, fmt: &mut Formatter) -> Result {
        write!(fmt, "({}, {})", &self.x, &self.y)
    }
}