use std::{ops::{Add, AddAssign, Sub, SubAssign, Mul, MulAssign, Div, DivAssign, Neg}, fmt::{Display, Formatter, Result}};

#[derive(Clone, Copy)]
pub struct Vec2f {
    pub x: f32,
    pub y: f32
}

// Arithmetic

impl Add<Self> for Vec2f {
    type Output = Self;
    fn add(self, v: Self) -> Self {
        Self {
            x: self.x + v.x,
            y: self.y + v.y,
        }
    }
}

impl Sub<Self> for Vec2f {
    type Output = Self;
    fn sub(self, v: Self) -> Self {
        Self {
            x: self.x - v.x,
            y: self.y - v.y,
        }
    }
}

impl Mul<Self> for Vec2f {
    type Output = Self;
    fn mul(self, v: Self) -> Self {
        Self {
            x: self.x * v.x,
            y: self.y * v.y,
        }
    }
}

impl Div<Self> for Vec2f {
    type Output = Self;
    fn div(self, v: Self) -> Self {
        Self {
            x: self.x / v.x,
            y: self.y / v.y,
        }
    }
}

impl Mul<f32> for Vec2f {
    type Output = Self;
    fn mul(self, f: f32) -> Self {
        Self {
            x: self.x * f,
            y: self.y * f,
        }
    }
}

impl Div<f32> for Vec2f {
    type Output = Self;
    fn div(self, f: f32) -> Self {
        Self {
            x: self.x / f,
            y: self.y / f,
        }
    }
}


// Arithmetic assignment

impl AddAssign<Self> for Vec2f {
    fn add_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x + v.x,
            y: self.y + v.y,
        };
    }
}

impl SubAssign<Self> for Vec2f {
    fn sub_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x - v.x,
            y: self.y - v.y,
        };
    }
}

impl MulAssign<Self> for Vec2f {
    fn mul_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x * v.x,
            y: self.y * v.y,
        };
    }
}

impl DivAssign<Self> for Vec2f {
    fn div_assign(&mut self, v: Self) {
        *self = Self {
            x: self.x / v.x,
            y: self.y / v.y,
        };
    }
}

impl MulAssign<f32> for Vec2f {
    fn mul_assign(&mut self, f: f32) {
        *self = Self {
            x: self.x * f,
            y: self.y * f,
        };
    }
}

impl DivAssign<f32> for Vec2f {
    fn div_assign(&mut self, f: f32) {
        *self = Self {
            x: self.x / f,
            y: self.y / f,
        };
    }
}


// Comparison

impl PartialEq for Vec2f {
    fn eq(&self, v: &Self) -> bool {
        self.x == v.x &&
        self.y == v.y
    }

    fn ne(&self, v: &Self) -> bool {
        !Self::eq(&self, v)
    }
}


// Other

impl Neg for Vec2f {
    type Output = Self;
    fn neg(self) -> Self{
        Self {
            x: -self.x,
            y: -self.y
        }
    }
}

impl Display for Vec2f {
    fn fmt(&self, fmt: &mut Formatter) -> Result {
        write!(fmt, "({}, {})", &self.x, &self.y)
    }
}