#![allow(dead_code)]

pub mod component;
pub mod core;
pub mod context;
pub mod graphics;
pub mod input;
pub mod level;
pub mod math;
pub mod screen;
pub mod util;

use crate::math::vec2i::Vec2i;
use crate::screen::window::{Window, RenderCallback};
use crate::graphics::color::Color;

fn main() {
    let mut window = Window::new("Hello World", &Vec2i{x: 800, y: 800});
    window.set_background_color(&Color{r: 0.0, g: 1.0, b: 0.0, a: 1.0});
    window.update();
    while window.update() != RenderCallback::Close {
        window.swap_buffers();
    }
}
