extern crate gl;

pub struct VertexBufferElement {
    pub element_type:   u32,
    pub element_size:   u32,
    pub count:          u32,
    pub normalized:     u8
}

pub struct VertexBufferLayout {
    stride: u32,
    elements: Vec<VertexBufferElement>
}

impl VertexBufferLayout {

    pub fn new() -> Self {
        Self {
            stride: 0,
            elements: vec![]
        }
    }

    fn push(&mut self, element_type: u32, element_size: u32, count: u32, normalized: u8) {
        let vbe = VertexBufferElement {
            element_type,
            element_size,
            count,
            normalized
        };
        self.elements.push(vbe);
        self.stride += count * element_size;
    }

    pub fn add_float(&mut self, count: u32) {
        self.push(gl::FLOAT, 4, count, gl::FALSE);
    }

    pub fn add_uint(&mut self, count: u32) {
        self.push(gl::UNSIGNED_INT, 4, count, gl::FALSE);
    }

    pub fn add_ubyte(&mut self, count: u32) {
        self.push(gl::UNSIGNED_BYTE, 1, count, gl::TRUE);
    }

    pub fn get_elements(&self) -> &Vec<VertexBufferElement> {
        &self.elements
    }

    pub fn get_stride(&self) -> u32 {
        self.stride
    }
}