use core::ffi::c_void;
extern crate gl;

pub fn create_vertex_buffer(vertices: *const f32, size: u32) -> u32 {
    let mut id: u32 = 0;
    unsafe {
        gl::GenBuffers(1, &mut id);
        gl::BindBuffer(gl::ARRAY_BUFFER, id);
        gl::BufferData(gl::ARRAY_BUFFER, size as isize, vertices as *const c_void, gl::STATIC_DRAW);
    }
    return id;
}

pub fn bind_vertex_buffer(id: u32) {
    unsafe {
        gl::BindBuffer(gl::ARRAY_BUFFER, id);
    }
}

pub fn unbind_vertex_buffer() {
    unsafe {
        gl::BindBuffer(gl::ARRAY_BUFFER, 0);
    }
}

pub fn delete_vertex_buffer(id: u32) {
    unsafe {
        gl::DeleteBuffers(1, &id);
    }
}