use std::ffi::c_void;

extern crate gl;

use crate::graphics::buffers::vertex_buffer_layout::VertexBufferLayout;
use crate::graphics::buffers::vertex_buffer;

pub fn create_vertex_array() -> u32{
    let mut id: u32 = 0;
    unsafe {
        gl::GenVertexArrays(1, &mut id);
    }
    return id;
}

pub fn add_buffer_to_vertex_array(va_id: u32, vb_id: u32, layout: &VertexBufferLayout) {
    bind_vertex_array(va_id);
    vertex_buffer::bind_vertex_buffer(vb_id);
    let mut offset: u32 = 0;
    for (i, element) in layout.get_elements().iter().enumerate() {
        unsafe {
            gl::EnableVertexAttribArray(i as u32);
            gl::VertexAttribPointer(i as u32, element.count as i32, element.element_type, element.normalized, layout.get_stride() as i32, offset as *const c_void);
            offset += element.count * element.element_size;
        }
    }
}

pub fn delete_vertex_array(id: u32) {
    unsafe {
        gl::DeleteVertexArrays(1, &id);
    }
}

pub fn bind_vertex_array(id: u32) {
    unsafe {
        gl::BindVertexArray(id);
    }
}

pub fn unbind_vertex_array() {
    unsafe {
        gl::BindVertexArray(0);
    }
}