use core::ffi::c_void;
extern crate gl;

pub fn create_index_buffer(indices: *const u16, count: u32) -> u32{
    let mut id: u32 = 0;
    unsafe {
        gl::GenBuffers(1, &mut id);
        gl::BindBuffer(gl::ELEMENT_ARRAY_BUFFER, id);
        gl::BufferData(gl::ELEMENT_ARRAY_BUFFER, (count * 4) as isize, indices as *const c_void, gl::STATIC_DRAW);
    }
    return id;
}

pub fn bind_index_buffer(id: u32) {
    unsafe {
        gl::BindBuffer(gl::ELEMENT_ARRAY_BUFFER, id);
    }
}

pub fn unbind_index_buffer() {
    unsafe {
        gl::BindBuffer(gl::ELEMENT_ARRAY_BUFFER, 0);
    }
}

pub fn delete_index_buffer(id: u32) {
    unsafe {
        gl::DeleteBuffers(1, &id);
    }
}