//! utility functions

pub mod counter;
pub mod status;
pub mod result;

thread_local! {
    pub(crate) static PANIC_MSG: std::cell::RefCell<Option<String>> = std::cell::RefCell::default();
}

pub fn set_panic_msg(msg: &str)
{
    PANIC_MSG.with(|m| {
	*m.borrow_mut() = Some(msg.to_string());
    })
}

pub(crate) fn get_panic_msg() -> Option<String>
{
    PANIC_MSG.with(|m| {
	(*m.borrow()).clone()
    })
}

#[macro_export]
macro_rules! test_panic{
    ($msg:literal) => {
	panic!(msg);
    };

    ($($arg:tt)*) => {{
	let msg = std::fmt::format(format_args!($($arg)*));

	$crate::util::set_panic_msg(&msg);

	panic!($($arg)*);
    }};
}
