#![allow(clippy::redundant_field_names)]
#![allow(clippy::match_like_matches_macro)]

mod engine;
mod report;
mod runners;
pub mod util;

#[cfg(test)]
mod tests;

pub use engine::Case as TestCase;
pub use engine::case::opts::Expect;

pub use util::status::Status as TestStatus;
pub use util::result::Result as TestResult;

pub use runners::plan::Plan as PlanRunner;

pub(crate) use util::counter::Counter as TestCounter;
pub(crate) use report::{ ReportPlan, ReportCase };


// #[cfg(doctest)]
// TODO: https://github.com/rust-lang/rust/issues/67295
#[doc(hidden)]
pub fn doctest_prepare() {
    std::env::remove_var("TESTSUITE_OUTPUT");
    std::env::remove_var("TESTSUITE_FORMAT");
}
