use crate::ReportPlan;

type Inner = Box<crate::ReportPlan>;

#[derive(Debug)]
pub(super) struct BoxedReport(Option<Inner>);

impl BoxedReport {
    pub(super) fn from_parent(&self) -> Self {
	Self(Some(Box::new(ReportPlan::new(self.0.as_ref().unwrap()))))
    }

    pub(super) fn take(&mut self) -> Inner {
	self.0.take().expect("inner ReportPlan is None")
    }
}

impl Default for BoxedReport {
    fn default() -> Self {
	Self(Some(Box::default()))
    }
}

impl std::ops::Deref for BoxedReport {
    type Target = Inner;

    fn deref(&self) -> &Self::Target {
	self.0.as_ref().expect("inner ReportPlan is None")
    }
}

impl std::ops::DerefMut for BoxedReport {
    fn deref_mut(&mut self) -> &mut Self::Target {
	self.0.as_mut().expect("inner ReportPlan is None")
    }
}
