use crate::TestStatus;
use super::report::{ BoxedReport };
use super::plan::Plan;
use super::opts::Opts;

#[derive(Debug)]
pub(super) struct Info {
    pub report:		BoxedReport,
}

impl Info {
    pub(super) fn new(parent_plan: &Plan, opts: &Opts) -> Self {
	let mut report = parent_plan.info.with(|i| BoxedReport::from_parent(&i.report));

	report.generic.name        = opts.name.clone();
	report.generic.description = opts.description.clone();
	report.generic.comment     = opts.comment.clone();

	report.num_planned = opts.total_count;

	if opts.do_skip {
	    report.status = TestStatus::Skip;
	    report.reason = opts.skip_reason.clone();
	}

	Self {
	    report:	report,
	}
    }

    pub fn emit_report(&self) {
	crate::report::emit(&self.report).expect("failed to write report");

	//std::io::stderr().write_all(crate::report::formatters::json::serialize(&self.report).as_bytes()).unwrap();
	//std::io::stderr().write_all(crate::report::formatters::tap::serialize(&self.report).as_bytes()).unwrap();
	//std::io::stderr().write_all(crate::report::formatters::junit::serialize(&self.report).as_bytes()).unwrap();
    }

    pub fn append_report(&mut self, report: Box<crate::ReportPlan>) {
	self.report.append_plan(report);
    }

    pub fn record_duration(&mut self, duration: std::time::Duration) {
	self.report.record_duration(duration)
    }
}

#[allow(clippy::derivable_impls)]
impl Default for Info {
    fn default() -> Self {
	Self {
//	    counter:		TestCounter::default(),
//	    status:		TestStatus::Init,
	    report:		BoxedReport::default()
	}
    }
}
