use super::status::Status;

/// Counts number of tests with a specific result
#[derive(Debug)]
pub struct Counter {
    pub num_skip:	u32,
    pub num_todo:	u32,
    pub num_pass:	u32,
    pub num_degraded:	u32,
    pub num_fail:	u32,
    pub num_panic:	u32,
    pub num_abort:	u32,
}

impl Counter {
    pub fn inc_from_status(&mut self, status: Status)
    {
	match status {
	    Status::Init     => panic!("bad status"),
	    Status::Skip     => self.num_skip     += 1,
	    Status::SkipFail => self.num_skip     += 1,
	    Status::Todo     => self.num_todo     += 1,
	    Status::Pass     => self.num_pass     += 1,
	    Status::Degraded => self.num_degraded += 1,
	    Status::Fail     => self.num_fail     += 1,
	    Status::Panic    => self.num_panic    += 1,
	    Status::Abort    => self.num_abort    += 1,
	}
    }

    pub fn get_total(&self) -> u32
    {
	self.num_skip + self.num_pass +
	    self.num_degraded + self.num_fail +
	    self.num_panic + self.num_abort
    }
}

impl Default for Counter {
    fn default() -> Self {
	Self {
	    num_skip:		0,
	    num_todo:		0,
	    num_pass:		0,
	    num_degraded:	0,
	    num_fail:		0,
	    num_panic:		0,
	    num_abort:		0,
	}
    }
}
