use crate::engine::case::opts::Opts;

pub struct Desc(Opts);

impl From<&str> for Desc
{
    fn from(name: &str) -> Self  {
	Self(Opts::new(name))
    }
}

impl Desc {
    pub(crate) fn into_inner(self) -> Opts {
	self.0
    }
}

impl From<Opts> for Desc
{
    fn from(args: Opts) -> Self  {
	Self(args)
    }
}

impl From<(&str, &str)> for Desc
{
    fn from(args: (&str, &str)) -> Self  {
	Self(Opts::new(args.0)
	     .set_description(args.1))
    }
}

impl From<(&str, &str, &str)> for Desc
{
    fn from(args: (&str, &str, &str)) -> Self  {
	Self(Opts::new(args.0)
	     .set_description(args.1)
	     .set_comment(args.2))
    }
}
