use std::time::{SystemTime, Duration};

#[derive(Debug)]
pub struct Generic {
    pub name:		String,
    pub description:	Option<String>,
    pub comment:	Option<String>,

    // time when plan was created
    pub ctime:		SystemTime,
    pub duration:	Option<Duration>,
}

impl Generic {
    pub fn record_duration(&mut self, duration: Duration)
    {
	assert!(self.duration.is_none());

	self.duration = Some(duration);
    }

    pub fn get_duration(&self) -> f64
    {
	match self.duration {
	    Some(d) => (d.as_micros() as f64 / 1_000_000_f64),
	    None    => 0 as f64
	}
    }
}

impl Default for Generic {
    fn default() -> Self {
	Self {
	    name:		String::default(),
	    description:	None,
	    comment:		None,
	    ctime:		SystemTime::now(),
	    duration:		None,
	}
    }
}
