use std::sync::Arc;

use super::plan::Plan;

type Inner = Arc<Plan>;

#[derive(Debug, Clone)]
pub struct PlanRc(Inner);

impl std::ops::Deref for PlanRc {
    type Target = Inner;

    fn deref(&self) -> &Self::Target {
	&self.0
    }
}

impl std::ops::DerefMut for PlanRc {
    fn deref_mut(&mut self) -> &mut Self::Target {
	&mut self.0
    }
}

impl std::cmp::PartialEq<Self> for PlanRc {
    fn eq(&self, other: &Self) -> bool {
	Arc::ptr_eq(&self.0, &other.0)
    }
}

impl PlanRc {
    pub fn new_root() -> Self{
	Self::new(Plan::new_root())
    }

    pub(super) fn new(plan: Plan) -> Self {
	Self(Arc::new(plan))
    }

    pub fn as_plan(&self) -> &Plan {
	&self.0
    }
}
