use super::plan_rc::PlanRc;
use super::plan::Plan;

use crate::TestStatus;
use crate::PlanRunner;

#[derive(Debug)]
pub struct Opts {
    pub total_count:	Option<u32>,
    pub name:		String,
    pub description:	Option<String>,
    pub comment:	Option<String>,
    pub ignore_abort:	bool,
    pub do_skip:	bool,
    pub skip_reason:	Option<String>,
}

impl Opts {
    pub(crate) fn new(name: &str) -> Self
    {
	Self {
	    total_count:	None,
	    name:		name.to_string(),
	    description:	None,
	    comment:		None,
	    ignore_abort:	false,
	    do_skip:		false,
	    skip_reason:	None,
	}
    }

    pub fn set_total_count(&mut self, count: u32) {
	self.total_count = Some(count);
    }

    pub fn set_description(&mut self, desc: &str) {
	self.description = Some(desc.to_string());
    }

    pub fn set_comment(&mut self, comment: &str)  {
	self.comment = Some(comment.to_string());
    }

    pub fn ignore_abort(&mut self) {
	self.ignore_abort = true;
    }

    pub fn set_skip(&mut self, skip: bool, reason: &str) {
	self.do_skip = skip;
	self.skip_reason = Some(reason.to_string());
    }

    pub fn run<F>(self, plan: &PlanRc, f: F) -> TestStatus
    where
	F: FnOnce(&PlanRunner),
    {
	Plan::run_internal(plan.clone(), self, f)
    }
}
